/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.elements;

import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Factory;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EStructuralFeatureImpl;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.jboss.drools.DroolsFactory;
import org.jboss.drools.DroolsPackage;
import org.jboss.drools.MetaDataType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.elements.MetadataTypeDefinition;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.Scripts;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class MetaTypeDefinitionTest<T> {
    protected BaseElement baseElement;

    public abstract MetadataTypeDefinition<T> getMetaTypeDefinition();

    protected abstract T getTestValue();

    protected abstract T formattedResult(T var1);

    protected abstract String formattedValue(T var1);

    protected String asStringValue(T testValue) {
        return testValue.toString();
    }

    @Before
    public void setUp() {
        this.baseElement = Factories.bpmn2.createTask();
    }

    @Test
    public void testGetValue() {
        MetadataTypeDefinition<T> metadataTypeDefinition = this.getMetaTypeDefinition();
        T expectedValue = this.getTestValue();
        this.prepareBaseElementAttribute(metadataTypeDefinition.name(), this.asStringValue(expectedValue));
        Assert.assertEquals(this.formattedResult(expectedValue), (Object)metadataTypeDefinition.getValue(this.baseElement));
    }

    @Test
    public void testSetValue() throws Exception {
        MetadataTypeDefinition metadataTypeDefinition = this.getMetaTypeDefinition();
        T expectedValue = this.getTestValue();
        metadataTypeDefinition.setValue(this.baseElement, expectedValue);
        ExtensionAttributeValue attributeValue = (ExtensionAttributeValue)this.baseElement.getExtensionValues().get(0);
        FeatureMap extensionElements = attributeValue.getValue();
        List metadataExtensions = (List)extensionElements.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, true);
        MetaDataType metaDataType = metadataExtensions.stream().filter(metaData -> metadataTypeDefinition.name().equals(metaData.getName())).findFirst().orElseThrow(() -> new Exception("expected metadata element:" + metadataTypeDefinition.name() + " was not found"));
        Assert.assertEquals((Object)this.formattedValue(expectedValue), (Object)metaDataType.getMetaValue());
    }

    private void prepareBaseElementAttribute(String name, String value) {
        ExtensionAttributeValue eav = Bpmn2Factory.eINSTANCE.createExtensionAttributeValue();
        this.baseElement.getExtensionValues().add(eav);
        eav.getValue().add((Object)new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, (Object)this.metaDataOf(name, value)));
    }

    private MetaDataType metaDataOf(String name, String value) {
        MetaDataType eleMetadata = DroolsFactory.eINSTANCE.createMetaDataType();
        eleMetadata.setName(name);
        eleMetadata.setMetaValue(Scripts.asCData((String)value));
        return eleMetadata;
    }
}

