/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties;

import org.apache.commons.lang3.StringEscapeUtils;
import org.assertj.core.api.Assertions;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Documentation;
import org.eclipse.bpmn2.Lane;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.LanePropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.Scripts;

public class LanePropertyWriterTest {
    @Test
    public void JBPM_7523_shouldPreserveNameChars() {
        Lane lane = Factories.bpmn2.createLane();
        PropertyWriterFactory writerFactory = new PropertyWriterFactory();
        LanePropertyWriter w = writerFactory.of(lane);
        String aWeirdName = "   XXX  !!@@ <><> ";
        String aWeirdDoc = "   XXX  !!@@ <><> Docs ";
        w.setName(aWeirdName);
        w.setDocumentation(aWeirdDoc);
        Assertions.assertThat((String)lane.getName()).isEqualTo((Object)StringEscapeUtils.escapeXml10((String)aWeirdName.trim()));
        Assertions.assertThat((String)((String)CustomElement.name.of((BaseElement)lane).get())).isEqualTo((Object)Scripts.asCData((String)aWeirdName));
        Assertions.assertThat((String)((Documentation)lane.getDocumentation().get(0)).getText()).isEqualTo((Object)Scripts.asCData((String)aWeirdDoc));
    }
}

