/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomInput;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.associations.AssociationType;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.FlatVariableScope;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.UserTaskPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.definition.property.notification.NotificationValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.notification.NotificationsInfo;

public class NotificationPropertyWriterTest {
    private FlatVariableScope variableScope;

    @Before
    public void before() {
        this.variableScope = new FlatVariableScope();
    }

    @Test
    public void addOneNotStartedNotifyValue() {
        UserTaskPropertyWriter userTaskPropertyWriter = new UserTaskPropertyWriter(Factories.bpmn2.createUserTask(), (VariableScope)this.variableScope);
        NotificationsInfo notificationsInfo = new NotificationsInfo();
        notificationsInfo.getValue().addValue(this.getNotificationValue(AssociationType.NOT_STARTED_NOTIFY.getName()));
        userTaskPropertyWriter.setNotifications(notificationsInfo);
        CustomInput notStartedNotify = (CustomInput)this.getFieldValue(UserTaskPropertyWriter.class, userTaskPropertyWriter, "notStartedNotify");
        Assert.assertEquals((Object)this.asCDATA(this.getNotificationValue(AssociationType.NOT_STARTED_NOTIFY.getName()).toCDATAFormat()), (Object)notStartedNotify.get());
    }

    @Test
    public void addTwoNotStartedNotifyValue() {
        UserTaskPropertyWriter userTaskPropertyWriter = new UserTaskPropertyWriter(Factories.bpmn2.createUserTask(), (VariableScope)this.variableScope);
        NotificationsInfo notificationsInfo = new NotificationsInfo();
        notificationsInfo.getValue().addValue(this.getNotificationValue(AssociationType.NOT_STARTED_NOTIFY.getName()));
        notificationsInfo.getValue().addValue(this.getNotificationValue(AssociationType.NOT_STARTED_NOTIFY.getName()));
        userTaskPropertyWriter.setNotifications(notificationsInfo);
        String cdata = this.getNotificationValue(AssociationType.NOT_STARTED_NOTIFY.getName()).toCDATAFormat();
        CustomInput notStartedNotify = (CustomInput)this.getFieldValue(UserTaskPropertyWriter.class, userTaskPropertyWriter, "notStartedNotify");
        Assert.assertEquals((Object)this.asCDATA(cdata + "^" + cdata), (Object)notStartedNotify.get());
    }

    @Test
    public void addOneNotCompletedNotifyValue() {
        UserTaskPropertyWriter userTaskPropertyWriter = new UserTaskPropertyWriter(Factories.bpmn2.createUserTask(), (VariableScope)this.variableScope);
        NotificationsInfo notificationsInfo = new NotificationsInfo();
        notificationsInfo.getValue().addValue(this.getNotificationValue(AssociationType.NOT_COMPLETED_NOTIFY.getName()));
        userTaskPropertyWriter.setNotifications(notificationsInfo);
        CustomInput notStartedNotify = (CustomInput)this.getFieldValue(UserTaskPropertyWriter.class, userTaskPropertyWriter, "notCompletedNotify");
        Assert.assertEquals((Object)this.asCDATA(this.getNotificationValue(AssociationType.NOT_COMPLETED_NOTIFY.getName()).toCDATAFormat()), (Object)notStartedNotify.get());
    }

    @Test
    public void addTwoNotCompletedNotifyValue() {
        UserTaskPropertyWriter userTaskPropertyWriter = new UserTaskPropertyWriter(Factories.bpmn2.createUserTask(), (VariableScope)this.variableScope);
        NotificationsInfo notificationsInfo = new NotificationsInfo();
        notificationsInfo.getValue().addValue(this.getNotificationValue(AssociationType.NOT_COMPLETED_NOTIFY.getName()));
        notificationsInfo.getValue().addValue(this.getNotificationValue(AssociationType.NOT_COMPLETED_NOTIFY.getName()));
        userTaskPropertyWriter.setNotifications(notificationsInfo);
        String cdata = this.getNotificationValue(AssociationType.NOT_COMPLETED_NOTIFY.getName()).toCDATAFormat();
        CustomInput notStartedNotify = (CustomInput)this.getFieldValue(UserTaskPropertyWriter.class, userTaskPropertyWriter, "notCompletedNotify");
        Assert.assertEquals((Object)this.asCDATA(cdata + "^" + cdata), (Object)notStartedNotify.get());
    }

    protected <T> T getFieldValue(Class parent, Object instance, String fieldName) {
        Field inputField = FieldUtils.getField((Class)parent, (String)fieldName, (boolean)true);
        try {
            return (T)inputField.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    private String asCDATA(String value) {
        return "<![CDATA[" + value + "]]>";
    }

    private NotificationValue getNotificationValue(String type) {
        ArrayList<String> users = new ArrayList<String>();
        users.add("AAA");
        users.add("BBB");
        ArrayList groups = new ArrayList();
        users.add("G1");
        users.add("G2");
        NotificationValue value = new NotificationValue();
        value.setType(type);
        value.setUsers(users);
        value.setGroups(groups);
        value.setFrom("User");
        value.setReplyTo("Admin");
        value.setSubject("Subj");
        value.setBody("Body");
        return value;
    }
}

