/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate.CatchingIntermediateEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateEscalationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.BaseCancellingEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.escalation.CancellingEscalationEventExecutionSet;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class CatchingIntermediateEscalationEventTest
extends CatchingIntermediateEventTest<IntermediateEscalationEvent> {
    private static final String BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/catchingIntermediateEscalationEvents.bpmn";
    private static final String EMPTY_TOP_LEVEL_EVENT_ID = "_5D25E05B-8085-451B-BDCC-1E945BB5D21F";
    private static final String FILLED_TOP_LEVEL_EVENT_ID = "_AC6A3989-D050-4385-B011-B05291F02964";
    private static final String EMPTY_SUBPROCESS_LEVEL_EVENT_ID = "_9AEC54C1-7E9A-4763-992E-DFD6330451EE";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_ID = "_DC14DEB1-483D-455B-95E4-882073C92823";
    private static final String EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID = "_0B297A34-733E-48CD-B9FE-7531C036BC3C";
    private static final String FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID = "_2155B7EA-648A-4B49-B784-DE3E04E47B48";
    private static final String EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID = "_C9A91991-AF34-489E-A7C9-1840DF0D8E6E";
    private static final String FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID = "_13BC7C98-398C-47CE-B4FE-CF388F7159BC";
    private static final String SLA_DUE_DATE = "12/25/1983";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 23;

    @Override
    @Test
    public void testUnmarshallTopLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Escalation event01 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Escalation event01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "escalation01";
        String EVENT_DATA_OUTPUT = "||output:String||[dout]output->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateEscalationEvent filledTopEvent = (IntermediateEscalationEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_TOP_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(filledTopEvent.getGeneral(), "Escalation event01 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Escalation event01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertEscalationEventExecutionSet(filledTopEvent.getExecutionSet(), "escalation01", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledTopEvent.getDataIOSet(), "||output:String||[dout]output->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyEventProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateEscalationEvent emptyTopEvent = (IntermediateEscalationEvent)this.getCatchingIntermediateNodeById(diagram, EMPTY_TOP_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(emptyTopEvent.getGeneral(), "", "");
        this.assertEscalationEventExecutionSet(emptyTopEvent.getExecutionSet(), "", true, "");
        this.assertDataIOSet(emptyTopEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Escalation event03 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Escalation event03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "escalation03";
        String EVENT_DATA_OUTPUT = "||output:String||[dout]output->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateEscalationEvent filledSubprocessEvent = (IntermediateEscalationEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Escalation event03 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Escalation event03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertEscalationEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "escalation03", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "||output:String||[dout]output->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateEscalationEvent emptySubprocessEvent = (IntermediateEscalationEvent)this.getCatchingIntermediateNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertEscalationEventExecutionSet(emptySubprocessEvent.getExecutionSet(), "", true, "");
        this.assertDataIOSet(emptySubprocessEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithEdgesFilledProperties() {
        String EVENT_NAME = "Escalation event02 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Escalation event02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "escalation02";
        String EVENT_DATA_OUTPUT = "||output:String||[dout]output->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateEscalationEvent filledSubprocessEvent = (IntermediateEscalationEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID, true, 2);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Escalation event02 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Escalation event02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertEscalationEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "escalation02", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "||output:String||[dout]output->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithEdgesEmptyProperties() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateEscalationEvent emptyEvent = (IntermediateEscalationEvent)this.getCatchingIntermediateNodeById(diagram, EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID, true, 2);
        this.assertGeneralSet(emptyEvent.getGeneral(), "", "");
        this.assertEscalationEventExecutionSet(emptyEvent.getExecutionSet(), "", true, "");
        this.assertDataIOSet(emptyEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithEdgesEmptyProperties() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateEscalationEvent emptySubprocessEvent = (IntermediateEscalationEvent)this.getCatchingIntermediateNodeById(diagram, EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID, true, 2);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertEscalationEventExecutionSet(emptySubprocessEvent.getExecutionSet(), "", true, "");
        this.assertDataIOSet(emptySubprocessEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithEdgesFilledProperties() {
        String EVENT_NAME = "Escalation event04 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Escalation event04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "escalation04";
        String EVENT_DATA_OUTPUT = "||output:String||[dout]output->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateEscalationEvent filledSubprocessEvent = (IntermediateEscalationEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID, true, 2);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Escalation event04 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Escalation event04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertEscalationEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "escalation04", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "||output:String||[dout]output->processGlobalVar");
    }

    @Override
    String getBpmnCatchingIntermediateEventFilePath() {
        return BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH;
    }

    @Override
    Class<IntermediateEscalationEvent> getCatchingIntermediateEventType() {
        return IntermediateEscalationEvent.class;
    }

    @Override
    String[] getFilledTopLevelEventIds() {
        return new String[]{FILLED_TOP_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptyTopLevelEventId() {
        return EMPTY_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledSubprocessLevelEventIds() {
        return new String[]{FILLED_SUBPROCESS_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptySubprocessLevelEventId() {
        return EMPTY_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledTopLevelEventWithEdgesIds() {
        return new String[]{FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptyTopLevelEventWithEdgesId() {
        return EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledSubprocessLevelEventWithEdgesIds() {
        return new String[]{FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptySubprocessLevelEventWithEdgesId() {
        return EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID;
    }

    private void assertEscalationEventExecutionSet(CancellingEscalationEventExecutionSet executionSet, String escalationRef, boolean isCancelling, String slaDueDate) {
        Assertions.assertThat((Object)executionSet).isNotNull();
        Assertions.assertThat((Object)executionSet.getEscalationRef()).isNotNull();
        Assertions.assertThat((String)executionSet.getEscalationRef().getValue()).isEqualTo((Object)escalationRef);
        this.assertEventCancelActivity((BaseCancellingEventExecutionSet)executionSet, isCancelling);
        this.assertEventSlaDueDate((BaseCancellingEventExecutionSet)executionSet, slaDueDate);
    }
}

