/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate.CatchingIntermediateEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateSignalEventCatching;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.BaseCancellingEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.CancellingSignalEventExecutionSet;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class CatchingIntermediateSignalEventTest
extends CatchingIntermediateEventTest<IntermediateSignalEventCatching> {
    private static final String BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/catchingIntermediateSignalEvents.bpmn";
    private static final String EMPTY_TOP_LEVEL_EVENT_ID = "061A48FF-5BDC-4A9F-B4A4-1379FBBB23C5";
    private static final String FILLED_TOP_LEVEL_EVENT_ID = "A45D6C7A-24BE-46AA-A6B9-25C480F7FFB5";
    private static final String EMPTY_SUBPROCESS_LEVEL_EVENT_ID = "FFA6848C-267E-46FA-806B-DF1F38BA3A3B";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_ID = "85C587F5-5C3A-4F48-B21B-887CF19FF3F2";
    private static final String EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID = "3DC11DED-4E87-4ECD-B2DA-F8AAB279C372";
    private static final String FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID = "A1A7E835-EBDA-4727-AAA9-7E230541B0F8";
    private static final String EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID = "C9F04A4E-107B-41B0-8A38-2CA7CD8D327C";
    private static final String FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID = "4257742E-5360-4D20-968A-FE14E68D9991";
    private static final String SLA_DUE_DATE = "12/25/1983";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 23;

    @Override
    @Test
    public void testUnmarshallTopLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "signal name ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String EVENT_DOCUMENTATION = "signal documentation\n ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String EVENT_REF = "signal1";
        String EVENT_DATA_OUTPUT = "||signal01:String||[dout]signal01->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateSignalEventCatching filledTopEvent = (IntermediateSignalEventCatching)this.getCatchingIntermediateNodeById(diagram, FILLED_TOP_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(filledTopEvent.getGeneral(), "signal name ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./", "signal documentation\n ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./");
        this.assertSignalEventExecutionSet(filledTopEvent.getExecutionSet(), "signal1", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledTopEvent.getDataIOSet(), "||signal01:String||[dout]signal01->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyEventProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateSignalEventCatching emptyTopEvent = (IntermediateSignalEventCatching)this.getCatchingIntermediateNodeById(diagram, EMPTY_TOP_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(emptyTopEvent.getGeneral(), "", "");
        this.assertSignalEventExecutionSet(emptyTopEvent.getExecutionSet(), "", true, "");
        this.assertDataIOSet(emptyTopEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "signal name ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String EVENT_DOCUMENTATION = "signal documentation\n ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String EVENT_REF = "signal3";
        String EVENT_DATA_OUTPUT = "||signal03:String||[dout]signal03->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateSignalEventCatching filledSubprocessEvent = (IntermediateSignalEventCatching)this.getCatchingIntermediateNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "signal name ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./", "signal documentation\n ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./");
        this.assertSignalEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "signal3", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "||signal03:String||[dout]signal03->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateSignalEventCatching emptySubprocessEvent = (IntermediateSignalEventCatching)this.getCatchingIntermediateNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertSignalEventExecutionSet(emptySubprocessEvent.getExecutionSet(), "", true, "");
        this.assertDataIOSet(emptySubprocessEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithEdgesFilledProperties() {
        String EVENT_NAME = "signal name ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String EVENT_DOCUMENTATION = "signal documentation\n ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String EVENT_REF = "signal2";
        String EVENT_DATA_OUTPUT = "||signal02:String||[dout]signal02->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateSignalEventCatching filledSubprocessEvent = (IntermediateSignalEventCatching)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID, true, 2);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "signal name ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./", "signal documentation\n ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./");
        this.assertSignalEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "signal2", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "||signal02:String||[dout]signal02->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithEdgesEmptyProperties() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateSignalEventCatching emptyEvent = (IntermediateSignalEventCatching)this.getCatchingIntermediateNodeById(diagram, EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID, true, 2);
        this.assertGeneralSet(emptyEvent.getGeneral(), "", "");
        this.assertSignalEventExecutionSet(emptyEvent.getExecutionSet(), "", true, "");
        this.assertDataIOSet(emptyEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithEdgesEmptyProperties() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateSignalEventCatching emptySubprocessEvent = (IntermediateSignalEventCatching)this.getCatchingIntermediateNodeById(diagram, EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID, true, 2);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertSignalEventExecutionSet(emptySubprocessEvent.getExecutionSet(), "", true, "");
        this.assertDataIOSet(emptySubprocessEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithEdgesFilledProperties() {
        String EVENT_NAME = "signal name ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String EVENT_DOCUMENTATION = "signal documentation\n ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String EVENT_REF = "signal4";
        String EVENT_DATA_OUTPUT = "||signal04:String||[dout]signal04->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateSignalEventCatching filledSubprocessEvent = (IntermediateSignalEventCatching)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID, true, 2);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "signal name ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./", "signal documentation\n ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./");
        this.assertSignalEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "signal4", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "||signal04:String||[dout]signal04->processGlobalVar");
    }

    @Override
    String getBpmnCatchingIntermediateEventFilePath() {
        return BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH;
    }

    @Override
    Class<IntermediateSignalEventCatching> getCatchingIntermediateEventType() {
        return IntermediateSignalEventCatching.class;
    }

    @Override
    String[] getFilledTopLevelEventIds() {
        return new String[]{FILLED_TOP_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptyTopLevelEventId() {
        return EMPTY_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledSubprocessLevelEventIds() {
        return new String[]{FILLED_SUBPROCESS_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptySubprocessLevelEventId() {
        return EMPTY_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledTopLevelEventWithEdgesIds() {
        return new String[]{FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptyTopLevelEventWithEdgesId() {
        return EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledSubprocessLevelEventWithEdgesIds() {
        return new String[]{FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptySubprocessLevelEventWithEdgesId() {
        return EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID;
    }

    private void assertSignalEventExecutionSet(CancellingSignalEventExecutionSet executionSet, String eventName, boolean isCancelling, String slaDueDate) {
        Assertions.assertThat((Object)executionSet).isNotNull();
        Assertions.assertThat((Object)executionSet.getSignalRef()).isNotNull();
        Assertions.assertThat((String)executionSet.getSignalRef().getValue()).isEqualTo((Object)eventName);
        this.assertEventCancelActivity((BaseCancellingEventExecutionSet)executionSet, isCancelling);
        this.assertEventSlaDueDate((BaseCancellingEventExecutionSet)executionSet, slaDueDate);
    }
}

