/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.tasks;

import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.tasks.TaskTest;
import org.kie.workbench.common.stunner.bpmn.definition.ScriptTask;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTaskExecutionSet;

public class ScriptTaskTest
extends TaskTest<ScriptTask> {
    private static final String BPMN_TASK_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/scriptTasks.bpmn";
    private static final String EMPTY_TOP_LEVEL_TASK_ID = "333A4DB9-7C2E-4977-A097-6EB5C0063758";
    private static final String FILLED_TOP_LEVEL_TASK_JAVA_ID = "31BA2691-4801-47C2-A3AA-8B7251EA3211";
    private static final String FILLED_TOP_LEVEL_TASK_JAVASCRIPT_ID = "C0CEEC7A-2CF2-46BE-871D-48326081333D";
    private static final String FILLED_TOP_LEVEL_TASK_MVEL_ID = "A624A934-9FF9-466B-87BD-AFCB9B49DBE8";
    private static final String EMPTY_SUBPROCESS_LEVEL_TASK_ID = "B5FFAB2E-541C-4076-B8BE-C7DF021BFBB7";
    private static final String FILLED_SUBPROCESS_LEVEL_TASK_JAVA_ID = "49B88C7E-D489-45FD-823F-BC311C9C77D9";
    private static final String FILLED_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID = "3E62ED06-C624-4CE0-8E14-0924870E58DA";
    private static final String FILLED_SUBPROCESS_LEVEL_TASK_MVEL_ID = "1AFC648A-5349-4DB5-990B-100EB53F27F7";
    private static final String EMPTY_ONE_INCOME_SUBPROCESS_LEVEL_TASK_ID = "E2D022E8-F2FA-42E8-9681-A904B7AB1CFF";
    private static final String FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_JAVA_ID = "9C038A3F-69E5-4B53-9069-E7F6A592610F";
    private static final String FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID = "937646E6-395A-44C9-8B40-510D0D8740A9";
    private static final String FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_MVEL_ID = "9954B580-F35D-43C4-A8AD-5032AC809AD2";
    private static final String EMPTY_ONE_INCOME_TOP_LEVEL_TASK_ID = "68D3692A-B349-4028-82EE-B2A8C21F5AA0";
    private static final String FILLED_ONE_INCOME_TOP_LEVEL_TASK_JAVA_ID = "B088F330-3FF9-49A1-BF54-A2C2F3D9A5DA";
    private static final String FILLED_ONE_INCOME_TOP_LEVEL_TASK_JAVASCRIPT_ID = "2C78233A-5E43-4B84-AA78-D80856DCC5E7";
    private static final String FILLED_ONE_INCOME_TOP_LEVEL_TASK_MVEL_ID = "EFC669E1-196D-49AD-95CC-18C521C7F4EF";
    private static final String EMPTY_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_ID = "8F3F3DBE-69B6-4E70-A6FC-63CC781E785A";
    private static final String FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_JAVA_ID = "C9C71AC1-DBDB-42C8-B97E-77BA7540FD43";
    private static final String FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID = "28BBADA1-77B6-45D5-8CAA-DDDE56B5ADC4";
    private static final String FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_MVEL_ID = "71B8BC86-1F13-42F0-9F0E-0C7A517BDC2D";
    private static final String EMPTY_TWO_INCOMES_TOP_LEVEL_TASK_ID = "BF703F87-D918-404F-AC1F-BB3AA4B7F193";
    private static final String FILLED_TWO_INCOMES_TOP_LEVEL_TASK_JAVA_ID = "A70EDCB6-7F3B-4524-BFEB-AD467B658BB4";
    private static final String FILLED_TWO_INCOMES_TOP_LEVEL_TASK_JAVASCRIPT_ID = "E4FE0906-EDFF-4A5C-9FA1-E470AFD00733";
    private static final String FILLED_TWO_INCOMES_TOP_LEVEL_TASK_MVEL_ID = "8A7FB383-DC6A-4271-A629-4E62A309D646";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 70;
    private static final String TASK_SCRIPT_DEFAULT_VALUE = null;
    private static final String TASK_SCRIPT_JAVA_LANGUAGE = "java";
    private static final String TASK_SCRIPT_JAVASCRIPT_LANGUAGE = "javascript";
    private static final String TASK_SCRIPT_MVEL_LANGUAGE = "mvel";
    private static final boolean IS_ASYNC = true;
    private static final boolean IS_NOT_ASYNC = false;
    private static final boolean IS_ADHOC_AUTOSTART = true;
    private static final boolean IS_NOT_ADHOC_AUTOSTART = false;

    @Override
    @Test
    public void testUnmarshallTopLevelTaskFilledProperties() {
        String TASK_NAME_JAVA = "Task01 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVA = "Task01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_SCRIPT_JAVA = "System.out.println(\"Called from Script Task.\");";
        String TASK_NAME_JAVASCRIPT = "Task07 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVASCRIPT = "Task07 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_SCRIPT_JAVASCRIPT = "console.log(\"Called from Script Task.\");";
        String TASK_NAME_MVEL = "Task10 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_MVEL = "Task10 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_SCRIPT_MVEL = "System.out.println(\"Called from Script Task.\");";
        this.assertDiagram(this.getDiagram(), 70);
        ScriptTask filledTopLevelTaskJava = (ScriptTask)this.getTaskNodeById(this.getDiagram(), FILLED_TOP_LEVEL_TASK_JAVA_ID, 0, false);
        this.assertGeneralSet(filledTopLevelTaskJava.getGeneral(), "Task01 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertScriptTaskExecutionSet(filledTopLevelTaskJava.getExecutionSet(), "System.out.println(\"Called from Script Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, true, true);
        ScriptTask filledTopLevelTaskJavascript = (ScriptTask)this.getTaskNodeById(this.getDiagram(), FILLED_TOP_LEVEL_TASK_JAVASCRIPT_ID, 0, false);
        this.assertGeneralSet(filledTopLevelTaskJavascript.getGeneral(), "Task07 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task07 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertScriptTaskExecutionSet(filledTopLevelTaskJavascript.getExecutionSet(), "console.log(\"Called from Script Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, true, true);
        ScriptTask filledTopLevelTaskMvel = (ScriptTask)this.getTaskNodeById(this.getDiagram(), FILLED_TOP_LEVEL_TASK_MVEL_ID, 0, false);
        this.assertGeneralSet(filledTopLevelTaskMvel.getGeneral(), "Task10 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task10 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertScriptTaskExecutionSet(filledTopLevelTaskMvel.getExecutionSet(), "System.out.println(\"Called from Script Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, true, true);
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyTaskProperties() {
        this.assertDiagram(this.getDiagram(), 70);
        ScriptTask filledTopLevelTask = (ScriptTask)this.getTaskNodeById(this.getDiagram(), EMPTY_TOP_LEVEL_TASK_ID, 0, false);
        this.assertGeneralSet(filledTopLevelTask.getGeneral(), "", "");
        this.assertScriptTaskExecutionSet(filledTopLevelTask.getExecutionSet(), TASK_SCRIPT_DEFAULT_VALUE, TASK_SCRIPT_JAVA_LANGUAGE, false, false);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelTaskFilledProperties() {
        String TASK_NAME_JAVA = "Task03 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVA = "Task03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_SCRIPT_JAVA = "System.out.println(\"Called from Script Task.\");";
        String TASK_NAME_JAVASCRIPT = "Task13 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVASCRIPT = "Task13 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_SCRIPT_JAVASCRIPT = "console.log(\"Called from Script Task.\");";
        String TASK_NAME_MVEL = "Task16 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_MVEL = "Task16 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_SCRIPT_MVEL = "System.out.println(\"Called from Script Task.\");";
        this.assertDiagram(this.getDiagram(), 70);
        ScriptTask filledSubprocessLevelTaskJava = (ScriptTask)this.getTaskNodeById(this.getDiagram(), FILLED_SUBPROCESS_LEVEL_TASK_JAVA_ID, 0, false);
        this.assertGeneralSet(filledSubprocessLevelTaskJava.getGeneral(), "Task03 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertScriptTaskExecutionSet(filledSubprocessLevelTaskJava.getExecutionSet(), "System.out.println(\"Called from Script Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, true, true);
        ScriptTask filledSubprocessLevelTaskJavascript = (ScriptTask)this.getTaskNodeById(this.getDiagram(), FILLED_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID, 0, false);
        this.assertGeneralSet(filledSubprocessLevelTaskJavascript.getGeneral(), "Task13 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task13 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertScriptTaskExecutionSet(filledSubprocessLevelTaskJavascript.getExecutionSet(), "console.log(\"Called from Script Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, true, true);
        ScriptTask filledSubprocessLevelTaskMvel = (ScriptTask)this.getTaskNodeById(this.getDiagram(), FILLED_SUBPROCESS_LEVEL_TASK_MVEL_ID, 0, false);
        this.assertGeneralSet(filledSubprocessLevelTaskMvel.getGeneral(), "Task16 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task16 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertScriptTaskExecutionSet(filledSubprocessLevelTaskMvel.getExecutionSet(), "System.out.println(\"Called from Script Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, true, true);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelTaskEmptyProperties() {
        this.assertDiagram(this.getDiagram(), 70);
        ScriptTask filledSubprocessLevelTaskJava = (ScriptTask)this.getTaskNodeById(this.getDiagram(), EMPTY_SUBPROCESS_LEVEL_TASK_ID, 0, false);
        this.assertGeneralSet(filledSubprocessLevelTaskJava.getGeneral(), "", "");
        this.assertScriptTaskExecutionSet(filledSubprocessLevelTaskJava.getExecutionSet(), TASK_SCRIPT_DEFAULT_VALUE, TASK_SCRIPT_JAVA_LANGUAGE, false, false);
    }

    @Override
    @Test
    public void testUnmarshallTopLevelTaskOneIncomeFilledProperties() {
        String TASK_NAME_JAVA = "Task02 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVA = "Task02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_SCRIPT_JAVA = "System.out.println(\"Called from Script Task.\");";
        String TASK_NAME_JAVASCRIPT = "Task08 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVASCRIPT = "Task08 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_SCRIPT_JAVASCRIPT = "console.log(\"Called from Script Task.\");";
        String TASK_NAME_MVEL = "Task11 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_MVEL = "Task11 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_SCRIPT_MVEL = "System.out.println(\"Called from Script Task.\");";
        this.assertDiagram(this.getDiagram(), 70);
        ScriptTask filledTopLevelTaskJava = (ScriptTask)this.getTaskNodeById(this.getDiagram(), FILLED_ONE_INCOME_TOP_LEVEL_TASK_JAVA_ID, 1, true);
        this.assertGeneralSet(filledTopLevelTaskJava.getGeneral(), "Task02 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertScriptTaskExecutionSet(filledTopLevelTaskJava.getExecutionSet(), "System.out.println(\"Called from Script Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, true, true);
        ScriptTask filledTopLevelTaskJavascript = (ScriptTask)this.getTaskNodeById(this.getDiagram(), FILLED_ONE_INCOME_TOP_LEVEL_TASK_JAVASCRIPT_ID, 1, true);
        this.assertGeneralSet(filledTopLevelTaskJavascript.getGeneral(), "Task08 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task08 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertScriptTaskExecutionSet(filledTopLevelTaskJavascript.getExecutionSet(), "console.log(\"Called from Script Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, true, true);
        ScriptTask filledTopLevelTaskMvel = (ScriptTask)this.getTaskNodeById(this.getDiagram(), FILLED_ONE_INCOME_TOP_LEVEL_TASK_MVEL_ID, 1, true);
        this.assertGeneralSet(filledTopLevelTaskMvel.getGeneral(), "Task11 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task11 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertScriptTaskExecutionSet(filledTopLevelTaskMvel.getExecutionSet(), "System.out.println(\"Called from Script Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, true, true);
    }

    @Override
    @Test
    public void testUnmarshallTopLevelTaskOneIncomeEmptyProperties() {
        this.assertDiagram(this.getDiagram(), 70);
        ScriptTask filledTopLevelTask = (ScriptTask)this.getTaskNodeById(this.getDiagram(), EMPTY_ONE_INCOME_TOP_LEVEL_TASK_ID, 1, true);
        this.assertGeneralSet(filledTopLevelTask.getGeneral(), "", "");
        this.assertScriptTaskExecutionSet(filledTopLevelTask.getExecutionSet(), TASK_SCRIPT_DEFAULT_VALUE, TASK_SCRIPT_JAVA_LANGUAGE, false, false);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelTaskOneIncomeEmptyProperties() {
        this.assertDiagram(this.getDiagram(), 70);
        ScriptTask filledSubprocessLevelTaskJava = (ScriptTask)this.getTaskNodeById(this.getDiagram(), EMPTY_ONE_INCOME_SUBPROCESS_LEVEL_TASK_ID, 1, true);
        this.assertGeneralSet(filledSubprocessLevelTaskJava.getGeneral(), "", "");
        this.assertScriptTaskExecutionSet(filledSubprocessLevelTaskJava.getExecutionSet(), TASK_SCRIPT_DEFAULT_VALUE, TASK_SCRIPT_JAVA_LANGUAGE, false, false);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelTaskOneIncomeFilledProperties() {
        String TASK_NAME_JAVA = "Task04 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVA = "Task04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_SCRIPT_JAVA = "System.out.println(\"Called from Script Task.\");";
        String TASK_NAME_JAVASCRIPT = "Task14 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVASCRIPT = "Task14 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_SCRIPT_JAVASCRIPT = "console.log(\"Called from Script Task.\");";
        String TASK_NAME_MVEL = "Task17 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_MVEL = "Task17 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_SCRIPT_MVEL = "System.out.println(\"Called from Script Task.\");";
        this.assertDiagram(this.getDiagram(), 70);
        ScriptTask filledSubprocessLevelTaskJava = (ScriptTask)this.getTaskNodeById(this.getDiagram(), FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_JAVA_ID, 1, true);
        this.assertGeneralSet(filledSubprocessLevelTaskJava.getGeneral(), "Task04 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertScriptTaskExecutionSet(filledSubprocessLevelTaskJava.getExecutionSet(), "System.out.println(\"Called from Script Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, true, true);
        ScriptTask filledSubprocessLevelTaskJavascript = (ScriptTask)this.getTaskNodeById(this.getDiagram(), FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID, 1, true);
        this.assertGeneralSet(filledSubprocessLevelTaskJavascript.getGeneral(), "Task14 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task14 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertScriptTaskExecutionSet(filledSubprocessLevelTaskJavascript.getExecutionSet(), "console.log(\"Called from Script Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, true, true);
        ScriptTask filledSubprocessLevelTaskMvel = (ScriptTask)this.getTaskNodeById(this.getDiagram(), FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_MVEL_ID, 1, true);
        this.assertGeneralSet(filledSubprocessLevelTaskMvel.getGeneral(), "Task17 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task17 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertScriptTaskExecutionSet(filledSubprocessLevelTaskMvel.getExecutionSet(), "System.out.println(\"Called from Script Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, true, true);
    }

    @Override
    @Test
    public void testUnmarshallTopLevelTaskTwoIncomesFilledProperties() {
        String TASK_NAME_JAVA = "Task05 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVA = "Task05 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_SCRIPT_JAVA = "System.out.println(\"Called from Script Task.\");";
        String TASK_NAME_JAVASCRIPT = "Task09 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVASCRIPT = "Task09 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_SCRIPT_JAVASCRIPT = "console.log(\"Called from Script Task.\");";
        String TASK_NAME_MVEL = "Task12 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_MVEL = "Task12 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_SCRIPT_MVEL = "System.out.println(\"Called from Script Task.\");";
        this.assertDiagram(this.getDiagram(), 70);
        ScriptTask filledTopLevelTaskJava = (ScriptTask)this.getTaskNodeById(this.getDiagram(), FILLED_TWO_INCOMES_TOP_LEVEL_TASK_JAVA_ID, 2, true);
        this.assertGeneralSet(filledTopLevelTaskJava.getGeneral(), "Task05 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task05 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertScriptTaskExecutionSet(filledTopLevelTaskJava.getExecutionSet(), "System.out.println(\"Called from Script Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, true, true);
        ScriptTask filledTopLevelTaskJavascript = (ScriptTask)this.getTaskNodeById(this.getDiagram(), FILLED_TWO_INCOMES_TOP_LEVEL_TASK_JAVASCRIPT_ID, 2, true);
        this.assertGeneralSet(filledTopLevelTaskJavascript.getGeneral(), "Task09 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task09 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertScriptTaskExecutionSet(filledTopLevelTaskJavascript.getExecutionSet(), "console.log(\"Called from Script Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, true, true);
        ScriptTask filledTopLevelTaskMvel = (ScriptTask)this.getTaskNodeById(this.getDiagram(), FILLED_TWO_INCOMES_TOP_LEVEL_TASK_MVEL_ID, 2, true);
        this.assertGeneralSet(filledTopLevelTaskMvel.getGeneral(), "Task12 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task12 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertScriptTaskExecutionSet(filledTopLevelTaskMvel.getExecutionSet(), "System.out.println(\"Called from Script Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, true, true);
    }

    @Override
    @Test
    public void testUnmarshallTopLevelTaskTwoIncomesEmptyProperties() {
        this.assertDiagram(this.getDiagram(), 70);
        ScriptTask filledTopLevelTask = (ScriptTask)this.getTaskNodeById(this.getDiagram(), EMPTY_TWO_INCOMES_TOP_LEVEL_TASK_ID, 2, true);
        this.assertGeneralSet(filledTopLevelTask.getGeneral(), "", "");
        this.assertScriptTaskExecutionSet(filledTopLevelTask.getExecutionSet(), TASK_SCRIPT_DEFAULT_VALUE, TASK_SCRIPT_JAVA_LANGUAGE, false, false);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelTaskTwoIncomesEmptyProperties() {
        this.assertDiagram(this.getDiagram(), 70);
        ScriptTask filledSubprocessLevelTaskJava = (ScriptTask)this.getTaskNodeById(this.getDiagram(), EMPTY_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_ID, 2, true);
        this.assertGeneralSet(filledSubprocessLevelTaskJava.getGeneral(), "", "");
        this.assertScriptTaskExecutionSet(filledSubprocessLevelTaskJava.getExecutionSet(), TASK_SCRIPT_DEFAULT_VALUE, TASK_SCRIPT_JAVA_LANGUAGE, false, false);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelTaskTwoIncomesFilledProperties() {
        String TASK_NAME_JAVA = "Task06 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVA = "Task06 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_SCRIPT_JAVA = "System.out.println(\"Called from Script Task.\");";
        String TASK_NAME_JAVASCRIPT = "Task15 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVASCRIPT = "Task15 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_SCRIPT_JAVASCRIPT = "console.log(\"Called from Script Task.\");";
        String TASK_NAME_MVEL = "Task18 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_MVEL = "Task18 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_SCRIPT_MVEL = "System.out.println(\"Called from Script Task.\");";
        this.assertDiagram(this.getDiagram(), 70);
        ScriptTask filledSubprocessLevelTaskJava = (ScriptTask)this.getTaskNodeById(this.getDiagram(), FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_JAVA_ID, 2, true);
        this.assertGeneralSet(filledSubprocessLevelTaskJava.getGeneral(), "Task06 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task06 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertScriptTaskExecutionSet(filledSubprocessLevelTaskJava.getExecutionSet(), "System.out.println(\"Called from Script Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, true, true);
        ScriptTask filledSubprocessLevelTaskJavascript = (ScriptTask)this.getTaskNodeById(this.getDiagram(), FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID, 2, true);
        this.assertGeneralSet(filledSubprocessLevelTaskJavascript.getGeneral(), "Task15 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task15 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertScriptTaskExecutionSet(filledSubprocessLevelTaskJavascript.getExecutionSet(), "console.log(\"Called from Script Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, true, true);
        ScriptTask filledSubprocessLevelTaskMvel = (ScriptTask)this.getTaskNodeById(this.getDiagram(), FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_MVEL_ID, 2, true);
        this.assertGeneralSet(filledSubprocessLevelTaskMvel.getGeneral(), "Task18 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task18 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertScriptTaskExecutionSet(filledSubprocessLevelTaskMvel.getExecutionSet(), "System.out.println(\"Called from Script Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, true, true);
    }

    @Override
    @Test
    public void testMarshallTopLevelTaskFilledProperties() {
        this.checkTaskMarshalling(FILLED_TOP_LEVEL_TASK_JAVA_ID, 0, false);
        this.checkTaskMarshalling(FILLED_TOP_LEVEL_TASK_JAVASCRIPT_ID, 0, false);
        this.checkTaskMarshalling(FILLED_TOP_LEVEL_TASK_MVEL_ID, 0, false);
    }

    @Override
    @Test
    public void testMarshallSubprocessLevelTaskFilledProperties() {
        this.checkTaskMarshalling(FILLED_SUBPROCESS_LEVEL_TASK_JAVA_ID, 0, false);
        this.checkTaskMarshalling(FILLED_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID, 0, false);
        this.checkTaskMarshalling(FILLED_SUBPROCESS_LEVEL_TASK_MVEL_ID, 0, false);
    }

    @Override
    @Test
    public void testMarshallTopLevelTaskOneIncomeFilledProperties() {
        this.checkTaskMarshalling(FILLED_ONE_INCOME_TOP_LEVEL_TASK_JAVA_ID, 1, true);
        this.checkTaskMarshalling(FILLED_ONE_INCOME_TOP_LEVEL_TASK_JAVASCRIPT_ID, 1, true);
        this.checkTaskMarshalling(FILLED_ONE_INCOME_TOP_LEVEL_TASK_MVEL_ID, 1, true);
    }

    @Override
    @Test
    public void testMarshallSubprocessLevelTaskOneIncomeFilledProperties() {
        this.checkTaskMarshalling(FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_JAVA_ID, 1, true);
        this.checkTaskMarshalling(FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID, 1, true);
        this.checkTaskMarshalling(FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_MVEL_ID, 1, true);
    }

    @Override
    @Test
    public void testMarshallTopLevelTaskTwoIncomesFilledProperties() {
        this.checkTaskMarshalling(FILLED_TWO_INCOMES_TOP_LEVEL_TASK_JAVA_ID, 2, true);
        this.checkTaskMarshalling(FILLED_TWO_INCOMES_TOP_LEVEL_TASK_JAVASCRIPT_ID, 2, true);
        this.checkTaskMarshalling(FILLED_TWO_INCOMES_TOP_LEVEL_TASK_MVEL_ID, 2, true);
    }

    @Override
    @Test
    public void testMarshallSubprocessLevelTaskTwoIncomesFilledProperties() {
        this.checkTaskMarshalling(FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_JAVA_ID, 2, true);
        this.checkTaskMarshalling(FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID, 2, true);
        this.checkTaskMarshalling(FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_MVEL_ID, 2, true);
    }

    @Override
    String getBpmnTaskFilePath() {
        return BPMN_TASK_FILE_PATH;
    }

    @Override
    Class<ScriptTask> getTaskType() {
        return ScriptTask.class;
    }

    @Override
    String getFilledTopLevelTaskId() {
        return null;
    }

    @Override
    String getEmptyTopLevelTaskId() {
        return EMPTY_TOP_LEVEL_TASK_ID;
    }

    @Override
    String getFilledSubprocessLevelTaskId() {
        return null;
    }

    @Override
    String getEmptySubprocessLevelTaskId() {
        return EMPTY_SUBPROCESS_LEVEL_TASK_ID;
    }

    @Override
    String getFilledTopLevelTaskOneIncomeId() {
        return null;
    }

    @Override
    String getEmptyTopLevelTaskOneIncomeId() {
        return EMPTY_ONE_INCOME_TOP_LEVEL_TASK_ID;
    }

    @Override
    String getFilledSubprocessLevelTaskOneIncomeId() {
        return null;
    }

    @Override
    String getEmptySubprocessLevelTaskOneIncomeId() {
        return EMPTY_ONE_INCOME_SUBPROCESS_LEVEL_TASK_ID;
    }

    @Override
    String getFilledTopLevelTaskTwoIncomesId() {
        return null;
    }

    @Override
    String getEmptyTopLevelTaskTwoIncomesId() {
        return EMPTY_TWO_INCOMES_TOP_LEVEL_TASK_ID;
    }

    @Override
    String getFilledSubprocessLevelTaskTwoIncomesId() {
        return null;
    }

    @Override
    String getEmptySubprocessLevelTaskTwoIncomesId() {
        return EMPTY_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_ID;
    }

    private void assertScriptTaskExecutionSet(ScriptTaskExecutionSet executionSet, String script, String scriptLanguage, boolean isAsync, boolean isAdHocAutostart) {
        Assert.assertNotNull((Object)executionSet);
        Assert.assertNotNull((Object)executionSet.getScript());
        Assert.assertNotNull((Object)executionSet.getScript().getValue());
        Assert.assertNotNull((Object)executionSet.getIsAsync());
        Assert.assertNotNull((Object)executionSet.getAdHocAutostart());
        Assert.assertEquals((Object)script, (Object)executionSet.getScript().getValue().getScript());
        Assert.assertEquals((Object)scriptLanguage, (Object)executionSet.getScript().getValue().getLanguage());
        Assert.assertEquals((Object)isAsync, (Object)executionSet.getIsAsync().getValue());
        Assert.assertEquals((Object)isAdHocAutostart, (Object)executionSet.getIsAsync().getValue());
    }
}

