/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.queryresults;

import org.mariadb.jdbc.internal.packet.dao.ColumnInformation;
import org.mariadb.jdbc.internal.queryresults.AbstractQueryResult;
import org.mariadb.jdbc.internal.queryresults.ModifyQueryResult;
import org.mariadb.jdbc.internal.queryresults.ResultSetType;

public class UpdateResult
extends ModifyQueryResult {
    private long updateCount;
    private short warnings;
    private final String message;
    private final long insertId;

    public UpdateResult(long updateCount, short warnings, String message, long insertId) {
        this.updateCount = updateCount;
        this.warnings = warnings;
        this.message = message;
        this.insertId = insertId;
    }

    @Override
    public void addResult(AbstractQueryResult other) {
        if (other.prepareResult != null) {
            this.prepareResult = other.prepareResult;
        }
        this.isClosed = other.isClosed();
        if (other instanceof UpdateResult) {
            UpdateResult updateResult = (UpdateResult)other;
            this.updateCount += updateResult.getUpdateCount();
            this.warnings = (short)(this.warnings + updateResult.getWarnings());
        }
    }

    @Override
    public long getUpdateCount() {
        return this.updateCount;
    }

    @Override
    public ResultSetType getResultSetType() {
        return ResultSetType.MODIFY;
    }

    @Override
    public short getWarnings() {
        return this.warnings;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public ColumnInformation[] getColumnInformation() {
        return null;
    }

    @Override
    public int getRows() {
        return 0;
    }

    @Override
    public long getInsertId() {
        return this.insertId;
    }
}

