/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.PortBinding;
import java.util.HashMap;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.docker.DockerClientConnector;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="DockerCreateContainerDefinitions.wid", name="DockerCreateContainer", displayName="DockerCreateContainer", defaultHandler="mvel: new org.jbpm.process.workitem.docker.CreateContainerWorkitemHandler()", documentation="docker-workitem/index.html", category="docker-workitem", icon="DockerCreateContainer.png", parameters={@WidParameter(name="ContainerName", required=true), @WidParameter(name="ContainerImageName", required=true), @WidParameter(name="ContainerCommand"), @WidParameter(name="ContainerHostName"), @WidParameter(name="ContainerEnv"), @WidParameter(name="ContainerPortBindings"), @WidParameter(name="ContainerBinds")}, results={@WidResult(name="ContainerId")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="docker-workitem", version="7.35.0.Final")}, serviceInfo=@WidService(category="Docker", description="Connect to and interact with a running Docker deamon", keywords="Docker,create,container", action=@WidAction(title="Create Docker container")))
public class CreateContainerWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateContainerWorkitemHandler.class);
    private static final String RESULTS_DOCUMENT = "ContainerId";
    private DockerClient dockerClient;

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            CreateContainerResponse container;
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String containerName = (String)workItem.getParameter("ContainerName");
            String containerImageName = (String)workItem.getParameter("ContainerImageName");
            String containerCommand = (String)workItem.getParameter("ContainerCommand");
            String containerHostName = (String)workItem.getParameter("ContainerHostName");
            String containerEnv = (String)workItem.getParameter("ContainerEnv");
            String containerPortBindings = (String)workItem.getParameter("ContainerPortBindings");
            String containerBinds = (String)workItem.getParameter("ContainerBinds");
            if (this.dockerClient == null) {
                DockerClientConnector connector = new DockerClientConnector();
                this.dockerClient = connector.getDockerClient();
            }
            CreateContainerCmd createContainerCmd = this.dockerClient.createContainerCmd(containerImageName).withName(containerName);
            if (containerCommand != null) {
                createContainerCmd = createContainerCmd.withCmd(new String[]{containerCommand});
            }
            if (containerHostName != null) {
                createContainerCmd = createContainerCmd.withHostName(containerHostName);
            }
            if (containerEnv != null) {
                createContainerCmd = createContainerCmd.withEnv(new String[]{containerEnv});
            }
            if (containerPortBindings != null) {
                createContainerCmd = createContainerCmd.withPortBindings(new PortBinding[]{PortBinding.parse((String)containerPortBindings)});
            }
            if (containerBinds != null) {
                createContainerCmd = createContainerCmd.withBinds(new Bind[]{Bind.parse((String)containerBinds)});
            }
            if ((container = createContainerCmd.exec()) != null && container.getId() != null) {
                results.put(RESULTS_DOCUMENT, container.getId());
            }
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            logger.error("Unable to create container: " + e.getMessage());
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setDockerClient(DockerClient dockerClient) {
        this.dockerClient = dockerClient;
    }
}

