/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query.standard;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import org.apache.lucene.search.Query;
import org.kie.workbench.common.services.refactoring.backend.server.query.NamedQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.SearchEmptyQueryBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.AbstractFindQuery;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueModuleRootPathIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValuePackageNameIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueSharedPartIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringStringPageRow;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KProperty;
import org.uberfire.paging.PageResponse;

@ApplicationScoped
public class FindScorecardNamesQuery
extends AbstractFindQuery
implements NamedQuery {
    public static final String NAME = FindScorecardNamesQuery.class.getSimpleName();
    private static final ValueSharedPartIndexTerm scorecardTerm = new ValueSharedPartIndexTerm("not-used", PartType.SCORECARD_MODEL_NAME);
    private ScorecardResponseBuilder responseBuilder = new ScorecardResponseBuilder();

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ResponseBuilder getResponseBuilder() {
        return this.responseBuilder;
    }

    @Override
    public Query toQuery(Set<ValueIndexTerm> terms) {
        SearchEmptyQueryBuilder queryBuilder = new SearchEmptyQueryBuilder();
        for (ValueIndexTerm term : terms) {
            if (term instanceof ValueSharedPartIndexTerm) {
                queryBuilder.addTerm(term);
                continue;
            }
            if (term instanceof ValueModuleRootPathIndexTerm) {
                queryBuilder.addTerm(term);
                continue;
            }
            if (!(term instanceof ValuePackageNameIndexTerm)) continue;
            queryBuilder.addTerm(term);
        }
        return queryBuilder.build();
    }

    @Override
    public void validateTerms(Set<ValueIndexTerm> queryTerms) throws IllegalArgumentException {
        this.checkNotNullAndNotEmpty(queryTerms);
        this.checkInvalidAndRequiredTerms(queryTerms, NAME, new String[]{null, null, scorecardTerm.getTerm()}, t -> t instanceof ValueModuleRootPathIndexTerm, t -> t instanceof ValuePackageNameIndexTerm, t -> Objects.equals(t.getTerm(), scorecardTerm.getTerm()));
    }

    private static class ScorecardResponseBuilder
    implements ResponseBuilder {
        private ScorecardResponseBuilder() {
        }

        @Override
        public PageResponse<RefactoringPageRow> buildResponse(int pageSize, int startRow, List<KObject> kObjects) {
            int hits = kObjects.size();
            PageResponse response = new PageResponse();
            List<RefactoringPageRow> result = this.buildResponse(kObjects);
            response.setTotalRowSize(hits);
            response.setPageRowList(result);
            response.setTotalRowSizeExact(true);
            response.setStartRowIndex(startRow);
            response.setLastPage(pageSize * startRow + 2 >= hits);
            return response;
        }

        @Override
        public List<RefactoringPageRow> buildResponse(List<KObject> kObjects) {
            ArrayList<RefactoringPageRow> result = new ArrayList<RefactoringPageRow>(kObjects.size());
            for (KObject kObject : kObjects) {
                for (String name : this.getScorecardModelNamesNamesFromKObject(kObject)) {
                    RefactoringStringPageRow row = new RefactoringStringPageRow();
                    row.setValue((Object)name);
                    result.add((RefactoringPageRow)row);
                }
            }
            return result;
        }

        private Set<String> getScorecardModelNamesNamesFromKObject(KObject kObject) {
            HashSet<String> result = new HashSet<String>();
            if (kObject == null) {
                return result;
            }
            for (KProperty property : kObject.getProperties()) {
                if (!Objects.equals("shared:scorecardModelName", property.getName())) continue;
                result.add(property.getValue().toString());
            }
            return result;
        }
    }
}

