/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.adf.engine.shared.formGeneration;

import java.util.HashMap;
import java.util.Map;
import org.kie.workbench.common.forms.adf.engine.shared.FormElementFilter;
import org.kie.workbench.common.forms.adf.engine.shared.formGeneration.FormGenerationContext;
import org.kie.workbench.common.forms.adf.engine.shared.formGeneration.FormGenerator;
import org.kie.workbench.common.forms.adf.engine.shared.formGeneration.I18nHelper;
import org.kie.workbench.common.forms.adf.engine.shared.formGeneration.layout.LayoutGenerator;
import org.kie.workbench.common.forms.adf.engine.shared.formGeneration.processing.FormElementProcessor;
import org.kie.workbench.common.forms.adf.service.building.FieldStatusModifier;
import org.kie.workbench.common.forms.adf.service.building.FormGenerationResourcesProvider;
import org.kie.workbench.common.forms.adf.service.definitions.FormDefinitionSettings;
import org.kie.workbench.common.forms.adf.service.definitions.I18nSettings;
import org.kie.workbench.common.forms.adf.service.definitions.elements.FormElement;
import org.kie.workbench.common.forms.adf.service.definitions.layout.LayoutColumnDefinition;
import org.kie.workbench.common.forms.adf.service.definitions.layout.LayoutDefinition;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;

public abstract class AbstractFormGenerator
implements FormGenerator {
    protected LayoutGenerator layoutGenerator;
    protected Map<Class<? extends FormElement>, FormElementProcessor> processors = new HashMap<Class<? extends FormElement>, FormElementProcessor>();
    protected Map<String, FormDefinitionSettings> formDefinitionSettings = new HashMap<String, FormDefinitionSettings>();
    protected Map<String, FieldStatusModifier> fieldModifiers = new HashMap<String, FieldStatusModifier>();
    protected Map<String, String> fieldModifierReferences = new HashMap<String, String>();

    public AbstractFormGenerator(LayoutGenerator layoutGenerator) {
        this.layoutGenerator = layoutGenerator;
    }

    protected void registerProcessor(FormElementProcessor processor) {
        if (processor != null) {
            this.processors.put(processor.getSupportedElementType(), processor);
        }
    }

    protected void registerResources(FormGenerationResourcesProvider provider) {
        if (provider != null) {
            if (this.isValid(provider.getDefinitionSettings())) {
                this.formDefinitionSettings.putAll(provider.getDefinitionSettings());
            }
            if (this.isValid(provider.getFieldModifiers())) {
                this.fieldModifiers.putAll(provider.getFieldModifiers());
            }
            if (this.isValid(provider.getFieldModifierReferences())) {
                this.fieldModifierReferences.putAll(provider.getFieldModifierReferences());
            }
        }
    }

    private boolean isValid(Map map) {
        return map != null && !map.isEmpty();
    }

    @Override
    public FormDefinition generateFormForModel(Object model, FormElementFilter ... filters) {
        FormDefinitionSettings settings = this.formDefinitionSettings.get(model.getClass().getName());
        if (settings != null) {
            return this.generateFormDefinition(settings, model, filters);
        }
        return null;
    }

    @Override
    public FormDefinition generateFormForClass(Class clazz, FormElementFilter ... filters) {
        return this.generateFormForClassName(clazz.getName(), filters);
    }

    @Override
    public FormDefinition generateFormForClassName(String className, FormElementFilter ... filters) {
        FormDefinitionSettings settings = this.formDefinitionSettings.get(className);
        if (settings != null) {
            return this.generateFormDefinition(settings, null, filters);
        }
        return null;
    }

    protected FormDefinition generateFormDefinition(FormDefinitionSettings settings, Object model, FormElementFilter ... filters) {
        FormGenerationContext context = new FormGenerationContext(model, settings, this.getI18nHelper(settings.getI18nSettings()), filters);
        context.setFieldStatusModifierReferences(this.fieldModifierReferences);
        context.setFieldStatusModifiers(this.fieldModifiers);
        if (settings.getLayout() == null || settings.getLayout().getColumns() == null || settings.getLayout().getColumns().length == 0) {
            settings.setLayout(new LayoutDefinition(new LayoutColumnDefinition[]{new LayoutColumnDefinition()}));
        }
        this.layoutGenerator.init(settings.getLayout().getColumns());
        this.processElements(context);
        FormDefinition form = context.getFormDefinition();
        form.setLayoutTemplate(this.layoutGenerator.build());
        return form;
    }

    protected abstract I18nHelper getI18nHelper(I18nSettings var1);

    protected void processElements(FormGenerationContext context) {
        context.getFormDefinitionSettings().getFormElements().forEach(formElement -> {
            LayoutComponent layoutComponent;
            FormElementFilter filter;
            FormElementProcessor processor = this.processors.get(formElement.getClass());
            if (processor != null && ((filter = context.getFilter(formElement.getName())) == null || filter.getPredicate().test(context.getModel())) && (layoutComponent = processor.processFormElement(formElement, context)) != null) {
                this.layoutGenerator.addComponent(layoutComponent, formElement.getLayoutSettings());
            }
        });
    }
}

