/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.service;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.screens.datasource.management.backend.service.DataSourceServicesHelper;
import org.kie.workbench.common.screens.datasource.management.backend.service.DefChangeHandler;
import org.uberfire.backend.vfs.Path;
import org.uberfire.workbench.events.ResourceAddedEvent;
import org.uberfire.workbench.events.ResourceDeletedEvent;
import org.uberfire.workbench.events.ResourceRenamedEvent;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

@ApplicationScoped
public class DefResourceChangeObserver {
    private DefChangeHandler defChangeHandler;
    private DataSourceServicesHelper serviceHelper;

    public DefResourceChangeObserver() {
    }

    @Inject
    public DefResourceChangeObserver(DataSourceServicesHelper serviceHelper) {
        this.serviceHelper = serviceHelper;
    }

    public void setDefChangeHandler(DefChangeHandler defChangeHandler) {
        this.defChangeHandler = defChangeHandler;
    }

    public void onResourceAdd(@Observes ResourceAddedEvent resourceAddedEvent) {
        if (this.defChangeHandler != null && this.isProcessable(resourceAddedEvent.getPath())) {
            this.defChangeHandler.processResourceAdd(resourceAddedEvent.getPath(), resourceAddedEvent.getSessionInfo());
        }
    }

    public void onResourceUpdate(@Observes ResourceUpdatedEvent resourceUpdatedEvent) {
        if (this.defChangeHandler != null && this.isProcessable(resourceUpdatedEvent.getPath())) {
            this.defChangeHandler.processResourceUpdate(resourceUpdatedEvent.getPath(), resourceUpdatedEvent.getSessionInfo());
        }
    }

    public void onResourceRename(@Observes ResourceRenamedEvent resourceRenamedEvent) {
        if (this.defChangeHandler != null && this.isProcessable(resourceRenamedEvent.getDestinationPath())) {
            this.defChangeHandler.processResourceRename(resourceRenamedEvent.getPath(), resourceRenamedEvent.getDestinationPath(), resourceRenamedEvent.getSessionInfo());
        }
    }

    public void onResourceDelete(@Observes ResourceDeletedEvent resourceDeletedEvent) {
        if (this.defChangeHandler != null && this.isProcessable(resourceDeletedEvent.getPath())) {
            this.defChangeHandler.processResourceDelete(resourceDeletedEvent.getPath(), resourceDeletedEvent.getSessionInfo());
        }
    }

    private boolean isProcessable(Path path) {
        return this.serviceHelper.isDataSourceFile(path) || this.serviceHelper.isDriverFile(path);
    }
}

