/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.backend.server.conversion;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.core.util.DateUtils;
import org.drools.decisiontable.parser.xls.ExcelParser;
import org.drools.template.model.Import;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionMessageType;
import org.drools.workbench.models.guided.dtable.shared.conversion.ConversionResult;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.drltext.service.DRLTextEditorService;
import org.drools.workbench.screens.drltext.type.DRLResourceTypeDefinition;
import org.drools.workbench.screens.dtablexls.backend.server.conversion.GuidedDecisionTableGeneratorListener;
import org.drools.workbench.screens.dtablexls.service.DecisionTableXLSConversionService;
import org.drools.workbench.screens.dtablexls.type.DecisionTableXLSResourceTypeDefinition;
import org.drools.workbench.screens.dtablexls.type.DecisionTableXLSXResourceTypeDefinition;
import org.drools.workbench.screens.factmodel.backend.server.util.FactModelPersistence;
import org.drools.workbench.screens.factmodel.model.AnnotationMetaModel;
import org.drools.workbench.screens.factmodel.model.FactMetaModel;
import org.drools.workbench.screens.factmodel.model.FactModels;
import org.drools.workbench.screens.factmodel.model.FieldMetaModel;
import org.drools.workbench.screens.globals.model.Global;
import org.drools.workbench.screens.globals.model.GlobalsModel;
import org.drools.workbench.screens.globals.service.GlobalsEditorService;
import org.drools.workbench.screens.globals.type.GlobalResourceTypeDefinition;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableEditorService;
import org.drools.workbench.screens.guided.dtable.type.GuidedDTableResourceTypeDefinition;
import org.guvnor.common.services.project.model.ProjectImports;
import org.guvnor.common.services.shared.config.AppConfigService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.DataModelImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.DataObjectImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.ObjectPropertyImpl;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.kie.workbench.common.services.shared.project.ProjectImportsService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@ApplicationScoped
public class DecisionTableXLSToDecisionTableGuidedConverter
implements DecisionTableXLSConversionService {
    private IOService ioService;
    private DRLTextEditorService drlService;
    private GuidedDecisionTableEditorService guidedDecisionTableService;
    private GlobalsEditorService globalsService;
    private KieModuleService moduleService;
    private ProjectImportsService importsService;
    private MetadataService metadataService;
    private DataModelerService modellerService;
    private DataModelService dataModelService;
    private AppConfigService appConfigService;
    private DecisionTableXLSResourceTypeDefinition xlsDTableType;
    private DecisionTableXLSXResourceTypeDefinition xlsxDTableType;
    private GuidedDTableResourceTypeDefinition guidedDTableType;
    private DRLResourceTypeDefinition drlType;
    private GlobalResourceTypeDefinition globalsType;
    private Map<String, AnnotationDefinition> annotationDefinitions;

    public DecisionTableXLSToDecisionTableGuidedConverter() {
    }

    @Inject
    public DecisionTableXLSToDecisionTableGuidedConverter(@Named(value="ioStrategy") IOService ioService, DRLTextEditorService drlService, GuidedDecisionTableEditorService guidedDecisionTableService, GlobalsEditorService globalsService, KieModuleService moduleService, ProjectImportsService importsService, MetadataService metadataService, DataModelerService modellerService, DataModelService dataModelService, AppConfigService appConfigService, DecisionTableXLSResourceTypeDefinition xlsDTableType, DecisionTableXLSXResourceTypeDefinition xlsxDTableType, GuidedDTableResourceTypeDefinition guidedDTableType, DRLResourceTypeDefinition drlType, GlobalResourceTypeDefinition globalsType) {
        this.ioService = ioService;
        this.drlService = drlService;
        this.guidedDecisionTableService = guidedDecisionTableService;
        this.globalsService = globalsService;
        this.moduleService = moduleService;
        this.importsService = importsService;
        this.metadataService = metadataService;
        this.modellerService = modellerService;
        this.dataModelService = dataModelService;
        this.appConfigService = appConfigService;
        this.xlsDTableType = xlsDTableType;
        this.xlsxDTableType = xlsxDTableType;
        this.guidedDTableType = guidedDTableType;
        this.drlType = drlType;
        this.globalsType = globalsType;
    }

    @PostConstruct
    public void setup() {
        this.initialiseTypeConversionMetaData();
        this.initialiseApplicationPreferences();
    }

    private void initialiseTypeConversionMetaData() {
        this.annotationDefinitions = this.modellerService.getAnnotationDefinitions();
    }

    private void initialiseApplicationPreferences() {
        ApplicationPreferences.setUp((Map)this.appConfigService.loadPreferences());
    }

    public ConversionResult convert(org.uberfire.backend.vfs.Path path) {
        ConversionResult result = new ConversionResult();
        if (!this.xlsDTableType.accept(path) && !this.xlsxDTableType.accept(path)) {
            result.addMessage("Source Asset must be either a XLS or XLSX Decision Table file.", ConversionMessageType.ERROR);
            return result;
        }
        PackageDataModelOracle dmo = this.dataModelService.getDataModel(path);
        GuidedDecisionTableGeneratorListener listener = this.parseAssets(path, result, dmo);
        org.uberfire.backend.vfs.Path context = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)path).getParent());
        this.createNewImports(context, listener.getImports(), result);
        this.createNewFunctions(context, listener.getImports(), listener.getFunctions(), result);
        this.createNewQueries(context, listener.getImports(), listener.getQueries(), result);
        this.makeNewJavaTypes(context, listener.getTypeDeclarations(), result);
        this.createNewGlobals(context, listener.getImports(), listener.getGlobals(), result);
        this.createNewDecisionTables(context, listener.getImports(), listener.getGuidedDecisionTables(), result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GuidedDecisionTableGeneratorListener parseAssets(org.uberfire.backend.vfs.Path path, ConversionResult result, PackageDataModelOracle dmo) {
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result, dmo);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream stream = this.ioService.newInputStream(Paths.convert((org.uberfire.backend.vfs.Path)path), new OpenOption[0]);
        try {
            parser.parseFile(stream);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ioe) {
                result.addMessage(ioe.getMessage(), ConversionMessageType.ERROR);
            }
        }
        return listener;
    }

    private void createNewFunctions(org.uberfire.backend.vfs.Path context, List<Import> imports, List<String> functions, ConversionResult result) {
        if (functions == null || functions.isEmpty()) {
            return;
        }
        for (int iCounter = 0; iCounter < functions.size(); ++iCounter) {
            String assetName = this.makeNewAssetName("Function " + (iCounter + 1), (ResourceTypeDefinition)this.drlType);
            String drl = this.makeDRL(imports, functions.get(iCounter));
            this.drlService.create(context, assetName, (Object)drl, "Converted from XLS Decision Table");
            result.addMessage("Created Function '" + assetName + "'", ConversionMessageType.INFO);
        }
    }

    private void createNewQueries(org.uberfire.backend.vfs.Path context, List<Import> imports, List<String> queries, ConversionResult result) {
        if (queries == null || queries.isEmpty()) {
            return;
        }
        for (int iCounter = 0; iCounter < queries.size(); ++iCounter) {
            String assetName = this.makeNewAssetName("Query " + (iCounter + 1), (ResourceTypeDefinition)this.drlType);
            String drl = this.makeDRL(imports, queries.get(iCounter));
            this.drlService.create(context, assetName, (Object)drl, "Converted from XLS Decision Table");
            result.addMessage("Created Query '" + assetName + "'", ConversionMessageType.INFO);
        }
    }

    private void makeNewJavaTypes(org.uberfire.backend.vfs.Path context, List<String> declaredTypes, ConversionResult result) {
        if (declaredTypes == null || declaredTypes.isEmpty()) {
            return;
        }
        KieModule module = (KieModule)this.moduleService.resolveModule(context);
        for (String declaredType : declaredTypes) {
            FactModels factModels = FactModelPersistence.unmarshal((String)declaredType);
            String packageName = factModels.getPackageName();
            DataModelImpl dataModel = new DataModelImpl();
            for (FactMetaModel factMetaModel : factModels.getModels()) {
                DataObjectImpl dataObject = new DataObjectImpl(packageName, factMetaModel.getName());
                dataObject.setSuperClassName(factMetaModel.getSuperType());
                List annotationMetaModel = factMetaModel.getAnnotations();
                this.addAnnotations((DataObject)dataObject, annotationMetaModel);
                List fields = factMetaModel.getFields();
                for (FieldMetaModel fieldMetaModel : fields) {
                    String fieldName = fieldMetaModel.name;
                    String fieldType = fieldMetaModel.type;
                    boolean isMultiple = false;
                    ObjectPropertyImpl property = new ObjectPropertyImpl(fieldName, fieldType, isMultiple);
                    dataObject.addProperty((ObjectProperty)property);
                    result.addMessage("Created Java Type " + this.getJavaTypeFQCN((DataObject)dataObject), ConversionMessageType.INFO);
                }
                dataModel.getDataObjects().add(dataObject);
            }
            this.modellerService.saveModel((DataModel)dataModel, module);
        }
    }

    private String getJavaTypeFQCN(DataObject dataObject) {
        String packageName = dataObject.getPackageName();
        String className = dataObject.getClassName();
        if (packageName == null || packageName.equals("")) {
            return className;
        }
        return packageName + "." + className;
    }

    private void addAnnotations(DataObject dataObject, List<AnnotationMetaModel> annotationMetaModelList) {
        for (AnnotationMetaModel annotationMetaModel : annotationMetaModelList) {
            AnnotationImpl annotation;
            String name = annotationMetaModel.name;
            Map values = annotationMetaModel.values;
            String key = "value";
            String value = "";
            if (values.size() > 0) {
                key = (String)values.keySet().iterator().next();
                value = (String)values.values().iterator().next();
            }
            if ("Role".equals(name)) {
                annotation = new AnnotationImpl(this.annotationDefinitions.get("org.kie.api.definition.type.Role"));
                annotation.setValue(key, (Object)value);
                dataObject.addAnnotation((Annotation)annotation);
                continue;
            }
            if ("Position".equals(name)) {
                annotation = new AnnotationImpl(this.annotationDefinitions.get("org.kie.api.definition.type.Position"));
                annotation.setValue(key, (Object)value);
                dataObject.addAnnotation((Annotation)annotation);
                continue;
            }
            if (!"Equals".equals(name)) continue;
            annotation = new AnnotationImpl(this.annotationDefinitions.get("org.kie.api.definition.type.Key"));
            annotation.setValue(key, (Object)value);
            dataObject.addAnnotation((Annotation)annotation);
        }
    }

    private String makeDRL(List<Import> imports, String baseDRL) {
        StringBuilder sb = new StringBuilder();
        if (imports != null && !imports.isEmpty()) {
            for (Import item : imports) {
                sb.append("import ").append(item.getClassName()).append(";\n");
            }
            sb.append("\n");
        }
        sb.append(baseDRL).append("\n");
        return sb.toString();
    }

    private void createNewGlobals(org.uberfire.backend.vfs.Path context, List<Import> imports, List<org.drools.template.model.Global> globals, ConversionResult result) {
        if (globals == null || globals.isEmpty()) {
            return;
        }
        String assetName = this.makeNewAssetName("Global", (ResourceTypeDefinition)this.globalsType);
        GlobalsModel model = this.makeGlobalsModel(imports, globals, result);
        this.globalsService.create(context, assetName, (Object)model, "Converted from XLS Decision Table");
        result.addMessage("Created Globals '" + assetName + "'", ConversionMessageType.INFO);
    }

    private GlobalsModel makeGlobalsModel(List<Import> imports, List<org.drools.template.model.Global> globals, ConversionResult result) {
        GlobalsModel model = new GlobalsModel();
        for (org.drools.template.model.Global global : globals) {
            if (global.getClassName().contains(".")) {
                model.getGlobals().add(new Global(global.getIdentifier(), global.getClassName()));
                continue;
            }
            boolean mapped = false;
            for (Import imp : imports) {
                if (!imp.getClassName().contains(".")) continue;
                String fullyQualifiedClassName = imp.getClassName();
                String leafClassName = fullyQualifiedClassName.substring(fullyQualifiedClassName.lastIndexOf(".") + 1);
                if (!global.getClassName().equals(leafClassName)) continue;
                model.getGlobals().add(new Global(global.getIdentifier(), fullyQualifiedClassName));
                mapped = true;
                break;
            }
            if (mapped) continue;
            result.addMessage("Unable to determine Fully Qualified Class Name for Global '" + global.getIdentifier() + "'. Skipping.", ConversionMessageType.ERROR);
        }
        return model;
    }

    private void createNewImports(org.uberfire.backend.vfs.Path context, List<Import> imports, ConversionResult result) {
        if (imports == null || imports.isEmpty()) {
            return;
        }
        KieModule module = (KieModule)this.moduleService.resolveModule(context);
        org.uberfire.backend.vfs.Path externalImportsPath = module.getImportsPath();
        ProjectImports projectImports = this.loadProjectImports(externalImportsPath);
        ArrayList<String> existingImports = new ArrayList<String>();
        for (Object item : projectImports.getImports().getImports()) {
            existingImports.add(item.getType());
        }
        boolean isModified = false;
        for (Import item : imports) {
            if (existingImports.contains(item.getClassName())) continue;
            isModified = true;
            result.addMessage("Created Import for '" + item.getClassName() + "'.", ConversionMessageType.INFO);
            projectImports.getImports().addImport(new org.kie.soup.project.datamodel.imports.Import(item.getClassName()));
        }
        if (isModified) {
            Metadata metadata = this.metadataService.getMetadata(context);
            this.importsService.save(externalImportsPath, (Object)projectImports, metadata, "Imports added during XLS conversion");
        }
    }

    ProjectImports loadProjectImports(org.uberfire.backend.vfs.Path externalImportsPath) {
        Path nioExternalImportsPath = Paths.convert((org.uberfire.backend.vfs.Path)externalImportsPath);
        ProjectImports projectImports = new ProjectImports();
        if (Files.exists((Path)nioExternalImportsPath, (LinkOption[])new LinkOption[0])) {
            projectImports = (ProjectImports)this.importsService.load(externalImportsPath);
        }
        return projectImports;
    }

    private void createNewDecisionTables(org.uberfire.backend.vfs.Path context, List<Import> imports, List<GuidedDecisionTable52> dtables, ConversionResult result) {
        if (dtables == null || dtables.isEmpty()) {
            return;
        }
        for (int iCounter = 0; iCounter < dtables.size(); ++iCounter) {
            GuidedDecisionTable52 dtable = dtables.get(iCounter);
            for (Import item : imports) {
                dtable.getImports().addImport(new org.kie.soup.project.datamodel.imports.Import(item.getClassName()));
            }
            String assetName = this.makeNewAssetName(dtable.getTableName(), (ResourceTypeDefinition)this.guidedDTableType);
            this.guidedDecisionTableService.create(context, assetName, (Object)dtable, "Converted from XLS Decision Table");
            result.addMessage("Created Guided Decision Table '" + assetName + "'", ConversionMessageType.INFO);
        }
    }

    private String makeNewAssetName(String baseName, ResourceTypeDefinition type) {
        Calendar now = Calendar.getInstance();
        StringBuilder sb = new StringBuilder(baseName);
        sb.append(" (converted on ");
        sb.append(DateUtils.format((Date)now.getTime()));
        sb.append(" ");
        sb.append(now.get(11));
        sb.append("-");
        sb.append(now.get(12));
        sb.append("-");
        sb.append(now.get(13));
        sb.append(")");
        sb.append(".").append(type.getSuffix());
        return sb.toString();
    }
}

