/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.processing.index.map;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.Dependent;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.processing.index.GraphIndexBuilder;
import org.kie.workbench.common.stunner.core.graph.processing.index.map.MapIndex;

@Dependent
public class MapIndexBuilder
implements GraphIndexBuilder<MapIndex> {
    public MapIndex build(Graph<?, Node> graph) {
        assert (graph != null);
        return this.doWork(graph, null);
    }

    public void update(MapIndex index, Graph<?, Node> graph) {
        this.doWork(graph, index);
    }

    private MapIndex doWork(Graph<?, Node> graph, MapIndex current) {
        HashMap<String, Node> nodes = new HashMap<String, Node>();
        HashMap<String, Edge> edges = new HashMap<String, Edge>();
        Iterable nodesIter = graph.nodes();
        for (Node node : nodesIter) {
            this.processNode(nodes, edges, node);
        }
        if (null == current) {
            return new MapIndex(graph, nodes, edges);
        }
        current.nodes.clear();
        current.nodes.putAll(nodes);
        current.edges.clear();
        current.edges.putAll(edges);
        return current;
    }

    private void processNode(Map<String, Node> nodes, Map<String, Edge> edges, Node node) {
        if (!nodes.containsKey(node.getUUID())) {
            nodes.put(node.getUUID(), node);
            List outEdges = node.getOutEdges();
            if (null != outEdges && !outEdges.isEmpty()) {
                for (Edge edge : outEdges) {
                    this.processEdge(nodes, edges, edge);
                }
            }
        }
    }

    private void processEdge(Map<String, Node> nodes, Map<String, Edge> edges, Edge edge) {
        if (!edges.containsKey(edge.getUUID())) {
            edges.put(edge.getUUID(), edge);
        }
    }
}

