/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.model.DMNElement;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.QName;

public abstract class Expression
extends DMNElement
implements HasTypeRef,
HasComponentWidths {
    protected QName typeRef;
    protected List<Double> componentWidths = new ArrayList<Double>();

    public Expression() {
    }

    public Expression(Id id, Description description, QName typeRef) {
        super(id, description);
        this.typeRef = typeRef;
    }

    @Override
    public QName getTypeRef() {
        return this.typeRef;
    }

    @Override
    public void setTypeRef(QName typeRef) {
        this.typeRef = typeRef;
    }

    @Override
    public List<Double> getComponentWidths() {
        int requiredComponentWidthCount = this.getRequiredComponentWidthCount();
        if (this.componentWidths.size() != requiredComponentWidthCount) {
            this.componentWidths = new ArrayList<Double>(requiredComponentWidthCount);
            IntStream.range(0, requiredComponentWidthCount).forEach(i -> this.componentWidths.add(null));
        }
        return this.componentWidths;
    }

    @Override
    public DMNModelInstrumentedBase asDMNModelInstrumentedBase() {
        return this;
    }

    @Override
    public List<HasTypeRef> getHasTypeRefs() {
        return new ArrayList<HasTypeRef>(Collections.singletonList(this));
    }
}

