/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import elemental2.promise.Promise;
import java.lang.Object;
import java.lang.String;
import java.lang.Void;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface ServiceWorkerGlobalScope extends WorkerGlobalScope {
  @JsFunction
  public interface OnactivateCallbackFn {
    Object onInvoke(ExtendableEvent p0);
  }

  @JsFunction
  public interface OnbeforeevictedCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnevictedCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnfetchCallbackFn {
    Object onInvoke(FetchEvent p0);
  }

  @JsFunction
  public interface OninstallCallbackFn {
    Object onInvoke(InstallEvent p0);
  }

  @JsFunction
  public interface OnmessageCallbackFn {
    Object onInvoke(MessageEvent p0);
  }

  @JsProperty
  CacheStorage getCaches();

  @JsProperty
  ServiceWorkerClients getClients();

  @JsProperty
  Console getConsole();

  @JsProperty
  Object getIndexedDB();

  @JsProperty
  OnactivateCallbackFn getOnactivate();

  @JsProperty
  OnbeforeevictedCallbackFn getOnbeforeevicted();

  @JsProperty
  OnevictedCallbackFn getOnevicted();

  @JsProperty
  OnfetchCallbackFn getOnfetch();

  @JsProperty
  OninstallCallbackFn getOninstall();

  @JsProperty
  OnmessageCallbackFn getOnmessage();

  @JsProperty
  ServiceWorkerRegistration getRegistration();

  @JsProperty
  String getScope();

  @JsProperty
  Cache getScriptCache();

  @JsProperty
  void setCaches(CacheStorage caches);

  @JsProperty
  void setClients(ServiceWorkerClients clients);

  @JsProperty
  void setConsole(Console console);

  @JsProperty
  void setIndexedDB(Object indexedDB);

  @JsProperty
  void setOnactivate(OnactivateCallbackFn onactivate);

  @JsProperty
  void setOnbeforeevicted(OnbeforeevictedCallbackFn onbeforeevicted);

  @JsProperty
  void setOnevicted(OnevictedCallbackFn onevicted);

  @JsProperty
  void setOnfetch(OnfetchCallbackFn onfetch);

  @JsProperty
  void setOninstall(OninstallCallbackFn oninstall);

  @JsProperty
  void setOnmessage(OnmessageCallbackFn onmessage);

  @JsProperty
  void setRegistration(ServiceWorkerRegistration registration);

  @JsProperty
  void setScope(String scope);

  @JsProperty
  void setScriptCache(Cache scriptCache);

  Promise<Void> skipWaiting();
}
