/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.acceptor.tabu.size;

import org.optaplanner.core.impl.localsearch.decider.acceptor.tabu.size.AbstractTabuSizeStrategy;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;

public class EntityRatioTabuSizeStrategy
extends AbstractTabuSizeStrategy {
    protected final double tabuRatio;

    public EntityRatioTabuSizeStrategy(double tabuRatio) {
        this.tabuRatio = tabuRatio;
        if (tabuRatio <= 0.0 || tabuRatio >= 1.0) {
            throw new IllegalArgumentException("The tabuRatio (" + tabuRatio + ") must be between 0.0 and 1.0.");
        }
    }

    @Override
    public int determineTabuSize(LocalSearchStepScope stepScope) {
        int entityCount = stepScope.getPhaseScope().getWorkingEntityCount();
        int tabuSize = (int)Math.round((double)entityCount * this.tabuRatio);
        return this.protectTabuSizeCornerCases(entityCount, tabuSize);
    }
}

