/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.simple;

import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.score.inliner.IntWeightedScoreImpacter;
import org.optaplanner.core.impl.score.inliner.ScoreInliner;

public class SimpleScoreInliner
extends ScoreInliner<SimpleScore> {
    protected int score;

    protected SimpleScoreInliner(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled);
    }

    public IntWeightedScoreImpacter buildWeightedScoreImpacter(SimpleScore constraintWeight) {
        if (constraintWeight.equals(SimpleScore.ZERO)) {
            throw new IllegalArgumentException("The constraintWeight (" + constraintWeight + ") cannot be zero, this constraint should have been culled during node creation.");
        }
        int simpleConstraintWeight = constraintWeight.getScore();
        return (matchWeight, matchScoreConsumer) -> {
            int impact = simpleConstraintWeight * matchWeight;
            this.score += impact;
            if (this.constraintMatchEnabled) {
                matchScoreConsumer.accept(SimpleScore.of(impact));
            }
            return () -> this.score -= impact;
        };
    }

    @Override
    public SimpleScore extractScore(int initScore) {
        return SimpleScore.ofUninitialized(initScore, this.score);
    }

    public String toString() {
        return SimpleScore.class.getSimpleName() + " inliner";
    }
}

