/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.command.impl;

import java.util.Objects;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractControlPointCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.DeleteControlPointCommand;
import org.kie.workbench.common.stunner.core.graph.content.HasControlPoints;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.util.ControlPointValidations;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

@Portable
public class AddControlPointCommand
extends AbstractControlPointCommand {
    private final ControlPoint controlPoint;
    private final int index;

    public AddControlPointCommand(@MapsTo(value="edgeUUID") String edgeUUID, @MapsTo(value="controlPoint") ControlPoint controlPoint, @MapsTo(value="index") int index) {
        super(edgeUUID);
        this.controlPoint = (ControlPoint)PortablePreconditions.checkNotNull((String)"controlPoint", (Object)controlPoint);
        this.index = index;
    }

    @Override
    protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
        ControlPointValidations.checkAddControlPoint(this.getEdgeControlPoints(context).getControlPoints(), this.controlPoint, this.index);
        return GraphCommandResultBuilder.SUCCESS;
    }

    public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
        this.check(context);
        HasControlPoints edgeControlPoints = this.getEdgeControlPoints(context);
        int size = Objects.isNull(edgeControlPoints.getControlPoints()) ? 0 : edgeControlPoints.getControlPoints().length;
        ControlPoint[] cps = new ControlPoint[size + 1];
        for (int i = 0; i < size + 1; ++i) {
            cps[i] = i < this.index ? edgeControlPoints.getControlPoints()[i] : (i == this.index ? this.controlPoint : edgeControlPoints.getControlPoints()[i - 1]);
        }
        edgeControlPoints.setControlPoints(cps);
        return GraphCommandResultBuilder.SUCCESS;
    }

    public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
        return new DeleteControlPointCommand(this.getEdgeUUID(), this.index).execute(context);
    }
}

