/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.command.impl;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.NonPortable;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCompositeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.DeleteConnectorCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.SafeDeleteNodeCommand;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

@Portable
public class DeleteElementsCommand
extends AbstractGraphCompositeCommand {
    private final Collection<String> uuids;
    private transient Collection<Element> elements;
    private transient DeleteCallback callback;

    public DeleteElementsCommand(@MapsTo(value="uuids") Collection<String> uuids) {
        this.uuids = (Collection)PortablePreconditions.checkNotNull((String)"uuids", uuids);
        this.callback = new DeleteCallback(){};
    }

    public DeleteElementsCommand(Supplier<Collection<Element>> elements) {
        this(elements.get().stream().map(Element::getUUID).collect(Collectors.toList()));
        this.elements = elements.get();
    }

    public DeleteElementsCommand(Supplier<Collection<Element>> elements, DeleteCallback callback) {
        this(elements);
        this.callback = callback;
    }

    protected DeleteElementsCommand initialize(GraphCommandExecutionContext context) {
        super.initialize(context);
        if (null == this.elements) {
            this.elements = this.uuids.stream().map(uuid -> context.getGraphIndex().get(uuid)).collect(Collectors.toList());
        }
        if (this.elements.isEmpty()) {
            throw new IllegalArgumentException("No elements to delete.");
        }
        if (1 == this.elements.size()) {
            Element element = this.elements.iterator().next();
            if (null != element.asNode()) {
                Node node = element.asNode();
                SafeDeleteNodeCommand.Options options = SafeDeleteNodeCommand.Options.defaults();
                this.commands.add(this.createSafeDeleteNodeCommand(node, options, this.callback));
            } else {
                Edge edge2 = element.asEdge();
                this.commands.add(new DeleteConnectorCommand((Edge<? extends View, Node>)edge2));
                this.callback.onDeleteEdge((Edge<? extends View, Node>)edge2);
            }
        } else {
            List<Element> edges = this.elements.stream().filter(e -> null != e.asEdge()).collect(Collectors.toList());
            Set edgeIds = edges.stream().map(Element::getUUID).collect(Collectors.toSet());
            edges.forEach(edge -> {
                this.commands.add(new DeleteConnectorCommand((Edge<? extends View, Node>)((Edge)edge)));
                this.callback.onDeleteEdge((Edge<? extends View, Node>)((Edge)edge));
            });
            this.elements.stream().filter(e -> null != e.asNode()).collect(Collectors.toList()).forEach(e -> {
                Node node = (Node)e;
                SafeDeleteNodeCommand.Options options = SafeDeleteNodeCommand.Options.exclude(edgeIds);
                this.commands.add(this.createSafeDeleteNodeCommand(node, options, this.callback));
            });
        }
        return this;
    }

    protected SafeDeleteNodeCommand createSafeDeleteNodeCommand(Node<?, Edge> node, SafeDeleteNodeCommand.Options options, DeleteCallback callback) {
        return new SafeDeleteNodeCommand(node, callback.onDeleteNode(node, options), options);
    }

    public Collection<String> getUUIDs() {
        return this.uuids;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[UUIDs=" + this.uuids + "]";
    }

    @Override
    protected boolean delegateRulesContextToChildren() {
        return true;
    }

    @NonPortable
    public static interface DeleteCallback {
        default public SafeDeleteNodeCommand.SafeDeleteNodeCommandCallback onDeleteNode(Node<?, Edge> node, SafeDeleteNodeCommand.Options options) {
            return null;
        }

        default public void onDeleteEdge(Edge<? extends View, Node> edge) {
        }
    }
}

