/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bound;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Dock;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.graph.util.Exceptions;

public class GraphUtils {
    public static Object getProperty(DefinitionManager definitionManager, Element<? extends Definition> element, String id) {
        return Optional.ofNullable(element).map(Element::getContent).map(Definition::getDefinition).map(def -> Exceptions.swallow(() -> definitionManager.adapters().forDefinition().getProperties(def), Collections.emptySet())).map(properties -> Exceptions.swallow(() -> GraphUtils.getProperty(definitionManager, properties, id), null)).orElseGet(() -> Optional.ofNullable(element).map(Element::getContent).map(Definition::getDefinition).map(def -> GraphUtils.getPropertyByField(definitionManager, def, id)).orElse(null));
    }

    public static Object getPropertyByField(DefinitionManager definitionManager, Object bean, String field) {
        return GraphUtils.getPropertyByField((String currentField) -> definitionManager.adapters().forDefinition().getProperty(bean, currentField), (Object ps, String currentField) -> definitionManager.adapters().forPropertySet().getProperty(ps, currentField), field);
    }

    private static Object getPropertyByField(Function<String, Optional<?>> propertyProvider, BiFunction<Object, String, Optional<?>> childPropertiesProvider, String field) {
        int index = field.indexOf(46);
        String firstField = index > -1 ? field.substring(0, index) : field;
        Optional<?> optionalBean = propertyProvider.apply(firstField);
        Object bean = optionalBean.orElse(null);
        return index > 0 && null != bean ? GraphUtils.getPropertyByField((String currentField) -> (Optional)childPropertiesProvider.apply(bean, (String)currentField), childPropertiesProvider, field.substring(index + 1)) : bean;
    }

    public static Object getProperty(DefinitionManager definitionManager, Set properties, String id) {
        if (null != id && null != properties) {
            for (Object property : properties) {
                String pId = definitionManager.adapters().forProperty().getId(property);
                if (!pId.equals(id)) continue;
                return property;
            }
        }
        return null;
    }

    public static int countEdges(DefinitionManager definitionManager, String edgeId, Collection<? extends Edge> edges) {
        if (null == edges) {
            return 0;
        }
        return (int)edges.stream().map(edge -> GraphUtils.getElementDefinitionId(definitionManager, edge)).filter(edgeId::equals).count();
    }

    public static Map<String, Integer> getLabelsCount(Graph<?, ? extends Node> target, Set<String> roleFilter) {
        return GraphUtils.getLabelsCount(target, e -> true, roleFilter);
    }

    public static Map<String, Integer> getLabelsCount(Graph<?, ? extends Node> target, Predicate<Element<?>> elementFilter, Set<String> roleFilter) {
        HashMap<String, Integer> labelsCount = new HashMap<String, Integer>();
        Iterable nodes = target.nodes();
        StreamSupport.stream(nodes.spliterator(), false).filter(elementFilter::test).forEach(node -> GraphUtils.computeLabelsCount(node, labelsCount, roleFilter));
        return labelsCount;
    }

    public static void computeLabelsCount(Node node, Map<String, Integer> labelsCount, Set<String> roleFilter) {
        Set<String> labels = GraphUtils.getLabels(node);
        labels.stream().filter(role -> null == roleFilter || roleFilter.contains(role)).forEach(role -> {
            Integer i = (Integer)labelsCount.get(role);
            labelsCount.put((String)role, null != i ? i + 1 : 1);
        });
    }

    public static CardinalityCountState computeCardinalityState(Diagram diagram) {
        Node thirdElement;
        String rootUUID = diagram.getMetadata().getCanvasRootUUID();
        Graph graph = diagram.getGraph();
        Iterator nodes = graph.nodes().iterator();
        Node firstElement = nodes.hasNext() ? ((Element)nodes.next()).asNode() : null;
        Node secondElement = null != firstElement && nodes.hasNext() ? ((Element)nodes.next()).asNode() : null;
        Node node = thirdElement = null != secondElement && nodes.hasNext() ? ((Element)nodes.next()).asNode() : null;
        if (null != thirdElement) {
            return CardinalityCountState.MULTIPLE_NODES;
        }
        if (null != secondElement && secondElement.getUUID().equals(rootUUID)) {
            return CardinalityCountState.SINGLE_NODE;
        }
        if (null != firstElement && firstElement.getUUID().equals(rootUUID)) {
            return null != secondElement ? CardinalityCountState.SINGLE_NODE : CardinalityCountState.EMPTY;
        }
        if (null != firstElement && null != secondElement) {
            return CardinalityCountState.MULTIPLE_NODES;
        }
        return null != firstElement ? CardinalityCountState.SINGLE_NODE : CardinalityCountState.EMPTY;
    }

    public static Set<String> getLabels(Element<? extends Definition<?>> element) {
        return element != null && null != element.getLabels() ? element.getLabels() : Collections.emptySet();
    }

    public static Element<?> getParent(Node<?, ? extends Edge> element) {
        return Optional.ofNullable(element).map(Node::getInEdges).orElse(Collections.emptyList()).stream().filter(e -> e.getContent() instanceof Child).findAny().map(Edge::getSourceNode).orElse(null);
    }

    public static Optional<Element<? extends Definition>> getParentByDefinitionId(DefinitionManager definitionManager, Function<Node, Element> parentSupplier, Node<?, ? extends Edge> candidate, Predicate<String> parentDefIdFilter) {
        PortablePreconditions.checkNotNull((String)"candidate", candidate);
        Element p = parentSupplier.apply(candidate);
        while (null != p && null != p.asNode() && p.getContent() instanceof Definition) {
            String cID = GraphUtils.getElementDefinitionId(definitionManager, p);
            if (parentDefIdFilter.test(cID)) {
                return Optional.of(p);
            }
            p = parentSupplier.apply(p.asNode());
        }
        return Optional.empty();
    }

    public static Optional<Element<? extends Definition>> getParentByDefinitionId(DefinitionManager definitionManager, Function<Node, Element> parentSupplier, Node<?, ? extends Edge> candidate, String parentDefId) {
        PortablePreconditions.checkNotNull((String)"candidate", candidate);
        PortablePreconditions.checkNotNull((String)"parentDefId", (Object)parentDefId);
        return GraphUtils.getParentByDefinitionId(definitionManager, parentSupplier, candidate, parentDefId::equals);
    }

    public static Point2D getPosition(View element) {
        Bound ul = element.getBounds().getUpperLeft();
        double x = ul.getX();
        double y = ul.getY();
        return new Point2D(x, y);
    }

    public static Point2D getComputedPosition(Node<?, ? extends Edge> element) {
        double x = 0.0;
        double y = 0.0;
        Node<?, ? extends Edge> parent = element;
        while (null != parent && null != parent.asNode() && parent.getContent() instanceof View) {
            Point2D position = GraphUtils.getPosition((View)parent.getContent());
            x += position.getX();
            y += position.getY();
            parent = GraphUtils.getParent(parent);
        }
        return new Point2D(x, y);
    }

    public static double[] getNodeSize(View element) {
        return GraphUtils.getSize(element.getBounds());
    }

    private static double[] getSize(Bounds bounds) {
        Bound ul = bounds.getUpperLeft();
        Bound lr = bounds.getLowerRight();
        double w = lr.getX() - ul.getX();
        double h = lr.getY() - ul.getY();
        return new double[]{Math.abs(w), Math.abs(h)};
    }

    public static boolean isRootNode(Element<? extends View<?>> element, Graph<DefinitionSet, Node> graph) {
        if (element instanceof Node) {
            Node node = (Node)element;
            Element<?> parent = GraphUtils.getParent(node);
            return parent == null;
        }
        return false;
    }

    public static boolean checkBoundsExceeded(Bounds parentBounds, Bounds bounds) {
        if (null == parentBounds) {
            return true;
        }
        if (parentBounds.hasUpperLeft() && (bounds.getUpperLeft().getX() < parentBounds.getUpperLeft().getX() || bounds.getUpperLeft().getY() < parentBounds.getUpperLeft().getY())) {
            return false;
        }
        return !parentBounds.hasLowerRight() || !(bounds.getLowerRight().getX() > parentBounds.getLowerRight().getX()) && !(bounds.getLowerRight().getY() > parentBounds.getLowerRight().getY());
    }

    public static <C> Node<Definition<C>, ?> getFirstNode(Graph<?, Node> graph, Class<?> type) {
        if (null != graph) {
            for (Node node : graph.nodes()) {
                Object content = node.getContent();
                try {
                    Definition definitionContent = (Definition)content;
                    if (!GraphUtils.instanceOf(definitionContent.getDefinition(), type)) continue;
                    return node;
                }
                catch (ClassCastException classCastException) {
                }
            }
        }
        return null;
    }

    public static boolean hasChildren(Node<?, ? extends Edge> element) {
        return Objects.nonNull(element.getOutEdges()) ? element.getOutEdges().stream().anyMatch(edge -> edge.getContent() instanceof Child) : false;
    }

    public static boolean hasDockedNodes(Node<?, ? extends Edge> element) {
        return Objects.nonNull(element.getOutEdges()) ? element.getOutEdges().stream().anyMatch(edge -> edge.getContent() instanceof Dock) : false;
    }

    public static boolean hasConnections(Node<? extends Definition<?>, ? extends Edge> node) {
        return Stream.concat(node.getInEdges().stream(), node.getOutEdges().stream()).anyMatch(GraphUtils.hasConnectionFilter());
    }

    public static boolean hasTargetConnections(Node<? extends Definition<?>, ? extends Edge> node) {
        return node.getInEdges().stream().anyMatch(GraphUtils.hasConnectionFilter());
    }

    public static Predicate<Element> isContentSomeDefinition() {
        return e -> e.getContent() instanceof Definition;
    }

    private static Predicate<Edge> hasConnectionFilter() {
        return edge -> edge.getContent() instanceof ViewConnector;
    }

    public static List<Node> getDockedNodes(Node<?, ? extends Edge> element) {
        return GraphUtils.getNodesFromOutEdges(element, edge -> edge.getContent() instanceof Dock);
    }

    public static List<Node> getChildNodes(Node<?, ? extends Edge> element) {
        return GraphUtils.getNodesFromOutEdges(element, edge -> edge.getContent() instanceof Child);
    }

    private static List<Node> getNodesFromOutEdges(Node<?, ? extends Edge> element, Predicate<Edge> filter) {
        Objects.requireNonNull(element.getOutEdges());
        return element.getOutEdges().stream().filter(filter::test).map(Edge::getTargetNode).collect(Collectors.toList());
    }

    public static List<Edge<? extends ViewConnector<?>, Node>> getSourceConnections(Node<?, ? extends Edge> element) {
        Objects.requireNonNull(element.getOutEdges());
        return GraphUtils.getConnections(element.getOutEdges());
    }

    public static List<Edge<? extends ViewConnector<?>, Node>> getTargetConnections(Node<?, ? extends Edge> element) {
        Objects.requireNonNull(element.getInEdges());
        return GraphUtils.getConnections(element.getInEdges());
    }

    private static List<Edge<? extends ViewConnector<?>, Node>> getConnections(List<? extends Edge> edges) {
        return edges.stream().filter(edge -> edge.getContent() instanceof ViewConnector).map(edge -> edge).collect(Collectors.toList());
    }

    public static boolean isDockedNode(Node<?, ? extends Edge> element) {
        return Objects.nonNull(element.getInEdges()) ? element.getInEdges().stream().anyMatch(edge -> edge.getContent() instanceof Dock) : false;
    }

    public static Optional<Node> getDockParent(Node<?, ? extends Edge> element) {
        return Objects.nonNull(element.getInEdges()) ? element.getInEdges().stream().filter(edge -> edge.getContent() instanceof Dock).map(Edge::getSourceNode).findFirst() : Optional.empty();
    }

    public static Long countChildren(Node<?, ? extends Edge> element) {
        return element.getOutEdges().stream().filter(edge -> edge.getContent() instanceof Child).count();
    }

    private static String getElementDefinitionId(DefinitionManager definitionManager, Element<?> element) {
        String targetId = null;
        if (element.getContent() instanceof Definition) {
            Object definition = ((Definition)element.getContent()).getDefinition();
            targetId = definitionManager.adapters().forDefinition().getId(definition).value();
        } else if (element.getContent() instanceof DefinitionSet) {
            targetId = (String)((DefinitionSet)element.getContent()).getDefinition();
        }
        return targetId;
    }

    private static boolean instanceOf(Object item, Class<?> clazz) {
        return null != item && item.getClass().equals(clazz);
    }

    public static OptionalInt getChildIndex(Element element, String uuid) {
        if (!(element instanceof Node)) {
            return OptionalInt.empty();
        }
        Node node = (Node)element;
        return Objects.nonNull(node.getOutEdges()) ? IntStream.range(0, node.getOutEdges().size()).filter(i -> uuid.equals(((Edge)node.getOutEdges().get(i)).getTargetNode().getUUID())).findFirst() : OptionalInt.empty();
    }

    public static class ParentPredicate {
        private final Function<Node, Element> parentSupplier;

        public ParentPredicate(Function<Node, Element> parentSupplier) {
            this.parentSupplier = parentSupplier;
        }

        public BiPredicate<Node<?, ? extends Edge>, Element<?>> isChildOf() {
            return (candidate, parent) -> {
                if (null != candidate) {
                    Element p = this.parentSupplier.apply((Node)candidate);
                    while (null != p) {
                        if (Objects.equals(p, parent)) {
                            return true;
                        }
                        if (!(p instanceof Node)) continue;
                        p = this.parentSupplier.apply((Node)p);
                    }
                }
                return false;
            };
        }
    }

    public static enum CardinalityCountState {
        EMPTY,
        SINGLE_NODE,
        MULTIPLE_NODES;

    }
}

