/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.workbench.client.test;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.common.services.shared.test.Failure;
import org.guvnor.common.services.shared.test.TestResultMessage;
import org.guvnor.messageconsole.events.PublishBatchMessagesEvent;
import org.guvnor.messageconsole.events.SystemMessage;
import org.kie.workbench.common.workbench.client.test.TestRunnerReportingView;
import org.uberfire.client.annotations.DefaultPosition;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.Position;

@Dependent
public class TestRunnerReportingPanel
implements TestRunnerReportingView.Presenter {
    private TestRunnerReportingView view;
    private List<SystemMessage> systemMessages = new ArrayList<SystemMessage>();
    private Event<PublishBatchMessagesEvent> publishBatchMessagesEvent;

    public TestRunnerReportingPanel() {
    }

    @Inject
    public TestRunnerReportingPanel(TestRunnerReportingView view, Event<PublishBatchMessagesEvent> publishBatchMessagesEvent) {
        this.view = view;
        this.publishBatchMessagesEvent = publishBatchMessagesEvent;
        view.setPresenter(this);
        view.resetDonut();
    }

    @DefaultPosition
    public Position getDefaultPosition() {
        return CompassPosition.EAST;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return "";
    }

    @WorkbenchPartView
    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void reset() {
        this.systemMessages = new ArrayList<SystemMessage>();
        this.view.reset();
    }

    @Override
    public void onViewAlerts() {
        PublishBatchMessagesEvent messagesEvent = new PublishBatchMessagesEvent();
        messagesEvent.setCleanExisting(true);
        messagesEvent.setMessagesToPublish(this.systemMessages);
        this.publishBatchMessagesEvent.fire((Object)messagesEvent);
    }

    public void onTestRun(TestResultMessage testResultMessage) {
        this.reset();
        if (testResultMessage.wasSuccessful()) {
            this.view.showSuccess();
        } else {
            if (testResultMessage.getFailures() != null) {
                this.systemMessages = testResultMessage.getFailures().stream().map(this::convert).collect(Collectors.toList());
            }
            this.view.showFailure();
        }
        int failures = testResultMessage.getFailures().size();
        this.view.showSuccessFailureDiagram(testResultMessage.getRunCount() - failures, failures);
        this.view.setRunStatus(this.getCompletedAt(), this.getScenariosRun(testResultMessage), this.getDuration(testResultMessage));
    }

    private SystemMessage convert(Failure failure) {
        SystemMessage systemMessage = new SystemMessage();
        systemMessage.setMessageType("TestResults");
        systemMessage.setLevel(Level.ERROR);
        systemMessage.setText(this.makeMessage(failure));
        systemMessage.setPath(failure.getPath());
        return systemMessage;
    }

    private String getCompletedAt() {
        DateTimeFormat timeFormat = DateTimeFormat.getFormat((String)"HH:mm:ss.SSS");
        return timeFormat.format(new Date());
    }

    private String getScenariosRun(TestResultMessage testResultMessage) {
        return String.valueOf(testResultMessage.getRunCount());
    }

    private String getDuration(TestResultMessage testResultMessage) {
        Long runTime = testResultMessage.getRunTime();
        Date runtime = new Date(runTime);
        String milliseconds = this.formatMilliseconds(DateTimeFormat.getFormat((String)"SSS").format(runtime)) + " milliseconds";
        String seconds = DateTimeFormat.getFormat((String)"s").format(runtime) + " seconds";
        String minutes = DateTimeFormat.getFormat((String)"m").format(runtime) + " minutes";
        if (runTime < 1000L) {
            return milliseconds;
        }
        if (runTime < 60000L) {
            return seconds + " and " + milliseconds;
        }
        return minutes + " and " + seconds;
    }

    String formatMilliseconds(String originalFormat) {
        return originalFormat.replaceFirst("^0+(?!$)", "");
    }

    private String makeMessage(Failure failure) {
        String displayName = failure.getDisplayName();
        String message = failure.getMessage();
        return displayName + (message != null && !message.isEmpty() ? " : " + message : "");
    }
}

