/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.DataAssociation;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.InputOutputSpecification;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.MultiInstanceLoopCharacteristics;
import org.eclipse.bpmn2.Property;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.MultipleInstanceActivityPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;
import org.mockito.Mockito;

public class MultipleInstanceActivityPropertyWriterTest {
    private static final String ACTIVITY_ID = "ACTIVITY_ID";
    private static final String PROPERTY_ID = "PROPERTY_ID";
    private static final String ITEM_ID = "ITEM_ID";
    private static final String IN_COLLECTION = "IN_COLLECTION";
    private static final String OUT_COLLECTION = "OUT_COLLECTION";
    private static final String INPUT_VARIABLE_ID = "INPUT_VARIABLE_ID";
    private static final String OUTPUT_VARIABLE_ID = "OUTPUT_VARIABLE_ID";
    private static final String COMPLETION_CONDITION = "COMPLETION_CONDITION";
    private Activity activity;
    private VariableScope variableScope;
    private MultipleInstanceActivityPropertyWriter writer;

    @Before
    public void setUp() {
        this.activity = Factories.bpmn2.createUserTask();
        this.activity.setId(ACTIVITY_ID);
        this.variableScope = (VariableScope)Mockito.mock(VariableScope.class);
        VariableScope.Variable variable = (VariableScope.Variable)Mockito.mock(VariableScope.Variable.class);
        Mockito.when((Object)this.variableScope.lookup(PROPERTY_ID)).thenReturn(Optional.of(variable));
        Property property = this.mockProperty(PROPERTY_ID, ITEM_ID);
        Mockito.when((Object)variable.getTypedIdentifier()).thenReturn((Object)property);
        this.writer = new MultipleInstanceActivityPropertyWriter(this.activity, this.variableScope);
    }

    @Test
    public void testSetCollectionInput() {
        this.writer.setCollectionInput(PROPERTY_ID);
        this.assertInputsInitialized();
        String inputId = "ACTIVITY_ID_IN_COLLECTIONInputX";
        this.assertHasDataInput(this.activity.getIoSpecification(), inputId, ITEM_ID, IN_COLLECTION);
        this.assertHasDataInputAssociation(this.activity, PROPERTY_ID, inputId);
        Assert.assertEquals((Object)inputId, (Object)((MultiInstanceLoopCharacteristics)this.activity.getLoopCharacteristics()).getLoopDataInputRef().getId());
    }

    @Test
    public void setSetInputAndAddAssociation() {
        this.testSetInput(true);
    }

    @Test
    public void setSetInputAndDontAddAssociation() {
        this.testSetInput(false);
    }

    @Test
    public void testSetInputNotFailed() {
        this.writer.setInput(null, false);
        this.writer.setInput("", false);
        Assert.assertNull((Object)this.activity.getIoSpecification());
        Assert.assertTrue((boolean)this.activity.getDataInputAssociations().isEmpty());
        Assert.assertNull((Object)this.activity.getLoopCharacteristics());
    }

    @Test
    public void testSetEmptyVariable() {
        String emptyName = "";
        this.writer.setInput(":", false);
        this.assertInputsInitialized();
        String inputId = "ACTIVITY_ID_InputX";
        String itemSubjectRef = "ACTIVITY_ID_multiInstanceItemType_";
        this.assertHasDataInput(this.activity.getIoSpecification(), inputId, itemSubjectRef, "");
        this.assertDontHasDataInputAssociation(this.activity, INPUT_VARIABLE_ID, inputId);
    }

    private void testSetInput(boolean addAssociation) {
        this.writer.setInput(INPUT_VARIABLE_ID, addAssociation);
        this.assertInputsInitialized();
        String inputId = "ACTIVITY_ID_INPUT_VARIABLE_IDInputX";
        String itemSubjectRef = "ACTIVITY_ID_multiInstanceItemType_INPUT_VARIABLE_ID";
        this.assertHasDataInput(this.activity.getIoSpecification(), inputId, itemSubjectRef, INPUT_VARIABLE_ID);
        if (addAssociation) {
            this.assertHasDataInputAssociation(this.activity, INPUT_VARIABLE_ID, inputId);
        } else {
            this.assertDontHasDataInputAssociation(this.activity, INPUT_VARIABLE_ID, inputId);
        }
    }

    @Test
    public void testSetOutputAndAddAssociation() {
        this.testSetOutput(true);
    }

    @Test
    public void testSetOutputAndDontAddAssociation() {
        this.testSetOutput(false);
    }

    private void testSetOutput(boolean addAssociation) {
        this.writer.setOutput(OUTPUT_VARIABLE_ID, true);
        this.assertOutputsInitialized();
        String outputId = "ACTIVITY_ID_OUTPUT_VARIABLE_IDOutputX";
        String itemSubjectRef = "ACTIVITY_ID_multiInstanceItemType_OUTPUT_VARIABLE_ID";
        this.assertHasDataOutput(this.activity.getIoSpecification(), outputId, itemSubjectRef, OUTPUT_VARIABLE_ID);
        if (addAssociation) {
            this.assertHasDataOutputAssociation(this.activity, outputId, OUTPUT_VARIABLE_ID);
        } else {
            this.assertDontHasDataInputAssociation(this.activity, outputId, OUTPUT_VARIABLE_ID);
        }
    }

    @Test
    public void testSetCollectionOutput() {
        this.writer.setCollectionOutput(PROPERTY_ID);
        this.assertOutputsInitialized();
        String outputId = "ACTIVITY_ID_OUT_COLLECTIONOutputX";
        this.assertHasDataOutput(this.activity.getIoSpecification(), outputId, ITEM_ID, OUT_COLLECTION);
        this.assertHasDataOutputAssociation(this.activity, outputId, PROPERTY_ID);
        Assert.assertEquals((Object)outputId, (Object)((MultiInstanceLoopCharacteristics)this.activity.getLoopCharacteristics()).getLoopDataOutputRef().getId());
    }

    @Test
    public void testSetCompletionCondition() {
        this.writer.setCompletionCondition(COMPLETION_CONDITION);
        Assert.assertEquals((Object)"<![CDATA[COMPLETION_CONDITION]]>", (Object)((FormalExpression)((MultiInstanceLoopCharacteristics)this.activity.getLoopCharacteristics()).getCompletionCondition()).getBody());
    }

    @Test
    public void testSetIsSequentialTrue() {
        this.writer.setIsSequential(true);
        Assert.assertTrue((boolean)((MultiInstanceLoopCharacteristics)this.activity.getLoopCharacteristics()).isIsSequential());
    }

    @Test
    public void testSetIsSequentialFalse() {
        this.writer.setIsSequential(false);
        Assert.assertFalse((boolean)((MultiInstanceLoopCharacteristics)this.activity.getLoopCharacteristics()).isIsSequential());
    }

    private void assertInputsInitialized() {
        Assert.assertNotNull((Object)this.activity.getIoSpecification());
        Assert.assertNotNull((Object)this.activity.getIoSpecification().getDataInputs());
        Assert.assertNotNull((Object)this.activity.getDataInputAssociations());
        Assert.assertNotNull((Object)this.activity.getLoopCharacteristics());
    }

    private void assertOutputsInitialized() {
        Assert.assertNotNull((Object)this.activity.getIoSpecification());
        Assert.assertNotNull((Object)this.activity.getIoSpecification().getDataOutputs());
        Assert.assertNotNull((Object)this.activity.getDataOutputAssociations());
        Assert.assertNotNull((Object)this.activity.getLoopCharacteristics());
    }

    private void assertHasDataInput(InputOutputSpecification ioSpecification, String id, String itemSubjectRef, String name) {
        Assert.assertNotNull((Object)ioSpecification.getDataInputs());
        Optional<DataInput> dataInput = ioSpecification.getDataInputs().stream().filter(di -> Objects.equals(id, di.getId())).filter(di -> Objects.equals(itemSubjectRef, di.getItemSubjectRef().getId())).filter(di -> Objects.equals(name, di.getName())).findFirst();
        if (!dataInput.isPresent()) {
            Assert.fail((String)String.format("DataInput: id: %s, itemSubjectRef: %s, name: %s was not found.", id, itemSubjectRef, name));
        }
    }

    private void assertHasDataOutput(InputOutputSpecification ioSpecification, String id, String itemSubjectRef, String name) {
        Assert.assertNotNull((Object)ioSpecification.getDataOutputs());
        Optional<DataOutput> dataOutput = ioSpecification.getDataOutputs().stream().filter(dout -> Objects.equals(id, dout.getId())).filter(dout -> Objects.equals(itemSubjectRef, dout.getItemSubjectRef().getId())).filter(dout -> Objects.equals(name, dout.getName())).findFirst();
        if (!dataOutput.isPresent()) {
            Assert.fail((String)String.format("DataOutput: id: %s, itemSubjectRef: %s, name: %s was not found.", id, itemSubjectRef, name));
        }
    }

    private void assertHasDataInputAssociation(Activity activity, String sourceRef, String targetRef) {
        Assert.assertNotNull((Object)activity.getDataInputAssociations());
        Optional inputAssociation = this.findDataAssociation(activity.getDataInputAssociations(), sourceRef, targetRef);
        if (!inputAssociation.isPresent()) {
            Assert.fail((String)String.format("DataInputAssociation sourceRef: %s, targetRef: %s was not found.", sourceRef, targetRef));
        }
    }

    private void assertDontHasDataInputAssociation(Activity activity, String sourceRef, String targetRef) {
        Assert.assertNotNull((Object)activity.getDataInputAssociations());
        Optional inputAssociation = this.findDataAssociation(activity.getDataInputAssociations(), sourceRef, targetRef);
        if (inputAssociation.isPresent()) {
            Assert.fail((String)String.format("DataInputAssociation sourceRef: %s, targetRef: %s shouldn't be present.", sourceRef, targetRef));
        }
    }

    private void assertHasDataOutputAssociation(Activity activity, String sourceRef, String targetRef) {
        Assert.assertNotNull((Object)activity.getDataOutputAssociations());
        Optional outputAssociation = this.findDataAssociation(activity.getDataOutputAssociations(), sourceRef, targetRef);
        if (!outputAssociation.isPresent()) {
            Assert.fail((String)String.format("DataInputAssociation sourceRef: %s, targetRef: %s was not found.", sourceRef, targetRef));
        }
    }

    private <T extends DataAssociation> Optional<T> findDataAssociation(List<T> dataAssociations, String sourceRef, String targetRef) {
        Assert.assertNotNull(dataAssociations);
        return dataAssociations.stream().filter(dia -> !dia.getSourceRef().isEmpty()).filter(dia -> Objects.equals(sourceRef, ((ItemAwareElement)dia.getSourceRef().get(0)).getId())).filter(dia -> Objects.equals(targetRef, dia.getTargetRef().getId())).findFirst();
    }

    private Property mockProperty(String name, String itemSubjectRef) {
        Property property = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)property.getId()).thenReturn((Object)name);
        Mockito.when((Object)property.getName()).thenReturn((Object)name);
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Mockito.when((Object)itemDefinition.getId()).thenReturn((Object)itemSubjectRef);
        Mockito.when((Object)property.getItemSubjectRef()).thenReturn((Object)itemDefinition);
        return property;
    }
}

