/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.organizationalunit.config;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.structure.backend.organizationalunit.config.SpaceConfigStorageImpl;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.organizationalunit.config.SpaceInfo;
import org.guvnor.structure.repositories.RepositoryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.java.nio.fs.jgit.FileSystemLock;
import org.uberfire.java.nio.fs.jgit.FileSystemLockManager;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;

@Startup
@ApplicationScoped
public class SpaceConfigCleanUp {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpaceConfigCleanUp.class);
    private static final String LOCK_NAME = ".config.lock";
    private static final String MARKER_NAME = ".config-cleanup.done";
    private static final String CLEAN_UP_MESSAGE = "Space config clean up.";
    private static final int LAST_ACCESS_THRESHOLD = 1;
    private OrganizationalUnitService orgUnitService;
    private SpaceConfigStorageRegistry spaceConfigStorageRegistry;

    public SpaceConfigCleanUp() {
    }

    @Inject
    public SpaceConfigCleanUp(OrganizationalUnitService orgUnitService, SpaceConfigStorageRegistry spaceConfigStorageRegistry) {
        this.orgUnitService = orgUnitService;
        this.spaceConfigStorageRegistry = spaceConfigStorageRegistry;
    }

    @PostConstruct
    public void postConstruct() {
        this.executeCleanUp();
    }

    private void executeCleanUp() {
        try {
            this.orgUnitService.getAllOrganizationalUnits().stream().map(OrganizationalUnit::getName).forEach(this::cleanUpSpaceConfigStorage);
        }
        catch (Exception e) {
            LOGGER.error("Error when executing clean up.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpSpaceConfigStorage(String spaceName) {
        SpaceConfigStorageImpl configStorage = (SpaceConfigStorageImpl)this.spaceConfigStorageRegistry.get(spaceName);
        JGitFileSystem fs = (JGitFileSystem)configStorage.getPath().getFileSystem();
        File configDirectory = fs.getGit().getRepository().getDirectory().getParentFile();
        File marker = this.createMarker(configDirectory);
        if (marker.exists()) {
            return;
        }
        FileSystemLock physicalLock = this.createLock(configDirectory);
        try {
            boolean updateNeeded;
            physicalLock.lock();
            SpaceInfo spaceInfo = configStorage.loadSpaceInfo();
            boolean bl = updateNeeded = spaceInfo.getRepositories().stream().map(repositoryInfo -> repositoryInfo.getConfiguration().getEnvironment()).filter(envMap -> !RepositoryUtils.cleanUpCredentialsFromEnvMap((Map)envMap).isEmpty()).count() != 0L;
            if (updateNeeded) {
                configStorage.saveSpaceInfo(spaceInfo);
                fs.getGit().resetWithSquash(CLEAN_UP_MESSAGE);
            }
            if (!marker.createNewFile()) {
                LOGGER.warn("Cannot create marker file {}.", (Object)MARKER_NAME);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error when cleaning up space config storage.", (Throwable)e);
        }
        finally {
            physicalLock.unlock();
        }
    }

    FileSystemLock createLock(File directory) {
        return FileSystemLockManager.getInstance().getFileSystemLock(directory, LOCK_NAME, TimeUnit.SECONDS, 1L);
    }

    File createMarker(File directory) {
        return new File(directory, MARKER_NAME);
    }
}

