/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner;

import java.util.List;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReader;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public interface BpmnEdge {
    public static Simple of(Edge<? extends View<?>, Node> edge, BpmnNode source, Connection sourceConnection, List<Point2D> controlPoints, BpmnNode target, Connection targetConnection, PropertyReader propertyReader) {
        return new Simple(edge, source, sourceConnection, controlPoints, target, targetConnection, propertyReader);
    }

    public static Docked docked(BpmnNode source, BpmnNode target) {
        return new Docked(source, target);
    }

    public BpmnNode getSource();

    public BpmnNode getTarget();

    public boolean isDocked();

    public static class Docked
    implements BpmnEdge {
        private final BpmnNode source;
        private final BpmnNode target;

        private Docked(BpmnNode source, BpmnNode target) {
            this.source = source;
            this.target = target;
        }

        @Override
        public BpmnNode getSource() {
            return this.source;
        }

        @Override
        public BpmnNode getTarget() {
            return this.target;
        }

        @Override
        public boolean isDocked() {
            return true;
        }
    }

    public static class Simple
    implements BpmnEdge {
        private final Edge<? extends View<?>, Node> edge;
        private final BpmnNode source;
        private final Connection sourceConnection;
        private final List<Point2D> controlPoints;
        private final BpmnNode target;
        private final Connection targetConnection;
        private final PropertyReader propertyReader;

        private Simple(Edge<? extends View<?>, Node> edge, BpmnNode source, Connection sourceConnection, List<Point2D> controlPoints, BpmnNode target, Connection targetConnection, PropertyReader propertyReader) {
            this.edge = edge;
            this.source = source;
            this.sourceConnection = sourceConnection;
            this.controlPoints = controlPoints;
            this.target = target;
            this.targetConnection = targetConnection;
            this.propertyReader = propertyReader;
        }

        public Edge<? extends View<?>, Node> getEdge() {
            return this.edge;
        }

        @Override
        public BpmnNode getSource() {
            return this.source;
        }

        public Connection getSourceConnection() {
            return this.sourceConnection;
        }

        public List<Point2D> getControlPoints() {
            return this.controlPoints;
        }

        @Override
        public BpmnNode getTarget() {
            return this.target;
        }

        public Connection getTargetConnection() {
            return this.targetConnection;
        }

        @Override
        public boolean isDocked() {
            return false;
        }

        public PropertyReader getPropertyReader() {
            return this.propertyReader;
        }
    }
}

