/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.kie.dmn.validation.dtanalysis.model.DDTAInputClause;
import org.kie.dmn.validation.dtanalysis.model.DDTAInputEntry;
import org.kie.dmn.validation.dtanalysis.model.DDTAOutputClause;
import org.kie.dmn.validation.dtanalysis.model.DDTARule;
import org.kie.dmn.validation.dtanalysis.model.Interval;

public class DDTATable {
    private List<DDTAInputClause> inputs = new ArrayList<DDTAInputClause>();
    private List<DDTARule> rules = new ArrayList<DDTARule>();
    private List<DDTAOutputClause> outputs = new ArrayList<DDTAOutputClause>();
    private Map<List<List<Interval>>, List<Integer>> cacheByInputEntry = new HashMap<List<List<Interval>>, List<Integer>>();
    private Map<List<Comparable<?>>, List<Integer>> cacheByOutputEntry = new HashMap();
    private List<Integer> colIDsStringWithoutEnum = new ArrayList<Integer>();

    public List<DDTAInputClause> getInputs() {
        return this.inputs;
    }

    public List<DDTARule> getRule() {
        return Collections.unmodifiableList(this.rules);
    }

    public int inputCols() {
        return this.inputs.size();
    }

    public int inputRules() {
        return this.rules.size();
    }

    public List<Interval> projectOnColumnIdx(int jColIdx) {
        ArrayList<Interval> results = new ArrayList<Interval>();
        for (DDTARule r : this.rules) {
            DDTAInputEntry ieX = r.getInputEntry().get(jColIdx);
            results.addAll(ieX.getIntervals());
        }
        return results;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DDTATable [rules=");
        this.rules.forEach(r -> builder.append("\n" + r));
        builder.append("\n]");
        return builder.toString();
    }

    public List<DDTAOutputClause> getOutputs() {
        return this.outputs;
    }

    public int outputCols() {
        return this.outputs.size();
    }

    public void addRule(DDTARule ddtaRule) {
        this.rules.add(ddtaRule);
        int ruleID = this.rules.size();
        List ieIntervals = ddtaRule.getInputEntry().stream().map(DDTAInputEntry::getIntervals).collect(Collectors.toList());
        this.cacheByInputEntry.computeIfAbsent(ieIntervals, x -> new ArrayList()).add(ruleID);
        this.cacheByOutputEntry.computeIfAbsent(ddtaRule.getOutputEntry(), x -> new ArrayList()).add(ruleID);
    }

    public Set<List<Comparable<?>>> outputEntries() {
        return Collections.unmodifiableSet(this.cacheByOutputEntry.keySet());
    }

    public List<Integer> ruleIDsByOutputEntry(List<Comparable<?>> oe) {
        return Collections.unmodifiableList(this.cacheByOutputEntry.getOrDefault(oe, Collections.emptyList()));
    }

    public Map<List<List<Interval>>, List<Integer>> getCacheByInputEntry() {
        return Collections.unmodifiableMap(this.cacheByInputEntry);
    }

    public void addColIdStringWithoutEnum(int colID) {
        this.colIDsStringWithoutEnum.add(colID);
    }

    public List<Integer> getColIDsStringWithoutEnum() {
        return Collections.unmodifiableList(this.colIDsStringWithoutEnum);
    }
}

