/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.bpmn2.ExclusiveGateway;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.InclusiveGateway;
import org.eclipse.bpmn2.ParallelGateway;
import org.eclipse.bpmn2.SequenceFlow;
import org.jbpm.simulation.PathContext;
import org.jbpm.simulation.PathContextManager;
import org.jbpm.simulation.handler.MainElementHandler;

public class GatewayElementHandler
extends MainElementHandler {
    private PathContextManager manager;

    @Override
    public boolean handle(FlowElement element, PathContextManager manager) {
        this.manager = manager;
        if (element instanceof ExclusiveGateway) {
            this.handleExclusiveGateway(this.getOutgoing(element));
            return true;
        }
        if (element instanceof InclusiveGateway) {
            this.handleInclusiveGateway(this.getOutgoing(element));
            return true;
        }
        if (element instanceof ParallelGateway) {
            this.handleParallelGateway(this.getOutgoing(element));
            return true;
        }
        throw new UnsupportedOperationException("Not supported element to handle " + element.eClass().getName());
    }

    protected void handleExclusiveGateway(List<SequenceFlow> outgoing) {
        ArrayList<PathContext> locked = new ArrayList<PathContext>();
        Stack<PathContext> contextsAtThisNode = this.manager.getContextsFromStack();
        for (PathContext contextAtThisNode : contextsAtThisNode) {
            for (SequenceFlow seqFlow : outgoing) {
                FlowNode target = seqFlow.getTargetRef();
                if (contextAtThisNode.getVisitedSplitPoint().contains(seqFlow)) continue;
                PathContext separatePath = this.manager.cloneGiven(contextAtThisNode);
                separatePath.addVisitedSplitPoint((FlowElement)seqFlow);
                this.manager.addToPath((FlowElement)seqFlow, separatePath);
                super.handle((FlowElement)target, this.manager);
                separatePath.setLocked(true);
                locked.add(separatePath);
            }
        }
        for (PathContext ctx : locked) {
            ctx.setLocked(false);
        }
    }

    protected void handleInclusiveGateway(List<SequenceFlow> outgoing) {
        this.handleExclusiveGateway(outgoing);
        PathContext.Type currentType = this.manager.getContextFromStack().getType();
        this.manager.getContextFromStack().setType(PathContext.Type.ROOT);
        if (outgoing.size() > 2) {
            ArrayList<SequenceFlow> copy = new ArrayList<SequenceFlow>(outgoing);
            ArrayList<SequenceFlow> andCombination = null;
            for (SequenceFlow flow : outgoing) {
                copy.remove(flow);
                PathContext contextAtThisNode = this.manager.cloneGivenWithoutPush(this.manager.getContextFromStack());
                for (SequenceFlow copyFlow : copy) {
                    this.manager.cloneGiven(contextAtThisNode);
                    andCombination = new ArrayList<SequenceFlow>();
                    andCombination.add(flow);
                    andCombination.add(copyFlow);
                    this.handleParallelGateway(andCombination);
                }
            }
        }
        this.manager.getContextFromStack().setType(PathContext.Type.ROOT);
        this.handleParallelGateway(outgoing);
        this.manager.getContextFromStack().setType(currentType);
    }

    protected void handleParallelGateway(List<SequenceFlow> outgoing) {
        PathContext context = this.manager.getContextFromStack();
        boolean canBeFinished = context.isCanBeFinished();
        context.setCanBeFinished(false);
        this.manager.addAllToPath(outgoing, context);
        int counter = 0;
        for (SequenceFlow seqFlow : outgoing) {
            FlowNode target = seqFlow.getTargetRef();
            if (++counter == outgoing.size()) {
                if (this.manager.getPaths().size() == 1) {
                    context.setCanBeFinished(canBeFinished);
                } else {
                    for (PathContext pathContext : this.manager.getPaths()) {
                        if (pathContext.getType() != PathContext.Type.ACTIVE) continue;
                        pathContext.setCanBeFinished(canBeFinished);
                    }
                }
            }
            super.handle((FlowElement)target, this.manager);
        }
        if (canBeFinished) {
            for (SequenceFlow seqFlow : outgoing) {
                this.manager.addToPath((FlowElement)seqFlow, context);
                this.manager.addToPath((FlowElement)seqFlow.getTargetRef(), context);
            }
            this.manager.finalizePathOnLeave();
        }
    }
}

