/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.textannotation;

import org.eclipse.bpmn2.Bpmn2Factory;
import org.eclipse.bpmn2.TextAnnotation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Result;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.TextAnnotationPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.textannotation.TextAnnotationConverter;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.powermock.api.mockito.PowerMockito;

@RunWith(value=MockitoJUnitRunner.class)
public class TextAnnotationConverterTest {
    private TextAnnotationConverter tested;
    @Mock
    private TypedFactoryManager typedFactoryManager;
    @Mock
    private PropertyReaderFactory propertyReaderFactory;
    private TextAnnotation element;
    @Mock
    private Node<View<org.kie.workbench.common.stunner.bpmn.definition.TextAnnotation>, Edge> node;
    @Mock
    private View<org.kie.workbench.common.stunner.bpmn.definition.TextAnnotation> content;
    @Mock
    private org.kie.workbench.common.stunner.bpmn.definition.TextAnnotation def;
    @Mock
    private TextAnnotationPropertyReader reader;

    @Before
    public void setUp() {
        this.element = Bpmn2Factory.eINSTANCE.createTextAnnotation();
        this.tested = new TextAnnotationConverter(this.typedFactoryManager, this.propertyReaderFactory);
        PowerMockito.when((Object)this.typedFactoryManager.newNode(Matchers.anyString(), (Class)Matchers.eq(org.kie.workbench.common.stunner.bpmn.definition.TextAnnotation.class))).thenReturn(this.node);
        PowerMockito.when((Object)this.node.getContent()).thenReturn(this.content);
        PowerMockito.when((Object)this.content.getDefinition()).thenReturn((Object)this.def);
        PowerMockito.when((Object)this.propertyReaderFactory.of(this.element)).thenReturn((Object)this.reader);
    }

    @Test
    public void convert() {
        Result node = this.tested.convert(this.element);
        Node value = ((BpmnNode)node.value()).value();
        Assert.assertEquals(this.content, (Object)value.getContent());
        Assert.assertEquals((Object)this.def, (Object)((View)value.getContent()).getDefinition());
    }
}

