/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Pattern;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.MariaDbResultSet;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.query.MariaDbQuery;
import org.mariadb.jdbc.internal.query.Query;
import org.mariadb.jdbc.internal.queryresults.AbstractQueryResult;
import org.mariadb.jdbc.internal.queryresults.ModifyQueryResult;
import org.mariadb.jdbc.internal.queryresults.ResultSetType;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.Utils;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class MariaDbStatement
implements Statement {
    private static volatile Timer timer;
    protected Protocol protocol;
    protected MariaDbConnection connection;
    protected boolean autoGeneratedKeys;
    protected boolean binaryData = false;
    protected AbstractQueryResult queryResult;
    protected TimerTask timerTask;
    protected boolean isRewriteable = true;
    protected String firstRewrite = null;
    protected ResultSet batchResultSet = null;
    boolean isClosed;
    boolean isTimedout;
    volatile boolean executing;
    List<Query> batchQueries;
    Queue<Object> cachedResultSets;
    private boolean warningsCleared;
    private int queryTimeout;
    private boolean escapeProcessing;
    private int fetchSize;
    private boolean isStreaming = false;
    private int maxRows;
    public static final Pattern deleteEndSemicolonPattern;

    public MariaDbStatement(MariaDbConnection connection, int autoGeneratedKeys) {
        this.autoGeneratedKeys = autoGeneratedKeys == 1;
        this.protocol = connection.getProtocol();
        this.connection = connection;
        this.escapeProcessing = true;
        this.cachedResultSets = new LinkedList<Object>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Timer getTimer() {
        Timer result = timer;
        if (result != null) return result;
        Class<MariaDbStatement> clazz = MariaDbStatement.class;
        synchronized (MariaDbStatement.class) {
            result = timer;
            if (result != null) return result;
            timer = result = new Timer("MariaDB-JDBC-Timer", true);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    public static void unloadDriver() {
        if (timer != null) {
            timer.cancel();
        }
    }

    public boolean isStreaming() {
        return this.fetchSize == Integer.MIN_VALUE;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    private void setTimerTask() {
        assert (this.timerTask == null);
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    MariaDbStatement.this.isTimedout = true;
                    MariaDbStatement.this.protocol.cancelCurrentQuery();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        MariaDbStatement.getTimer().schedule(this.timerTask, this.queryTimeout * 1000);
    }

    void executeQueryProlog() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("execute() is called on closed statement");
        }
        if (this.protocol.isExplicitClosed()) {
            throw new SQLException("execute() is called on closed connection");
        }
        if (this.protocol.getProxy() == null) {
            this.checkReconnectWithoutProxy();
        }
        this.protocol.closeIfActiveResult();
        if (this.isStreaming && this.protocol.hasMoreResults()) {
            while (this.getInternalMoreResults(true)) {
            }
        }
        this.cachedResultSets.clear();
        ((MariaDbConnection)this.getConnection()).reenableWarnings();
        try {
            this.protocol.setMaxRows(this.maxRows);
        }
        catch (QueryException qe) {
            ExceptionMapper.throwException(qe, this.connection, this);
        }
        if (this.queryTimeout != 0) {
            this.setTimerTask();
        }
    }

    protected void cacheMoreResults() {
        if (this.isStreaming()) {
            return;
        }
        AbstractQueryResult saveResult = this.queryResult;
        try {
            while (this.protocol.hasMoreResults()) {
                this.queryResult = this.protocol.getMoreResults(false);
                this.cachedResultSets.add(this.queryResult);
            }
        }
        catch (QueryException e) {
            this.cachedResultSets.add(ExceptionMapper.createException(e, this.connection, this));
        }
        this.queryResult = saveResult;
    }

    private void executeQueryEpilog(QueryException queryException, Query query) throws SQLException {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
        if (this.isTimedout) {
            this.isTimedout = false;
            queryException = new QueryException("Query timed out", 1317, "JZ0002", queryException);
        }
        if (queryException == null) {
            return;
        }
        if (this.protocol.getOptions().dumpQueriesOnException || queryException.getErrorCode() == 1064) {
            String queryString = query.toString();
            if (queryString.length() > 1024) {
                queryString = queryString.substring(0, 1024);
            }
            queryException.setMessage(queryException.getMessage() + "\nQuery is:\n" + queryString);
        }
        if (queryException.getSqlState() != null && queryException.getSqlState().startsWith("08")) {
            this.close();
        }
        ExceptionMapper.throwException(queryException, this.connection, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean execute(Query query) throws SQLException {
        this.checkClose();
        this.executing = true;
        QueryException exception = null;
        this.connection.lock.lock();
        try {
            boolean bl;
            this.executeQueryProlog();
            try {
                this.batchResultSet = null;
                this.queryResult = this.protocol.executeQuery(query, this.isStreaming());
                if (this.autoGeneratedKeys && this.queryResult.getResultSetType() == ResultSetType.MODIFY) {
                    this.batchResultSet = (MariaDbResultSet)this.getInternalGeneratedKeys();
                }
                this.cacheMoreResults();
                bl = this.queryResult.getResultSetType() == ResultSetType.SELECT;
            }
            catch (QueryException e) {
                boolean bl2;
                try {
                    exception = e;
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    this.executeQueryEpilog(exception, query);
                    this.executing = false;
                    throw throwable;
                }
                this.executeQueryEpilog(exception, query);
                this.executing = false;
                this.connection.lock.unlock();
                return bl2;
            }
            this.executeQueryEpilog(exception, query);
            this.executing = false;
            return bl;
        }
        finally {
            this.connection.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean execute(List<Query> queries, boolean isRewritable, int rewriteOffset) throws SQLException {
        this.checkClose();
        this.executing = true;
        QueryException exception = null;
        this.connection.lock.lock();
        try {
            boolean bl;
            this.executeQueryProlog();
            try {
                this.batchResultSet = null;
                this.queryResult = this.protocol.executeQuery(queries, this.isStreaming(), isRewritable, rewriteOffset);
                this.cacheMoreResults();
                bl = this.queryResult.getResultSetType() == ResultSetType.SELECT;
            }
            catch (QueryException e) {
                boolean bl2;
                try {
                    exception = e;
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    this.executeQueryEpilog(exception, queries.get(0));
                    this.executing = false;
                    throw throwable;
                }
                this.executeQueryEpilog(exception, queries.get(0));
                this.executing = false;
                this.connection.lock.unlock();
                return bl2;
            }
            this.executeQueryEpilog(exception, queries.get(0));
            this.executing = false;
            return bl;
        }
        finally {
            this.connection.lock.unlock();
        }
    }

    @Override
    public boolean execute(String queryString) throws SQLException {
        this.autoGeneratedKeys = false;
        return this.execute(this.stringToQuery(queryString));
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.autoGeneratedKeys = autoGeneratedKeys == 1;
        return this.execute(this.stringToQuery(sql));
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.autoGeneratedKeys = true;
        return this.execute(this.stringToQuery(sql));
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.autoGeneratedKeys = true;
        return this.execute(this.stringToQuery(sql));
    }

    protected ResultSet executeQuery(Query query) throws SQLException {
        if (this.execute(query)) {
            return this.getResultSet();
        }
        return MariaDbResultSet.EMPTY;
    }

    @Override
    public ResultSet executeQuery(String queryString) throws SQLException {
        return this.executeQuery(this.stringToQuery(queryString));
    }

    protected int executeUpdate(Query query) throws SQLException {
        if (this.execute(query)) {
            return 0;
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String queryString) throws SQLException {
        this.autoGeneratedKeys = false;
        return this.executeUpdate(this.stringToQuery(queryString));
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.autoGeneratedKeys = autoGeneratedKeys == 1;
        return this.executeUpdate(this.stringToQuery(sql));
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.autoGeneratedKeys = true;
        return this.executeUpdate(this.stringToQuery(sql));
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.autoGeneratedKeys = true;
        return this.executeUpdate(this.stringToQuery(sql));
    }

    protected Query stringToQuery(String queryString) throws SQLException {
        queryString = deleteEndSemicolonPattern.matcher(queryString).replaceAll("");
        if (this.escapeProcessing) {
            queryString = Utils.nativeSql(queryString, this.connection.noBackslashEscapes);
        }
        return new MariaDbQuery(queryString);
    }

    @Override
    public void close() throws SQLException {
        if (this.queryResult != null) {
            this.queryResult.close();
            this.queryResult = null;
        }
        this.cachedResultSets.clear();
        if (this.isStreaming()) {
            this.connection.lock.lock();
            try {
                while (this.getInternalMoreResults(true)) {
                }
            }
            finally {
                this.connection.lock.unlock();
            }
        }
        this.protocol = null;
        this.isClosed = true;
        if (this.connection == null || this.connection.pooledConnection == null || this.connection.pooledConnection.statementEventListeners.isEmpty()) {
            return;
        }
        this.connection.pooledConnection.fireStatementClosed(this);
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("max rows cannot be negative : asked for " + max);
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.escapeProcessing = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    public void setLocalInfileInputStream(InputStream inputStream) throws SQLException {
        this.checkClose();
        this.protocol.setLocalInfileInputStream(inputStream);
    }

    @Override
    public void cancel() throws SQLException {
        this.checkClose();
        try {
            if (!this.executing) {
                return;
            }
            this.protocol.cancelCurrentQuery();
        }
        catch (QueryException e) {
            ExceptionMapper.throwException(e, this.connection, this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClose();
        if (!this.warningsCleared) {
            return this.connection.getWarnings();
        }
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningsCleared = true;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Cursors are not supported");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (!this.autoGeneratedKeys) {
            throw new SQLException("getGeneratedKeys error. Statement.RETURN_GENERATED_KEYS must be precised on connection.prepareStatement(String sql, int autoGeneratedKeys) or statement.executeUpdate(String sql, int autoGeneratedKeys)");
        }
        if (this.batchResultSet != null) {
            return this.batchResultSet;
        }
        return this.getInternalGeneratedKeys();
    }

    protected ResultSet getInternalGeneratedKeys() throws SQLException {
        if (this.queryResult != null && this.queryResult.getResultSetType() == ResultSetType.MODIFY) {
            long insertId = ((ModifyQueryResult)this.queryResult).getInsertId();
            if (insertId == 0L) {
                return MariaDbResultSet.createEmptyGeneratedKeysResultSet(this.connection);
            }
            int updateCount = this.getUpdateCount();
            return MariaDbResultSet.createGeneratedKeysResultSet(insertId, updateCount, this.connection, this.binaryData);
        }
        return MariaDbResultSet.EMPTY;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClose();
        if (this.queryResult == null || this.queryResult.getResultSetType() != ResultSetType.SELECT) {
            return null;
        }
        return new MariaDbResultSet(this.queryResult, this, this.protocol);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.queryResult == null || this.queryResult.getResultSetType() == ResultSetType.SELECT) {
            return -1;
        }
        return (int)((ModifyQueryResult)this.queryResult).getUpdateCount();
    }

    protected boolean getInternalMoreResults(boolean streaming) throws SQLException {
        try {
            if (this.queryResult != null) {
                this.queryResult.close();
            }
            this.queryResult = this.protocol.getMoreResults(streaming);
            if (this.queryResult == null) {
                return false;
            }
            this.warningsCleared = false;
            this.connection.reenableWarnings();
            return this.queryResult.getResultSetType() == ResultSetType.SELECT;
        }
        catch (QueryException e) {
            ExceptionMapper.throwException(e, this.connection, this);
            return false;
        }
    }

    public boolean getInternalMoreResults() throws SQLException {
        if (!this.isStreaming()) {
            if (this.cachedResultSets.isEmpty()) {
                this.queryResult = null;
                return false;
            }
            Object obj = this.cachedResultSets.remove();
            if (obj instanceof QueryException) {
                ExceptionMapper.throwException((QueryException)obj, this.connection, this);
            }
            this.queryResult = (AbstractQueryResult)obj;
            if (this.batchResultSet != null) {
                this.batchResultSet = ((MariaDbResultSet)this.batchResultSet).joinResultSets((MariaDbResultSet)this.getInternalGeneratedKeys());
            }
            return this.queryResult.getResultSetType() == ResultSetType.SELECT;
        }
        return this.getInternalMoreResults(false);
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkClose();
        return this.getInternalMoreResults();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkClose();
        return this.getInternalMoreResults();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0 && rows != Integer.MIN_VALUE) {
            throw new SQLException("invalid fetch size");
        }
        this.fetchSize = rows;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1004;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        String sqlQuery;
        if (this.batchQueries == null) {
            this.batchQueries = new ArrayList<Query>();
        }
        if (this.protocol.getOptions().rewriteBatchedStatements || this.protocol.getOptions().allowMultiQueries) {
            sqlQuery = deleteEndSemicolonPattern.matcher(sql).replaceAll("");
            this.isInsertRewriteable(sqlQuery);
        } else {
            sqlQuery = sql;
        }
        this.batchQueries.add(new MariaDbQuery(sqlQuery));
    }

    protected void isInsertRewriteable(String sql) {
        if (!this.isRewriteable) {
            return;
        }
        int index = this.getInsertIncipit(sql);
        if (index == -1) {
            this.isRewriteable = false;
            return;
        }
        if (this.firstRewrite == null) {
            this.firstRewrite = sql.substring(0, index);
        }
    }

    protected int getInsertIncipit(String sql) {
        String sqlUpper = sql.toUpperCase();
        if (!sqlUpper.startsWith("INSERT") && !sqlUpper.startsWith("/*CLIENT*/ INSERT")) {
            return -1;
        }
        if (sqlUpper.indexOf("SELECT") != -1) {
            return -1;
        }
        int idx = sqlUpper.indexOf(" VALUE");
        if (idx == -1) {
            idx = sqlUpper.indexOf(")VALUE");
        }
        int startBracket = sqlUpper.indexOf("(", idx);
        int endBracket = sqlUpper.indexOf(")", startBracket);
        int semicolonPos = sqlUpper.indexOf(59);
        while (semicolonPos > -1) {
            if (semicolonPos < startBracket || semicolonPos > endBracket) {
                return -1;
            }
            semicolonPos = sqlUpper.indexOf(59, semicolonPos + 1);
        }
        return startBracket;
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.batchQueries != null) {
            this.batchQueries.clear();
        }
        this.firstRewrite = null;
        this.isRewriteable = true;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int batchQueriesCount;
        this.checkClose();
        if (this.batchQueries == null || this.batchQueries.size() == 0) {
            return new int[0];
        }
        int[] ret = new int[this.batchQueries.size()];
        MariaDbResultSet rs = null;
        this.cachedResultSets.clear();
        this.connection.lock.lock();
        try {
            if (this.getProtocol().getOptions().allowMultiQueries || this.getProtocol().getOptions().rewriteBatchedStatements) {
                int size = this.batchQueries.size();
                this.batchResultSet = null;
                boolean rewrittenBatch = this.isRewriteable && this.getProtocol().getOptions().rewriteBatchedStatements;
                this.execute(this.batchQueries, rewrittenBatch, rewrittenBatch && this.firstRewrite != null ? this.firstRewrite.length() : 0);
                int[] nArray = rewrittenBatch ? this.getUpdateCountsForReWrittenBatch(size) : this.getUpdateRewrittenCounts();
                return nArray;
            }
            for (batchQueriesCount = 0; batchQueriesCount < this.batchQueries.size(); ++batchQueriesCount) {
                this.execute(this.batchQueries.get(batchQueriesCount));
                int updateCount = this.getUpdateCount();
                ret[batchQueriesCount] = updateCount == -1 ? -2 : updateCount;
                if (!this.autoGeneratedKeys) continue;
                rs = batchQueriesCount == 0 ? (MariaDbResultSet)this.getInternalGeneratedKeys() : rs.joinResultSets((MariaDbResultSet)this.getInternalGeneratedKeys());
            }
        }
        catch (SQLException sqle) {
            throw new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), Arrays.copyOf(ret, batchQueriesCount), (Throwable)sqle);
        }
        finally {
            this.connection.lock.unlock();
            this.clearBatch();
        }
        this.batchResultSet = rs;
        return ret;
    }

    protected int[] getUpdateRewrittenCounts() throws SQLException {
        int[] result = new int[this.cachedResultSets.size() + 1];
        int count = 0;
        int updateCount = this.getUpdateCount();
        result[count++] = updateCount == -1 ? -2 : updateCount;
        if (this.autoGeneratedKeys) {
            this.batchResultSet = this.getInternalGeneratedKeys();
        }
        while (!this.cachedResultSets.isEmpty()) {
            Object obj = this.cachedResultSets.remove();
            if (obj instanceof QueryException) {
                ExceptionMapper.throwException((QueryException)obj, this.connection, this);
            } else if (obj instanceof SQLException) {
                throw (SQLException)obj;
            }
            this.queryResult = (AbstractQueryResult)obj;
            updateCount = this.getUpdateCount();
            result[count++] = updateCount == -1 ? -2 : updateCount;
            if (!this.autoGeneratedKeys) continue;
            if (this.batchResultSet == null) {
                this.batchResultSet = this.getInternalGeneratedKeys();
                continue;
            }
            this.batchResultSet = ((MariaDbResultSet)this.batchResultSet).joinResultSets((MariaDbResultSet)this.getInternalGeneratedKeys());
        }
        if (!this.autoGeneratedKeys) {
            this.cachedResultSets.clear();
        }
        return result;
    }

    protected int[] getUpdateCountsForReWrittenBatch(int size) throws SQLException {
        int totalUpdateCount = 0;
        this.batchResultSet = this.getInternalGeneratedKeys();
        int updateCount = this.getUpdateCount();
        totalUpdateCount += updateCount != -1 ? updateCount : 0;
        while (!this.cachedResultSets.isEmpty()) {
            Object obj = this.cachedResultSets.remove();
            if (obj instanceof QueryException) {
                ExceptionMapper.throwException((QueryException)obj, this.connection, this);
            }
            this.queryResult = (AbstractQueryResult)obj;
            updateCount = this.getUpdateCount();
            totalUpdateCount += updateCount != -1 ? updateCount : 0;
            if (!this.autoGeneratedKeys) continue;
            this.batchResultSet = ((MariaDbResultSet)this.batchResultSet).joinResultSets((MariaDbResultSet)this.getInternalGeneratedKeys());
        }
        this.cachedResultSets.clear();
        int[] result = new int[size];
        int resultVal = totalUpdateCount == size ? 1 : -2;
        for (int count = 0; count < size; ++count) {
            result[count] = resultVal;
        }
        return result;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.isWrapperFor(iface)) {
                return (T)this;
            }
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
        catch (Exception e) {
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaceOrWrapper) throws SQLException {
        return interfaceOrWrapper.isInstance(this);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    private void checkReconnectWithoutProxy() throws SQLException {
        if (this.protocol.shouldReconnectWithoutProxy()) {
            try {
                this.protocol.connectWithoutProxy();
            }
            catch (QueryException qe) {
                ExceptionMapper.throwException(qe, this.connection, this);
            }
        }
    }

    protected void checkClose() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Cannot do an operation on a closed statement");
        }
    }

    static {
        deleteEndSemicolonPattern = Pattern.compile("[;][ ]*$", 2);
    }
}

