/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.queryresults;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.regex.Pattern;
import org.mariadb.jdbc.MariaDbBlob;
import org.mariadb.jdbc.MariaDbClob;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.ColumnInformation;
import org.mariadb.jdbc.internal.queryresults.ValueObject;
import org.mariadb.jdbc.internal.util.Options;

public class MariaDbValueObject
implements ValueObject {
    private static final Pattern isIntegerRegex = Pattern.compile("^-?\\d+\\.0+$");
    private final byte[] rawBytes;
    private final MariaDbType dataType;
    private final boolean isBinaryEncoded;
    private final ColumnInformation columnInfo;
    private final Options options;

    public MariaDbValueObject(byte[] rawBytes, ColumnInformation columnInfo, Options options) {
        this.dataType = columnInfo.getType();
        this.rawBytes = rawBytes;
        this.isBinaryEncoded = false;
        this.columnInfo = columnInfo;
        this.options = options;
    }

    public MariaDbValueObject(byte[] rawBytes, ColumnInformation columnInfo, boolean isBinaryEncoded, Options options) {
        this.dataType = columnInfo.getType();
        this.rawBytes = rawBytes;
        this.isBinaryEncoded = isBinaryEncoded;
        this.columnInfo = columnInfo;
        this.options = options;
    }

    @Override
    public String getString() throws SQLException {
        return this.getString(null);
    }

    @Override
    public String getString(Calendar cal) throws SQLException {
        if (this.rawBytes == null) {
            return null;
        }
        switch (this.columnInfo.getType()) {
            case BIT: {
                if (!this.options.tinyInt1isBit || this.columnInfo.getLength() != 1L) break;
                return this.rawBytes[0] == 0 ? "0" : "1";
            }
            case TINYINT: {
                if (this.options.tinyInt1isBit && this.columnInfo.getLength() == 1L) {
                    return this.rawBytes[0] == 0 ? "0" : "1";
                }
                if (!this.isBinaryEncoded) break;
                return String.valueOf(this.getTinyInt());
            }
            case SMALLINT: {
                if (!this.isBinaryEncoded) break;
                return String.valueOf(this.getSmallInt());
            }
            case INTEGER: 
            case MEDIUMINT: {
                if (!this.isBinaryEncoded) break;
                return String.valueOf(this.getMediumInt());
            }
            case BIGINT: {
                if (!this.isBinaryEncoded) break;
                if (!this.columnInfo.isSigned()) {
                    return String.valueOf(this.getBigInteger());
                }
                return String.valueOf(this.getLong());
            }
            case DOUBLE: {
                return String.valueOf(this.getDouble());
            }
            case FLOAT: {
                return String.valueOf(this.getFloat());
            }
            case TIME: {
                return this.getTimeString();
            }
            case DATE: {
                if (!this.isBinaryEncoded) break;
                try {
                    return this.getDate(cal).toString();
                }
                catch (ParseException parseException) {
                    break;
                }
            }
            case YEAR: {
                if (this.options.yearIsDateType) {
                    try {
                        return this.getDate(cal).toString();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                if (!this.isBinaryEncoded) break;
                return String.valueOf(this.getSmallInt());
            }
            case TIMESTAMP: 
            case DATETIME: {
                try {
                    return this.getTimestamp(cal).toString();
                }
                catch (ParseException parseException) {
                    break;
                }
            }
            case DECIMAL: {
                return this.getBigDecimal().toString();
            }
            case BLOB: 
            case LONGBLOB: 
            case MEDIUMBLOB: 
            case TINYBLOB: 
            case GEOMETRY: {
                return new String(this.getBytes());
            }
            case NULL: {
                return null;
            }
            case OLDDECIMAL: {
                return this.getBigDecimal().toString();
            }
            default: {
                return new String(this.rawBytes, StandardCharsets.UTF_8);
            }
        }
        return new String(this.rawBytes, StandardCharsets.UTF_8);
    }

    private String getTimeString() {
        if (this.rawBytes == null || this.rawBytes.length == 0) {
            return null;
        }
        String rawValue = new String(this.rawBytes, StandardCharsets.UTF_8);
        if ("0000-00-00".equals(rawValue)) {
            return null;
        }
        if (!this.isBinaryEncoded) {
            if (!this.options.useLegacyDatetimeCode && rawValue.indexOf(".") > 0) {
                return rawValue.substring(0, rawValue.indexOf("."));
            }
            return rawValue;
        }
        byte hour = this.rawBytes[5];
        int day = this.rawBytes[1] & 0xFF | (this.rawBytes[2] & 0xFF) << 8 | (this.rawBytes[3] & 0xFF) << 16 | (this.rawBytes[4] & 0xFF) << 24;
        int timeHour = hour + day * 24;
        String hourString = timeHour < 10 ? "0" + timeHour : Integer.toString(timeHour);
        byte minutes = this.rawBytes[6];
        String minuteString = minutes < 10 ? "0" + minutes : Integer.toString(minutes);
        byte seconds = this.rawBytes[7];
        String secondString = seconds < 10 ? "0" + seconds : Integer.toString(seconds);
        int microseconds = 0;
        if (this.rawBytes.length > 8) {
            microseconds = this.rawBytes[8] & 0xFF | (this.rawBytes[9] & 0xFF) << 8 | (this.rawBytes[10] & 0xFF) << 16 | (this.rawBytes[11] & 0xFF) << 24;
        }
        String microsecondString = Integer.toString(microseconds);
        while (microsecondString.length() < 6) {
            microsecondString = "0" + microsecondString;
        }
        boolean negative = this.rawBytes[0] == 1;
        return (negative ? "-" : "") + hourString + ":" + minuteString + ":" + secondString;
    }

    @Override
    public byte getByte() throws SQLException {
        long value;
        if (this.rawBytes == null) {
            return 0;
        }
        if (!this.isBinaryEncoded) {
            if (this.dataType == MariaDbType.BIT) {
                return this.rawBytes[0];
            }
            return this.parseByte();
        }
        switch (this.dataType) {
            case BIT: {
                return this.rawBytes[0];
            }
            case TINYINT: {
                value = this.getTinyInt();
                break;
            }
            case SMALLINT: 
            case YEAR: {
                value = this.getSmallInt();
                break;
            }
            case INTEGER: 
            case MEDIUMINT: {
                value = this.getMediumInt();
                break;
            }
            case BIGINT: {
                value = this.getLong();
                break;
            }
            case FLOAT: {
                value = (long)this.getFloat();
                break;
            }
            case DOUBLE: {
                value = (long)this.getDouble();
                break;
            }
            default: {
                return this.parseByte();
            }
        }
        this.rangeCheck(Byte.class, -128L, 127L, value);
        return (byte)value;
    }

    private void rangeCheck(Object className, long minValue, long maxValue, long value) throws SQLException {
        if (value < minValue || value > maxValue) {
            throw new SQLException("Out of range value for column '" + this.columnInfo.getName() + "' : value " + value + " is not in " + className + " range", "22003", 1264);
        }
    }

    private int getTinyInt() throws SQLException {
        int value = this.rawBytes[0];
        if (!this.columnInfo.isSigned()) {
            value = this.rawBytes[0] & 0xFF;
        }
        return value;
    }

    private int getSmallInt() throws SQLException {
        int value = this.rawBytes[0] & 0xFF | (this.rawBytes[1] & 0xFF) << 8;
        if (!this.columnInfo.isSigned()) {
            return value & 0xFFFF;
        }
        return (short)value;
    }

    private long getMediumInt() throws SQLException {
        long value = this.rawBytes[0] & 0xFF | (this.rawBytes[1] & 0xFF) << 8 | (this.rawBytes[2] & 0xFF) << 16 | (this.rawBytes[3] & 0xFF) << 24;
        if (!this.columnInfo.isSigned()) {
            value &= 0xFFFFFFFFL;
        }
        return value;
    }

    private byte parseByte() throws SQLException {
        String value = new String(this.rawBytes, StandardCharsets.UTF_8);
        try {
            switch (this.dataType) {
                case FLOAT: {
                    Float floatValue = Float.valueOf(value);
                    if (floatValue.compareTo(Float.valueOf(127.0f)) >= 1) {
                        throw new SQLException("Out of range value for column '" + this.columnInfo.getName() + "' : value " + value + " is not in Byte range", "22003", 1264);
                    }
                    return floatValue.byteValue();
                }
                case DOUBLE: {
                    Double doubleValue = Double.valueOf(value);
                    if (doubleValue.compareTo(127.0) >= 1) {
                        throw new SQLException("Out of range value for column '" + this.columnInfo.getName() + "' : value " + value + " is not in Byte range", "22003", 1264);
                    }
                    return doubleValue.byteValue();
                }
            }
            return Byte.parseByte(value);
        }
        catch (NumberFormatException nfe) {
            if (isIntegerRegex.matcher(value).find()) {
                try {
                    return Byte.parseByte(value.substring(0, value.indexOf(".")));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new SQLException("Out of range value for column '" + this.columnInfo.getName() + "' : value " + value + " is not in Byte range", "22003", 1264);
        }
    }

    @Override
    public short getShort() throws SQLException {
        long value;
        if (this.rawBytes == null) {
            return 0;
        }
        if (!this.isBinaryEncoded) {
            return this.parseShort();
        }
        switch (this.dataType) {
            case BIT: {
                return this.rawBytes[0];
            }
            case TINYINT: {
                value = this.getTinyInt();
                break;
            }
            case SMALLINT: 
            case YEAR: {
                value = this.rawBytes[0] & 0xFF | (this.rawBytes[1] & 0xFF) << 8;
                if (this.columnInfo.isSigned()) {
                    return (short)value;
                }
                value &= 0xFFFFL;
                break;
            }
            case INTEGER: 
            case MEDIUMINT: {
                value = this.getMediumInt();
                break;
            }
            case BIGINT: {
                value = this.getLong();
                break;
            }
            case FLOAT: {
                value = (long)this.getFloat();
                break;
            }
            case DOUBLE: {
                value = (long)this.getDouble();
                break;
            }
            default: {
                return this.parseShort();
            }
        }
        this.rangeCheck(Short.class, -32768L, 32767L, value);
        return (short)value;
    }

    private short parseShort() throws SQLException {
        String value = new String(this.rawBytes, StandardCharsets.UTF_8);
        try {
            switch (this.dataType) {
                case FLOAT: {
                    Float floatValue = Float.valueOf(value);
                    if (floatValue.compareTo(Float.valueOf(32767.0f)) >= 1) {
                        throw new SQLException("Out of range value for column '" + this.columnInfo.getName() + "' : value " + value + " is not in Short range", "22003", 1264);
                    }
                    return floatValue.shortValue();
                }
                case DOUBLE: {
                    Double doubleValue = Double.valueOf(value);
                    if (doubleValue.compareTo(32767.0) >= 1) {
                        throw new SQLException("Out of range value for column '" + this.columnInfo.getName() + "' : value " + value + " is not in Short range", "22003", 1264);
                    }
                    return doubleValue.shortValue();
                }
            }
            return Short.parseShort(value);
        }
        catch (NumberFormatException nfe) {
            if (isIntegerRegex.matcher(value).find()) {
                try {
                    return Short.parseShort(value.substring(0, value.indexOf(".")));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new SQLException("Out of range value for column '" + this.columnInfo.getName() + "' : value " + value + " is not in Short range", "22003", 1264);
        }
    }

    @Override
    public int getInt() throws SQLException {
        long value;
        if (this.rawBytes == null) {
            return 0;
        }
        if (!this.isBinaryEncoded) {
            return this.parseInt();
        }
        switch (this.dataType) {
            case BIT: {
                return this.rawBytes[0];
            }
            case TINYINT: {
                value = this.getTinyInt();
                break;
            }
            case SMALLINT: 
            case YEAR: {
                value = this.getSmallInt();
                break;
            }
            case INTEGER: 
            case MEDIUMINT: {
                value = this.rawBytes[0] & 0xFF | (this.rawBytes[1] & 0xFF) << 8 | (this.rawBytes[2] & 0xFF) << 16 | (this.rawBytes[3] & 0xFF) << 24;
                if (this.columnInfo.isSigned()) {
                    return (int)value;
                }
                if (value >= 0L) break;
                value &= 0xFFFFFFFFL;
                break;
            }
            case BIGINT: {
                value = this.getLong();
                break;
            }
            case FLOAT: {
                value = (long)this.getFloat();
                break;
            }
            case DOUBLE: {
                value = (long)this.getDouble();
                break;
            }
            default: {
                return this.parseInt();
            }
        }
        this.rangeCheck(Integer.class, Integer.MIN_VALUE, Integer.MAX_VALUE, value);
        return (int)value;
    }

    private int parseInt() throws SQLException {
        String value = new String(this.rawBytes, StandardCharsets.UTF_8);
        try {
            switch (this.dataType) {
                case FLOAT: {
                    Float floatValue = Float.valueOf(value);
                    if (floatValue.compareTo(Float.valueOf(2.1474836E9f)) >= 1) {
                        throw new SQLException("Out of range value for column '" + this.columnInfo.getName() + "' : value " + value + " is not in Integer range", "22003", 1264);
                    }
                    return floatValue.intValue();
                }
                case DOUBLE: {
                    Double doubleValue = Double.valueOf(value);
                    if (doubleValue.compareTo(2.147483647E9) >= 1) {
                        throw new SQLException("Out of range value for column '" + this.columnInfo.getName() + "' : value " + value + " is not in Integer range", "22003", 1264);
                    }
                    return doubleValue.intValue();
                }
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            if (isIntegerRegex.matcher(value).find()) {
                try {
                    return Integer.parseInt(value.substring(0, value.indexOf(".")));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new SQLException("Out of range value for column '" + this.columnInfo.getName() + "' : value " + value + " is not in Integer range", "22003", 1264);
        }
    }

    @Override
    public long getLong() throws SQLException {
        long value;
        if (this.rawBytes == null) {
            return 0L;
        }
        if (!this.isBinaryEncoded) {
            return this.parseLong();
        }
        switch (this.dataType) {
            case BIT: {
                return this.rawBytes[0];
            }
            case TINYINT: {
                value = this.getTinyInt();
                break;
            }
            case SMALLINT: 
            case YEAR: {
                value = this.getSmallInt();
                break;
            }
            case INTEGER: 
            case MEDIUMINT: {
                value = this.getMediumInt();
                break;
            }
            case BIGINT: {
                long value2 = (long)(this.rawBytes[0] & 0xFF) | (long)(this.rawBytes[1] & 0xFF) << 8 | (long)(this.rawBytes[2] & 0xFF) << 16 | (long)(this.rawBytes[3] & 0xFF) << 24 | (long)(this.rawBytes[4] & 0xFF) << 32 | (long)(this.rawBytes[5] & 0xFF) << 40 | (long)(this.rawBytes[6] & 0xFF) << 48 | (long)(this.rawBytes[7] & 0xFF) << 56;
                if (this.columnInfo.isSigned()) {
                    return value2;
                }
                BigInteger unsignedValue = new BigInteger(1, new byte[]{(byte)(value2 >> 56), (byte)(value2 >> 48), (byte)(value2 >> 40), (byte)(value2 >> 32), (byte)(value2 >> 24), (byte)(value2 >> 16), (byte)(value2 >> 8), (byte)(value2 >> 0)});
                if (unsignedValue.compareTo(new BigInteger(String.valueOf(Long.MAX_VALUE))) > 0) {
                    throw new SQLException("Out of range value for column '" + this.columnInfo.getName() + "' : value " + unsignedValue + " is not in Long range", "22003", 1264);
                }
                return unsignedValue.longValue();
            }
            case FLOAT: {
                Float floatValue = Float.valueOf(this.getFloat());
                if (floatValue.compareTo(Float.valueOf(9.223372E18f)) >= 1) {
                    throw new SQLException("Out of range value for column '" + this.columnInfo.getName() + "' : value " + floatValue + " is not in Long range", "22003", 1264);
                }
                return floatValue.longValue();
            }
            case DOUBLE: {
                Double doubleValue = this.getDouble();
                if (doubleValue.compareTo(9.223372036854776E18) >= 1) {
                    throw new SQLException("Out of range value for column '" + this.columnInfo.getName() + "' : value " + doubleValue + " is not in Long range", "22003", 1264);
                }
                return doubleValue.longValue();
            }
            default: {
                return this.parseLong();
            }
        }
        this.rangeCheck(Long.class, Long.MIN_VALUE, Long.MAX_VALUE, value);
        return value;
    }

    private long parseLong() throws SQLException {
        String value = new String(this.rawBytes, StandardCharsets.UTF_8);
        try {
            switch (this.dataType) {
                case FLOAT: {
                    Float floatValue = Float.valueOf(value);
                    if (floatValue.compareTo(Float.valueOf(9.223372E18f)) >= 1) {
                        throw new SQLException("Out of range value for column '" + this.columnInfo.getName() + "' : value " + value + " is not in Long range", "22003", 1264);
                    }
                    return floatValue.longValue();
                }
                case DOUBLE: {
                    Double doubleValue = Double.valueOf(value);
                    if (doubleValue.compareTo(9.223372036854776E18) >= 1) {
                        throw new SQLException("Out of range value for column '" + this.columnInfo.getName() + "' : value " + value + " is not in Long range", "22003", 1264);
                    }
                    return doubleValue.longValue();
                }
            }
            return Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            if (isIntegerRegex.matcher(value).find()) {
                try {
                    return Long.parseLong(value.substring(0, value.indexOf(".")));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new SQLException("Out of range value for column '" + this.columnInfo.getName() + "' : value " + value + " is not in Long range", "22003", 1264);
        }
    }

    @Override
    public float getFloat() throws SQLException {
        long value;
        if (this.rawBytes == null) {
            return 0.0f;
        }
        if (!this.isBinaryEncoded) {
            return Float.valueOf(new String(this.rawBytes, StandardCharsets.UTF_8)).floatValue();
        }
        switch (this.dataType) {
            case BIT: {
                return this.rawBytes[0];
            }
            case TINYINT: {
                value = this.getTinyInt();
                break;
            }
            case SMALLINT: 
            case YEAR: {
                value = this.getSmallInt();
                break;
            }
            case INTEGER: 
            case MEDIUMINT: {
                value = this.getMediumInt();
                break;
            }
            case BIGINT: {
                long value2 = (long)(this.rawBytes[0] & 0xFF) | (long)(this.rawBytes[1] & 0xFF) << 8 | (long)(this.rawBytes[2] & 0xFF) << 16 | (long)(this.rawBytes[3] & 0xFF) << 24 | (long)(this.rawBytes[4] & 0xFF) << 32 | (long)(this.rawBytes[5] & 0xFF) << 40 | (long)(this.rawBytes[6] & 0xFF) << 48 | (long)(this.rawBytes[7] & 0xFF) << 56;
                if (this.columnInfo.isSigned()) {
                    return value2;
                }
                BigInteger unsignedValue = new BigInteger(1, new byte[]{(byte)(value2 >> 56), (byte)(value2 >> 48), (byte)(value2 >> 40), (byte)(value2 >> 32), (byte)(value2 >> 24), (byte)(value2 >> 16), (byte)(value2 >> 8), (byte)(value2 >> 0)});
                return unsignedValue.floatValue();
            }
            case FLOAT: {
                int valueFloat = this.rawBytes[0] & 0xFF | (this.rawBytes[1] & 0xFF) << 8 | (this.rawBytes[2] & 0xFF) << 16 | (this.rawBytes[3] & 0xFF) << 24;
                return Float.intBitsToFloat(valueFloat);
            }
            case DOUBLE: {
                return (float)this.getDouble();
            }
            default: {
                return Float.valueOf(new String(this.rawBytes, StandardCharsets.UTF_8)).floatValue();
            }
        }
        return Float.valueOf(String.valueOf(value)).floatValue();
    }

    @Override
    public double getDouble() throws SQLException {
        if (this.rawBytes == null) {
            return 0.0;
        }
        if (!this.isBinaryEncoded) {
            return Double.valueOf(new String(this.rawBytes, StandardCharsets.UTF_8));
        }
        switch (this.dataType) {
            case BIT: {
                return this.rawBytes[0];
            }
            case TINYINT: {
                return this.getTinyInt();
            }
            case SMALLINT: 
            case YEAR: {
                return this.getSmallInt();
            }
            case INTEGER: 
            case MEDIUMINT: {
                return this.getMediumInt();
            }
            case BIGINT: {
                long valueLong = (long)(this.rawBytes[0] & 0xFF) | (long)(this.rawBytes[1] & 0xFF) << 8 | (long)(this.rawBytes[2] & 0xFF) << 16 | (long)(this.rawBytes[3] & 0xFF) << 24 | (long)(this.rawBytes[4] & 0xFF) << 32 | (long)(this.rawBytes[5] & 0xFF) << 40 | (long)(this.rawBytes[6] & 0xFF) << 48 | (long)(this.rawBytes[7] & 0xFF) << 56;
                if (this.columnInfo.isSigned()) {
                    return valueLong;
                }
                return new BigInteger(1, new byte[]{(byte)(valueLong >> 56), (byte)(valueLong >> 48), (byte)(valueLong >> 40), (byte)(valueLong >> 32), (byte)(valueLong >> 24), (byte)(valueLong >> 16), (byte)(valueLong >> 8), (byte)(valueLong >> 0)}).doubleValue();
            }
            case FLOAT: {
                return this.getFloat();
            }
            case DOUBLE: {
                long valueDouble = (long)(this.rawBytes[0] & 0xFF) | (long)(this.rawBytes[1] & 0xFF) << 8 | (long)(this.rawBytes[2] & 0xFF) << 16 | (long)(this.rawBytes[3] & 0xFF) << 24 | (long)(this.rawBytes[4] & 0xFF) << 32 | (long)(this.rawBytes[5] & 0xFF) << 40 | (long)(this.rawBytes[6] & 0xFF) << 48 | (long)(this.rawBytes[7] & 0xFF) << 56;
                return Double.longBitsToDouble(valueDouble);
            }
        }
        return Double.valueOf(new String(this.rawBytes, StandardCharsets.UTF_8));
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        if (this.rawBytes == null) {
            return null;
        }
        if (!this.isBinaryEncoded) {
            return new BigDecimal(new String(this.rawBytes, StandardCharsets.UTF_8));
        }
        switch (this.dataType) {
            case BIT: {
                return BigDecimal.valueOf(this.rawBytes[0]);
            }
            case TINYINT: {
                return BigDecimal.valueOf(this.getTinyInt());
            }
            case SMALLINT: 
            case YEAR: {
                return BigDecimal.valueOf(this.getSmallInt());
            }
            case INTEGER: 
            case MEDIUMINT: {
                return BigDecimal.valueOf(this.getMediumInt());
            }
            case BIGINT: {
                long value = (long)(this.rawBytes[0] & 0xFF) | (long)(this.rawBytes[1] & 0xFF) << 8 | (long)(this.rawBytes[2] & 0xFF) << 16 | (long)(this.rawBytes[3] & 0xFF) << 24 | (long)(this.rawBytes[4] & 0xFF) << 32 | (long)(this.rawBytes[5] & 0xFF) << 40 | (long)(this.rawBytes[6] & 0xFF) << 48 | (long)(this.rawBytes[7] & 0xFF) << 56;
                if (this.columnInfo.isSigned()) {
                    return new BigDecimal(String.valueOf(BigInteger.valueOf(value))).setScale(this.columnInfo.getDecimals());
                }
                return new BigDecimal(String.valueOf(new BigInteger(1, new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)(value >> 0)}))).setScale(this.columnInfo.getDecimals());
            }
            case FLOAT: {
                return BigDecimal.valueOf(this.getFloat());
            }
            case DOUBLE: {
                return BigDecimal.valueOf(this.getDouble());
            }
        }
        return new BigDecimal(new String(this.rawBytes, StandardCharsets.UTF_8));
    }

    @Override
    public byte[] getBytes() {
        return this.rawBytes;
    }

    @Override
    public BigInteger getBigInteger() throws SQLException {
        if (this.rawBytes == null) {
            return null;
        }
        if (!this.isBinaryEncoded) {
            return new BigInteger(new String(this.rawBytes, StandardCharsets.UTF_8));
        }
        switch (this.dataType) {
            case BIT: {
                return BigInteger.valueOf(this.rawBytes[0]);
            }
            case TINYINT: {
                return BigInteger.valueOf(this.columnInfo.isSigned() ? this.getByte() : this.rawBytes[0] & 0xFF);
            }
            case SMALLINT: 
            case YEAR: {
                int valueShort = this.rawBytes[0] & 0xFF | (this.rawBytes[1] & 0xFF) << 8;
                return BigInteger.valueOf(this.columnInfo.isSigned() ? valueShort : valueShort & 0xFFFF);
            }
            case INTEGER: 
            case MEDIUMINT: {
                int valueInt = this.rawBytes[0] & 0xFF | (this.rawBytes[1] & 0xFF) << 8 | (this.rawBytes[2] & 0xFF) << 16 | (this.rawBytes[3] & 0xFF) << 24;
                return BigInteger.valueOf(this.columnInfo.isSigned() ? (long)valueInt : (valueInt >= 0 ? (long)valueInt : (long)valueInt & 0xFFFFFFFFL));
            }
            case BIGINT: {
                long value = (long)(this.rawBytes[0] & 0xFF) | (long)(this.rawBytes[1] & 0xFF) << 8 | (long)(this.rawBytes[2] & 0xFF) << 16 | (long)(this.rawBytes[3] & 0xFF) << 24 | (long)(this.rawBytes[4] & 0xFF) << 32 | (long)(this.rawBytes[5] & 0xFF) << 40 | (long)(this.rawBytes[6] & 0xFF) << 48 | (long)(this.rawBytes[7] & 0xFF) << 56;
                if (this.columnInfo.isSigned()) {
                    return BigInteger.valueOf(value);
                }
                return new BigInteger(1, new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)(value >> 0)});
            }
            case FLOAT: {
                return BigInteger.valueOf((long)this.getFloat());
            }
            case DOUBLE: {
                return BigInteger.valueOf((long)this.getDouble());
            }
        }
        return new BigInteger(new String(this.rawBytes, StandardCharsets.UTF_8));
    }

    @Override
    public Date getDate(Calendar cal) throws ParseException {
        if (this.rawBytes == null) {
            return null;
        }
        if (!this.isBinaryEncoded) {
            String rawValue = new String(this.rawBytes, StandardCharsets.UTF_8);
            String zeroDate = "0000-00-00";
            if (rawValue.equals(zeroDate)) {
                return null;
            }
            switch (this.dataType) {
                case TIMESTAMP: 
                case DATETIME: {
                    return new Date(this.getTimestamp(cal).getTime());
                }
                case TIME: {
                    return new Date(this.getTime(cal).getTime());
                }
                case DATE: {
                    return new Date(Integer.parseInt(rawValue.substring(0, 4)) - 1900, Integer.parseInt(rawValue.substring(5, 7)) - 1, Integer.parseInt(rawValue.substring(8, 10)));
                }
                case YEAR: {
                    int year = Integer.parseInt(rawValue);
                    if (this.rawBytes.length == 2 && this.columnInfo.getLength() == 2L) {
                        year = year <= 69 ? (year += 2000) : (year += 1900);
                    }
                    return new Date(year - 1900, 0, 1);
                }
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            if (cal != null) {
                sdf.setCalendar(cal);
            }
            java.util.Date utilDate = sdf.parse(rawValue);
            return new Date(utilDate.getTime());
        }
        return this.binaryDate(cal);
    }

    @Override
    public Time getTime(Calendar cal) throws ParseException {
        if (this.rawBytes == null) {
            return null;
        }
        String raw = new String(this.rawBytes, StandardCharsets.UTF_8);
        String zeroDate = "0000-00-00";
        if (raw.equals(zeroDate)) {
            return null;
        }
        if (!this.isBinaryEncoded) {
            String[] rawPart;
            if (this.dataType == MariaDbType.TIMESTAMP || this.dataType == MariaDbType.DATETIME) {
                return new Time(this.getTimestamp(cal).getTime());
            }
            if (this.dataType == MariaDbType.DATE) {
                Calendar zeroCal = Calendar.getInstance();
                zeroCal.set(1970, 0, 1, 0, 0, 0);
                zeroCal.set(14, 0);
                return new Time(zeroCal.getTimeInMillis());
            }
            if (!this.options.useLegacyDatetimeCode && (raw.startsWith("-") || raw.split(":").length != 3 || raw.indexOf(":") > 3)) {
                throw new ParseException("Time format \"" + raw + "\" incorrect, must be HH:mm:ss", 0);
            }
            boolean negate = raw.startsWith("-");
            if (negate) {
                raw = raw.substring(1);
            }
            if ((rawPart = raw.split(":")).length == 3) {
                int hour = Integer.parseInt(rawPart[0]);
                int minutes = Integer.parseInt(rawPart[1]);
                int seconds = Integer.parseInt(rawPart[2].substring(0, 2));
                Calendar calendar = Calendar.getInstance();
                if (this.options.useLegacyDatetimeCode) {
                    calendar.setLenient(true);
                }
                calendar.clear();
                calendar.set(1970, 0, 1, (negate ? -1 : 1) * hour, minutes, seconds);
                int nanoseconds = this.extractNanos(raw);
                calendar.set(14, nanoseconds / 1000000);
                return new Time(calendar.getTimeInMillis());
            }
            throw new ParseException(raw + " cannot be parse as time. time must have \"99:99:99\" format", 0);
        }
        return this.binaryTime(cal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date binaryDate(Calendar cal) throws ParseException {
        Date dt;
        Calendar calendar;
        switch (this.dataType) {
            case TIMESTAMP: 
            case DATETIME: {
                return new Date(this.getTimestamp(cal).getTime());
            }
        }
        if (this.rawBytes.length == 0) {
            return null;
        }
        int year = this.rawBytes[0] & 0xFF | (this.rawBytes[1] & 0xFF) << 8;
        byte month = this.rawBytes[2];
        byte day = this.rawBytes[3];
        Calendar calendar2 = calendar = Calendar.getInstance();
        synchronized (calendar2) {
            calendar.clear();
            calendar.set(1, year);
            calendar.set(2, month - 1);
            calendar.set(5, day);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            dt = new Date(calendar.getTimeInMillis());
        }
        return dt;
    }

    private Time binaryTime(Calendar cal) throws ParseException {
        switch (this.dataType) {
            case TIMESTAMP: 
            case DATETIME: {
                Timestamp ts = this.binaryTimestamp(cal);
                return new Time(ts.getTime());
            }
            case DATE: {
                Calendar tmpCalendar = Calendar.getInstance();
                tmpCalendar.clear();
                tmpCalendar.set(1970, 0, 1, 0, 0, 0);
                tmpCalendar.set(14, 0);
                return new Time(tmpCalendar.getTimeInMillis());
            }
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        if (this.options.useLegacyDatetimeCode) {
            calendar.setLenient(false);
        }
        byte hour = 0;
        int minutes = 0;
        int seconds = 0;
        if (this.rawBytes.length > 7) {
            hour = this.rawBytes[5];
            minutes = this.rawBytes[6];
            seconds = this.rawBytes[7];
        }
        calendar.set(1970, 0, 1, hour, minutes, seconds);
        int nanoseconds = 0;
        if (this.rawBytes.length > 8) {
            nanoseconds = this.rawBytes[8] & 0xFF | (this.rawBytes[9] & 0xFF) << 8 | (this.rawBytes[10] & 0xFF) << 16 | (this.rawBytes[11] & 0xFF) << 24;
        }
        calendar.set(14, nanoseconds / 1000);
        return new Time(calendar.getTimeInMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timestamp binaryTimestamp(Calendar cal) throws ParseException {
        Timestamp tt;
        if (this.rawBytes.length == 0) {
            return null;
        }
        byte hour = 0;
        byte minutes = 0;
        byte seconds = 0;
        int microseconds = 0;
        if (this.dataType == MariaDbType.TIME) {
            return new Timestamp(this.getTime(cal).getTime());
        }
        int year = this.rawBytes[0] & 0xFF | (this.rawBytes[1] & 0xFF) << 8;
        byte month = this.rawBytes[2];
        byte day = this.rawBytes[3];
        if (this.rawBytes.length > 4) {
            hour = this.rawBytes[4];
            minutes = this.rawBytes[5];
            seconds = this.rawBytes[6];
            if (this.rawBytes.length > 7) {
                microseconds = this.rawBytes[7] & 0xFF | (this.rawBytes[8] & 0xFF) << 8 | (this.rawBytes[9] & 0xFF) << 16 | (this.rawBytes[10] & 0xFF) << 24;
            }
        }
        Calendar calendar = Calendar.getInstance();
        if (!this.options.useLegacyDatetimeCode) {
            calendar = cal;
        }
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            calendar.set(year, month - 1, day, hour, minutes, seconds);
            tt = new Timestamp(calendar.getTimeInMillis());
        }
        tt.setNanos(microseconds * 1000);
        return tt;
    }

    private int extractNanos(String timestring) throws ParseException {
        int index = timestring.indexOf(46);
        if (index == -1) {
            return 0;
        }
        int nanos = 0;
        for (int i = index + 1; i < index + 10; ++i) {
            int digit;
            if (i >= timestring.length()) {
                digit = 0;
            } else {
                char value = timestring.charAt(i);
                if (value < '0' || value > '9') {
                    throw new ParseException("cannot parse subsecond part in timestamp string '" + timestring + "'", i);
                }
                digit = value - 48;
            }
            nanos = nanos * 10 + digit;
        }
        return nanos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(Calendar cal) throws ParseException {
        if (this.rawBytes == null) {
            return null;
        }
        if (!this.isBinaryEncoded) {
            String rawValue = new String(this.rawBytes, StandardCharsets.UTF_8);
            String zeroTimestamp = "0000-00-00 00:00:00";
            if (rawValue.equals(zeroTimestamp)) {
                return null;
            }
            switch (this.dataType) {
                case TIME: {
                    Timestamp tt = new Timestamp(this.getTime(cal).getTime());
                    tt.setNanos(this.extractNanos(rawValue));
                    return tt;
                }
            }
            try {
                Timestamp timestamp;
                int hour = 0;
                int minutes = 0;
                int seconds = 0;
                int year = Integer.parseInt(rawValue.substring(0, 4));
                int month = Integer.parseInt(rawValue.substring(5, 7));
                int day = Integer.parseInt(rawValue.substring(8, 10));
                if (rawValue.length() >= 19) {
                    hour = Integer.parseInt(rawValue.substring(11, 13));
                    minutes = Integer.parseInt(rawValue.substring(14, 16));
                    seconds = Integer.parseInt(rawValue.substring(17, 19));
                }
                int nanoseconds = this.extractNanos(rawValue);
                Calendar calendar = cal;
                if (this.options.useLegacyDatetimeCode) {
                    calendar = Calendar.getInstance();
                }
                Calendar calendar2 = calendar;
                synchronized (calendar2) {
                    calendar.set(1, year);
                    calendar.set(2, month - 1);
                    calendar.set(5, day);
                    calendar.set(11, hour);
                    calendar.set(12, minutes);
                    calendar.set(13, seconds);
                    calendar.set(14, nanoseconds / 1000000);
                    timestamp = new Timestamp(calendar.getTime().getTime());
                }
                timestamp.setNanos(nanoseconds);
                return timestamp;
            }
            catch (NumberFormatException n) {
                throw new ParseException("Value \"" + rawValue + "\" cannot be parse as Timestamp", 0);
            }
            catch (StringIndexOutOfBoundsException s) {
                throw new ParseException("Value \"" + rawValue + "\" cannot be parse as Timestamp", 0);
            }
        }
        return this.binaryTimestamp(cal);
    }

    @Override
    public InputStream getInputStream() {
        if (this.rawBytes == null) {
            return null;
        }
        return new ByteArrayInputStream(new String(this.rawBytes, StandardCharsets.UTF_8).getBytes());
    }

    @Override
    public InputStream getBinaryInputStream() {
        if (this.rawBytes == null) {
            return null;
        }
        return new ByteArrayInputStream(this.rawBytes);
    }

    @Override
    public boolean getBoolean() {
        if (this.rawBytes == null) {
            return false;
        }
        String rawVal = new String(this.rawBytes, StandardCharsets.UTF_8);
        return rawVal.equalsIgnoreCase("true") || rawVal.equals("1") || (this.rawBytes[0] & 0xFF) == 1;
    }

    @Override
    public boolean isNull() {
        String zeroTimestamp = "0000-00-00 00:00:00";
        String zeroDate = "0000-00-00";
        return this.rawBytes == null || this.isBinaryEncoded && (this.dataType == MariaDbType.DATE || this.dataType == MariaDbType.TIMESTAMP || this.dataType == MariaDbType.DATETIME) && this.rawBytes.length == 0 || !this.isBinaryEncoded && (this.dataType == MariaDbType.TIMESTAMP || this.dataType == MariaDbType.DATETIME) && zeroTimestamp.equals(new String(this.rawBytes, StandardCharsets.UTF_8)) || !this.isBinaryEncoded && this.dataType == MariaDbType.DATE && zeroDate.equals(new String(this.rawBytes, StandardCharsets.UTF_8));
    }

    public int getDisplayLength() {
        if (this.rawBytes != null) {
            return this.rawBytes.length;
        }
        return 4;
    }

    @Override
    public Blob getBlob() {
        if (this.rawBytes == null) {
            return null;
        }
        return new MariaDbBlob(this.rawBytes);
    }

    public Clob getClob() {
        if (this.rawBytes == null) {
            return null;
        }
        return new MariaDbClob(this.rawBytes);
    }

    @Override
    public Object getObject(int dataTypeMappingFlags, Calendar cal) throws SQLException, ParseException {
        if (this.rawBytes == null) {
            return null;
        }
        switch (this.dataType) {
            case BIT: {
                if (this.columnInfo.getLength() == 1L) {
                    return this.getBytes()[0] != 0;
                }
                return this.getBytes();
            }
            case TINYINT: {
                if ((dataTypeMappingFlags & 1) != 0 && this.columnInfo.getLength() == 1L) {
                    return this.getBytes()[0] != 48;
                }
                return this.getInt();
            }
            case INTEGER: {
                if (!this.columnInfo.isSigned()) {
                    return this.getLong();
                }
                return this.getInt();
            }
            case BIGINT: {
                if (!this.columnInfo.isSigned()) {
                    return this.getBigInteger();
                }
                return this.getLong();
            }
            case DOUBLE: {
                return this.getDouble();
            }
            case TIMESTAMP: 
            case DATETIME: {
                return this.getTimestamp(cal);
            }
            case DATE: {
                return this.getDate(cal);
            }
            case VARCHAR: {
                if (this.columnInfo.isBinary()) {
                    return this.getBytes();
                }
                return this.getString();
            }
            case DECIMAL: {
                return this.getBigDecimal();
            }
            case BLOB: 
            case LONGBLOB: 
            case MEDIUMBLOB: 
            case TINYBLOB: {
                return this.getBytes();
            }
            case NULL: {
                return null;
            }
            case YEAR: {
                if ((dataTypeMappingFlags & 2) != 0) {
                    return this.getDate(cal);
                }
                return this.getShort();
            }
            case SMALLINT: 
            case MEDIUMINT: {
                return this.getInt();
            }
            case FLOAT: {
                return Float.valueOf(this.getFloat());
            }
            case TIME: {
                return this.getTime(cal);
            }
            case VARSTRING: 
            case STRING: {
                if (this.columnInfo.isBinary()) {
                    return this.getBytes();
                }
                return this.getString();
            }
            case OLDDECIMAL: {
                return this.getString();
            }
            case GEOMETRY: {
                return this.getBytes();
            }
            case ENUM: {
                break;
            }
            case NEWDATE: {
                break;
            }
            case SET: {
                break;
            }
        }
        throw new RuntimeException(this.dataType.toString());
    }
}

