/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.backend.definition.adapter.bind;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.kie.workbench.common.stunner.core.backend.definition.adapter.ReflectionAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.AbstractBindableDefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableDefinitionAdapter;
import org.kie.workbench.common.stunner.core.graph.util.Exceptions;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BackendBindableDefinitionAdapter<T>
extends AbstractBindableDefinitionAdapter<T>
implements BindableDefinitionAdapter<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BackendBindableDefinitionAdapter.class);

    BackendBindableDefinitionAdapter(DefinitionUtils definitionUtils) {
        super(definitionUtils);
    }

    public String getCategory(T definition) {
        Class<?> type = definition.getClass();
        try {
            return (String)ReflectionAdapterUtils.getFieldValue(definition, (String)this.propertyCategoryFieldNames.get(type));
        }
        catch (IllegalAccessException e) {
            LOG.error("Error obtaining category for Definition with id " + this.getId(definition));
            return null;
        }
    }

    public String getTitle(T definition) {
        Class<?> type = definition.getClass();
        try {
            return (String)ReflectionAdapterUtils.getFieldValue(definition, (String)this.propertyTitleFieldNames.get(type));
        }
        catch (IllegalAccessException e) {
            LOG.error("Error obtaining title for Definition with id " + this.getId(definition));
            return null;
        }
    }

    public Optional<String> getNameField(T definition) {
        return (Optional)Exceptions.swallow(() -> Optional.ofNullable(ReflectionAdapterUtils.getFieldValue(definition, (String)this.propertyNameFields.get(definition.getClass()))), Optional.empty());
    }

    public String getDescription(T definition) {
        Class<?> type = definition.getClass();
        try {
            return (String)ReflectionAdapterUtils.getFieldValue(definition, (String)this.propertyDescriptionFieldNames.get(type));
        }
        catch (IllegalAccessException e) {
            LOG.error("Error obtaining description for Definition with id " + this.getId(definition));
            return null;
        }
    }

    public Set<String> getLabels(T definition) {
        Class<?> type = definition.getClass();
        try {
            return (Set)ReflectionAdapterUtils.getFieldValue(definition, (String)this.propertyLabelsFieldNames.get(type));
        }
        catch (IllegalAccessException e) {
            LOG.error("Error obtaining labels for Definition with id " + this.getId(definition));
            return Collections.emptySet();
        }
    }

    public Set<?> getPropertySets(T definition) {
        Class<?> type = definition.getClass();
        Set fields = (Set)this.propertySetsFieldNames.get(type);
        try {
            return ReflectionAdapterUtils.getFieldValues(definition, fields);
        }
        catch (IllegalAccessException e) {
            LOG.error("Error obtaining property sets for Definition with id " + this.getId(definition));
            return Collections.emptySet();
        }
    }

    protected Set<?> getBindProperties(T definition) {
        Class<?> type = definition.getClass();
        Set fields = (Set)this.propertiesFieldNames.get(type);
        try {
            if (null != fields) {
                return ReflectionAdapterUtils.getFieldValues(definition, fields);
            }
        }
        catch (IllegalAccessException e) {
            LOG.error("Error obtaining properties for Definition with id " + this.getId(definition));
        }
        return Collections.emptySet();
    }

    public Optional<?> getProperty(T definition, String propertyName) {
        return Optional.ofNullable(this.propertiesFieldNames.get(definition.getClass())).orElse(Collections.emptySet()).stream().filter(name -> Objects.equals(name, propertyName)).findFirst().map(prop -> Exceptions.swallow(() -> ReflectionAdapterUtils.getFieldValue(definition, prop), null));
    }

    protected String getStringFieldValue(Object pojo, String fieldName) {
        try {
            return (String)ReflectionAdapterUtils.getFieldValue(pojo, fieldName);
        }
        catch (IllegalAccessException e) {
            LOG.error("Error obtaining the field [" + fieldName + "] value for type [" + pojo.getClass() + "]");
            return null;
        }
    }
}

