/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.editors.types;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.impl.JavaBackedType;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.soup.project.datamodel.oracle.ModuleDataModelOracle;
import org.kie.workbench.common.dmn.api.editors.types.DataObject;
import org.kie.workbench.common.dmn.api.editors.types.DataObjectProperty;
import org.kie.workbench.common.dmn.api.editors.types.DataObjectsService;
import org.kie.workbench.common.services.backend.project.ModuleClassLoaderHelper;
import org.kie.workbench.common.services.datamodel.backend.server.DataModelOracleUtilities;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.datamodel.util.PrimitiveUtilities;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;

@Service
@Dependent
public class DataObjectsServiceImpl
implements DataObjectsService {
    private DataModelService dataModelService;
    private ModuleClassLoaderHelper moduleClassLoaderHelper;
    private KieModuleService moduleService;

    protected DataObjectsServiceImpl() {
        this(null, null, null);
    }

    @Inject
    public DataObjectsServiceImpl(DataModelService dataModelService, ModuleClassLoaderHelper moduleClassLoaderHelper, KieModuleService moduleService) {
        this.dataModelService = dataModelService;
        this.moduleClassLoaderHelper = moduleClassLoaderHelper;
        this.moduleService = moduleService;
    }

    public List<DataObject> loadDataObjects(WorkspaceProject workspaceProject) {
        KieModule module = (KieModule)this.moduleService.resolveModule(workspaceProject.getRootPath());
        ClassLoader classLoader = this.moduleClassLoaderHelper.getModuleClassLoader(module);
        ModuleDataModelOracle dmo = this.dataModelService.getModuleDataModel(workspaceProject.getRootPath());
        String[] types = DataModelOracleUtilities.getFactTypes((ModuleDataModelOracle)dmo);
        Map typesModelFields = dmo.getModuleModelFields();
        Map parametersType = dmo.getModuleFieldParametersType();
        List<DataObject> dataObjects = Arrays.stream(types).map(DataObject::new).collect(Collectors.toList());
        dataObjects.forEach(dataObject -> this.convertProperties((DataObject)dataObject, dataObjects, typesModelFields, classLoader, parametersType));
        return dataObjects;
    }

    private void convertProperties(DataObject dataObject, List<DataObject> dataObjects, Map<String, ModelField[]> typesModelFields, ClassLoader classLoader, Map<String, String> parametersType) {
        ModelField[] typeModelFields = typesModelFields.getOrDefault(dataObject.getClassType(), new ModelField[0]);
        dataObject.setProperties(Arrays.stream(typeModelFields).filter(typeModelField -> !Objects.equals(typeModelField.getName(), "this")).map(typeModelField -> this.convertProperty((ModelField)typeModelField, dataObjects, classLoader, parametersType, dataObject)).collect(Collectors.toList()));
    }

    private DataObjectProperty convertProperty(ModelField field, List<DataObject> dataObjects, ClassLoader classLoader, Map<String, String> parametersType, DataObject dataObject) {
        DataObjectProperty dataObjectProperty = new DataObjectProperty();
        dataObjectProperty.setList(this.isList(field.getClassName(), classLoader));
        if (dataObjectProperty.isList()) {
            String parametersKey = dataObject.getClassType() + "#" + field.getName();
            if (!parametersType.containsKey(parametersKey)) {
                dataObjectProperty.setType(this.convertDataType(field.getClassName(), dataObjects, classLoader));
            } else {
                String type = parametersType.get(parametersKey);
                String listType = this.convertDataType(type, dataObjects, classLoader);
                dataObjectProperty.setType(listType);
            }
        } else {
            dataObjectProperty.setType(this.convertDataType(field.getClassName(), dataObjects, classLoader));
        }
        dataObjectProperty.setProperty(field.getName());
        return dataObjectProperty;
    }

    private boolean isList(String typeName, ClassLoader classLoader) {
        try {
            String className = PrimitiveUtilities.getClassNameForPrimitiveType((String)typeName);
            Class<?> clazz = classLoader.loadClass(Objects.nonNull(className) ? className : typeName);
            return List.class.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    private String convertDataType(String typeName, List<DataObject> dataObjects, ClassLoader classLoader) {
        for (DataObject dataObject : dataObjects) {
            if (!Objects.equals(typeName, dataObject.getClassType())) continue;
            return typeName;
        }
        try {
            String className = PrimitiveUtilities.getClassNameForPrimitiveType((String)typeName);
            Class<?> clazz = classLoader.loadClass(Objects.nonNull(className) ? className : typeName);
            org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType builtInType = this.determineBuiltInTypeFromClass(clazz);
            if (Objects.nonNull(builtInType)) {
                return builtInType.getName();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType.ANY.getName();
    }

    private org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType determineBuiltInTypeFromClass(Class<?> clazz) {
        Type type = JavaBackedType.determineTypeFromClass(clazz);
        if (type instanceof BuiltInType) {
            BuiltInType builtIn = (BuiltInType)type;
            switch (builtIn) {
                case UNKNOWN: 
                case DURATION: 
                case RANGE: 
                case FUNCTION: 
                case LIST: 
                case UNARY_TEST: {
                    return org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType.ANY;
                }
                case NUMBER: {
                    return org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType.NUMBER;
                }
                case STRING: {
                    return org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType.STRING;
                }
                case DATE: {
                    return org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType.DATE;
                }
                case TIME: {
                    return org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType.TIME;
                }
                case DATE_TIME: {
                    return org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType.DATE_TIME;
                }
                case BOOLEAN: {
                    return org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType.BOOLEAN;
                }
                case CONTEXT: {
                    return org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType.CONTEXT;
                }
            }
        }
        return org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType.ANY;
    }
}

