/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties;

import java.util.List;
import java.util.Optional;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.Bpmn2Factory;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.Expression;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.InputOutputSpecification;
import org.eclipse.bpmn2.InputSet;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.LoopCharacteristics;
import org.eclipse.bpmn2.MultiInstanceLoopCharacteristics;
import org.eclipse.bpmn2.OutputSet;
import org.eclipse.bpmn2.Property;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Ids;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.ActivityPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.Scripts;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public class MultipleInstanceActivityPropertyWriter
extends ActivityPropertyWriter {
    private MultiInstanceLoopCharacteristics miloop;
    private InputOutputSpecification ioSpec;
    private InputSet inputSet;
    private OutputSet outputSet;

    public MultipleInstanceActivityPropertyWriter(Activity activity, VariableScope variableScope) {
        super(activity, variableScope);
    }

    public void setCollectionInput(String collectionInput) {
        if (StringUtils.isEmpty((String)collectionInput)) {
            return;
        }
        this.setUpLoopCharacteristics();
        String suffix = "IN_COLLECTION";
        String id = Ids.dataInput(this.activity.getId(), suffix);
        DataInput dataInputElement = MultipleInstanceActivityPropertyWriter.createDataInput(id, suffix);
        this.ioSpec.getDataInputs().add(dataInputElement);
        this.findPropertyById(collectionInput).ifPresent(prop -> {
            dataInputElement.setItemSubjectRef(prop.getItemSubjectRef());
            this.miloop.setLoopDataInputRef((ItemAwareElement)dataInputElement);
            MultipleInstanceActivityPropertyWriter.addSafe(this.inputSet.getDataInputRefs(), dataInputElement);
            DataInputAssociation dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
            dia.getSourceRef().add(prop);
            dia.setTargetRef((ItemAwareElement)dataInputElement);
            MultipleInstanceActivityPropertyWriter.addSafe(this.activity.getDataInputAssociations(), dia);
        });
    }

    public void setCollectionOutput(String collectionOutput) {
        if (StringUtils.isEmpty((String)collectionOutput)) {
            return;
        }
        this.setUpLoopCharacteristics();
        String suffix = "OUT_COLLECTION";
        String id = Ids.dataOutput(this.activity.getId(), suffix);
        DataOutput dataOutputElement = MultipleInstanceActivityPropertyWriter.createDataOutput(id, suffix);
        MultipleInstanceActivityPropertyWriter.addSafe(this.ioSpec.getDataOutputs(), dataOutputElement);
        this.findPropertyById(collectionOutput).ifPresent(prop -> {
            dataOutputElement.setItemSubjectRef(prop.getItemSubjectRef());
            this.miloop.setLoopDataOutputRef((ItemAwareElement)dataOutputElement);
            MultipleInstanceActivityPropertyWriter.addSafe(this.outputSet.getDataOutputRefs(), dataOutputElement);
            DataOutputAssociation doa = Bpmn2Factory.eINSTANCE.createDataOutputAssociation();
            doa.getSourceRef().add(dataOutputElement);
            doa.setTargetRef((ItemAwareElement)prop);
            MultipleInstanceActivityPropertyWriter.addSafe(this.activity.getDataOutputAssociations(), doa);
        });
    }

    public void setInput(String name) {
        this.setInput(name, true);
    }

    protected void setInput(String name, boolean addDataInputAssociation) {
        if (StringUtils.isEmpty((String)name)) {
            return;
        }
        String[] variable = name.split(":");
        String variableName = this.getVariableName(variable);
        String variableType = this.getVariableType(variable);
        this.setUpLoopCharacteristics();
        DataInput miDataInputElement = MultipleInstanceActivityPropertyWriter.createDataInput(variableName, variableName);
        ItemDefinition item = this.createItemDefinition(variableName, variableType);
        this.addItemDefinition(item);
        miDataInputElement.setItemSubjectRef(item);
        this.miloop.setInputDataItem(miDataInputElement);
        String id = Ids.dataInput(this.activity.getId(), variableName);
        DataInput dataInputElement = MultipleInstanceActivityPropertyWriter.createDataInput(id, variableName);
        dataInputElement.setItemSubjectRef(item);
        MultipleInstanceActivityPropertyWriter.addSafe(this.ioSpec.getDataInputs(), dataInputElement);
        MultipleInstanceActivityPropertyWriter.addSafe(this.inputSet.getDataInputRefs(), dataInputElement);
        if (addDataInputAssociation) {
            DataInputAssociation dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
            dia.getSourceRef().add(miDataInputElement);
            dia.setTargetRef((ItemAwareElement)dataInputElement);
            MultipleInstanceActivityPropertyWriter.addSafe(this.activity.getDataInputAssociations(), dia);
        }
    }

    private String getVariableName(String[] parsedVariable) {
        return parsedVariable.length > 0 && !parsedVariable[0].isEmpty() ? parsedVariable[0] : "";
    }

    private String getVariableType(String[] parsedVariable) {
        return parsedVariable.length > 1 && !parsedVariable[1].isEmpty() ? parsedVariable[1] : Object.class.getName();
    }

    public void setOutput(String name) {
        this.setOutput(name, true);
    }

    public void setOutput(String name, boolean addDataOutputAssociation) {
        if (StringUtils.isEmpty((String)name)) {
            return;
        }
        String[] variable = name.split(":");
        String variableName = this.getVariableName(variable);
        String variableType = this.getVariableType(variable);
        this.setUpLoopCharacteristics();
        DataOutput miDataOutputElement = MultipleInstanceActivityPropertyWriter.createDataOutput(variableName, variableName);
        ItemDefinition item = this.createItemDefinition(variableName, variableType);
        this.addItemDefinition(item);
        miDataOutputElement.setItemSubjectRef(item);
        this.miloop.setOutputDataItem(miDataOutputElement);
        String id = Ids.dataOutput(this.activity.getId(), variableName);
        DataOutput dataOutputElement = MultipleInstanceActivityPropertyWriter.createDataOutput(id, variableName);
        dataOutputElement.setItemSubjectRef(item);
        MultipleInstanceActivityPropertyWriter.addSafe(this.ioSpec.getDataOutputs(), dataOutputElement);
        MultipleInstanceActivityPropertyWriter.addSafe(this.outputSet.getDataOutputRefs(), dataOutputElement);
        if (addDataOutputAssociation) {
            DataOutputAssociation doa = Bpmn2Factory.eINSTANCE.createDataOutputAssociation();
            doa.getSourceRef().add(dataOutputElement);
            doa.setTargetRef((ItemAwareElement)miDataOutputElement);
            MultipleInstanceActivityPropertyWriter.addSafe(this.activity.getDataOutputAssociations(), doa);
        }
    }

    public void setCompletionCondition(String expression) {
        if (!StringUtils.isEmpty((String)expression)) {
            this.setUpLoopCharacteristics();
            FormalExpression formalExpression = Factories.bpmn2.createFormalExpression();
            formalExpression.setBody(Scripts.asCData(expression));
            this.miloop.setCompletionCondition((Expression)formalExpression);
        }
    }

    public void setIsSequential(boolean sequential) {
        this.setUpLoopCharacteristics();
        this.miloop.setIsSequential(sequential);
    }

    protected void setUpLoopCharacteristics() {
        if (this.miloop == null) {
            this.miloop = Factories.bpmn2.createMultiInstanceLoopCharacteristics();
            this.activity.setLoopCharacteristics((LoopCharacteristics)this.miloop);
            this.ioSpec = this.getIoSpecification();
            this.inputSet = this.getInputSet(this.ioSpec);
            this.outputSet = this.getOutputSet(this.ioSpec);
        }
    }

    protected static DataInput createDataInput(String id, String name) {
        DataInput dataInput = Factories.bpmn2.createDataInput();
        dataInput.setId(id);
        dataInput.setName(name);
        return dataInput;
    }

    protected static DataOutput createDataOutput(String id, String name) {
        DataOutput dataOutput = Factories.bpmn2.createDataOutput();
        dataOutput.setId(id);
        dataOutput.setName(name);
        return dataOutput;
    }

    protected ItemDefinition createItemDefinition(String name, String type) {
        ItemDefinition item = Factories.bpmn2.createItemDefinition();
        item.setId(Ids.multiInstanceItemType(this.activity.getId(), name));
        String varType = type.isEmpty() ? Object.class.getName() : type;
        item.setStructureRef(varType);
        return item;
    }

    protected static void addSafe(List<DataInput> inputs, DataInput dataInput) {
        inputs.removeIf(existingDataInput -> dataInput.getId().equals(existingDataInput.getId()));
        inputs.add(dataInput);
    }

    protected static void addSafe(List<DataInputAssociation> associations, DataInputAssociation inputAssociation) {
        associations.removeIf(existingDia -> inputAssociation.getTargetRef().getId().equals(existingDia.getTargetRef().getId()));
        associations.add(inputAssociation);
    }

    protected static void addSafe(List<DataOutput> outputs, DataOutput dataOutput) {
        outputs.removeIf(existingDataOutput -> dataOutput.getId().equals(existingDataOutput.getId()));
        outputs.add(dataOutput);
    }

    protected static void addSafe(List<DataOutputAssociation> associations, DataOutputAssociation outputAssociation) {
        associations.removeIf(existingDoa -> existingDoa.getSourceRef() != null && !existingDoa.getSourceRef().isEmpty() && ((ItemAwareElement)outputAssociation.getSourceRef().get(0)).getId().equals(((ItemAwareElement)existingDoa.getSourceRef().get(0)).getId()));
        associations.add(outputAssociation);
    }

    private Optional<Property> findPropertyById(String id) {
        return this.variableScope.lookup(id).map(VariableScope.Variable::getTypedIdentifier);
    }
}

