/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import bpsim.ElementParameters;
import bpsim.NormalDistributionType;
import bpsim.Parameter;
import bpsim.ParameterValue;
import bpsim.PoissonDistributionType;
import bpsim.TimeParameters;
import bpsim.UniformDistributionType;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Match;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.SimulationAttributeSet;

public class SimulationAttributeSets {
    public static SimulationAttributeSet of(ElementParameters eleType) {
        TimeParameters timeParams = eleType.getTimeParameters();
        if (timeParams == null) {
            return new SimulationAttributeSet();
        }
        Parameter processingTime = timeParams.getProcessingTime();
        ParameterValue paramValue = (ParameterValue)processingTime.getParameterValue().get(0);
        return Match.of(ParameterValue.class, SimulationAttributeSet.class).when(NormalDistributionType.class, ndt -> {
            SimulationAttributeSet simulationSet = new SimulationAttributeSet();
            simulationSet.getMean().setValue(Double.valueOf(ndt.getMean()));
            simulationSet.getStandardDeviation().setValue(Double.valueOf(ndt.getStandardDeviation()));
            simulationSet.getDistributionType().setValue("normal");
            return simulationSet;
        }).when(UniformDistributionType.class, udt -> {
            SimulationAttributeSet simulationSet = new SimulationAttributeSet();
            simulationSet.getMin().setValue(Double.valueOf(udt.getMin()));
            simulationSet.getMax().setValue(Double.valueOf(udt.getMax()));
            simulationSet.getDistributionType().setValue("uniform");
            return simulationSet;
        }).when(PoissonDistributionType.class, pdt -> {
            SimulationAttributeSet simulationSet = new SimulationAttributeSet();
            simulationSet.getMean().setValue(Double.valueOf(pdt.getMean()));
            simulationSet.getDistributionType().setValue("poisson");
            return simulationSet;
        }).apply(paramValue).asSuccess().value();
    }

    public static ElementParameters toElementParameters(SimulationAttributeSet simulationSet) {
        ElementParameters elementParameters = Factories.bpsim.createElementParameters();
        TimeParameters timeParameters = Factories.bpsim.createTimeParameters();
        Parameter processingTime = Factories.bpsim.createParameter();
        timeParameters.setProcessingTime(processingTime);
        switch (simulationSet.getDistributionType().getValue()) {
            case "normal": {
                NormalDistributionType ndt = Factories.bpsim.createNormalDistributionType();
                ndt.setMean(simulationSet.getMean().getValue().doubleValue());
                ndt.setStandardDeviation(simulationSet.getStandardDeviation().getValue().doubleValue());
                processingTime.getParameterValue().add((Object)ndt);
                break;
            }
            case "uniform": {
                UniformDistributionType udt = Factories.bpsim.createUniformDistributionType();
                udt.setMin(simulationSet.getMin().getValue().doubleValue());
                udt.setMax(simulationSet.getMax().getValue().doubleValue());
                processingTime.getParameterValue().add((Object)udt);
                break;
            }
            case "poisson": {
                PoissonDistributionType pdt = Factories.bpsim.createPoissonDistributionType();
                pdt.setMean(simulationSet.getMean().getValue().doubleValue());
                processingTime.getParameterValue().add((Object)pdt);
            }
        }
        elementParameters.setTimeParameters(timeParameters);
        return elementParameters;
    }
}

