/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.project.backend.forms.conditions;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.kie.soup.project.datamodel.oracle.FieldAccessorsAndMutators;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.ClassFieldInspector;
import org.kie.workbench.common.services.datamodeller.codegen.GenerationTools;
import org.kie.workbench.common.stunner.bpmn.forms.conditions.Condition;
import org.kie.workbench.common.stunner.bpmn.forms.conditions.ConditionEditorService;
import org.kie.workbench.common.stunner.bpmn.forms.conditions.FieldMetadata;
import org.kie.workbench.common.stunner.bpmn.forms.conditions.FunctionDef;
import org.kie.workbench.common.stunner.bpmn.forms.conditions.GenerateConditionResult;
import org.kie.workbench.common.stunner.bpmn.forms.conditions.ParamDef;
import org.kie.workbench.common.stunner.bpmn.forms.conditions.ParseConditionResult;
import org.kie.workbench.common.stunner.bpmn.forms.conditions.TypeMetadata;
import org.kie.workbench.common.stunner.bpmn.forms.conditions.TypeMetadataQuery;
import org.kie.workbench.common.stunner.bpmn.forms.conditions.TypeMetadataQueryResult;
import org.kie.workbench.common.stunner.bpmn.project.backend.forms.conditions.parser.ConditionGenerator;
import org.kie.workbench.common.stunner.bpmn.project.backend.forms.conditions.parser.ConditionParser;
import org.kie.workbench.common.stunner.bpmn.project.backend.forms.conditions.parser.FunctionsRegistry;
import org.kie.workbench.common.stunner.bpmn.project.backend.forms.conditions.parser.GenerateConditionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.vfs.Path;

public abstract class BaseConditionEditorServiceImpl
implements ConditionEditorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseConditionEditorServiceImpl.class);

    public List<FunctionDef> findAvailableFunctions(Path path, String clazz) {
        Class<Object> resolvedClazz;
        ClassLoader classLoader = this.resolveClassLoader(path);
        try {
            resolvedClazz = classLoader.loadClass(clazz);
        }
        catch (ClassNotFoundException e) {
            resolvedClazz = Object.class;
            LOGGER.warn("Class: " + clazz + " was not properly resolved for module: " + path + " only java.lang.Object functions will be returned instead");
        }
        return this.findAvailableFunctions(resolvedClazz, classLoader);
    }

    protected List<FunctionDef> findAvailableFunctions(Class<?> clazz, ClassLoader classLoader) {
        ArrayList<FunctionDef> result = new ArrayList<FunctionDef>();
        for (FunctionDef functionDef : FunctionsRegistry.getInstance().getFunctions()) {
            try {
                Class<?> paramClass = classLoader.loadClass(((ParamDef)functionDef.getParams().get(0)).getType());
                if (!paramClass.isAssignableFrom(clazz)) continue;
                result.add(functionDef);
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("Uncommon error, internal function param type was not resolved: " + ((ParamDef)functionDef.getParams().get(0)).getType());
            }
        }
        return result;
    }

    public ParseConditionResult parseCondition(String conditionStr) {
        try {
            ConditionParser parser = new ConditionParser(conditionStr);
            return new ParseConditionResult(parser.parse());
        }
        catch (ParseException e) {
            return new ParseConditionResult(e.getMessage());
        }
    }

    public GenerateConditionResult generateCondition(Condition condition) {
        ConditionGenerator generator = new ConditionGenerator();
        try {
            return new GenerateConditionResult(generator.generateScript(condition));
        }
        catch (GenerateConditionException e) {
            return new GenerateConditionResult(null, e.getMessage());
        }
    }

    public TypeMetadataQueryResult findMetadata(TypeMetadataQuery query) {
        return this.findMetadata(query, this.resolveClassLoader(query.getPath()));
    }

    protected TypeMetadataQueryResult findMetadata(TypeMetadataQuery query, ClassLoader classLoader) {
        HashSet<TypeMetadata> typeMetadatas = new HashSet<TypeMetadata>();
        HashSet<String> missingTypes = new HashSet<String>();
        for (String type : query.getTypes()) {
            try {
                TypeMetadata typeMetadata = this.buildTypeMetadata(type, classLoader);
                typeMetadatas.add(typeMetadata);
            }
            catch (ClassNotFoundException e) {
                missingTypes.add(type);
            }
        }
        return new TypeMetadataQueryResult(typeMetadatas, missingTypes);
    }

    protected TypeMetadata buildTypeMetadata(String type, ClassLoader classLoader) throws ClassNotFoundException {
        GenerationTools generationTools = new GenerationTools();
        Class<?> clazz = classLoader.loadClass(type);
        ClassFieldInspector fieldInspector = new ClassFieldInspector(clazz);
        ArrayList<FieldMetadata> fields = new ArrayList<FieldMetadata>();
        for (String fieldName : fieldInspector.getFieldNames()) {
            ClassFieldInspector.FieldInfo fieldInfo = (ClassFieldInspector.FieldInfo)fieldInspector.getFieldTypesFieldInfo().get(fieldName);
            if (fieldInfo.getOrigin() != ModelField.FIELD_ORIGIN.DECLARED && fieldInfo.getOrigin() != ModelField.FIELD_ORIGIN.INHERITED) continue;
            String accessor = null;
            String mutator = null;
            if (fieldInfo.getAccessorAndMutator() == FieldAccessorsAndMutators.ACCESSOR || fieldInfo.getAccessorAndMutator() == FieldAccessorsAndMutators.BOTH) {
                accessor = generationTools.toJavaGetter(fieldName, fieldInfo.getReturnType().getName());
            }
            if (fieldInfo.getAccessorAndMutator() == FieldAccessorsAndMutators.MUTATOR || fieldInfo.getAccessorAndMutator() == FieldAccessorsAndMutators.BOTH) {
                mutator = generationTools.toJavaSetter(fieldName);
            }
            fields.add(new FieldMetadata(fieldName, fieldInfo.getReturnType().getName(), accessor, mutator));
        }
        return new TypeMetadata(type, fields);
    }

    protected abstract ClassLoader resolveClassLoader(Path var1);
}

