/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.project.backend.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.project.datamodel.oracle.ModuleDataModelOracle;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;
import org.kie.workbench.common.services.datamodel.backend.server.DataModelOracleUtilities;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.stunner.bpmn.project.service.DataTypesService;
import org.uberfire.backend.vfs.Path;

@Service
public class BPMNFindDataTypesProjectService
implements DataTypesService {
    private DataModelService dataModelService;

    protected BPMNFindDataTypesProjectService() {
        this(null);
    }

    @Inject
    public BPMNFindDataTypesProjectService(DataModelService dataModelService) {
        this.dataModelService = dataModelService;
    }

    public List<String> getDataTypeNames(Path path) {
        if (null == path) {
            return Collections.emptyList();
        }
        ArrayList<String> dataTypeNames = new ArrayList<String>();
        try {
            PackageDataModelOracle oracle = this.dataModelService.getDataModel(path);
            String[] fullyQualifiedClassNames = DataModelOracleUtilities.getFactTypes((ModuleDataModelOracle)oracle);
            dataTypeNames.addAll(Arrays.asList(fullyQualifiedClassNames));
            Collections.sort(dataTypeNames);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        return dataTypeNames;
    }
}

