/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.rules;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeTraverseCallback;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessor;

@DMNEditor
public class AcyclicDirectedGraphWalker
implements TreeWalkTraverseProcessor {
    private Graph graph;
    private TreeTraverseCallback<Graph, Node, Edge> callback;
    private Predicate<Node<?, Edge>> startNodePredicate = n -> n.getInEdges().isEmpty();
    private final Node<?, Edge> source;
    private final Node<?, Edge> target;
    private final Edge<?, Node> connector;

    public AcyclicDirectedGraphWalker() {
        this(null, null, null);
    }

    public AcyclicDirectedGraphWalker(Node<?, Edge> source, Node<?, Edge> target, Edge<?, Node> connector) {
        this.source = source;
        this.target = target;
        this.connector = connector;
    }

    public AcyclicDirectedGraphWalker useStartNodePredicate(Predicate<Node<?, Edge>> predicate) {
        this.startNodePredicate = predicate;
        return this;
    }

    public void traverse(Graph graph, Node node, TreeTraverseCallback<Graph, Node, Edge> callback) {
        this.startTraverse(graph, Optional.ofNullable(node), callback);
    }

    public void traverse(Graph graph, TreeTraverseCallback<Graph, Node, Edge> callback) {
        this.startTraverse(graph, Optional.empty(), callback);
    }

    private void startTraverse(Graph graph, Optional<Node<?, Edge>> node, TreeTraverseCallback<Graph, Node, Edge> callback) {
        assert (graph != null && callback != null);
        this.graph = graph;
        this.callback = callback;
        this.startGraphTraversal(node);
        this.endGraphTraversal();
        this.graph = null;
        this.callback = null;
    }

    private void startGraphTraversal(Optional<Node<?, Edge>> startNode) {
        this.callback.startGraphTraversal(this.graph);
        if (!startNode.isPresent()) {
            List<Node<?, Edge>> orderedGraphNodes = this.getStartingNodes();
            for (Node<?, Edge> node : orderedGraphNodes) {
                this.startNodeTraversal(node);
            }
        } else {
            this.startNodeTraversal(startNode.get());
        }
    }

    private void endGraphTraversal() {
        this.callback.endGraphTraversal();
    }

    private void startNodeTraversal(Node<?, Edge> node) {
        if (this.callback.startNodeTraversal(node)) {
            node.getOutEdges().forEach(this::startEdgeTraversal);
            if (node.equals(this.source)) {
                this.startEdgeTraversal(this.connector);
            }
            this.callback.endNodeTraversal(node);
        }
    }

    private void startEdgeTraversal(Edge edge) {
        if (this.callback.startEdgeTraversal(edge)) {
            if (edge.equals(this.connector)) {
                this.startNodeTraversal(this.target);
            } else {
                Node targetNode = edge.getTargetNode();
                if (Objects.nonNull(targetNode)) {
                    this.startNodeTraversal(targetNode);
                }
            }
        }
        this.endEdgeTraversal(edge);
    }

    private void endEdgeTraversal(Edge edge) {
        this.callback.endEdgeTraversal(edge);
    }

    private List<Node<?, Edge>> getStartingNodes() {
        Iterable nodes = this.graph.nodes();
        LinkedList result = new LinkedList();
        nodes.forEach(n -> {
            if (this.isStartingNode((Node)n)) {
                result.add((Node<?, Edge>)n);
            }
        });
        return result;
    }

    private boolean isStartingNode(Node node) {
        return null == node.getInEdges() || this.startNodePredicate.test(node);
    }
}

