/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ProxiedAuthorizationV2RequestControl;
import com.unboundid.ldap.sdk.examples.ModRate;
import com.unboundid.util.Debug;
import com.unboundid.util.FixedRateBarrier;
import com.unboundid.util.ResultCodeCounter;
import com.unboundid.util.ValuePattern;
import java.util.Random;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class ModRateThread
extends Thread {
    private final AtomicBoolean stopRequested;
    private final AtomicLong errorCounter;
    private final AtomicLong modCounter;
    private final AtomicLong modDurations;
    private final AtomicLong remainingIterationsBeforeReconnect;
    private final AtomicReference<ResultCode> resultCode;
    private final boolean increment;
    private final byte[] charSet;
    private final Control[] modifyControls;
    private final CyclicBarrier startBarrier;
    private final int incrementAmount;
    private final int valueCount;
    private final int valueLength;
    private LDAPConnection connection;
    private final long iterationsBeforeReconnect;
    private final ModRate modRate;
    private final ResultCodeCounter rcCounter;
    private final Random random;
    private final String[] attributes;
    private final AtomicReference<Thread> modThread;
    private final ValuePattern authzID;
    private final ValuePattern entryDN;
    private final FixedRateBarrier fixedRateBarrier;

    ModRateThread(ModRate modRate, int threadNumber, LDAPConnection connection, ValuePattern entryDN, String[] attributes, byte[] charSet, int valueLength, int valueCount, boolean increment, int incrementAmount, Control[] modifyControls, ValuePattern authzID, long randomSeed, long iterationsBeforeReconnect, CyclicBarrier startBarrier, AtomicLong modCounter, AtomicLong modDurations, AtomicLong errorCounter, ResultCodeCounter rcCounter, FixedRateBarrier rateBarrier) {
        this.setName("ModRate Thread " + threadNumber);
        this.setDaemon(true);
        this.modRate = modRate;
        this.connection = connection;
        this.entryDN = entryDN;
        this.attributes = attributes;
        this.charSet = charSet;
        this.valueLength = valueLength;
        this.valueCount = valueCount;
        this.increment = increment;
        this.incrementAmount = incrementAmount;
        this.modifyControls = modifyControls;
        this.authzID = authzID;
        this.iterationsBeforeReconnect = iterationsBeforeReconnect;
        this.modCounter = modCounter;
        this.modDurations = modDurations;
        this.errorCounter = errorCounter;
        this.rcCounter = rcCounter;
        this.startBarrier = startBarrier;
        this.fixedRateBarrier = rateBarrier;
        this.remainingIterationsBeforeReconnect = iterationsBeforeReconnect > 0L ? new AtomicLong(iterationsBeforeReconnect) : null;
        connection.setConnectionName("mod-" + threadNumber);
        this.resultCode = new AtomicReference<Object>(null);
        this.modThread = new AtomicReference<Object>(null);
        this.stopRequested = new AtomicBoolean(false);
        this.random = new Random(randomSeed);
    }

    public void run() {
        this.modThread.set(ModRateThread.currentThread());
        Modification[] mods = new Modification[this.attributes.length];
        byte[][] valueBytes = new byte[this.valueCount][this.valueLength];
        ASN1OctetString[] values = new ASN1OctetString[this.valueCount];
        if (this.increment) {
            valueBytes[0] = String.valueOf(this.incrementAmount).getBytes();
            values[0] = new ASN1OctetString(valueBytes[0]);
            for (int i = 0; i < this.attributes.length; ++i) {
                mods[i] = new Modification(ModificationType.INCREMENT, this.attributes[i], values);
            }
        }
        ModifyRequest modifyRequest = new ModifyRequest("", mods);
        try {
            this.startBarrier.await();
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        while (!this.stopRequested.get()) {
            long startTime;
            block19: {
                if (this.iterationsBeforeReconnect > 0L && this.remainingIterationsBeforeReconnect.decrementAndGet() <= 0L) {
                    this.remainingIterationsBeforeReconnect.set(this.iterationsBeforeReconnect);
                    if (this.connection != null) {
                        this.connection.close();
                        this.connection = null;
                    }
                }
                if (this.connection == null) {
                    try {
                        this.connection = this.modRate.getConnection();
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                        this.errorCounter.incrementAndGet();
                        ResultCode rc = le.getResultCode();
                        this.rcCounter.increment(rc);
                        this.resultCode.compareAndSet(null, rc);
                        if (this.fixedRateBarrier == null) continue;
                        this.fixedRateBarrier.await();
                        continue;
                    }
                }
                modifyRequest.setDN(this.entryDN.nextValue());
                if (!this.increment) {
                    int i;
                    for (i = 0; i < this.valueCount; ++i) {
                        for (int j = 0; j < this.valueLength; ++j) {
                            valueBytes[i][j] = this.charSet[this.random.nextInt(this.charSet.length)];
                        }
                        values[i] = new ASN1OctetString(valueBytes[i]);
                    }
                    for (i = 0; i < this.attributes.length; ++i) {
                        mods[i] = new Modification(ModificationType.REPLACE, this.attributes[i], values);
                    }
                    modifyRequest.setModifications(mods);
                }
                modifyRequest.setControls(this.modifyControls);
                if (this.authzID != null) {
                    modifyRequest.addControl(new ProxiedAuthorizationV2RequestControl(this.authzID.nextValue()));
                }
                if (this.fixedRateBarrier != null) {
                    this.fixedRateBarrier.await();
                }
                startTime = System.nanoTime();
                try {
                    this.connection.modify(modifyRequest);
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    this.errorCounter.incrementAndGet();
                    ResultCode rc = le.getResultCode();
                    this.rcCounter.increment(rc);
                    this.resultCode.compareAndSet(null, rc);
                    if (le.getResultCode().isConnectionUsable()) break block19;
                    this.connection.close();
                    this.connection = null;
                }
            }
            this.modCounter.incrementAndGet();
            this.modDurations.addAndGet(System.nanoTime() - startTime);
        }
        if (this.connection != null) {
            this.connection.close();
        }
        this.modThread.set(null);
    }

    public ResultCode stopRunning() {
        Thread t;
        this.stopRequested.set(true);
        if (this.fixedRateBarrier != null) {
            this.fixedRateBarrier.shutdownRequested();
        }
        if ((t = this.modThread.get()) != null) {
            try {
                t.join();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        this.resultCode.compareAndSet(null, ResultCode.SUCCESS);
        return this.resultCode.get();
    }
}

