/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.step01;

import java.util.HashSet;
import java.util.Objects;
import javax.enterprise.inject.Default;
import org.kie.workbench.common.stunner.core.graph.processing.layout.OrientedEdgeImpl;
import org.kie.workbench.common.stunner.core.graph.processing.layout.ReorderedGraph;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.LayeredGraph;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.OrientedEdge;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.step01.CycleBreaker;

@Default
public final class ReverseEdgesCycleBreaker
implements CycleBreaker {
    private LayeredGraph graph;
    private final HashSet<String> visitedVertices = new HashSet();

    public void breakCycle(ReorderedGraph graph) {
        this.graph = (LayeredGraph)graph;
        for (String vertex : this.graph.getVertices()) {
            this.visit(vertex);
        }
    }

    private boolean visit(String vertex) {
        String[] verticesFromThis;
        if (this.visitedVertices.contains(vertex)) {
            return false;
        }
        this.visitedVertices.add(vertex);
        for (String nextVertex : verticesFromThis = this.getVerticesFrom(vertex)) {
            OrientedEdge toReverse;
            if (this.visit(nextVertex) || (toReverse = (OrientedEdge)this.graph.getEdges().stream().filter(edge -> Objects.equals(edge.getFromVertexId(), vertex) && Objects.equals(edge.getToVertexId(), nextVertex)).findFirst().orElse(null)) == null) continue;
            this.graph.getEdges().remove(toReverse);
            OrientedEdgeImpl reversed = new OrientedEdgeImpl(toReverse.getToVertexId(), toReverse.getFromVertexId());
            this.graph.getEdges().add(reversed);
        }
        this.visitedVertices.remove(vertex);
        return true;
    }

    private String[] getVerticesFrom(String vertex) {
        HashSet<String> verticesFrom = new HashSet<String>();
        for (OrientedEdge edge : this.graph.getEdges()) {
            if (!Objects.equals(edge.getFromVertexId(), vertex)) continue;
            verticesFrom.add(edge.getToVertexId());
        }
        return verticesFrom.toArray(new String[0]);
    }
}

