/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.rule.handler.impl;

import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import org.kie.workbench.common.stunner.core.rule.RuleEvaluationHandler;
import org.kie.workbench.common.stunner.core.rule.RuleViolations;
import org.kie.workbench.common.stunner.core.rule.context.CardinalityContext;
import org.kie.workbench.common.stunner.core.rule.impl.Occurrences;
import org.kie.workbench.common.stunner.core.rule.violations.CardinalityMaxRuleViolation;
import org.kie.workbench.common.stunner.core.rule.violations.CardinalityMinRuleViolation;
import org.kie.workbench.common.stunner.core.rule.violations.DefaultRuleViolations;
import org.kie.workbench.common.stunner.core.validation.Violation;

@ApplicationScoped
public class CardinalityEvaluationHandler
implements RuleEvaluationHandler<Occurrences, CardinalityContext> {
    public Class<Occurrences> getRuleType() {
        return Occurrences.class;
    }

    public Class<CardinalityContext> getContextType() {
        return CardinalityContext.class;
    }

    public boolean accepts(Occurrences rule, CardinalityContext context) {
        return context.getRoles().contains(rule.getRole());
    }

    public RuleViolations evaluate(Occurrences rule, CardinalityContext context) {
        int count;
        Violation.Type type;
        DefaultRuleViolations results = new DefaultRuleViolations();
        int minOccurrences = rule.getMinOccurrences();
        int maxOccurrences = rule.getMaxOccurrences();
        int currentCount = context.getCurrentCount();
        int candidateCount = context.getCandidateCount();
        Optional operation = context.getOperation();
        Violation.Type type2 = type = operation.filter(arg_0 -> CardinalityContext.Operation.ADD.equals(arg_0)).isPresent() ? Violation.Type.ERROR : Violation.Type.WARNING;
        int n = !operation.isPresent() ? currentCount : (count = ((CardinalityContext.Operation)operation.get()).equals((Object)CardinalityContext.Operation.ADD) ? currentCount + candidateCount : currentCount - candidateCount);
        if (count < minOccurrences) {
            results.addViolation(new CardinalityMinRuleViolation(context.getRoles().toString(), minOccurrences, currentCount, type));
        } else if (maxOccurrences > -1 && count > maxOccurrences) {
            results.addViolation(new CardinalityMaxRuleViolation(context.getRoles().toString(), maxOccurrences, currentCount, type));
        }
        return results;
    }
}

