/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.forms.validation.timerEditor;

import com.google.gwt.regexp.shared.RegExp;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.kie.soup.commons.cron.CronExpression;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.timer.TimerSettingsValue;
import org.kie.workbench.common.stunner.bpmn.forms.validation.timerEditor.ValidTimerSettingsValue;

public class TimerSettingsValueValidator
implements ConstraintValidator<ValidTimerSettingsValue, TimerSettingsValue> {
    public static final String TimeDurationInvalid = "The timer duration must be a valid ISO-8601 duration or an expression like #{expression}.";
    public static final String ISOTimeCycleInvalid = "The timer cycle must be a valid ISO-8601 repetable interval or an expression like #{expression}.";
    public static final String CronTimeCycleInvalid = "The time cycle must be a valid cron interval or an expression like #{expression}.";
    public static final String TimeDateInvalid = "The timer date must be a valid ISO-8601 date time or an expression like #{expression}.";
    public static final String NoValueHasBeenProvided = "At least one field must have a non empty value.";
    public static final String ISO = "none";
    public static final String CRON = "cron";
    private static final String ISO_DURATION = "P(?:\\d+(?:\\.\\d+)?D)?(?:T(?:\\d+(?:\\.\\d+)?H)?(?:\\d+(?:\\.\\d+)?M)?(?:\\d+(?:\\.\\d+)?S)?)?";
    private static final String ISO_REPETABLE_INTERVAL = "(R\\d*\\/)P(?:\\d+(?:\\.\\d+)?D)?(?:T(?:\\d+(?:\\.\\d+)?H)?(?:\\d+(?:\\.\\d+)?M)?(?:\\d+(?:\\.\\d+)?S)?)?";
    private static final String ISO_DATE_TIME = "^([\\+-]?\\d{4}(?!\\d{2}\\b))(-)(0[1-9]|1[0-2])(-)(0[1-9]|1[0-9]|2[0-9]|3[0-1])T(0[0-9]|1[0-9]|2[0-4])(:)([0-5][0-9])(:)([0-5][0-9])(.[0-9][0-9][0-9])?(((\\+)(0[0-9]|1[0-5]))|((\\-)(0[0-9]|1[0-8]))):([0-5][0-9])$";
    private static final String CRON_INTERVAL = "(\\d+)?(\\d+?d)?(\\s)?(\\d+?h)?(\\s)?(\\d+?m)?(\\s)?(\\d+?s)?(\\s)?(\\d+?ms)?";
    private static final String EXPRESSION = "#{(.+)}";
    private static final RegExp durationExpr = RegExp.compile((String)"^P(?:\\d+(?:\\.\\d+)?D)?(?:T(?:\\d+(?:\\.\\d+)?H)?(?:\\d+(?:\\.\\d+)?M)?(?:\\d+(?:\\.\\d+)?S)?)?$");
    private static final RegExp repetableIntervalExpr = RegExp.compile((String)"^(R\\d*\\/)P(?:\\d+(?:\\.\\d+)?D)?(?:T(?:\\d+(?:\\.\\d+)?H)?(?:\\d+(?:\\.\\d+)?M)?(?:\\d+(?:\\.\\d+)?S)?)?$");
    private static final RegExp cronIntervalExpr = RegExp.compile((String)"^(\\d+)?(\\d+?d)?(\\s)?(\\d+?h)?(\\s)?(\\d+?m)?(\\s)?(\\d+?s)?(\\s)?(\\d+?ms)?$");
    private static final RegExp expressionExpr = RegExp.compile((String)"^#{(.+)}$");
    private static final RegExp dateTimeExpr = RegExp.compile((String)"^^([\\+-]?\\d{4}(?!\\d{2}\\b))(-)(0[1-9]|1[0-2])(-)(0[1-9]|1[0-9]|2[0-9]|3[0-1])T(0[0-9]|1[0-9]|2[0-4])(:)([0-5][0-9])(:)([0-5][0-9])(.[0-9][0-9][0-9])?(((\\+)(0[0-9]|1[0-5]))|((\\-)(0[0-9]|1[0-8]))):([0-5][0-9])$$");

    public void initialize(ValidTimerSettingsValue constraintAnnotation) {
    }

    public boolean isValid(TimerSettingsValue timerSettings, ConstraintValidatorContext constraintValidatorContext) {
        String errorMessage = null;
        if (timerSettings.getTimeDuration() != null) {
            String value = timerSettings.getTimeDuration();
            if (TimerSettingsValueValidator.looksLikeExpression(value) && !TimerSettingsValueValidator.isValidExpression(value) || !TimerSettingsValueValidator.looksLikeExpression(value) && !TimerSettingsValueValidator.isValidDuration(value)) {
                errorMessage = TimeDurationInvalid;
            }
        } else if (ISO.equals(timerSettings.getTimeCycleLanguage())) {
            String value = timerSettings.getTimeCycle();
            if (TimerSettingsValueValidator.looksLikeExpression(value) && !TimerSettingsValueValidator.isValidExpression(value) || !TimerSettingsValueValidator.looksLikeExpression(value) && !TimerSettingsValueValidator.isValidRepetableInterval(value)) {
                errorMessage = ISOTimeCycleInvalid;
            }
        } else if (CRON.equals(timerSettings.getTimeCycleLanguage())) {
            String value = timerSettings.getTimeCycle();
            if (TimerSettingsValueValidator.looksLikeExpression(value) && !TimerSettingsValueValidator.isValidExpression(value) || !TimerSettingsValueValidator.looksLikeExpression(value) && !TimerSettingsValueValidator.isValidCronExpression(value)) {
                errorMessage = CronTimeCycleInvalid;
            }
        } else if (timerSettings.getTimeDate() != null) {
            String value = timerSettings.getTimeDate();
            if (TimerSettingsValueValidator.looksLikeExpression(value) && !TimerSettingsValueValidator.isValidExpression(value) || !TimerSettingsValueValidator.looksLikeExpression(value) && !TimerSettingsValueValidator.isValidTimeDate(value)) {
                errorMessage = TimeDateInvalid;
            }
        } else {
            errorMessage = NoValueHasBeenProvided;
        }
        if (errorMessage != null) {
            constraintValidatorContext.disableDefaultConstraintViolation();
            constraintValidatorContext.buildConstraintViolationWithTemplate(errorMessage).addConstraintViolation();
            return false;
        }
        return true;
    }

    private static boolean looksLikeExpression(String value) {
        return TimerSettingsValueValidator.hasSomething(value) && (value.startsWith("#{") || value.contains("{") || value.contains("}"));
    }

    private static boolean isValidExpression(String value) {
        return TimerSettingsValueValidator.hasSomething(value) && expressionExpr.test(value) && value.length() > 3;
    }

    private static boolean isValidDuration(String value) {
        return TimerSettingsValueValidator.hasSomething(value) && durationExpr.test(value);
    }

    private static boolean isValidRepetableInterval(String value) {
        return TimerSettingsValueValidator.hasSomething(value) && repetableIntervalExpr.test(value);
    }

    private static boolean isValidCronExpression(String value) {
        return TimerSettingsValueValidator.isValidBPMNCronExpression(value) || TimerSettingsValueValidator.isValidQuartzExpression(value);
    }

    private static boolean isValidBPMNCronExpression(String value) {
        return TimerSettingsValueValidator.hasSomething(value) && cronIntervalExpr.test(value) && !value.endsWith(" ");
    }

    private static boolean isValidQuartzExpression(String value) {
        return TimerSettingsValueValidator.hasSomething(value) && CronExpression.isValidExpression((String)value);
    }

    private static boolean isValidTimeDate(String value) {
        return TimerSettingsValueValidator.hasSomething(value) && dateTimeExpr.test(value);
    }

    private static boolean hasSomething(String value) {
        return value != null && !value.trim().isEmpty();
    }
}

