/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.definition.adapter.binding;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionId;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableDefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.property.PropertyMetaTypes;
import org.kie.workbench.common.stunner.core.factory.graph.ElementFactory;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

public abstract class AbstractBindableDefinitionAdapter<T>
implements BindableDefinitionAdapter<T> {
    protected DefinitionUtils definitionUtils;
    protected Map<PropertyMetaTypes, Class> metaPropertyTypeClasses;
    protected Map<Class, Class> baseTypes;
    protected Map<Class, Set<String>> propertySetsFieldNames;
    protected Map<Class, Set<String>> propertiesFieldNames;
    protected Map<Class, Class> propertyGraphFactoryFieldNames;
    protected Map<Class, String> propertyIdFieldNames;
    protected Map<Class, String> propertyLabelsFieldNames;
    protected Map<Class, String> propertyTitleFieldNames;
    protected Map<Class, String> propertyCategoryFieldNames;
    protected Map<Class, String> propertyDescriptionFieldNames;
    protected Map<Class, String> propertyNameFields;

    public AbstractBindableDefinitionAdapter(DefinitionUtils definitionUtils) {
        this.definitionUtils = definitionUtils;
    }

    protected abstract Set<?> getBindProperties(T var1);

    public void setBindings(Map<PropertyMetaTypes, Class> metaPropertyTypeClasses, Map<Class, Class> baseTypes, Map<Class, Set<String>> propertySetsFieldNames, Map<Class, Set<String>> propertiesFieldNames, Map<Class, Class> propertyGraphFactoryFieldNames, Map<Class, String> propertyIdFieldNames, Map<Class, String> propertyLabelsFieldNames, Map<Class, String> propertyTitleFieldNames, Map<Class, String> propertyCategoryFieldNames, Map<Class, String> propertyDescriptionFieldNames, Map<Class, String> propertyNameFields) {
        this.metaPropertyTypeClasses = metaPropertyTypeClasses;
        this.baseTypes = baseTypes;
        this.propertySetsFieldNames = propertySetsFieldNames;
        this.propertiesFieldNames = propertiesFieldNames;
        this.propertyGraphFactoryFieldNames = propertyGraphFactoryFieldNames;
        this.propertyIdFieldNames = propertyIdFieldNames;
        this.propertyLabelsFieldNames = propertyLabelsFieldNames;
        this.propertyTitleFieldNames = propertyTitleFieldNames;
        this.propertyCategoryFieldNames = propertyCategoryFieldNames;
        this.propertyDescriptionFieldNames = propertyDescriptionFieldNames;
        this.propertyNameFields = propertyNameFields;
    }

    protected abstract String getStringFieldValue(T var1, String var2);

    public DefinitionId getId(T pojo) {
        String fieldId = this.getIdField(pojo);
        String definitionId = this.getDefinitionId(pojo.getClass());
        if (null != fieldId) {
            String id = BindableAdapterUtils.getDynamicDefinitionId((String)definitionId, (String)this.getStringFieldValue(pojo, fieldId));
            return DefinitionId.build((String)id, (int)definitionId.length());
        }
        return DefinitionId.build((String)definitionId);
    }

    public String getBaseType(Class<?> type) {
        Class baseType = this.baseTypes.get(type);
        if (null != baseType) {
            return this.getDefinitionId(baseType);
        }
        return null;
    }

    public String[] getTypes(String baseType) {
        LinkedList<String> result = new LinkedList<String>();
        for (Map.Entry<Class, Class> entry : this.baseTypes.entrySet()) {
            Class type = entry.getKey();
            Class _baseType = entry.getValue();
            String _id = this.getDefinitionId(_baseType);
            if (!baseType.equals(_id)) continue;
            result.add(this.getDefinitionId(type));
        }
        if (!result.isEmpty()) {
            return result.toArray(new String[result.size()]);
        }
        return null;
    }

    public Object getMetaProperty(PropertyMetaTypes metaPropertyType, T pojo) {
        Set<?> properties;
        Class pClass = this.metaPropertyTypeClasses.get(metaPropertyType);
        if (null != pClass && null != (properties = this.getProperties(pojo))) {
            return properties.stream().filter(property -> pClass.equals(property.getClass())).findFirst().orElse(null);
        }
        return null;
    }

    public Set<?> getProperties(T pojo) {
        Set<?> bindProperties;
        HashSet result = new HashSet();
        Set<?> propertySetProperties = this.definitionUtils.getPropertiesFromPropertySets(pojo);
        if (null != propertySetProperties) {
            result.addAll(propertySetProperties);
        }
        if (null != (bindProperties = this.getBindProperties(pojo)) && !bindProperties.isEmpty()) {
            result.addAll(bindProperties);
        }
        return result;
    }

    public Class<? extends ElementFactory> getGraphFactoryType(T pojo) {
        return this.getGraphFactory(pojo.getClass());
    }

    public Class<? extends ElementFactory> getGraphFactory(Class<?> type) {
        return this.getPropertyGraphFactoryFieldNames().get(type);
    }

    public boolean accepts(Class<?> type) {
        boolean hasType = this.getPropertyCategoryFieldNames().containsKey(type);
        return hasType || this.baseTypes.values().contains(type);
    }

    public int getPriority() {
        return 0;
    }

    protected Map<Class, Set<String>> getPropertySetsFieldNames() {
        return this.propertySetsFieldNames;
    }

    protected Map<Class, Set<String>> getPropertiesFieldNames() {
        return this.propertiesFieldNames;
    }

    protected Map<Class, Class> getPropertyGraphFactoryFieldNames() {
        return this.propertyGraphFactoryFieldNames;
    }

    protected Map<Class, String> getPropertyIdFieldNames() {
        return this.propertyIdFieldNames;
    }

    protected Map<Class, String> getPropertyLabelsFieldNames() {
        return this.propertyLabelsFieldNames;
    }

    protected Map<Class, String> getPropertyTitleFieldNames() {
        return this.propertyTitleFieldNames;
    }

    protected Map<Class, String> getPropertyCategoryFieldNames() {
        return this.propertyCategoryFieldNames;
    }

    protected Map<Class, String> getPropertyDescriptionFieldNames() {
        return this.propertyDescriptionFieldNames;
    }

    protected String getDefinitionId(Class<?> type) {
        return BindableAdapterUtils.getDefinitionId(type);
    }

    private String getIdField(T pojo) {
        return this.getPropertyIdFieldNames().get(pojo.getClass());
    }
}

