/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.processing.traverse.content;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Parent;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.FullContentTraverseCallback;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.FullContentTraverseProcessor;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeTraverseCallback;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessor;

@Dependent
public final class FullContentTraverseProcessorImpl
implements FullContentTraverseProcessor {
    TreeWalkTraverseProcessor treeWalkTraverseProcessor;

    @Inject
    public FullContentTraverseProcessorImpl(TreeWalkTraverseProcessor treeWalkTraverseProcessor) {
        this.treeWalkTraverseProcessor = treeWalkTraverseProcessor;
    }

    public void traverse(Graph<View, Node<View, Edge>> graph, final FullContentTraverseCallback<Node<View, Edge>, Edge<Object, Node>> callback) {
        this.treeWalkTraverseProcessor.traverse(graph, (Object)new TreeTraverseCallback<Graph, Node, Edge>(){

            public void startGraphTraversal(Graph graph) {
                if (graph.getContent() instanceof DefinitionSet) {
                    callback.startGraphTraversal(graph);
                }
            }

            public boolean startNodeTraversal(Node node) {
                if (node.getContent() instanceof View) {
                    callback.startNodeTraversal(node);
                    return true;
                }
                return false;
            }

            public boolean startEdgeTraversal(Edge edge) {
                if (edge.getContent() instanceof View) {
                    callback.startViewEdgeTraversal(edge);
                } else if (edge.getContent() instanceof Child) {
                    callback.startChildEdgeTraversal(edge);
                } else if (edge.getContent() instanceof Parent) {
                    callback.startParentEdgeTraversal(edge);
                } else {
                    callback.startEdgeTraversal(edge);
                }
                return true;
            }

            public void endNodeTraversal(Node node) {
                if (node.getContent() instanceof View) {
                    callback.endNodeTraversal(node);
                }
            }

            public void endEdgeTraversal(Edge edge) {
                if (edge.getContent() instanceof View) {
                    callback.endViewEdgeTraversal(edge);
                } else if (edge.getContent() instanceof Child) {
                    callback.endChildEdgeTraversal(edge);
                } else if (edge.getContent() instanceof Parent) {
                    callback.endParentEdgeTraversal(edge);
                } else {
                    callback.endEdgeTraversal(edge);
                }
            }

            public void endGraphTraversal() {
                callback.endGraphTraversal();
            }
        });
    }
}

