/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Documentation;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.InputOutputSpecification;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.Property;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.UserTask;
import org.eclipse.emf.ecore.impl.EStructuralFeatureImpl;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.jboss.drools.MetaDataType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.BPMNDefinitionSet;
import org.kie.workbench.common.stunner.bpmn.BPMNTestDefinitionFactory;
import org.kie.workbench.common.stunner.bpmn.WorkItemDefinitionMockRegistry;
import org.kie.workbench.common.stunner.bpmn.backend.BPMNDirectDiagramMarshaller;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.DeclarationList;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.ParsedAssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.VariableDeclaration;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.DefinitionsConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.BasePropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.Assertions;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.Unmarshalling;
import org.kie.workbench.common.stunner.bpmn.definition.AdHocSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.Association;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDiagram;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDiagramImpl;
import org.kie.workbench.common.stunner.bpmn.definition.BusinessRuleTask;
import org.kie.workbench.common.stunner.bpmn.definition.EmbeddedSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.EndCompensationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.EndErrorEvent;
import org.kie.workbench.common.stunner.bpmn.definition.EndEscalationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.EndMessageEvent;
import org.kie.workbench.common.stunner.bpmn.definition.EndNoneEvent;
import org.kie.workbench.common.stunner.bpmn.definition.EndSignalEvent;
import org.kie.workbench.common.stunner.bpmn.definition.EndTerminateEvent;
import org.kie.workbench.common.stunner.bpmn.definition.EventGateway;
import org.kie.workbench.common.stunner.bpmn.definition.EventSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.ExclusiveGateway;
import org.kie.workbench.common.stunner.bpmn.definition.GenericServiceTask;
import org.kie.workbench.common.stunner.bpmn.definition.InclusiveGateway;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateCompensationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateCompensationEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateConditionalEvent;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateErrorEventCatching;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateEscalationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateEscalationEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateMessageEventCatching;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateMessageEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateSignalEventCatching;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateSignalEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateTimerEvent;
import org.kie.workbench.common.stunner.bpmn.definition.Lane;
import org.kie.workbench.common.stunner.bpmn.definition.MultipleInstanceSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.NoneTask;
import org.kie.workbench.common.stunner.bpmn.definition.ReusableSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.ScriptTask;
import org.kie.workbench.common.stunner.bpmn.definition.SequenceFlow;
import org.kie.workbench.common.stunner.bpmn.definition.StartCompensationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.StartConditionalEvent;
import org.kie.workbench.common.stunner.bpmn.definition.StartErrorEvent;
import org.kie.workbench.common.stunner.bpmn.definition.StartEscalationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.StartMessageEvent;
import org.kie.workbench.common.stunner.bpmn.definition.StartNoneEvent;
import org.kie.workbench.common.stunner.bpmn.definition.StartSignalEvent;
import org.kie.workbench.common.stunner.bpmn.definition.StartTimerEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.DiagramSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.GlobalVariables;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.IsInterrupting;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.error.InterruptingErrorEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.message.MessageRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.SignalRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.timer.CancellingTimerEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.timer.TimerSettings;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.notification.NotificationValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.notification.NotificationsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.reassignment.ReassignmentValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.reassignment.ReassignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.service.GenericServiceTaskValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.SimulationSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.AdHocSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ReusableSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.TaskTypes;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.UserTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData;
import org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessVariables;
import org.kie.workbench.common.stunner.bpmn.workitem.ServiceTask;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinitionRegistry;
import org.kie.workbench.common.stunner.bpmn.workitem.service.WorkItemDefinitionLookupService;
import org.kie.workbench.common.stunner.core.StunnerTestingGraphAPI;
import org.kie.workbench.common.stunner.core.backend.StunnerTestingGraphBackendAPI;
import org.kie.workbench.common.stunner.core.backend.service.XMLEncoderDiagramMetadataMarshaller;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.factory.definition.TypeDefinitionFactory;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bound;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Dock;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.DiscreteConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnectorImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class BPMNDirectDiagramMarshallerTest {
    private static final String PATH_DIAGRAM = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram";
    private static final String BPMN_MANUAL_TASK = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/unsupported/manualTask.bpmn";
    private static final String BPMN_SEND_TASK = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/unsupported/sendTask.bpmn";
    private static final String BPMN_RECEIVED_TASK = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/unsupported/receivedTask.bpmn";
    private static final String BPMN_CHILDLANESET = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/unsupported/4.6.10.10_P1_v3.bpmn";
    private static final String EXECUTION = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/unsupported/Execution.bpmn";
    private static final String BPMN_DATASTORE = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/unsupported/TestDataStore.bpmn";
    private static final String JBPM_DESIGNER_ALL_ELEMENTS = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/unsupported/jbpmDesigner1.bpmn";
    private static final String BPMN_DATAOBJECT = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/unsupported/dataObject1.bpmn";
    private static final String BPMN_BASIC = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/basic.bpmn";
    private static final String BPMN_EVALUATION = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/evaluation.bpmn";
    private static final String BPMN_LANES = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/lanes.bpmn";
    private static final String BPMN_BOUNDARY_EVENTS = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/boundaryIntmEvent.bpmn";
    private static final String BPMN_NOT_BOUNDARY_EVENTS = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/notBoundaryIntmEvent.bpmn";
    private static final String BPMN_PROCESSVARIABLES = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/processVariables.bpmn";
    private static final String BPMN_GLOBALVARIABLES = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/globalVariables.bpmn";
    private static final String BPMN_USERTASKASSIGNMENTS = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/userTaskAssignments.bpmn";
    private static final String BPMN_USERTASK_MI = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/userTaskMI.bpmn";
    private static final String BPMN_BUSINESSRULETASKASSIGNMENTS = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/businessRuleTaskAssignments.bpmn";
    private static final String BPMN_STARTNONEEVENT = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/startNoneEvent.bpmn";
    private static final String BPMN_STARTTIMEREVENT = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/startTimerEvent.bpmn";
    private static final String BPMN_STARTSIGNALEVENT = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/startSignalEvent.bpmn";
    private static final String BPMN_STARTMESSAGEEVENT = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/startMessageEvent.bpmn";
    private static final String BPMN_STARTERROREVENT = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/startErrorEvent.bpmn";
    private static final String BPMN_STARTCONDITIONALEVENT = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/startConditionalEvent.bpmn";
    private static final String BPMN_STARTESCALATIONEVENT = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/startEscalationEvent.bpmn";
    private static final String BPMN_STARTCOMPENSATIONEVENT = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/startCompensationEvent.bpmn";
    private static final String BPMN_INTERMEDIATE_SIGNAL_EVENTCATCHING = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/intermediateSignalEventCatching.bpmn";
    private static final String BPMN_INTERMEDIATE_ERROR_EVENTCATCHING = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/intermediateErrorEventCatching.bpmn";
    private static final String BPMN_INTERMEDIATE_SIGNAL_EVENTTHROWING = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/intermediateSignalEventThrowing.bpmn";
    private static final String BPMN_INTERMEDIATE_MESSAGE_EVENTCATCHING = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/intermediateMessageEventCatching.bpmn";
    private static final String BPMN_INTERMEDIATE_MESSAGE_EVENTTHROWING = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/intermediateMessageEventThrowing.bpmn";
    private static final String BPMN_INTERMEDIATE_TIMER_EVENT = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/intermediateTimerEvent.bpmn";
    private static final String BPMN_INTERMEDIATE_CONDITIONAL_EVENTS = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/intermediateConditionalEvents.bpmn";
    private static final String BPMN_INTERMEDIATE_ESCALATION_EVENTS = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/intermediateEscalationEvents.bpmn";
    private static final String BPMN_INTERMEDIATE_COMPENSATION_EVENTS = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/intermediateCompensationEvents.bpmn";
    private static final String BPMN_INTERMEDIATE_COMPENSATION_EVENTS_WITH_ASSOCIATION = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/intermediateCompensationEventsWithAssociation.bpmn";
    private static final String BPMN_INTERMEDIATE_ESCALATION_EVENTTHROWING = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/intermediateEscalationEventThrowing.bpmn";
    private static final String BPMN_INTERMEDIATE_COMPENSATION_EVENTTHROWING = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/intermediateCompensationEventThrowing.bpmn";
    private static final String BPMN_ENDSIGNALEVENT = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/endSignalEvent.bpmn";
    private static final String BPMN_ENDMESSAGEEVENT = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/endMessageEvent.bpmn";
    private static final String BPMN_ENDNONEEVENT = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/endNoneEvent.bpmn";
    private static final String BPMN_ENDTERMINATEEVENT = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/endTerminateEvent.bpmn";
    private static final String BPMN_ENDESCALATIONEVENT = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/endEscalationEvent.bpmn";
    private static final String BPMN_ENDCOMPENSATIONEVENT = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/endCompensationEvent.bpmn";
    private static final String BPMN_PROCESSPROPERTIES = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/processProperties.bpmn";
    private static final String BPMN_BUSINESSRULETASKRULEFLOWGROUP = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/businessRuleTask.bpmn";
    private static final String BPMN_EVENT_SUBPROCESS_STARTERROREVENT = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/isInterruptingStartErrorEvent.bpmn";
    private static final String BPMN_REUSABLE_SUBPROCESS = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/reusableSubprocessCalledElement.bpmn";
    private static final String BPMN_REUSABLE_SUBPROCESS_MI = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/reusableSubProcessMI.bpmn";
    private static final String BPMN_EMBEDDED_SUBPROCESS = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/embeddedSubprocess.bpmn";
    private static final String BPMN_EVENT_SUBPROCESS = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/eventSubprocess.bpmn";
    private static final String BPMN_ADHOC_SUBPROCESS = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/adHocSubProcess.bpmn";
    private static final String BPMN_MULTIPLE_INSTANCE_SUBPROCESS = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/multipleInstanceSubprocess.bpmn";
    private static final String BPMN_SCRIPTTASK = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/scriptTask.bpmn";
    private static final String BPMN_USERTASKASSIGNEES = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/userTaskAssignees.bpmn";
    private static final String BPMN_USERTASKPROPERTIES = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/userTaskProperties.bpmn";
    private static final String BPMN_SEQUENCEFLOW = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/sequenceFlow.bpmn";
    private static final String BPMN_XORGATEWAY = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/xorGateway.bpmn";
    private static final String BPMN_INCLUSIVE_GATEWAY = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/inclusiveGateway.bpmn";
    private static final String BPMN_TIMER_EVENT = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/timerEvent.bpmn";
    private static final String BPMN_SIMULATIONPROPERTIES = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/simulationProperties.bpmn";
    private static final String BPMN_MAGNETDOCKERS = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/magnetDockers.bpmn";
    private static final String BPMN_MAGNETSINLANE = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/magnetsInLane.bpmn";
    private static final String BPMN_ENDERROR_EVENT = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/endErrorEvent.bpmn";
    private static final String BPMN_EVENT_DEFINITION_REF = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/eventDefinitionRef.bpmn";
    private static final String BPMN_SERVICE_TASKS = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/serviceTasks.bpmn";
    private static final String BPMN_NESTED_SUBPROCESSES = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/nestedSubprocesses.bpmn";
    private static final String BPMN_REASSIGNMENT_NOTIFICATION = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/reassignmentAndNotification.bpmn";
    private static final String BPMN_ARIS_LANES_1 = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/aris/ARIS_LANES_1.bpmn";
    private static final String BPMN_ARIS_LANES_2 = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/aris/ARIS_LANES_2.bpmn";
    private static final String BPMN_ARIS_LANES_3 = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/aris/ARIS_LANES_3.bpmn";
    private static final String ARIS_MULTIPLE_COLLAPSED_SUBPROCESSES = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/aris/ARIS_MULTIPLE_COLLAPSED_SUBPROCESSES.bpmn";
    private static final String ARIS_NESTED_COLLAPSED_SUBPROCESSES = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/aris/ARIS_NESTED_COLLAPSED_SUBPROCESES.bpmn";
    private static final String ARIS_COLLAPSED_SUBPROCESS_IN_LANE = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/aris/ARIS_COLLAPSED_SUBPROCESS_IN_LANE.bpmn";
    private static final String BPMN_LOG_TASK_JBPM_DESIGNER = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/logtask.bpmn";
    private static final String BPMN_SERVICETASKS_JBPM_DESIGNER = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/serviceTasksJBPMDeginer.bpmn";
    private static final String BPMN_EVENT_GATEWAY = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/eventGateway.bpmn";
    private static final String BPMN_TRAVELS = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/travels.bpmn";
    private static final String BPMN_FLIGHT_BOOKING = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/flightBooking.bpmn";
    private static final String NEW_LINE = System.lineSeparator();
    private StunnerTestingGraphAPI stunnerAPI;
    private XMLEncoderDiagramMetadataMarshaller xmlEncoder;
    private WorkItemDefinitionRegistry widRegistry;
    private WorkItemDefinitionLookupService widService;
    private BPMNDirectDiagramMarshaller tested;

    @Before
    public void setup() throws Exception {
        this.widRegistry = new WorkItemDefinitionMockRegistry();
        this.widService = (WorkItemDefinitionLookupService)Mockito.mock(WorkItemDefinitionLookupService.class);
        Mockito.when((Object)this.widService.execute(Matchers.any(Metadata.class))).thenReturn((Object)this.widRegistry.items());
        this.stunnerAPI = StunnerTestingGraphBackendAPI.build(BPMNDefinitionSet.class, (TypeDefinitionFactory)new BPMNTestDefinitionFactory(this.widRegistry));
        this.xmlEncoder = new XMLEncoderDiagramMetadataMarshaller();
        this.tested = new BPMNDirectDiagramMarshaller(this.xmlEncoder, this.stunnerAPI.getDefinitionManager(), this.stunnerAPI.getRuleManager(), this.widService, this.stunnerAPI.getFactoryManager(), this.stunnerAPI.commandFactory, this.stunnerAPI.commandManager);
    }

    @Test
    public void testManualTask() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_MANUAL_TASK);
        String result = this.tested.marshall(diagram);
        String uuid = "_25DC90B5-E0BA-4D32-842E-DD11CE507B01";
        Node element = diagram.getGraph().getNode("_25DC90B5-E0BA-4D32-842E-DD11CE507B01");
        Assertions.assertDiagram(diagram, 4);
        Assert.assertTrue((boolean)(((Definition)element.getContent()).getDefinition() instanceof NoneTask));
        Assert.assertTrue((boolean)result.contains("<bpmn2:task id=\"$uuid\" name=\"manual\">".replace("$uuid", "_25DC90B5-E0BA-4D32-842E-DD11CE507B01")));
    }

    @Test
    public void testSendTask() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_SEND_TASK);
        String result = this.tested.marshall(diagram);
        String uuid = "_25DC90B5-E0BA-4D32-842E-DD11CE507B01";
        Node element = diagram.getGraph().getNode("_25DC90B5-E0BA-4D32-842E-DD11CE507B01");
        Assertions.assertDiagram(diagram, 4);
        Assert.assertTrue((boolean)(((Definition)element.getContent()).getDefinition() instanceof NoneTask));
        Assert.assertTrue((boolean)result.contains("<bpmn2:task id=\"$uuid\" name=\"send\">".replace("$uuid", "_25DC90B5-E0BA-4D32-842E-DD11CE507B01")));
    }

    @Test
    public void testReceiveTask() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_RECEIVED_TASK);
        String result = this.tested.marshall(diagram);
        String uuid = "_25DC90B5-E0BA-4D32-842E-DD11CE507B01";
        Node element = diagram.getGraph().getNode("_25DC90B5-E0BA-4D32-842E-DD11CE507B01");
        Assertions.assertDiagram(diagram, 4);
        Assert.assertTrue((boolean)(((Definition)element.getContent()).getDefinition() instanceof NoneTask));
        Assert.assertTrue((boolean)result.contains("<bpmn2:task id=\"$uuid\" name=\"received\">".replace("$uuid", "_25DC90B5-E0BA-4D32-842E-DD11CE507B01")));
    }

    @Test
    public void testDataObject() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_DATAOBJECT);
        String result = this.tested.marshall(diagram);
        String uuid = "dataObject1";
        Node element = diagram.getGraph().getNode("dataObject1");
        Assert.assertNull((Object)element);
        Assertions.assertDiagram(diagram, 4);
        Assert.assertFalse((boolean)result.contains("<bpmn2:dataObject id=\"dataObject1\""));
    }

    @Test
    public void testDataStore() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_DATASTORE);
        String result = this.tested.marshall(diagram);
        String uuid = "ID-f701d630-7adb-11e9-74db-069646171c32";
        Node element = diagram.getGraph().getNode("ID-f701d630-7adb-11e9-74db-069646171c32");
        Assert.assertNull((Object)element);
        Assertions.assertDiagram(diagram, 2);
        Assert.assertFalse((boolean)result.contains("<semantic:dataStore name=\"Data store\" id=\"ID-f701d630-7adb-11e9-74db-069646171c32\"/>"));
    }

    @Test
    public void testChildLaneSet() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_CHILDLANESET);
        String result = this.tested.marshall(diagram);
        List<String> uudis = Arrays.asList("ID-d840fb6a-2566-11e9-4768-06332ceaf548", "ID-953d72f2-0f1d-11e7-62b5-d0bf9cf32000", "ID-bd86bfb8-3391-11e9-4932-0200a2035cb6");
        Assert.assertTrue((boolean)uudis.stream().map(arg_0 -> ((Graph)diagram.getGraph()).getNode(arg_0)).map(Element::getContent).map(Definition.class::cast).map(Definition::getDefinition).allMatch(Lane.class::isInstance));
        Assertions.assertDiagram(diagram, 63);
        Assert.assertTrue((boolean)uudis.stream().allMatch(uuid -> result.contains("<bpmn2:lane id=\"$uuid\"".replace("$uuid", (CharSequence)uuid))));
    }

    @Test
    public void testExecution() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(EXECUTION);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(diagram, 20);
    }

    @Test
    public void testJBPMAllElements() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(JBPM_DESIGNER_ALL_ELEMENTS);
        Assertions.assertDiagram(diagram, 68);
    }

    @Test
    public void testUnmarshallBasic() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_BASIC);
        Assertions.assertDiagram(diagram, 4);
        Assert.assertEquals((Object)"Basic process", (Object)diagram.getMetadata().getTitle());
        Node diagramNode = diagram.getGraph().getNode("_8nbnEfbPEeWV2qFDuocQ6Q");
        Assert.assertTrue((boolean)(((Definition)diagramNode.getContent()).getDefinition() instanceof BPMNDiagram));
        BPMNDiagramImpl bpmnDiagram = (BPMNDiagramImpl)((Definition)diagramNode.getContent()).getDefinition();
        Assert.assertTrue((bpmnDiagram.getDiagramSet() != null ? 1 : 0) != 0);
        Assert.assertTrue((bpmnDiagram.getDiagramSet().getExecutable() != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)bpmnDiagram.getDiagramSet().getExecutable().getValue());
        Node task1 = diagram.getGraph().getNode("810797AB-7D09-4E1F-8A5B-96C424E4B031");
        Assert.assertTrue((boolean)(((Definition)task1.getContent()).getDefinition() instanceof NoneTask));
    }

    @Test
    public void testUnmarshallLogTaskJBPMDesigner() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_LOG_TASK_JBPM_DESIGNER);
        Assertions.assertDiagram(diagram, 4);
        Node log = diagram.getGraph().getNode("_AE76ACC9-CCD0-425D-BD40-5E4F3533A1DF");
        Assert.assertTrue((boolean)(((Definition)log.getContent()).getDefinition() instanceof ServiceTask));
    }

    @Test
    public void testUnmarshallServiceTaskJBPMDesigner() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_SERVICETASKS_JBPM_DESIGNER);
        Assertions.assertDiagram(diagram, 9);
        Node email = diagram.getGraph().getNode("_2255B80D-ADCF-47C8-A16F-82E7BB9AD929");
        Node rest = diagram.getGraph().getNode("_D8B91719-0540-4A98-9734-CAF4C703B051");
        Node ws = diagram.getGraph().getNode("_FD3F17AB-199B-4A59-A8B4-CBDCCDBFF7DA");
        Node log = diagram.getGraph().getNode("_324A9674-039E-4B80-80EF-A9B6A44ACA33");
        Assert.assertTrue((boolean)(((Definition)email.getContent()).getDefinition() instanceof ServiceTask));
        Assert.assertTrue((boolean)(((Definition)rest.getContent()).getDefinition() instanceof ServiceTask));
        Assert.assertTrue((boolean)(((Definition)ws.getContent()).getDefinition() instanceof ServiceTask));
        Assert.assertTrue((boolean)(((Definition)log.getContent()).getDefinition() instanceof ServiceTask));
    }

    @Test
    public void testUnmarshallEvaluation() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_EVALUATION);
        Assertions.assertDiagram(diagram, 8);
        Assert.assertEquals((Object)"Evaluation", (Object)diagram.getMetadata().getTitle());
        Node task1 = diagram.getGraph().getNode("_88233779-B395-4B8C-A086-9EF43698426C");
        Node task2 = diagram.getGraph().getNode("_AE5BF0DC-B720-4FDE-9499-5ED89D41FB1A");
        Node task3 = diagram.getGraph().getNode("_6063D302-9D81-4C86-920B-E808A45377C2");
        Assert.assertTrue((boolean)(((View)task1.getContent()).getDefinition() instanceof org.kie.workbench.common.stunner.bpmn.definition.UserTask));
        Assert.assertTrue((boolean)(((View)task2.getContent()).getDefinition() instanceof org.kie.workbench.common.stunner.bpmn.definition.UserTask));
        Assert.assertTrue((boolean)(((View)task3.getContent()).getDefinition() instanceof org.kie.workbench.common.stunner.bpmn.definition.UserTask));
        Bounds task1Bounds = ((View)task1.getContent()).getBounds();
        Bound task1ULBound = task1Bounds.getUpperLeft();
        Bound task1LRBound = task1Bounds.getLowerRight();
        Assert.assertEquals((double)648.0, (double)task1ULBound.getX(), (double)0.0);
        Assert.assertEquals((double)149.0, (double)task1ULBound.getY(), (double)0.0);
        Assert.assertEquals((double)784.0, (double)task1LRBound.getX(), (double)0.0);
        Assert.assertEquals((double)197.0, (double)task1LRBound.getY(), (double)0.0);
    }

    @Test
    public void testUnmarshallFlightBooking() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_FLIGHT_BOOKING);
        Node serviceTask1Node = diagram.getGraph().getNode("ServiceTask_1");
        GenericServiceTask serviceTask1 = (GenericServiceTask)((View)serviceTask1Node.getContent()).getDefinition();
        GenericServiceTaskValue serviceTaskValue = serviceTask1.getExecutionSet().getGenericServiceTaskInfo().getValue();
        Assert.assertEquals((Object)"Java", (Object)serviceTaskValue.getServiceImplementation());
        Assert.assertEquals((Object)"org.acme.travels.service.FlightBookingService", (Object)serviceTaskValue.getServiceInterface());
        Assert.assertEquals((Object)"bookFlight", (Object)serviceTaskValue.getServiceOperation());
        Assert.assertEquals((Object)"org.acme.travels.Trip", (Object)serviceTaskValue.getInMessageStructure());
        Assert.assertEquals((Object)"org.acme.travels.Flight", (Object)serviceTaskValue.getOutMessagetructure());
        String marshalled = this.tested.marshall(diagram);
        Assert.assertTrue((boolean)marshalled.contains("<bpmn2:itemDefinition id=\"ServiceTask_1_InMessageType\" structureRef=\"org.acme.travels.Trip\"/>"));
        Assert.assertTrue((boolean)marshalled.contains("<bpmn2:itemDefinition id=\"ServiceTask_1_OutMessageType\" structureRef=\"org.acme.travels.Flight\"/>"));
    }

    @Test
    public void testUnmarshallTravels() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_TRAVELS);
        Node userTask1Node = diagram.getGraph().getNode("UserTask_1");
        org.kie.workbench.common.stunner.bpmn.definition.UserTask userTask1 = (org.kie.workbench.common.stunner.bpmn.definition.UserTask)((View)userTask1Node.getContent()).getDefinition();
        ParsedAssignmentsInfo parsedAssignmentsInfo = ParsedAssignmentsInfo.fromString((String)userTask1.getExecutionSet().getAssignmentsinfo().getValue());
        this.assertDataTye("org.acme.travels.Trip", "trip", parsedAssignmentsInfo.getInputs());
        this.assertDataTye("org.acme.travels.Traveller", "traveller", parsedAssignmentsInfo.getInputs());
        this.assertDataTye("java.lang.Boolean", "Skippable", parsedAssignmentsInfo.getInputs());
        this.assertDataTye("java.lang.Integer", "Priority", parsedAssignmentsInfo.getInputs());
        this.assertDataTye("java.lang.String", "Comment", parsedAssignmentsInfo.getInputs());
        Node businessRuleTaskNode = diagram.getGraph().getNode("BusinessRuleTask_1");
        BusinessRuleTask businessRuleTask1 = (BusinessRuleTask)((View)businessRuleTaskNode.getContent()).getDefinition();
        ParsedAssignmentsInfo businessRuleParsedAssignmentsInfo = ParsedAssignmentsInfo.fromString((String)businessRuleTask1.getDataIOSet().getAssignmentsinfo().getValue());
        this.assertDataTye("org.acme.travels.Traveller", "traveller", businessRuleParsedAssignmentsInfo.getInputs());
        this.assertDataTye("org.acme.travels.Trip", "trip", businessRuleParsedAssignmentsInfo.getInputs());
        this.assertDataTye("org.acme.travels.Trip", "trip", businessRuleParsedAssignmentsInfo.getOutputs());
    }

    private void assertDataTye(String expectedType, String name, DeclarationList declarationList) {
        Assert.assertEquals((Object)expectedType, declarationList.getDeclarations().stream().filter(d -> Objects.equals(d.getIdentifier(), name)).map(VariableDeclaration::getType).findFirst().orElse(null));
    }

    @Test
    public void testUnmarshallProcessVariables() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_PROCESSVARIABLES);
        Assertions.assertDiagram(diagram, 8);
        Assert.assertEquals((Object)"ProcessVariables", (Object)diagram.getMetadata().getTitle());
        BPMNDiagramImpl bpmnDiagram = this.getBpmnDiagram(diagram);
        ProcessVariables variables = bpmnDiagram.getProcessData().getProcessVariables();
        Assert.assertEquals((Object)variables.getValue(), (Object)"employee:java.lang.String:[],reason:java.lang.String:[],performance:java.lang.String:[]");
        Node diagramNode = diagram.getGraph().getNode("_luRBMdEjEeWXpsZ1tNStKQ");
        Assert.assertTrue((boolean)(((Definition)diagramNode.getContent()).getDefinition() instanceof BPMNDiagram));
        bpmnDiagram = (BPMNDiagramImpl)((Definition)diagramNode.getContent()).getDefinition();
        Assert.assertTrue((bpmnDiagram.getProcessData() != null ? 1 : 0) != 0);
        Assert.assertTrue((bpmnDiagram.getProcessData().getProcessVariables() != null ? 1 : 0) != 0);
        variables = bpmnDiagram.getProcessData().getProcessVariables();
        Assert.assertEquals((Object)variables.getValue(), (Object)"employee:java.lang.String:[],reason:java.lang.String:[],performance:java.lang.String:[]");
    }

    @Test
    public void testUnmarshallGlobalVariables() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_GLOBALVARIABLES);
        Assertions.assertDiagram(diagram, 1);
        Assert.assertEquals((Object)"Global Variables", (Object)diagram.getMetadata().getTitle());
        BPMNDiagramImpl bpmnDiagram = this.getBpmnDiagram(diagram);
        GlobalVariables variables = bpmnDiagram.getAdvancedData().getGlobalVariables();
        Assert.assertEquals((Object)"GV1:Boolean,GV2:Boolean,GV3:Integer", (Object)variables.getValue());
        Node diagramNode = diagram.getGraph().getNode("__-CvwCveEemCffTTkSwXXQ");
        Assert.assertTrue((boolean)(((Definition)diagramNode.getContent()).getDefinition() instanceof BPMNDiagram));
        bpmnDiagram = (BPMNDiagramImpl)((Definition)diagramNode.getContent()).getDefinition();
        Assert.assertTrue((bpmnDiagram.getDiagramSet() != null ? 1 : 0) != 0);
        Assert.assertTrue((bpmnDiagram.getAdvancedData().getGlobalVariables() != null ? 1 : 0) != 0);
        variables = bpmnDiagram.getAdvancedData().getGlobalVariables();
        Assert.assertEquals((Object)"GV1:Boolean,GV2:Boolean,GV3:Integer", (Object)variables.getValue());
    }

    private BPMNDiagramImpl getBpmnDiagram(Diagram<Graph, Metadata> diagram) {
        BPMNDiagramImpl bpmnDiagram = null;
        Iterator<Element> it = this.nodesIterator(diagram);
        while (it.hasNext()) {
            Object oDefinition;
            Element element = it.next();
            if (!(element.getContent() instanceof View) || !((oDefinition = ((View)element.getContent()).getDefinition()) instanceof BPMNDiagram)) continue;
            bpmnDiagram = (BPMNDiagramImpl)oDefinition;
            break;
        }
        return bpmnDiagram;
    }

    @Test
    public void testUnmarshallProcessProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_PROCESSPROPERTIES);
        Assertions.assertDiagram(diagram, 4);
        Assert.assertEquals((Object)"BPSimple", (Object)diagram.getMetadata().getTitle());
        DiagramSet diagramProperties = null;
        Iterator<Element> it = this.nodesIterator(diagram);
        while (it.hasNext()) {
            Object oDefinition;
            Element element = it.next();
            if (!(element.getContent() instanceof View) || !((oDefinition = ((View)element.getContent()).getDefinition()) instanceof BPMNDiagram)) continue;
            BPMNDiagramImpl bpmnDiagram = (BPMNDiagramImpl)oDefinition;
            diagramProperties = bpmnDiagram.getDiagramSet();
            break;
        }
        Assert.assertEquals((Object)"BPSimple", (Object)diagramProperties.getName().getValue());
        Assert.assertEquals((Object)"This is a\nsimple\nprocess", (Object)diagramProperties.getDocumentation().getValue());
        Assert.assertEquals((Object)"JDLProj.BPSimple", (Object)diagramProperties.getId().getValue());
        Assert.assertEquals((Object)"org.jbpm", (Object)diagramProperties.getPackageProperty().getValue());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)diagramProperties.getExecutable().getValue());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)diagramProperties.getAdHoc().getValue());
        Assert.assertEquals((Object)"This is the\nProcess\nInstance\nDescription", (Object)diagramProperties.getProcessInstanceDescription().getValue());
        Assert.assertEquals((Object)"12/25/1983", (Object)diagramProperties.getSlaDueDate().getValue());
    }

    @Test
    public void testUnmarshallUserTaskAssignments() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_USERTASKASSIGNMENTS);
        Assertions.assertDiagram(diagram, 8);
        Assert.assertEquals((Object)"UserTaskAssignments", (Object)diagram.getMetadata().getTitle());
        Node selfEvaluationNode = diagram.getGraph().getNode("_6063D302-9D81-4C86-920B-E808A45377C2");
        org.kie.workbench.common.stunner.bpmn.definition.UserTask selfEvaluationTask = (org.kie.workbench.common.stunner.bpmn.definition.UserTask)((Definition)selfEvaluationNode.getContent()).getDefinition();
        Assert.assertEquals((Object)selfEvaluationTask.getTaskType().getValue(), (Object)TaskTypes.USER);
        UserTaskExecutionSet executionSet = selfEvaluationTask.getExecutionSet();
        AssignmentsInfo assignmentsinfo = executionSet.getAssignmentsinfo();
        Assert.assertEquals((Object)assignmentsinfo.getValue(), (Object)"|reason:com.test.Reason,Comment:Object,Skippable:Object||performance:Object|[din]reason->reason,[dout]performance->performance");
    }

    @Test
    public void testUnmarshallUserTaskMI() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_USERTASK_MI);
        Assertions.assertDiagram(diagram, 4);
        Assert.assertEquals((Object)"userTaskMI", (Object)diagram.getMetadata().getTitle());
        Node node = diagram.getGraph().getNode("_CACC5C21-CE79-4445-9411-BE8C7A75E860");
        Assert.assertNotNull((Object)node);
        org.kie.workbench.common.stunner.bpmn.definition.UserTask userTask = (org.kie.workbench.common.stunner.bpmn.definition.UserTask)((Definition)node.getContent()).getDefinition();
        Assert.assertNotNull((Object)userTask);
        Assert.assertEquals((Object)TaskTypes.USER, (Object)userTask.getTaskType().getValue());
        Assert.assertEquals((Object)"TheUserTask", (Object)userTask.getGeneral().getName().getValue());
        UserTaskExecutionSet executionSet = userTask.getExecutionSet();
        Assert.assertTrue((boolean)executionSet.getIsMultipleInstance().getValue());
        Assert.assertEquals((Object)"theInputCollection", (Object)executionSet.getMultipleInstanceCollectionInput().getValue());
        Assert.assertEquals((Object)"theInputVariable:java.lang.Object", (Object)executionSet.getMultipleInstanceDataInput().getValue());
        Assert.assertEquals((Object)"theOutputCollection", (Object)executionSet.getMultipleInstanceCollectionOutput().getValue());
        Assert.assertEquals((Object)"theOutputVariable:java.lang.Object", (Object)executionSet.getMultipleInstanceDataOutput().getValue());
        Assert.assertEquals((Object)"theCompletionCondition", (Object)executionSet.getMultipleInstanceCompletionCondition().getValue());
    }

    @Test
    public void testUnmarshallBusinessRuleTaskAssignments() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_BUSINESSRULETASKASSIGNMENTS);
        Assertions.assertDiagram(diagram, 4);
        Assert.assertEquals((Object)"BusinessRuleTaskAssignments", (Object)diagram.getMetadata().getTitle());
        Node businessRuleNode = diagram.getGraph().getNode("_45C2C340-D1D0-4D63-8419-EF38F9E73507");
        BusinessRuleTask businessRuleTask = (BusinessRuleTask)((Definition)businessRuleNode.getContent()).getDefinition();
        Assert.assertEquals((Object)businessRuleTask.getTaskType().getValue(), (Object)TaskTypes.BUSINESS_RULE);
        DataIOSet dataIOSet = businessRuleTask.getDataIOSet();
        AssignmentsInfo assignmentsinfo = dataIOSet.getAssignmentsinfo();
        Assert.assertEquals((Object)assignmentsinfo.getValue(), (Object)"|input1:String,input2:String||output1:String,output2:String|[din]pv1->input1,[din]pv2->input2,[dout]output1->pv2,[dout]output2->pv2");
    }

    @Test
    public void testUnmarshallStartNoneEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_STARTNONEEVENT);
        Assertions.assertDiagram(diagram, 4);
        Assert.assertEquals((Object)"startNoneEvent", (Object)diagram.getMetadata().getTitle());
        Node startNoneEventNode = diagram.getGraph().getNode("processStartEvent");
        StartNoneEvent startNoneEvent = (StartNoneEvent)((Definition)startNoneEventNode.getContent()).getDefinition();
        Assert.assertNotNull((Object)startNoneEvent.getGeneral());
        Assert.assertEquals((Object)"MyStartNoneEvent", (Object)startNoneEvent.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"MyStartNoneEventDocumentation", (Object)startNoneEvent.getGeneral().getDocumentation().getValue());
        Assert.assertEquals((Object)"12/25/1983", (Object)startNoneEvent.getExecutionSet().getSlaDueDate().getValue());
    }

    @Test
    public void testUnmarshallStartTimerEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_STARTTIMEREVENT);
        Assertions.assertDiagram(diagram, 4);
        Assert.assertEquals((Object)"StartTimerEvent", (Object)diagram.getMetadata().getTitle());
        Node startTimerEventNode = diagram.getGraph().getNode("_49ADC988-B63D-4AEB-B811-67969F305FD0");
        StartTimerEvent startTimerEvent = (StartTimerEvent)((Definition)startTimerEventNode.getContent()).getDefinition();
        IsInterrupting isInterrupting = startTimerEvent.getExecutionSet().getIsInterrupting();
        Assert.assertEquals((Object)false, (Object)isInterrupting.getValue());
        Assert.assertEquals((Object)"12/25/1983", (Object)startTimerEvent.getExecutionSet().getSlaDueDate().getValue());
    }

    @Test
    public void testUnmarshallStartSignalEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_STARTSIGNALEVENT);
        Assertions.assertDiagram(diagram, 4);
        Assert.assertEquals((Object)"StartSignalEvent", (Object)diagram.getMetadata().getTitle());
        Node startSignalEventNode = diagram.getGraph().getNode("_1876844A-4DAC-4214-8BCD-2ABA3FCC8EB5");
        StartSignalEvent startSignalEvent = (StartSignalEvent)((Definition)startSignalEventNode.getContent()).getDefinition();
        Assert.assertNotNull((Object)startSignalEvent.getExecutionSet());
        SignalRef signalRef = startSignalEvent.getExecutionSet().getSignalRef();
        Assert.assertEquals((Object)"sig1", (Object)signalRef.getValue());
        Assert.assertEquals((Object)"12/25/1983", (Object)startSignalEvent.getExecutionSet().getSlaDueDate().getValue());
    }

    @Test
    public void testUnmarshallStartErrorEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_STARTERROREVENT);
        Assertions.assertDiagram(diagram, 3);
        Assert.assertEquals((Object)"startErrorEventProcess", (Object)diagram.getMetadata().getTitle());
        Node startEventNode = diagram.getGraph().getNode("3BD5BBC8-F1C7-45DE-8BDF-A06D8464A61B");
        StartErrorEvent startErrorEvent = (StartErrorEvent)((Definition)startEventNode.getContent()).getDefinition();
        Assert.assertNotNull((Object)startErrorEvent.getGeneral());
        Assert.assertEquals((Object)"MyStartErrorEvent", (Object)startErrorEvent.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"MyStartErrorEventDocumentation", (Object)startErrorEvent.getGeneral().getDocumentation().getValue());
        Assert.assertNotNull((Object)startErrorEvent.getExecutionSet());
        Assert.assertNotNull((Object)startErrorEvent.getExecutionSet().getErrorRef());
        Assert.assertEquals((Object)"MyError", (Object)startErrorEvent.getExecutionSet().getErrorRef().getValue());
        Assert.assertEquals((Object)"12/25/1983", (Object)startErrorEvent.getExecutionSet().getSlaDueDate().getValue());
        DataIOSet dataIOSet = startErrorEvent.getDataIOSet();
        AssignmentsInfo assignmentsInfo = dataIOSet.getAssignmentsinfo();
        Assert.assertEquals((Object)"||errorOutput_:String||[dout]errorOutput_->var1", (Object)assignmentsInfo.getValue());
    }

    @Test
    public void testUnmarshallStartMessageEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_STARTMESSAGEEVENT);
        Assertions.assertDiagram(diagram, 2);
        Assert.assertEquals((Object)"StartMessageEvent", (Object)diagram.getMetadata().getTitle());
        Node startMessageEventNode = diagram.getGraph().getNode("_34C4BBFC-544F-4E23-B17B-547BB48EEB63");
        StartMessageEvent startMessageEvent = (StartMessageEvent)((Definition)startMessageEventNode.getContent()).getDefinition();
        Assert.assertNotNull((Object)startMessageEvent.getExecutionSet());
        MessageRef messageRef = startMessageEvent.getExecutionSet().getMessageRef();
        IsInterrupting isInterrupting = startMessageEvent.getExecutionSet().getIsInterrupting();
        Assert.assertEquals((Object)"msgref", (Object)messageRef.getValue());
        Assert.assertEquals((Object)true, (Object)isInterrupting.getValue());
        Assert.assertEquals((Object)"12/25/1983", (Object)startMessageEvent.getExecutionSet().getSlaDueDate().getValue());
        DataIOSet dataIOSet = startMessageEvent.getDataIOSet();
        AssignmentsInfo assignmentsInfo = dataIOSet.getAssignmentsinfo();
        Assert.assertEquals((Object)"||StartMessageEventOutputVar1:String||[dout]StartMessageEventOutputVar1->var1", (Object)assignmentsInfo.getValue());
    }

    @Test
    public void testUnmarshallStartConditionalEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_STARTCONDITIONALEVENT);
        Assertions.assertDiagram(diagram, 2);
        Assert.assertEquals((Object)"StartConditionalEvent", (Object)diagram.getMetadata().getTitle());
        Node startEventNode = diagram.getGraph().getNode("_8F9C10C4-F1EE-4B49-B4CE-3059ADD4B391");
        Assert.assertNotNull((Object)startEventNode);
        StartConditionalEvent startConditionalEvent = (StartConditionalEvent)((Definition)startEventNode.getContent()).getDefinition();
        Assert.assertNotNull((Object)startConditionalEvent.getGeneral());
        Assert.assertEquals((Object)"StartConditionalEventName", (Object)startConditionalEvent.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"StartConditionalEventDocumentation", (Object)startConditionalEvent.getGeneral().getDocumentation().getValue());
        Assert.assertNotNull((Object)startConditionalEvent.getExecutionSet());
        Assert.assertEquals((Object)"drools", (Object)startConditionalEvent.getExecutionSet().getConditionExpression().getValue().getLanguage());
        Assert.assertEquals((Object)"StartConditionalEventConditionExpression", (Object)startConditionalEvent.getExecutionSet().getConditionExpression().getValue().getScript());
        Assert.assertEquals((Object)true, (Object)startConditionalEvent.getExecutionSet().getIsInterrupting().getValue());
        Assert.assertEquals((Object)"12/25/1983", (Object)startConditionalEvent.getExecutionSet().getSlaDueDate().getValue());
    }

    @Test
    public void testUnmarshallStartEscalationEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_STARTESCALATIONEVENT);
        Assertions.assertDiagram(diagram, 2);
        Assert.assertEquals((Object)"StartEscalationEvent", (Object)diagram.getMetadata().getTitle());
        Node startEventNode = diagram.getGraph().getNode("_D5AAA79F-9CD6-43C1-92E2-5D3C9340A303");
        Assert.assertNotNull((Object)startEventNode);
        StartEscalationEvent startEscalationEvent = (StartEscalationEvent)((Definition)startEventNode.getContent()).getDefinition();
        Assert.assertNotNull((Object)startEscalationEvent.getGeneral());
        Assert.assertEquals((Object)"StartEscalationEventName", (Object)startEscalationEvent.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"StartEscalationEventDocumentation", (Object)startEscalationEvent.getGeneral().getDocumentation().getValue());
        Assert.assertNotNull((Object)startEscalationEvent.getExecutionSet());
        Assert.assertEquals((Object)"EscalationCode", (Object)startEscalationEvent.getExecutionSet().getEscalationRef().getValue());
        Assert.assertEquals((Object)true, (Object)startEscalationEvent.getExecutionSet().getIsInterrupting().getValue());
        Assert.assertEquals((Object)"12/25/1983", (Object)startEscalationEvent.getExecutionSet().getSlaDueDate().getValue());
        DataIOSet dataIOSet = startEscalationEvent.getDataIOSet();
        AssignmentsInfo assignmentsInfo = dataIOSet.getAssignmentsinfo();
        Assert.assertEquals((Object)"||escalationOutput:String||[dout]escalationOutput->processVar1", (Object)assignmentsInfo.getValue());
    }

    @Test
    public void testUnmarshallStartCompensationEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_STARTCOMPENSATIONEVENT);
        Assertions.assertDiagram(diagram, 2);
        Assert.assertEquals((Object)"StartCompensationEvent", (Object)diagram.getMetadata().getTitle());
        Node startEventNode = diagram.getGraph().getNode("_19C23644-6CF0-4508-81B2-4CA2179137AB");
        Assert.assertNotNull((Object)startEventNode);
        StartCompensationEvent startCompensationEvent = (StartCompensationEvent)((Definition)startEventNode.getContent()).getDefinition();
        Assert.assertNotNull((Object)startCompensationEvent.getGeneral());
        Assert.assertEquals((Object)"StartCompensationEventName", (Object)startCompensationEvent.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"StartCompensationEventDocumentation", (Object)startCompensationEvent.getGeneral().getDocumentation().getValue());
        Assert.assertFalse((boolean)startCompensationEvent.getExecutionSet().getIsInterrupting().getValue());
        Assert.assertEquals((Object)"12/25/1983", (Object)startCompensationEvent.getExecutionSet().getSlaDueDate().getValue());
    }

    @Test
    public void testUnmarshallIntermediateTimerEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_INTERMEDIATE_TIMER_EVENT);
        Assertions.assertDiagram(diagram, 2);
        Assert.assertEquals((Object)"intermediateTimer", (Object)diagram.getMetadata().getTitle());
        Node intermediateEventNode = diagram.getGraph().getNode("_8D881072-284F-4F0D-8CF2-AD1F4540FC4E");
        IntermediateTimerEvent intermediateTimerEvent = (IntermediateTimerEvent)((Definition)intermediateEventNode.getContent()).getDefinition();
        Assert.assertNotNull((Object)intermediateTimerEvent.getGeneral());
        Assert.assertEquals((Object)"MyTimer", (Object)intermediateTimerEvent.getGeneral().getName().getValue());
        Assert.assertNotNull((Object)intermediateTimerEvent.getExecutionSet());
        Assert.assertEquals((Object)"abc", (Object)intermediateTimerEvent.getExecutionSet().getTimerSettings().getValue().getTimeCycle());
        Assert.assertEquals((Object)"none", (Object)intermediateTimerEvent.getExecutionSet().getTimerSettings().getValue().getTimeCycleLanguage());
        Assert.assertEquals((Object)"abc", (Object)intermediateTimerEvent.getExecutionSet().getTimerSettings().getValue().getTimeDate());
        Assert.assertEquals((Object)"abc", (Object)intermediateTimerEvent.getExecutionSet().getTimerSettings().getValue().getTimeDuration());
        Assert.assertEquals((Object)"12/25/1983", (Object)intermediateTimerEvent.getExecutionSet().getSlaDueDate().getValue());
    }

    @Test
    public void testUnmarshallIntermediateConditionalEvents() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_INTERMEDIATE_CONDITIONAL_EVENTS);
        Assertions.assertDiagram(diagram, 4);
        Assert.assertEquals((Object)"IntermediateConditionalEvents", (Object)diagram.getMetadata().getTitle());
        Node catchingEventNode = diagram.getGraph().getNode("_31A24997-C7B3-4286-8B4D-0EFD7CB11206");
        Assert.assertNotNull((Object)catchingEventNode);
        IntermediateConditionalEvent catchingConditionalEvent = (IntermediateConditionalEvent)((Definition)catchingEventNode.getContent()).getDefinition();
        Assert.assertNotNull((Object)catchingConditionalEvent.getGeneral());
        Assert.assertEquals((Object)"CatchingIntermediateConditionalEventName", (Object)catchingConditionalEvent.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"CatchingIntermediateConditionalDocumentation", (Object)catchingConditionalEvent.getGeneral().getDocumentation().getValue());
        Assert.assertNotNull((Object)catchingConditionalEvent.getExecutionSet());
        Assert.assertEquals((Object)"drools", (Object)catchingConditionalEvent.getExecutionSet().getConditionExpression().getValue().getLanguage());
        Assert.assertEquals((Object)"CatchingIntermediateConditionalEventCompletionCondition", (Object)catchingConditionalEvent.getExecutionSet().getConditionExpression().getValue().getScript());
        Assert.assertEquals((Object)true, (Object)catchingConditionalEvent.getExecutionSet().getCancelActivity().getValue());
        Assert.assertEquals((Object)"12/25/1983", (Object)catchingConditionalEvent.getExecutionSet().getSlaDueDate().getValue());
        Node boundaryEventNode = diagram.getGraph().getNode("_FD2DB546-4A85-4C50-9003-548A9A354F97");
        Assert.assertNotNull((Object)boundaryEventNode);
        IntermediateConditionalEvent boundaryConditionalEvent = (IntermediateConditionalEvent)((Definition)boundaryEventNode.getContent()).getDefinition();
        Assert.assertNotNull((Object)boundaryConditionalEvent.getGeneral());
        Assert.assertEquals((Object)"BoundaryConditionalEventName", (Object)boundaryConditionalEvent.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"BoundaryConditionalEventDocumentation", (Object)boundaryConditionalEvent.getGeneral().getDocumentation().getValue());
        Assert.assertNotNull((Object)boundaryConditionalEvent.getExecutionSet());
        Assert.assertEquals((Object)"drools", (Object)boundaryConditionalEvent.getExecutionSet().getConditionExpression().getValue().getLanguage());
        Assert.assertEquals((Object)"BoundaryConditionalEventCompletionCondition", (Object)boundaryConditionalEvent.getExecutionSet().getConditionExpression().getValue().getScript());
        Assert.assertEquals((Object)true, (Object)boundaryConditionalEvent.getExecutionSet().getCancelActivity().getValue());
        Assert.assertEquals((Object)"12/25/1983", (Object)boundaryConditionalEvent.getExecutionSet().getSlaDueDate().getValue());
    }

    @Test
    public void testUnmarshallIntermediateEscalationEvents() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_INTERMEDIATE_ESCALATION_EVENTS);
        Assertions.assertDiagram(diagram, 3);
        Assert.assertEquals((Object)"IntermediateEscalationEvents", (Object)diagram.getMetadata().getTitle());
        Node catchingEventNode = diagram.getGraph().getNode("_C7F2BA98-1100-4CF8-A994-40E2B65F6E5D");
        Assert.assertNotNull((Object)catchingEventNode);
        IntermediateEscalationEvent intermediateEscalationEvent = (IntermediateEscalationEvent)((Definition)catchingEventNode.getContent()).getDefinition();
        Assert.assertNotNull((Object)intermediateEscalationEvent.getGeneral());
        Assert.assertEquals((Object)"BoundaryEscalationEventName", (Object)intermediateEscalationEvent.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"BoundaryEscalationEventDocumentation", (Object)intermediateEscalationEvent.getGeneral().getDocumentation().getValue());
        Assert.assertNotNull((Object)intermediateEscalationEvent.getExecutionSet());
        Assert.assertEquals((Object)true, (Object)intermediateEscalationEvent.getExecutionSet().getCancelActivity().getValue());
        Assert.assertEquals((Object)"EscalationCode", (Object)intermediateEscalationEvent.getExecutionSet().getEscalationRef().getValue());
        DataIOSet dataIOSet = intermediateEscalationEvent.getDataIOSet();
        AssignmentsInfo assignmentsInfo = dataIOSet.getAssignmentsinfo();
        Assert.assertEquals((Object)"||escalationOutput:String||[dout]escalationOutput->processVar1", (Object)assignmentsInfo.getValue());
        Assert.assertEquals((Object)"12/25/1983", (Object)intermediateEscalationEvent.getExecutionSet().getSlaDueDate().getValue());
    }

    @Test
    public void testUnmarshallIntermediateCompensationEvents() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_INTERMEDIATE_COMPENSATION_EVENTS);
        Assertions.assertDiagram(diagram, 3);
        Assert.assertEquals((Object)"IntermediateCompensationEvents", (Object)diagram.getMetadata().getTitle());
        Node catchingEventNode = diagram.getGraph().getNode("_8CE8AB54-7E8B-4032-B340-2DBEBAB5080F");
        Assert.assertNotNull((Object)catchingEventNode);
        IntermediateCompensationEvent intermediateCompensationEvent = (IntermediateCompensationEvent)((Definition)catchingEventNode.getContent()).getDefinition();
        Assert.assertNotNull((Object)intermediateCompensationEvent.getGeneral());
        Assert.assertEquals((Object)"IntermediateCompensationEventName", (Object)intermediateCompensationEvent.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"IntermediateCompensationEventDocumentation", (Object)intermediateCompensationEvent.getGeneral().getDocumentation().getValue());
        Assert.assertEquals((Object)"IntermediateCompensationEventDocumentation", (Object)intermediateCompensationEvent.getGeneral().getDocumentation().getValue());
        Assert.assertEquals((Object)"12/25/1983", (Object)intermediateCompensationEvent.getExecutionSet().getSlaDueDate().getValue());
    }

    @Test
    public void testUnmarshallIntermediateCompensationEventsWithAssociations() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_INTERMEDIATE_COMPENSATION_EVENTS_WITH_ASSOCIATION);
        Assertions.assertDiagram(diagram, 6);
        Assert.assertEquals((Object)"IntermediateCompensationEventsWithAssociation", (Object)diagram.getMetadata().getTitle());
        Node catchingEventNode = diagram.getGraph().getNode("_DF70C614-A641-4109-8A8D-506B15E3F31B");
        Assert.assertNotNull((Object)catchingEventNode);
        IntermediateCompensationEvent intermediateCompensationEvent = (IntermediateCompensationEvent)((Definition)catchingEventNode.getContent()).getDefinition();
        Assert.assertTrue((boolean)GraphUtils.isDockedNode((Node)catchingEventNode));
        Assert.assertNotNull((Object)intermediateCompensationEvent.getGeneral());
        Assert.assertEquals((Object)"IntermediateCompensationEventName", (Object)intermediateCompensationEvent.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"IntermediateCompensationEventDocumentation", (Object)intermediateCompensationEvent.getGeneral().getDocumentation().getValue());
        Assert.assertEquals((Object)"12/25/1983", (Object)intermediateCompensationEvent.getExecutionSet().getSlaDueDate().getValue());
        Node userTask1Node = diagram.getGraph().getNode("_C18CC8D2-D7CA-457D-9258-01D1E6973A86");
        Assert.assertNotNull((Object)userTask1Node);
        org.kie.workbench.common.stunner.bpmn.definition.UserTask userTask1 = (org.kie.workbench.common.stunner.bpmn.definition.UserTask)((Definition)userTask1Node.getContent()).getDefinition();
        Assert.assertEquals((Object)"Task1", (Object)userTask1.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"Task1Documentation", (Object)userTask1.getGeneral().getDocumentation().getValue());
        Assert.assertEquals((Object)userTask1Node, GraphUtils.getDockParent((Node)catchingEventNode).orElse(null));
        Node userTask2Node = diagram.getGraph().getNode("_7EF24042-BD4E-4843-9874-8AC3F7AFF3CD");
        Assert.assertNotNull((Object)userTask2Node);
        org.kie.workbench.common.stunner.bpmn.definition.UserTask userTask2 = (org.kie.workbench.common.stunner.bpmn.definition.UserTask)((Definition)userTask2Node.getContent()).getDefinition();
        Assert.assertEquals((Object)"Task2", (Object)userTask2.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"Task2Documentation", (Object)userTask2.getGeneral().getDocumentation().getValue());
        Edge associationEdge = userTask2Node.getInEdges().stream().filter(edge -> edge.getUUID().equals("_B41D28D1-FC39-40E8-BF89-C57649989014")).map(e -> e.asEdge()).findFirst().orElse(null);
        Assert.assertNotNull((Object)associationEdge);
        Assert.assertNotNull((Object)associationEdge.getContent());
        Association association = (Association)((View)associationEdge.getContent()).getDefinition();
        Assert.assertEquals((Object)"AssociationDocumentation", (Object)association.getGeneral().getDocumentation().getValue());
        Assert.assertEquals((Object)associationEdge.getSourceNode(), (Object)catchingEventNode);
        Assert.assertEquals((Object)associationEdge.getTargetNode(), (Object)userTask2Node);
    }

    @Test
    public void testUnmarshallIntermediateSignalEventCatching() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_INTERMEDIATE_SIGNAL_EVENTCATCHING);
        Assertions.assertDiagram(diagram, 2);
        Assert.assertEquals((Object)"intermediateSignalCatching", (Object)diagram.getMetadata().getTitle());
        Node intermediateEventNode = diagram.getGraph().getNode("_2C9B14A3-F663-476D-9FDF-31590D3A9CC5");
        IntermediateSignalEventCatching intermediateSignalEventCatching = (IntermediateSignalEventCatching)((Definition)intermediateEventNode.getContent()).getDefinition();
        Assert.assertNotNull((Object)intermediateSignalEventCatching.getGeneral());
        Assert.assertEquals((Object)"MySignalCatchingEvent", (Object)intermediateSignalEventCatching.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"MySignalCatchingEventDocumentation", (Object)intermediateSignalEventCatching.getGeneral().getDocumentation().getValue());
        Assert.assertNotNull((Object)intermediateSignalEventCatching.getExecutionSet());
        Assert.assertEquals((Object)true, (Object)intermediateSignalEventCatching.getExecutionSet().getCancelActivity().getValue());
        Assert.assertEquals((Object)"MySignal", (Object)intermediateSignalEventCatching.getExecutionSet().getSignalRef().getValue());
        Assert.assertEquals((Object)"12/25/1983", (Object)intermediateSignalEventCatching.getExecutionSet().getSlaDueDate().getValue());
        DataIOSet dataIOSet = intermediateSignalEventCatching.getDataIOSet();
        AssignmentsInfo assignmentsInfo = dataIOSet.getAssignmentsinfo();
        Assert.assertEquals((Object)"||output1_:String||[dout]output1_->var1", (Object)assignmentsInfo.getValue());
    }

    @Test
    public void testUnmarshallIntermediateErrorEventCatching() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_INTERMEDIATE_ERROR_EVENTCATCHING);
        Assertions.assertDiagram(diagram, 2);
        Assert.assertEquals((Object)"intermediateErrorCatching", (Object)diagram.getMetadata().getTitle());
        Node intermediateEventNode = diagram.getGraph().getNode("80A2A7A9-7C68-408C-BE3B-467562A2C139");
        IntermediateErrorEventCatching intermediateErrorEventCatching = (IntermediateErrorEventCatching)((Definition)intermediateEventNode.getContent()).getDefinition();
        Assert.assertNotNull((Object)intermediateErrorEventCatching.getGeneral());
        Assert.assertEquals((Object)"MyErrorCatchingEvent", (Object)intermediateErrorEventCatching.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"MyErrorCatchingEventDocumentation", (Object)intermediateErrorEventCatching.getGeneral().getDocumentation().getValue());
        Assert.assertNotNull((Object)intermediateErrorEventCatching.getExecutionSet());
        Assert.assertEquals((Object)true, (Object)intermediateErrorEventCatching.getExecutionSet().getCancelActivity().getValue());
        Assert.assertEquals((Object)"MyError", (Object)intermediateErrorEventCatching.getExecutionSet().getErrorRef().getValue());
        Assert.assertEquals((Object)"12/25/1983", (Object)intermediateErrorEventCatching.getExecutionSet().getSlaDueDate().getValue());
        DataIOSet dataIOSet = intermediateErrorEventCatching.getDataIOSet();
        AssignmentsInfo assignmentsInfo = dataIOSet.getAssignmentsinfo();
        Assert.assertEquals((Object)"||theErrorEventOutput:String||[dout]theErrorEventOutput->errorVar", (Object)assignmentsInfo.getValue());
    }

    @Test
    public void testUnmarshallIntermediateSignalEventThrowing() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_INTERMEDIATE_SIGNAL_EVENTTHROWING);
        Assertions.assertDiagram(diagram, 2);
        Assert.assertEquals((Object)"intermediateSignalThrowing", (Object)diagram.getMetadata().getTitle());
        Node intermediateEventNode = diagram.getGraph().getNode("_A45EC77D-5414-4348-BA8F-05C4FFD660EE");
        IntermediateSignalEventThrowing intermediateSignalEventThrowing = (IntermediateSignalEventThrowing)((Definition)intermediateEventNode.getContent()).getDefinition();
        Assert.assertNotNull((Object)intermediateSignalEventThrowing.getGeneral());
        Assert.assertEquals((Object)"MySignalThrowingEvent", (Object)intermediateSignalEventThrowing.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"MySignalThrowingEventDocumentation", (Object)intermediateSignalEventThrowing.getGeneral().getDocumentation().getValue());
        Assert.assertNotNull((Object)intermediateSignalEventThrowing.getExecutionSet());
        Assert.assertEquals((Object)"processInstance", (Object)intermediateSignalEventThrowing.getExecutionSet().getSignalScope().getValue());
        Assert.assertEquals((Object)"MySignal", (Object)intermediateSignalEventThrowing.getExecutionSet().getSignalRef().getValue());
        DataIOSet dataIOSet = intermediateSignalEventThrowing.getDataIOSet();
        AssignmentsInfo assignmentsInfo = dataIOSet.getAssignmentsinfo();
        Assert.assertEquals((Object)"_input1:String||||[din]var1->_input1", (Object)assignmentsInfo.getValue());
    }

    @Test
    public void testUnmarshallIntermediateEscalationEventThrowing() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_INTERMEDIATE_ESCALATION_EVENTTHROWING);
        Assertions.assertDiagram(diagram, 2);
        Assert.assertEquals((Object)"IntermediateEscalationEventThrowing", (Object)diagram.getMetadata().getTitle());
        Node throwingEventNode = diagram.getGraph().getNode("_8516D854-F67F-4697-9837-40A32033AE25");
        Assert.assertNotNull((Object)throwingEventNode);
        IntermediateEscalationEventThrowing throwingEscalationEvent = (IntermediateEscalationEventThrowing)((Definition)throwingEventNode.getContent()).getDefinition();
        Assert.assertNotNull((Object)throwingEscalationEvent.getGeneral());
        Assert.assertEquals((Object)"ThrowingEscalationEventName", (Object)throwingEscalationEvent.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"ThrowingEscalationEventDocumentation", (Object)throwingEscalationEvent.getGeneral().getDocumentation().getValue());
        Assert.assertNotNull((Object)throwingEscalationEvent.getExecutionSet());
        Assert.assertEquals((Object)"EscalationCode", (Object)throwingEscalationEvent.getExecutionSet().getEscalationRef().getValue());
        DataIOSet dataIOSet = throwingEscalationEvent.getDataIOSet();
        AssignmentsInfo assignmentsInfo = dataIOSet.getAssignmentsinfo();
        Assert.assertEquals((Object)"escalationOutput:String||||[din]processVar1->escalationOutput", (Object)assignmentsInfo.getValue());
    }

    @Test
    public void testUnmarshallIntermediateCompensationEventThrowing() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_INTERMEDIATE_COMPENSATION_EVENTTHROWING);
        Assertions.assertDiagram(diagram, 3);
        Assert.assertEquals((Object)"IntermediateCompensationEventThrowing", (Object)diagram.getMetadata().getTitle());
        Node throwingEventNode = diagram.getGraph().getNode("_F1D87D25-4D73-4DC5-A0C2-C627CED773BA");
        Assert.assertNotNull((Object)throwingEventNode);
        IntermediateCompensationEventThrowing throwingCompensationEvent = (IntermediateCompensationEventThrowing)((Definition)throwingEventNode.getContent()).getDefinition();
        Assert.assertNotNull((Object)throwingCompensationEvent.getGeneral());
        Assert.assertEquals((Object)"ThrowingCompensationEventName", (Object)throwingCompensationEvent.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"ThrowingCompensationEventDocumentation", (Object)throwingCompensationEvent.getGeneral().getDocumentation().getValue());
        Assert.assertNotNull((Object)throwingCompensationEvent.getExecutionSet());
        Assert.assertEquals((Object)"_E318295E-B0B6-4FB2-B5EB-A43BFD44FCBD", (Object)throwingCompensationEvent.getExecutionSet().getActivityRef().getValue());
    }

    @Test
    public void testUnmarshallIntermediateMessageEventCatching() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_INTERMEDIATE_MESSAGE_EVENTCATCHING);
        Assertions.assertDiagram(diagram, 2);
        Assert.assertEquals((Object)"IntermediateMessageEventCatching", (Object)diagram.getMetadata().getTitle());
        Node intermediateMessageEventCatchingNode = diagram.getGraph().getNode("_BD708E30-CA48-4051-BAEA-BBCB5F396CEE");
        IntermediateMessageEventCatching intermediateMessageEventCatching = (IntermediateMessageEventCatching)((Definition)intermediateMessageEventCatchingNode.getContent()).getDefinition();
        Assert.assertNotNull((Object)intermediateMessageEventCatching.getExecutionSet());
        MessageRef messageRef = intermediateMessageEventCatching.getExecutionSet().getMessageRef();
        Assert.assertEquals((Object)"msgref1", (Object)messageRef.getValue());
        DataIOSet dataIOSet = intermediateMessageEventCatching.getDataIOSet();
        AssignmentsInfo assignmentsInfo = dataIOSet.getAssignmentsinfo();
        Assert.assertEquals((Object)"||IntermediateMessageEventCatchingOutputVar1:String||[dout]IntermediateMessageEventCatchingOutputVar1->var1", (Object)assignmentsInfo.getValue());
        Assert.assertEquals((Object)"12/25/1983", (Object)intermediateMessageEventCatching.getExecutionSet().getSlaDueDate().getValue());
    }

    @Test
    public void testUnmarshallIntermediateMessageEventThrowing() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_INTERMEDIATE_MESSAGE_EVENTTHROWING);
        Assertions.assertDiagram(diagram, 2);
        Assert.assertEquals((Object)"IntermediateMessageEventThrowing", (Object)diagram.getMetadata().getTitle());
        Node intermediateMessageEventThrowingNode = diagram.getGraph().getNode("_85823DF6-02A0-4B8D-AE7A-61641A3A2E4B");
        IntermediateMessageEventThrowing intermediateMessageEventThrowing = (IntermediateMessageEventThrowing)((Definition)intermediateMessageEventThrowingNode.getContent()).getDefinition();
        Assert.assertNotNull((Object)intermediateMessageEventThrowing.getExecutionSet());
        MessageRef messageRef = intermediateMessageEventThrowing.getExecutionSet().getMessageRef();
        Assert.assertEquals((Object)"msgref", (Object)messageRef.getValue());
        DataIOSet dataIOSet = intermediateMessageEventThrowing.getDataIOSet();
        AssignmentsInfo assignmentsInfo = dataIOSet.getAssignmentsinfo();
        Assert.assertEquals((Object)"IntermediateMessageEventThrowingInputVar1:String||||[din]var1->IntermediateMessageEventThrowingInputVar1", (Object)assignmentsInfo.getValue());
    }

    @Test
    public void testUnmarshallEndNoneEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_ENDNONEEVENT);
        Assertions.assertDiagram(diagram, 3);
        Assert.assertEquals((Object)"endNoneEvent", (Object)diagram.getMetadata().getTitle());
        Node endNoneEventNode = diagram.getGraph().getNode("_9DF2C9D3-15DF-4436-B6C6-85B58B8696B6");
        EndNoneEvent endNoneEvent = (EndNoneEvent)((Definition)endNoneEventNode.getContent()).getDefinition();
        Assert.assertNotNull((Object)endNoneEvent.getGeneral());
        Assert.assertEquals((Object)"MyEndNoneEvent", (Object)endNoneEvent.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"MyEndNoneEventDocumentation", (Object)endNoneEvent.getGeneral().getDocumentation().getValue());
    }

    @Test
    public void testUnmarshallIsInterruptingStartErrorEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_EVENT_SUBPROCESS_STARTERROREVENT);
        Assertions.assertDiagram(diagram, 7);
        Assert.assertEquals((Object)"EventSubprocessStartErrorEvent", (Object)diagram.getMetadata().getTitle());
        Node startEventNode = diagram.getGraph().getNode("9ABD5C04-C6E2-4DF3-829F-ADB283330AD6");
        StartErrorEvent startErrorEvent = (StartErrorEvent)((Definition)startEventNode.getContent()).getDefinition();
        BPMNGeneralSet eventGeneralSet = startErrorEvent.getGeneral();
        Assert.assertNotNull((Object)eventGeneralSet);
        Assert.assertEquals((Object)"StartErrorEvent", (Object)eventGeneralSet.getName().getValue());
        Assert.assertEquals((Object)"Some not empty\nDocumentation\n~`!@#$%^&*()_+=-{}|[]\\:\";'<>/?.,", (Object)eventGeneralSet.getDocumentation().getValue());
        InterruptingErrorEventExecutionSet eventExecutionSet = startErrorEvent.getExecutionSet();
        Assert.assertNotNull((Object)eventExecutionSet);
        Assert.assertNotNull((Object)eventExecutionSet.getErrorRef());
        Assert.assertEquals((Object)"Error1", (Object)eventExecutionSet.getErrorRef().getValue());
        Assert.assertEquals((Object)true, (Object)eventExecutionSet.getIsInterrupting().getValue());
        Assert.assertEquals((Object)"12/25/1983", (Object)eventExecutionSet.getSlaDueDate().getValue());
        DataIOSet eventDataIOSet = startErrorEvent.getDataIOSet();
        AssignmentsInfo assignmentsInfo = eventDataIOSet.getAssignmentsinfo();
        Assert.assertEquals((Object)"||Var1:String||[dout]Var1->Var1", (Object)assignmentsInfo.getValue());
        Node emptyEventNode = diagram.getGraph().getNode("50B93E5E-C05D-40DD-BF48-2B6AE919763E");
        StartErrorEvent emptyErrorEvent = (StartErrorEvent)((Definition)emptyEventNode.getContent()).getDefinition();
        BPMNGeneralSet emptyEventGeneralSet = emptyErrorEvent.getGeneral();
        Assert.assertNotNull((Object)emptyEventGeneralSet);
        Assert.assertEquals((Object)"", (Object)emptyEventGeneralSet.getName().getValue());
        Assert.assertEquals((Object)"", (Object)emptyEventGeneralSet.getDocumentation().getValue());
        InterruptingErrorEventExecutionSet emptyExecutionSet = emptyErrorEvent.getExecutionSet();
        Assert.assertNotNull((Object)emptyExecutionSet);
        Assert.assertNotNull((Object)emptyExecutionSet.getErrorRef());
        Assert.assertEquals((Object)"", (Object)emptyExecutionSet.getErrorRef().getValue());
        Assert.assertEquals((Object)false, (Object)emptyExecutionSet.getIsInterrupting().getValue());
        Assert.assertEquals((Object)"", (Object)emptyExecutionSet.getSlaDueDate().getValue());
        DataIOSet emptyDataIOSet = emptyErrorEvent.getDataIOSet();
        AssignmentsInfo emptyAssignmentsInfo = emptyDataIOSet.getAssignmentsinfo();
        Assert.assertEquals((Object)"", (Object)emptyAssignmentsInfo.getValue());
    }

    @Test
    public void testUnmarshallEndTerminateEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_ENDTERMINATEEVENT);
        Assertions.assertDiagram(diagram, 3);
        Assert.assertEquals((Object)"endTerminateEvent", (Object)diagram.getMetadata().getTitle());
        Node endNoneEventNode = diagram.getGraph().getNode("_1B379E3E-E4ED-4BD2-AEE8-CD85374CEC78");
        EndTerminateEvent endTerminateEvent = (EndTerminateEvent)((Definition)endNoneEventNode.getContent()).getDefinition();
        Assert.assertNotNull((Object)endTerminateEvent.getGeneral());
        Assert.assertEquals((Object)"MyEndTerminateEvent", (Object)endTerminateEvent.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"MyEndTerminateEventDocumentation", (Object)endTerminateEvent.getGeneral().getDocumentation().getValue());
    }

    @Test
    public void testUnmarshallEndSignalEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_ENDSIGNALEVENT);
        Assertions.assertDiagram(diagram, 2);
        Assert.assertEquals((Object)"EndEventAssignments", (Object)diagram.getMetadata().getTitle());
        Node endSignalEventNode = diagram.getGraph().getNode("_C9151E0C-2E3E-4558-AFC2-34038E3A8552");
        EndSignalEvent endSignalEvent = (EndSignalEvent)((Definition)endSignalEventNode.getContent()).getDefinition();
        DataIOSet dataIOSet = endSignalEvent.getDataIOSet();
        AssignmentsInfo assignmentsinfo = dataIOSet.getAssignmentsinfo();
        Assert.assertEquals((Object)"EndSignalEventInput1:String||||[din]employee->EndSignalEventInput1", (Object)assignmentsinfo.getValue());
        Assert.assertEquals((Object)"project", (Object)endSignalEvent.getExecutionSet().getSignalScope().getValue());
        Assert.assertEquals((Object)"employee", (Object)endSignalEvent.getExecutionSet().getSignalRef().getValue());
    }

    @Test
    public void testUnmarshallEndMessageEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_ENDMESSAGEEVENT);
        Assertions.assertDiagram(diagram, 2);
        Assert.assertEquals((Object)"EndMessageEvent", (Object)diagram.getMetadata().getTitle());
        Node endMessageEventNode = diagram.getGraph().getNode("_4A8A0A9E-D4A5-4B6E-94A6-20817A57B3C6");
        EndMessageEvent endMessageEvent = (EndMessageEvent)((Definition)endMessageEventNode.getContent()).getDefinition();
        Assert.assertNotNull((Object)endMessageEvent.getExecutionSet());
        MessageRef messageRef = endMessageEvent.getExecutionSet().getMessageRef();
        Assert.assertEquals((Object)"msgref", (Object)messageRef.getValue());
        DataIOSet dataIOSet = endMessageEvent.getDataIOSet();
        AssignmentsInfo assignmentsInfo = dataIOSet.getAssignmentsinfo();
        Assert.assertEquals((Object)"EndMessageEventInputVar1:String||||[din]var1->EndMessageEventInputVar1", (Object)assignmentsInfo.getValue());
    }

    @Test
    public void testUnmarshallEndErrorEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_ENDERROR_EVENT);
        Assertions.assertDiagram(diagram, 2);
        Assert.assertEquals((Object)"endErrorEventProcess", (Object)diagram.getMetadata().getTitle());
        Node endEventNode = diagram.getGraph().getNode("_E69BD781-AB7F-45C4-85DA-B1F3BAE5BCCB");
        EndErrorEvent endErrorEvent = (EndErrorEvent)((Definition)endEventNode.getContent()).getDefinition();
        Assert.assertNotNull((Object)endErrorEvent.getGeneral());
        Assert.assertEquals((Object)"MyErrorEventName", (Object)endErrorEvent.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"MyErrorEventDocumentation", (Object)endErrorEvent.getGeneral().getDocumentation().getValue());
        Assert.assertNotNull((Object)endErrorEvent.getExecutionSet());
        Assert.assertNotNull((Object)endErrorEvent.getExecutionSet().getErrorRef());
        Assert.assertEquals((Object)"MyError", (Object)endErrorEvent.getExecutionSet().getErrorRef().getValue());
        DataIOSet dataIOSet = endErrorEvent.getDataIOSet();
        AssignmentsInfo assignmentsInfo = dataIOSet.getAssignmentsinfo();
        Assert.assertEquals((Object)"myErrorEventInput:String||||[din]var1->myErrorEventInput", (Object)assignmentsInfo.getValue());
    }

    @Test
    public void testUnmarshallEndEscalationEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_ENDESCALATIONEVENT);
        Assertions.assertDiagram(diagram, 2);
        Assert.assertEquals((Object)"EndEscalationEvent", (Object)diagram.getMetadata().getTitle());
        Node endEventNode = diagram.getGraph().getNode("_8F6A4096-26AA-4C14-B1F0-B96ED24BD5C7");
        Assert.assertNotNull((Object)endEventNode);
        EndEscalationEvent endEscalationEvent = (EndEscalationEvent)((Definition)endEventNode.getContent()).getDefinition();
        Assert.assertNotNull((Object)endEscalationEvent.getGeneral());
        Assert.assertEquals((Object)"EndEscalationEventName", (Object)endEscalationEvent.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"EndEscalationEventDocumentation", (Object)endEscalationEvent.getGeneral().getDocumentation().getValue());
        Assert.assertNotNull((Object)endEscalationEvent.getExecutionSet());
        Assert.assertEquals((Object)"EscalationCode", (Object)endEscalationEvent.getExecutionSet().getEscalationRef().getValue());
        DataIOSet dataIOSet = endEscalationEvent.getDataIOSet();
        AssignmentsInfo assignmentsInfo = dataIOSet.getAssignmentsinfo();
        Assert.assertEquals((Object)"escalationInput:String||||[din]processVar1->escalationInput", (Object)assignmentsInfo.getValue());
    }

    @Test
    public void testUnmarshallEndCompensationEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_ENDCOMPENSATIONEVENT);
        Assertions.assertDiagram(diagram, 3);
        Assert.assertEquals((Object)"EndCompensationEvent", (Object)diagram.getMetadata().getTitle());
        Node endEventNode = diagram.getGraph().getNode("_2AEA503B-26E5-4F11-A54D-3E275F8BFA6A");
        Assert.assertNotNull((Object)endEventNode);
        EndCompensationEvent endCompensationEvent = (EndCompensationEvent)((Definition)endEventNode.getContent()).getDefinition();
        Assert.assertNotNull((Object)endCompensationEvent.getGeneral());
        Assert.assertEquals((Object)"EndCompensationEventName", (Object)endCompensationEvent.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"EndCompensationEventDocumentation", (Object)endCompensationEvent.getGeneral().getDocumentation().getValue());
        Assert.assertNotNull((Object)endCompensationEvent.getExecutionSet());
        Assert.assertEquals((Object)"_7795AFA7-E602-4D90-B4B6-249639C4D965", (Object)endCompensationEvent.getExecutionSet().getActivityRef().getValue());
    }

    @Test
    public void testUnmarshallUserTaskAssignees() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_USERTASKASSIGNEES);
        Assertions.assertDiagram(diagram, 6);
        Assert.assertEquals((Object)"UserGroups", (Object)diagram.getMetadata().getTitle());
        UserTaskExecutionSet executionSet = null;
        Iterator<Element> it = this.nodesIterator(diagram);
        while (it.hasNext()) {
            Object oDefinition;
            Element element = it.next();
            if (!(element.getContent() instanceof View) || !((oDefinition = ((View)element.getContent()).getDefinition()) instanceof org.kie.workbench.common.stunner.bpmn.definition.UserTask)) continue;
            org.kie.workbench.common.stunner.bpmn.definition.UserTask userTask = (org.kie.workbench.common.stunner.bpmn.definition.UserTask)oDefinition;
            executionSet = userTask.getExecutionSet();
            break;
        }
        Assert.assertEquals((Object)"user,user1", (Object)executionSet.getActors().getValue());
        Assert.assertEquals((Object)"admin,kiemgmt", (Object)executionSet.getGroupid().getValue());
    }

    @Test
    public void testUnmarshallUserTaskProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_USERTASKPROPERTIES);
        Assertions.assertDiagram(diagram, 4);
        Assert.assertEquals((Object)"MyBP", (Object)diagram.getMetadata().getTitle());
        UserTaskExecutionSet userTaskExecutionSet = null;
        Iterator<Element> it = this.nodesIterator(diagram);
        while (it.hasNext()) {
            Object oDefinition;
            Element element = it.next();
            if (!(element.getContent() instanceof View) || !((oDefinition = ((View)element.getContent()).getDefinition()) instanceof org.kie.workbench.common.stunner.bpmn.definition.UserTask)) continue;
            org.kie.workbench.common.stunner.bpmn.definition.UserTask userTask = (org.kie.workbench.common.stunner.bpmn.definition.UserTask)oDefinition;
            userTaskExecutionSet = userTask.getExecutionSet();
            break;
        }
        Assert.assertEquals((Object)"MyUserTask", (Object)userTaskExecutionSet.getTaskName().getValue());
        Assert.assertEquals((Object)"true", (Object)userTaskExecutionSet.getIsAsync().getValue().toString());
        Assert.assertEquals((Object)"false", (Object)userTaskExecutionSet.getSkippable().getValue().toString());
        Assert.assertEquals((Object)"my subject", (Object)userTaskExecutionSet.getSubject().getValue());
        Assert.assertEquals((Object)"admin", (Object)userTaskExecutionSet.getCreatedBy().getValue());
        Assert.assertEquals((Object)"my description", (Object)userTaskExecutionSet.getDescription().getValue());
        Assert.assertEquals((Object)"3", (Object)userTaskExecutionSet.getPriority().getValue());
        Assert.assertEquals((Object)"true", (Object)userTaskExecutionSet.getAdHocAutostart().getValue().toString());
        Assert.assertEquals((Object)"System.out.println(\"Hello\");", (Object)((ScriptTypeValue)userTaskExecutionSet.getOnEntryAction().getValue().getValues().get(0)).getScript());
        Assert.assertEquals((Object)"java", (Object)((ScriptTypeValue)userTaskExecutionSet.getOnEntryAction().getValue().getValues().get(0)).getLanguage());
        Assert.assertEquals((Object)"System.out.println(\"Bye\");", (Object)((ScriptTypeValue)userTaskExecutionSet.getOnExitAction().getValue().getValues().get(0)).getScript());
        Assert.assertEquals((Object)"java", (Object)((ScriptTypeValue)userTaskExecutionSet.getOnExitAction().getValue().getValues().get(0)).getLanguage());
    }

    @Test
    public void testUnmarshallSimulationProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_SIMULATIONPROPERTIES);
        Assertions.assertDiagram(diagram, 4);
        Assert.assertEquals((Object)"SimulationProperties", (Object)diagram.getMetadata().getTitle());
        SimulationSet simulationSet = null;
        Iterator<Element> it = this.nodesIterator(diagram);
        while (it.hasNext()) {
            Object oDefinition;
            Element element = it.next();
            if (!(element.getContent() instanceof View) || !((oDefinition = ((View)element.getContent()).getDefinition()) instanceof org.kie.workbench.common.stunner.bpmn.definition.UserTask)) continue;
            org.kie.workbench.common.stunner.bpmn.definition.UserTask userTask = (org.kie.workbench.common.stunner.bpmn.definition.UserTask)oDefinition;
            simulationSet = userTask.getSimulationSet();
            break;
        }
        Assert.assertEquals((Object)111.0, (Object)simulationSet.getQuantity().getValue());
        Assert.assertEquals((Object)"poisson", (Object)simulationSet.getDistributionType().getValue());
        Assert.assertEquals((Object)123.0, (Object)simulationSet.getUnitCost().getValue());
        Assert.assertEquals((Object)999.0, (Object)simulationSet.getWorkingHours().getValue());
        Assert.assertEquals((Object)321.0, (Object)simulationSet.getMean().getValue());
    }

    @Test
    public void testUnmarshallNotBoundaryEvents() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_NOT_BOUNDARY_EVENTS);
        Assert.assertEquals((Object)"Not Boundary Event", (Object)diagram.getMetadata().getTitle());
        Assertions.assertDiagram(diagram, 6);
        Node event = diagram.getGraph().getNode("_CB178D55-8DC2-4CAA-8C42-4F5028D4A1F6");
        List inEdges = event.getInEdges();
        boolean foundViewConnector = false;
        for (Edge e : inEdges) {
            if (!(e.getContent() instanceof ViewConnector)) continue;
            foundViewConnector = true;
        }
        Assert.assertTrue((boolean)foundViewConnector);
        Bounds bounds = ((View)event.getContent()).getBounds();
        Bound ul = bounds.getUpperLeft();
        Bound lr = bounds.getLowerRight();
        Assert.assertEquals((double)305.0, (double)ul.getX(), (double)0.0);
        Assert.assertEquals((double)300.0, (double)ul.getY(), (double)0.0);
        Assert.assertEquals((double)361.0, (double)lr.getX(), (double)0.0);
        Assert.assertEquals((double)356.0, (double)lr.getY(), (double)0.0);
    }

    @Test
    public void testUnmarshallBoundaryEvents() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_BOUNDARY_EVENTS);
        Assert.assertEquals((Object)"Boundary Event", (Object)diagram.getMetadata().getTitle());
        Assertions.assertDiagram(diagram, 6);
        Node event = diagram.getGraph().getNode("_CB178D55-8DC2-4CAA-8C42-4F5028D4A1F6");
        List inEdges = event.getInEdges();
        boolean foundDockConector = false;
        for (Edge e : inEdges) {
            if (!(e.getContent() instanceof Dock)) continue;
            foundDockConector = true;
        }
        Assert.assertTrue((boolean)foundDockConector);
        Bounds bounds = ((View)event.getContent()).getBounds();
        Bound ul = bounds.getUpperLeft();
        Bound lr = bounds.getLowerRight();
        Assert.assertEquals((double)57.0, (double)ul.getX(), (double)0.0);
        Assert.assertEquals((double)70.0, (double)ul.getY(), (double)0.0);
        Assert.assertEquals((double)113.0, (double)lr.getX(), (double)0.0);
        Assert.assertEquals((double)126.0, (double)lr.getY(), (double)0.0);
    }

    @Test
    public void testUnmarshallScriptTask() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_SCRIPTTASK);
        ScriptTask javascriptScriptTask = null;
        ScriptTask javaScriptTask = null;
        Iterator<Element> it = this.nodesIterator(diagram);
        while (it.hasNext()) {
            Object oDefinition;
            Element element = it.next();
            if (!(element.getContent() instanceof View) || !((oDefinition = ((View)element.getContent()).getDefinition()) instanceof ScriptTask)) continue;
            ScriptTask task = (ScriptTask)oDefinition;
            if ("Javascript Script Task".equals(task.getGeneral().getName().getValue())) {
                javascriptScriptTask = task;
                continue;
            }
            if (!"Java Script Task".equals(task.getGeneral().getName().getValue())) continue;
            javaScriptTask = task;
        }
        Assert.assertNotNull(javascriptScriptTask);
        Assert.assertNotNull((Object)javascriptScriptTask.getExecutionSet());
        Assert.assertNotNull((Object)javascriptScriptTask.getExecutionSet().getScript());
        Assert.assertEquals((Object)javascriptScriptTask.getTaskType().getValue(), (Object)TaskTypes.SCRIPT);
        Assert.assertEquals((Object)"Javascript Script Task", (Object)javascriptScriptTask.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"var str = FirstName + LastName;", (Object)javascriptScriptTask.getExecutionSet().getScript().getValue().getScript());
        Assert.assertEquals((Object)"javascript", (Object)javascriptScriptTask.getExecutionSet().getScript().getValue().getLanguage());
        Assert.assertEquals((Object)"true", (Object)javascriptScriptTask.getExecutionSet().getIsAsync().getValue().toString());
        Assert.assertEquals((Object)"true", (Object)javascriptScriptTask.getExecutionSet().getAdHocAutostart().getValue().toString());
        Assert.assertNotNull((Object)javaScriptTask);
        Assert.assertNotNull((Object)javaScriptTask.getExecutionSet());
        Assert.assertNotNull((Object)javaScriptTask.getExecutionSet().getScript());
        Assert.assertEquals((Object)javaScriptTask.getTaskType().getValue(), (Object)TaskTypes.SCRIPT);
        Assert.assertEquals((Object)"Java Script Task", (Object)javaScriptTask.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"if (name.toString().equals(\"Jay\")) {\n\n      System.out.println(\"Hello\\n\" + name.toString() + \"\\n\");\n\n} else {\n\n\n  System.out.println(\"Hi\\n\" + name.toString() + \"\\n\");\n\n\n}\n", (Object)javaScriptTask.getExecutionSet().getScript().getValue().getScript());
        Assert.assertEquals((Object)"java", (Object)javaScriptTask.getExecutionSet().getScript().getValue().getLanguage());
        Assert.assertEquals((Object)"true", (Object)javaScriptTask.getExecutionSet().getIsAsync().getValue().toString());
        Assert.assertEquals((Object)"false", (Object)javaScriptTask.getExecutionSet().getAdHocAutostart().getValue().toString());
    }

    @Test
    public void testUnmarshallSequenceFlow() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_SEQUENCEFLOW);
        SequenceFlow sequenceFlow1 = null;
        SequenceFlow sequenceFlow2 = null;
        Iterator<Element> it = this.nodesIterator(diagram);
        while (it.hasNext()) {
            Object oDefinition;
            Element element = it.next();
            if (!(element.getContent() instanceof View) || !((oDefinition = ((View)element.getContent()).getDefinition()) instanceof ExclusiveGateway)) continue;
            List outEdges = ((NodeImpl)element).getOutEdges();
            for (Edge edge : outEdges) {
                SequenceFlow flow = (SequenceFlow)((ViewConnectorImpl)edge.getContent()).getDefinition();
                if ("route1".equals(flow.getGeneral().getName().getValue())) {
                    sequenceFlow1 = flow;
                }
                if (!"route2".equals(flow.getGeneral().getName().getValue())) continue;
                sequenceFlow2 = flow;
            }
        }
        Assert.assertNotNull(sequenceFlow1);
        Assert.assertNotNull((Object)sequenceFlow1.getExecutionSet());
        Assert.assertNotNull((Object)sequenceFlow1.getExecutionSet().getConditionExpression());
        Assert.assertNotNull((Object)sequenceFlow1.getExecutionSet().getPriority());
        Assert.assertNotNull((Object)sequenceFlow1.getGeneral());
        Assert.assertNotNull((Object)sequenceFlow1.getGeneral().getName());
        Assert.assertEquals((Object)"route1", (Object)sequenceFlow1.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"age >= 10;", (Object)sequenceFlow1.getExecutionSet().getConditionExpression().getValue().getScript());
        Assert.assertEquals((Object)"javascript", (Object)sequenceFlow1.getExecutionSet().getConditionExpression().getValue().getLanguage());
        Assert.assertEquals((Object)"2", (Object)sequenceFlow1.getExecutionSet().getPriority().getValue());
        Assert.assertNotNull(sequenceFlow2);
        Assert.assertNotNull((Object)sequenceFlow2.getExecutionSet());
        Assert.assertNotNull((Object)sequenceFlow2.getExecutionSet().getConditionExpression());
        Assert.assertNotNull((Object)sequenceFlow2.getExecutionSet().getPriority());
        Assert.assertNotNull((Object)sequenceFlow2.getGeneral());
        Assert.assertNotNull((Object)sequenceFlow2.getGeneral().getName());
        Assert.assertEquals((Object)"route2", (Object)sequenceFlow2.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"age\n<\n10;", (Object)sequenceFlow2.getExecutionSet().getConditionExpression().getValue().getScript());
        Assert.assertEquals((Object)"java", (Object)sequenceFlow2.getExecutionSet().getConditionExpression().getValue().getLanguage());
        Assert.assertEquals((Object)"1", (Object)sequenceFlow2.getExecutionSet().getPriority().getValue());
    }

    @Test
    public void testUnmarshallBusinessRuleTask() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_BUSINESSRULETASKRULEFLOWGROUP);
        BusinessRuleTask businessRuleTask = null;
        Iterator<Element> it = this.nodesIterator(diagram);
        while (it.hasNext()) {
            Object oDefinition;
            Element element = it.next();
            if (!(element.getContent() instanceof View) || !((oDefinition = ((View)element.getContent()).getDefinition()) instanceof BusinessRuleTask)) continue;
            businessRuleTask = (BusinessRuleTask)oDefinition;
            break;
        }
        Assert.assertNotNull(businessRuleTask);
        Assert.assertNotNull((Object)businessRuleTask.getExecutionSet());
        Assert.assertNotNull((Object)businessRuleTask.getExecutionSet().getRuleFlowGroup());
        Assert.assertNotNull((Object)businessRuleTask.getGeneral());
        Assert.assertNotNull((Object)businessRuleTask.getGeneral().getName());
        Assert.assertEquals((Object)businessRuleTask.getTaskType().getValue(), (Object)TaskTypes.BUSINESS_RULE);
        Assert.assertEquals((Object)"my business rule task", (Object)businessRuleTask.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"my-ruleflow-group", (Object)businessRuleTask.getExecutionSet().getRuleFlowGroup().getValue());
        Assert.assertEquals((Object)"true", (Object)businessRuleTask.getExecutionSet().getIsAsync().getValue().toString());
        Assert.assertEquals((Object)"true", (Object)businessRuleTask.getExecutionSet().getIsAsync().getValue().toString());
        Assert.assertEquals((Object)"System.out.println(\"Hello\");", (Object)((ScriptTypeValue)businessRuleTask.getExecutionSet().getOnEntryAction().getValue().getValues().get(0)).getScript());
        Assert.assertEquals((Object)"java", (Object)((ScriptTypeValue)businessRuleTask.getExecutionSet().getOnEntryAction().getValue().getValues().get(0)).getLanguage());
        Assert.assertEquals((Object)"System.out.println(\"Bye\");", (Object)((ScriptTypeValue)businessRuleTask.getExecutionSet().getOnExitAction().getValue().getValues().get(0)).getScript());
        Assert.assertEquals((Object)"java", (Object)((ScriptTypeValue)businessRuleTask.getExecutionSet().getOnExitAction().getValue().getValues().get(0)).getLanguage());
    }

    @Test
    public void testUnmarshallXorGateway() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_XORGATEWAY);
        Assertions.assertDiagram(diagram, 7);
        Assert.assertEquals((Object)diagram.getMetadata().getTitle(), (Object)"XORGateway");
        Graph graph = diagram.getGraph();
        Node gatewayNode = graph.getNode("_877EA035-1A14-42E9-8CAA-43E9BF908C70");
        ExclusiveGateway xorGateway = (ExclusiveGateway)((Definition)gatewayNode.getContent()).getDefinition();
        Assert.assertEquals((Object)"AgeSplit", (Object)xorGateway.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"_5110D608-BDAD-47BF-A3F9-E1DBE43ED7CD", (Object)xorGateway.getExecutionSet().getDefaultRoute().getValue());
        SequenceFlow sequenceFlow1 = null;
        SequenceFlow sequenceFlow2 = null;
        List outEdges = gatewayNode.getOutEdges();
        if (outEdges != null) {
            for (Edge edge : outEdges) {
                if ("_C72E00C3-70DC-4BC9-A08E-761B4263A239".equals(edge.getUUID())) {
                    sequenceFlow1 = (SequenceFlow)((ViewConnector)edge.getContent()).getDefinition();
                    continue;
                }
                if (!"_5110D608-BDAD-47BF-A3F9-E1DBE43ED7CD".equals(edge.getUUID())) continue;
                sequenceFlow2 = (SequenceFlow)((ViewConnector)edge.getContent()).getDefinition();
            }
        }
        Assert.assertNotNull(sequenceFlow1);
        Assert.assertEquals((Object)"10 and over", (Object)sequenceFlow1.getGeneral().getName().getValue());
        Assert.assertNotNull(sequenceFlow2);
        Assert.assertEquals((Object)"under 10", (Object)sequenceFlow2.getGeneral().getName().getValue());
    }

    @Test
    public void testUnmarshallInclusiveGateway() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_INCLUSIVE_GATEWAY);
        Assertions.assertDiagram(diagram, 7);
        Assert.assertEquals((Object)diagram.getMetadata().getTitle(), (Object)"TestInclusiveGateway");
        Graph graph = diagram.getGraph();
        Node gatewayNode = graph.getNode("_526EE472-FE8B-4E9A-A951-CFBA86C3691F");
        Assert.assertTrue((boolean)(((Definition)gatewayNode.getContent()).getDefinition() instanceof InclusiveGateway));
        InclusiveGateway inclusiveGateway = (InclusiveGateway)((Definition)gatewayNode.getContent()).getDefinition();
        Assert.assertEquals((Object)"InclusiveGatewayName", (Object)inclusiveGateway.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"_3D5701E9-CFD3-4218-9200-897B6D4FF041", (Object)inclusiveGateway.getExecutionSet().getDefaultRoute().getValue());
        SequenceFlow sequenceFlow1 = null;
        SequenceFlow sequenceFlow2 = null;
        List outEdges = gatewayNode.getOutEdges();
        if (outEdges != null) {
            for (Edge edge : outEdges) {
                if ("_3D5701E9-CFD3-4218-9200-897B6D4FF041".equals(edge.getUUID())) {
                    sequenceFlow1 = (SequenceFlow)((ViewConnector)edge.getContent()).getDefinition();
                    continue;
                }
                if (!"_A414F16D-90BB-4742-A4E7-EBF7EA1ECD7E".equals(edge.getUUID())) continue;
                sequenceFlow2 = (SequenceFlow)((ViewConnector)edge.getContent()).getDefinition();
            }
        }
        Assert.assertNotNull(sequenceFlow1);
        Assert.assertEquals((Object)"OutSequence1", (Object)sequenceFlow1.getGeneral().getName().getValue());
        Assert.assertNotNull(sequenceFlow2);
        Assert.assertEquals((Object)"OutSequence2", (Object)sequenceFlow2.getGeneral().getName().getValue());
    }

    @Test
    public void testUnmarshallReusableSubprocess() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_REUSABLE_SUBPROCESS);
        ReusableSubprocess reusableSubprocess = null;
        Iterator<Element> it = this.nodesIterator(diagram);
        while (it.hasNext()) {
            Object oDefinition;
            Element element = it.next();
            if (!(element.getContent() instanceof View) || !((oDefinition = ((View)element.getContent()).getDefinition()) instanceof ReusableSubprocess)) continue;
            reusableSubprocess = (ReusableSubprocess)oDefinition;
            break;
        }
        Assert.assertNotNull(reusableSubprocess);
        Assert.assertNotNull((Object)reusableSubprocess.getExecutionSet());
        Assert.assertNotNull((Object)reusableSubprocess.getExecutionSet().getCalledElement());
        Assert.assertNotNull((Object)reusableSubprocess.getGeneral());
        BPMNGeneralSet generalSet = reusableSubprocess.getGeneral();
        ReusableSubprocessTaskExecutionSet executionSet = reusableSubprocess.getExecutionSet();
        Assert.assertNotNull((Object)generalSet);
        Assert.assertNotNull((Object)executionSet);
        Assert.assertEquals((Object)"my subprocess", (Object)generalSet.getName().getValue());
        Assert.assertEquals((Object)"my-called-element\" <&> \"", (Object)executionSet.getCalledElement().getValue());
        Assert.assertEquals((Object)false, (Object)executionSet.getIndependent().getValue());
        Assert.assertEquals((Object)true, (Object)executionSet.getWaitForCompletion().getValue());
        String assignmentsInfo = reusableSubprocess.getDataIOSet().getAssignmentsinfo().getValue();
        Assert.assertEquals((Object)"|input1:String,input2:Float||output1:String,output2:Float|[din]pv1->input1,[din]pv2->input2,[dout]output1->pv1,[dout]output2->pv2", (Object)assignmentsInfo);
        Assert.assertEquals((Object)"true", (Object)reusableSubprocess.getExecutionSet().getIsAsync().getValue().toString());
        String SLA_DUE_DATE = "12/25/1983";
        Assert.assertEquals((Object)"12/25/1983", (Object)executionSet.getSlaDueDate().getValue());
    }

    @Test
    public void testUnmarshallReusableSubprocessMI() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_REUSABLE_SUBPROCESS_MI);
        Assertions.assertDiagram(diagram, 4);
        Assert.assertEquals((Object)"reusableSubProcessMI", (Object)diagram.getMetadata().getTitle());
        Node node = diagram.getGraph().getNode("_CACC5C21-CE79-4445-9411-BE8C7A75E860");
        Assert.assertNotNull((Object)node);
        ReusableSubprocess subprocess = (ReusableSubprocess)((Definition)node.getContent()).getDefinition();
        Assert.assertNotNull((Object)subprocess);
        Assert.assertEquals((Object)"TheReusableSubProcess", (Object)subprocess.getGeneral().getName().getValue());
        ReusableSubprocessTaskExecutionSet executionSet = subprocess.getExecutionSet();
        Assert.assertEquals((Object)"test.SubProcess", (Object)executionSet.getCalledElement().getValue());
        Assert.assertTrue((boolean)executionSet.getIsMultipleInstance().getValue());
        Assert.assertEquals((Object)"theInputCollection", (Object)executionSet.getMultipleInstanceCollectionInput().getValue());
        Assert.assertEquals((Object)"theInputVariable:java.lang.Object", (Object)executionSet.getMultipleInstanceDataInput().getValue());
        Assert.assertEquals((Object)"theOutputCollection", (Object)executionSet.getMultipleInstanceCollectionOutput().getValue());
        Assert.assertEquals((Object)"theOutputVariable:java.lang.Object", (Object)executionSet.getMultipleInstanceDataOutput().getValue());
        Assert.assertEquals((Object)"theCompletionCondition", (Object)executionSet.getMultipleInstanceCompletionCondition().getValue());
        String SLA_DUE_DATE = "12/25/1983";
        Assert.assertEquals((Object)"12/25/1983", (Object)executionSet.getSlaDueDate().getValue());
    }

    @Test
    public void testUnmarshallAddHocSubprocess() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_ADHOC_SUBPROCESS);
        AdHocSubprocess adHocSubprocess = null;
        Iterator<Element> it = this.nodesIterator(diagram);
        while (it.hasNext()) {
            Object oDefinition;
            Element element = it.next();
            if (!(element.getContent() instanceof View) || !((oDefinition = ((View)element.getContent()).getDefinition()) instanceof AdHocSubprocess)) continue;
            adHocSubprocess = (AdHocSubprocess)oDefinition;
            break;
        }
        Assert.assertNotNull(adHocSubprocess);
        BPMNGeneralSet generalSet = adHocSubprocess.getGeneral();
        AdHocSubprocessTaskExecutionSet executionSet = adHocSubprocess.getExecutionSet();
        ProcessData processData = adHocSubprocess.getProcessData();
        Assert.assertNotNull((Object)generalSet);
        Assert.assertNotNull((Object)executionSet);
        Assert.assertNotNull((Object)processData);
        Assert.assertEquals((Object)"AdHocSubprocess1", (Object)generalSet.getName().getValue());
        Assert.assertEquals((Object)"AdHocSubprocess1Documentation", (Object)generalSet.getDocumentation().getValue());
        Assert.assertNotNull((Object)executionSet.getAdHocCompletionCondition());
        Assert.assertNotNull((Object)executionSet.getAdHocCompletionCondition().getValue());
        Assert.assertNotNull((Object)executionSet.getAdHocOrdering());
        Assert.assertNotNull((Object)executionSet.getOnEntryAction());
        Assert.assertNotNull((Object)executionSet.getOnExitAction());
        Assert.assertEquals((Object)"autocomplete", (Object)executionSet.getAdHocCompletionCondition().getValue().getScript());
        Assert.assertEquals((Object)"drools", (Object)executionSet.getAdHocCompletionCondition().getValue().getLanguage());
        Assert.assertEquals((Object)"Sequential", (Object)executionSet.getAdHocOrdering().getValue());
        Assert.assertEquals((long)1L, (long)executionSet.getOnEntryAction().getValue().getValues().size());
        Assert.assertEquals((Object)"System.out.println(\"onEntryAction\");", (Object)((ScriptTypeValue)executionSet.getOnEntryAction().getValue().getValues().get(0)).getScript());
        Assert.assertEquals((Object)"mvel", (Object)((ScriptTypeValue)executionSet.getOnEntryAction().getValue().getValues().get(0)).getLanguage());
        Assert.assertEquals((long)1L, (long)executionSet.getOnExitAction().getValue().getValues().size());
        Assert.assertEquals((Object)"System.out.println(\"onExitAction\");", (Object)((ScriptTypeValue)executionSet.getOnExitAction().getValue().getValues().get(0)).getScript());
        Assert.assertEquals((Object)"java", (Object)((ScriptTypeValue)executionSet.getOnExitAction().getValue().getValues().get(0)).getLanguage());
        Assert.assertEquals((Object)"subProcessVar1:String:[],subProcessVar2:String:[]", (Object)processData.getProcessVariables().getValue());
        Assert.assertTrue((boolean)executionSet.getIsAsync().getValue());
        String SLA_DUE_DATE = "12/25/1983";
        Assert.assertEquals((Object)"12/25/1983", (Object)executionSet.getSlaDueDate().getValue());
    }

    @Test
    public void testUnmarshallMagnetDockers() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_MAGNETDOCKERS);
        this.testMagnetDockers(diagram);
    }

    private void testMagnetDockers(Diagram<Graph, Metadata> diagram) {
        Node userTaskNode = (Node)this.findElementByContentType(diagram, org.kie.workbench.common.stunner.bpmn.definition.UserTask.class);
        Node businessRuleTaskNode = (Node)this.findElementByContentType(diagram, BusinessRuleTask.class);
        Node scriptTaskNode = (Node)this.findElementByContentType(diagram, ScriptTask.class);
        Assert.assertNotNull((Object)userTaskNode);
        Assert.assertNotNull((Object)businessRuleTaskNode);
        Assert.assertNotNull((Object)scriptTaskNode);
        ViewConnector userTaskInEdgeConnector = this.getInEdgeViewConnector(userTaskNode);
        ViewConnector businessRuleTaskInEdgeConnector = this.getInEdgeViewConnector(businessRuleTaskNode);
        ViewConnector scriptTaskInEdgeConnector = this.getInEdgeViewConnector(scriptTaskNode);
        Assert.assertNotNull((Object)userTaskInEdgeConnector);
        Assert.assertNotNull((Object)businessRuleTaskInEdgeConnector);
        Assert.assertNotNull((Object)scriptTaskInEdgeConnector);
        ViewConnector userTaskOutEdgeConnector = this.getOutEdgeViewConnector(userTaskNode);
        ViewConnector businessRuleTaskOutEdgeConnector = this.getOutEdgeViewConnector(businessRuleTaskNode);
        ViewConnector scriptTaskOutEdgeConnector = this.getOutEdgeViewConnector(scriptTaskNode);
        Assert.assertNotNull((Object)userTaskOutEdgeConnector);
        Assert.assertNotNull((Object)businessRuleTaskOutEdgeConnector);
        Assert.assertNotNull((Object)scriptTaskOutEdgeConnector);
        Assert.assertTrue((boolean)userTaskInEdgeConnector.getSourceConnection().isPresent());
        Assert.assertTrue((boolean)userTaskInEdgeConnector.getTargetConnection().isPresent());
        DiscreteConnection sourceConnection = (DiscreteConnection)userTaskInEdgeConnector.getSourceConnection().get();
        DiscreteConnection targetConnection = (DiscreteConnection)userTaskInEdgeConnector.getTargetConnection().get();
        Assert.assertEquals((double)20.0, (double)sourceConnection.getLocation().getX(), (double)0.1);
        Assert.assertEquals((double)0.0, (double)sourceConnection.getLocation().getY(), (double)0.1);
        Assert.assertEquals((double)0.0, (double)targetConnection.getLocation().getX(), (double)0.1);
        Assert.assertEquals((double)24.0, (double)targetConnection.getLocation().getY(), (double)0.1);
        Assert.assertTrue((boolean)sourceConnection.isAuto());
        Assert.assertTrue((boolean)targetConnection.isAuto());
        Assert.assertTrue((boolean)businessRuleTaskInEdgeConnector.getSourceConnection().isPresent());
        Assert.assertTrue((boolean)businessRuleTaskInEdgeConnector.getTargetConnection().isPresent());
        sourceConnection = (DiscreteConnection)businessRuleTaskInEdgeConnector.getSourceConnection().get();
        targetConnection = (DiscreteConnection)businessRuleTaskInEdgeConnector.getTargetConnection().get();
        Assert.assertEquals((double)40.0, (double)sourceConnection.getLocation().getX(), (double)0.1);
        Assert.assertEquals((double)20.0, (double)sourceConnection.getLocation().getY(), (double)0.1);
        Assert.assertEquals((double)0.0, (double)targetConnection.getLocation().getX(), (double)0.1);
        Assert.assertEquals((double)0.0, (double)targetConnection.getLocation().getY(), (double)0.1);
        Assert.assertFalse((boolean)sourceConnection.isAuto());
        Assert.assertFalse((boolean)targetConnection.isAuto());
        Assert.assertTrue((boolean)scriptTaskInEdgeConnector.getSourceConnection().isPresent());
        Assert.assertTrue((boolean)scriptTaskInEdgeConnector.getTargetConnection().isPresent());
        sourceConnection = (DiscreteConnection)scriptTaskInEdgeConnector.getSourceConnection().get();
        targetConnection = (DiscreteConnection)scriptTaskInEdgeConnector.getTargetConnection().get();
        Assert.assertEquals((double)0.0, (double)sourceConnection.getLocation().getX(), (double)0.1);
        Assert.assertEquals((double)40.0, (double)sourceConnection.getLocation().getY(), (double)0.1);
        Assert.assertEquals((double)0.0, (double)targetConnection.getLocation().getX(), (double)0.1);
        Assert.assertEquals((double)48.0, (double)targetConnection.getLocation().getY(), (double)0.1);
        Assert.assertTrue((boolean)userTaskOutEdgeConnector.getSourceConnection().isPresent());
        Assert.assertTrue((boolean)userTaskOutEdgeConnector.getTargetConnection().isPresent());
        sourceConnection = (DiscreteConnection)userTaskOutEdgeConnector.getSourceConnection().get();
        targetConnection = (DiscreteConnection)userTaskOutEdgeConnector.getTargetConnection().get();
        Assert.assertEquals((double)136.0, (double)sourceConnection.getLocation().getX(), (double)0.1);
        Assert.assertEquals((double)24.0, (double)sourceConnection.getLocation().getY(), (double)0.1);
        Assert.assertEquals((double)0.0, (double)targetConnection.getLocation().getX(), (double)0.1);
        Assert.assertEquals((double)14.0, (double)targetConnection.getLocation().getY(), (double)0.1);
        Assert.assertTrue((boolean)businessRuleTaskOutEdgeConnector.getSourceConnection().isPresent());
        Assert.assertTrue((boolean)businessRuleTaskOutEdgeConnector.getTargetConnection().isPresent());
        sourceConnection = (DiscreteConnection)businessRuleTaskOutEdgeConnector.getSourceConnection().get();
        targetConnection = (DiscreteConnection)businessRuleTaskOutEdgeConnector.getTargetConnection().get();
        Assert.assertEquals((double)68.0, (double)sourceConnection.getLocation().getX(), (double)0.1);
        Assert.assertEquals((double)48.0, (double)sourceConnection.getLocation().getY(), (double)0.1);
        Assert.assertEquals((double)14.0, (double)targetConnection.getLocation().getX(), (double)0.1);
        Assert.assertEquals((double)28.0, (double)targetConnection.getLocation().getY(), (double)0.1);
        Assert.assertTrue((boolean)scriptTaskOutEdgeConnector.getSourceConnection().isPresent());
        Assert.assertTrue((boolean)scriptTaskOutEdgeConnector.getTargetConnection().isPresent());
        sourceConnection = (DiscreteConnection)scriptTaskOutEdgeConnector.getSourceConnection().get();
        targetConnection = (DiscreteConnection)scriptTaskOutEdgeConnector.getTargetConnection().get();
        Assert.assertEquals((double)0.0, (double)sourceConnection.getLocation().getX(), (double)0.1);
        Assert.assertEquals((double)0.0, (double)sourceConnection.getLocation().getY(), (double)0.1);
        Assert.assertEquals((double)0.0, (double)targetConnection.getLocation().getX(), (double)0.1);
        Assert.assertEquals((double)0.0, (double)targetConnection.getLocation().getY(), (double)0.1);
    }

    @Test
    public void testUnmarshallMagnetsInLane() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_MAGNETSINLANE);
        this.testMagnetsInLane(diagram);
    }

    private void testMagnetsInLane(Diagram<Graph, Metadata> diagram) throws Exception {
        Node userTaskNode = (Node)this.findElementByContentType(diagram, org.kie.workbench.common.stunner.bpmn.definition.UserTask.class);
        Node scriptTaskNode = (Node)this.findElementByContentType(diagram, ScriptTask.class);
        Assert.assertNotNull((Object)userTaskNode);
        Assert.assertNotNull((Object)scriptTaskNode);
        ViewConnector userTaskInEdgeConnector = this.getInEdgeViewConnector(userTaskNode);
        ViewConnector scriptTaskInEdgeConnector = this.getInEdgeViewConnector(scriptTaskNode);
        Assert.assertNotNull((Object)userTaskInEdgeConnector);
        Assert.assertNotNull((Object)scriptTaskInEdgeConnector);
        ViewConnector userTaskOutEdgeConnector = this.getOutEdgeViewConnector(userTaskNode);
        ViewConnector scriptTaskOutEdgeConnector = this.getOutEdgeViewConnector(scriptTaskNode);
        Assert.assertNotNull((Object)userTaskOutEdgeConnector);
        Assert.assertNotNull((Object)scriptTaskOutEdgeConnector);
        Assert.assertTrue((boolean)userTaskInEdgeConnector.getSourceConnection().isPresent());
        Assert.assertTrue((boolean)userTaskInEdgeConnector.getTargetConnection().isPresent());
        Connection sourceConnection = (Connection)userTaskInEdgeConnector.getSourceConnection().get();
        Connection targetConnection = (Connection)userTaskInEdgeConnector.getTargetConnection().get();
        Assert.assertEquals((double)136.0, (double)sourceConnection.getLocation().getX(), (double)0.1);
        Assert.assertEquals((double)24.0, (double)sourceConnection.getLocation().getY(), (double)0.1);
        Assert.assertEquals((double)68.0, (double)targetConnection.getLocation().getX(), (double)0.1);
        Assert.assertEquals((double)0.0, (double)targetConnection.getLocation().getY(), (double)0.1);
        Assert.assertTrue((boolean)scriptTaskInEdgeConnector.getSourceConnection().isPresent());
        Assert.assertTrue((boolean)scriptTaskInEdgeConnector.getTargetConnection().isPresent());
        sourceConnection = (Connection)scriptTaskInEdgeConnector.getSourceConnection().get();
        targetConnection = (Connection)scriptTaskInEdgeConnector.getTargetConnection().get();
        Assert.assertEquals((double)136.0, (double)sourceConnection.getLocation().getX(), (double)0.1);
        Assert.assertEquals((double)48.0, (double)sourceConnection.getLocation().getY(), (double)0.1);
        Assert.assertEquals((double)0.0, (double)targetConnection.getLocation().getX(), (double)0.1);
        Assert.assertEquals((double)0.0, (double)targetConnection.getLocation().getY(), (double)0.1);
        Assert.assertTrue((boolean)userTaskOutEdgeConnector.getSourceConnection().isPresent());
        Assert.assertTrue((boolean)userTaskOutEdgeConnector.getTargetConnection().isPresent());
        sourceConnection = (Connection)userTaskOutEdgeConnector.getSourceConnection().get();
        targetConnection = (Connection)userTaskOutEdgeConnector.getTargetConnection().get();
        Assert.assertEquals((double)136.0, (double)sourceConnection.getLocation().getX(), (double)0.1);
        Assert.assertEquals((double)48.0, (double)sourceConnection.getLocation().getY(), (double)0.1);
        Assert.assertEquals((double)0.0, (double)targetConnection.getLocation().getX(), (double)0.1);
        Assert.assertEquals((double)0.0, (double)targetConnection.getLocation().getY(), (double)0.1);
        Assert.assertTrue((boolean)scriptTaskOutEdgeConnector.getSourceConnection().isPresent());
        Assert.assertTrue((boolean)scriptTaskOutEdgeConnector.getTargetConnection().isPresent());
        sourceConnection = (Connection)scriptTaskOutEdgeConnector.getSourceConnection().get();
        targetConnection = (Connection)scriptTaskOutEdgeConnector.getTargetConnection().get();
        Assert.assertEquals((double)136.0, (double)sourceConnection.getLocation().getX(), (double)0.1);
        Assert.assertEquals((double)0.0, (double)sourceConnection.getLocation().getY(), (double)0.1);
        Assert.assertEquals((double)0.0, (double)targetConnection.getLocation().getX(), (double)0.1);
        Assert.assertEquals((double)14.0, (double)targetConnection.getLocation().getY(), (double)0.1);
    }

    @Test
    public void testUnmarshallEventDefinitionRef() {
        try {
            Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_EVENT_DEFINITION_REF);
            Node intermediateTimerEvent = diagram.getGraph().getNode("FLOWNODE_9e71d692-986c-11e7-40d3-005056844bde");
            IntermediateTimerEvent definition = (IntermediateTimerEvent)((Definition)intermediateTimerEvent.getContent()).getDefinition();
            CancellingTimerEventExecutionSet executionSet = definition.getExecutionSet();
            TimerSettings timerSettings = executionSet.getTimerSettings();
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testMarshallBasic() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_BASIC);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 3, 2);
    }

    @Test
    public void testMarshallEvaluation() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_EVALUATION);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 7, 7);
    }

    @Test
    public void testMarshallNotBoundaryEvents() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_NOT_BOUNDARY_EVENTS);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 5, 4);
    }

    @Test
    public void testMarshallBoundaryEvents() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_BOUNDARY_EVENTS);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 5, 3);
        Assert.assertTrue((boolean)result.contains("Bounds height=\"56.0\" width=\"56.0\" x=\"327.0\" y=\"210.0\""));
    }

    @Test
    public void testMarshallProcessVariables() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_PROCESSVARIABLES);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 7, 7);
        Definitions definitions = new DefinitionsConverter(diagram.getGraph()).toDefinitions();
        Assert.assertNotNull((Object)definitions);
        List rootElements = definitions.getRootElements();
        Assert.assertNotNull((Object)rootElements);
        this.assertItemExists(rootElements, "_employeeItem", "java.lang.String");
        this.assertItemExists(rootElements, "_reasonItem", "java.lang.String");
        this.assertItemExists(rootElements, "_performanceItem", "java.lang.String");
        Process process = this.getProcess(definitions);
        Assert.assertNotNull((Object)process);
        List properties = process.getProperties();
        Assert.assertNotNull((Object)properties);
        Assert.assertNotNull((Object)this.getProcessProperty(properties, "employee", "_employeeItem"));
        Assert.assertNotNull((Object)this.getProcessProperty(properties, "reason", "_reasonItem"));
        Assert.assertNotNull((Object)this.getProcessProperty(properties, "performance", "_performanceItem"));
    }

    @Test
    public void testMarshallProcessProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_PROCESSPROPERTIES);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 3, 2);
        Definitions definitions = new DefinitionsConverter(diagram.getGraph()).toDefinitions();
        Assert.assertNotNull((Object)definitions);
        Process process = this.getProcess(definitions);
        Assert.assertNotNull((Object)process);
        Assert.assertEquals((Object)"JDLProj.BPSimple", (Object)process.getId());
        Assert.assertEquals((Object)"BPSimple", (Object)process.getName());
        Assert.assertTrue((boolean)process.isIsExecutable());
        Assert.assertEquals((Object)"true", (Object)this.getProcessPropertyValue(process, "adHoc"));
        Assert.assertEquals((Object)"org.jbpm", (Object)this.getProcessPropertyValue(process, "packageName"));
        Assert.assertEquals((Object)"1.0", (Object)this.getProcessPropertyValue(process, "version"));
        Assert.assertNotNull((Object)process.getDocumentation());
        Assert.assertFalse((boolean)process.getDocumentation().isEmpty());
        Assert.assertEquals((Object)"<![CDATA[This is a\nsimple\nprocess]]>", (Object)((Documentation)process.getDocumentation().get(0)).getText());
        Assert.assertEquals((Object)"<![CDATA[This is the\nProcess\nInstance\nDescription]]>", (Object)this.getProcessExtensionValue(process, "customDescription"));
        Assert.assertEquals((Object)"<![CDATA[12/25/1983]]>", (Object)this.getProcessExtensionValue(process, "customSLADueDate"));
    }

    @Test
    public void testMarshallUserTaskAssignments() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_USERTASKASSIGNMENTS);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 7, 7);
        DefinitionsConverter definitionsConverter = new DefinitionsConverter(diagram.getGraph());
        Definitions definitions = definitionsConverter.toDefinitions();
        Assert.assertNotNull((Object)definitions);
        Process process = this.getProcess(definitions);
        Assert.assertNotNull((Object)process);
        UserTask userTask = (UserTask)this.getNamedFlowElement(process, UserTask.class, "Self Evaluation");
        Assert.assertNotNull((Object)userTask);
        DataInput dataInput = this.getDataInput((Activity)userTask, "reason");
        this.validateDataInputOrOutput((ItemAwareElement)dataInput, "_reasonInputX", "com.test.Reason", "_reasonInputXItem");
        DataOutput dataOutput = this.getDataOutput((Activity)userTask, "performance");
        this.validateDataInputOrOutput((ItemAwareElement)dataOutput, "_performanceOutputX", "Object", "_performanceOutputXItem");
        ItemAwareElement sourceRef = this.getDataInputAssociationSourceRef((Activity)userTask, "reason");
        Assert.assertNotNull((Object)sourceRef);
        ItemAwareElement targetRef = this.getDataInputAssociationTargetRef((Activity)userTask, "_reasonInputX");
        Assert.assertNotNull((Object)targetRef);
        sourceRef = this.getDataOutputAssociationSourceRef((Activity)userTask, "_performanceOutputX");
        Assert.assertNotNull((Object)sourceRef);
        targetRef = this.getDataOutputAssociationTargetRef((Activity)userTask, "performance");
        Assert.assertNotNull((Object)targetRef);
    }

    @Test
    public void testMarshallUserTaskMI() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_USERTASK_MI);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 3, 2);
        Assert.assertTrue((boolean)result.contains("<bpmn2:itemDefinition id=\"_CACC5C21-CE79-4445-9411-BE8C7A75E860_multiInstanceItemType_theInputVariable\" structureRef=\"java.lang.Object\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:itemDefinition id=\"_CACC5C21-CE79-4445-9411-BE8C7A75E860_multiInstanceItemType_theOutputVariable\" structureRef=\"java.lang.Object\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:dataInput id=\"_CACC5C21-CE79-4445-9411-BE8C7A75E860_IN_COLLECTIONInputX\" itemSubjectRef=\"_theInputCollectionItem\" name=\"IN_COLLECTION\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:dataInput id=\"_CACC5C21-CE79-4445-9411-BE8C7A75E860_theInputVariableInputX\" itemSubjectRef=\"_CACC5C21-CE79-4445-9411-BE8C7A75E860_multiInstanceItemType_theInputVariable\" name=\"theInputVariable\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:dataOutput id=\"_CACC5C21-CE79-4445-9411-BE8C7A75E860_OUT_COLLECTIONOutputX\" itemSubjectRef=\"_theOutputCollectionItem\" name=\"OUT_COLLECTION\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:dataOutput id=\"_CACC5C21-CE79-4445-9411-BE8C7A75E860_theOutputVariableOutputX\" itemSubjectRef=\"_CACC5C21-CE79-4445-9411-BE8C7A75E860_multiInstanceItemType_theOutputVariable\" name=\"theOutputVariable\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:dataInputRefs>_CACC5C21-CE79-4445-9411-BE8C7A75E860_IN_COLLECTIONInputX</bpmn2:dataInputRefs>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:dataInputRefs>_CACC5C21-CE79-4445-9411-BE8C7A75E860_theInputVariableInputX</bpmn2:dataInputRefs>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:dataOutputRefs>_CACC5C21-CE79-4445-9411-BE8C7A75E860_OUT_COLLECTIONOutputX</bpmn2:dataOutputRefs>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:dataOutputRefs>_CACC5C21-CE79-4445-9411-BE8C7A75E860_theOutputVariableOutputX</bpmn2:dataOutputRefs>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:sourceRef>theInputCollection</bpmn2:sourceRef>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:targetRef>_CACC5C21-CE79-4445-9411-BE8C7A75E860_IN_COLLECTIONInputX</bpmn2:targetRef>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:sourceRef>theInputVariable</bpmn2:sourceRef>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:targetRef>_CACC5C21-CE79-4445-9411-BE8C7A75E860_theInputVariableInputX</bpmn2:targetRef>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:sourceRef>_CACC5C21-CE79-4445-9411-BE8C7A75E860_OUT_COLLECTIONOutputX</bpmn2:sourceRef>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:targetRef>theOutputCollection</bpmn2:targetRef>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:sourceRef>_CACC5C21-CE79-4445-9411-BE8C7A75E860_theOutputVariableOutputX</bpmn2:sourceRef>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:targetRef>theOutputVariable</bpmn2:targetRef>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:multiInstanceLoopCharacteristics"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:loopDataInputRef>_CACC5C21-CE79-4445-9411-BE8C7A75E860_IN_COLLECTIONInputX</bpmn2:loopDataInputRef>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:loopDataOutputRef>_CACC5C21-CE79-4445-9411-BE8C7A75E860_OUT_COLLECTIONOutputX</bpmn2:loopDataOutputRef>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:inputDataItem xsi:type=\"bpmn2:tDataInput\" id=\"theInputVariable\" itemSubjectRef=\"_CACC5C21-CE79-4445-9411-BE8C7A75E860_multiInstanceItemType_theInputVariable\" name=\"theInputVariable\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:outputDataItem xsi:type=\"bpmn2:tDataOutput\" id=\"theOutputVariable\" itemSubjectRef=\"_CACC5C21-CE79-4445-9411-BE8C7A75E860_multiInstanceItemType_theOutputVariable\" name=\"theOutputVariable\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:completionCondition xsi:type=\"bpmn2:tFormalExpression\" id=\""));
        Assert.assertTrue((boolean)result.contains("<![CDATA[theCompletionCondition]]></bpmn2:completionCondition>"));
        Assert.assertTrue((boolean)result.contains("</bpmn2:multiInstanceLoopCharacteristics>"));
    }

    @Test
    public void testMarshallBusinessRuleTaskAssignments() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_BUSINESSRULETASKASSIGNMENTS);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 3, 2);
        Assert.assertTrue((boolean)result.contains("<bpmn2:dataInput id=\"_45C2C340-D1D0-4D63-8419-EF38F9E73507_input1InputX\" drools:dtype=\"String\" itemSubjectRef=\"__45C2C340-D1D0-4D63-8419-EF38F9E73507_input1InputXItem\" name=\"input1\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:dataInput id=\"_45C2C340-D1D0-4D63-8419-EF38F9E73507_input2InputX\" drools:dtype=\"String\" itemSubjectRef=\"__45C2C340-D1D0-4D63-8419-EF38F9E73507_input2InputXItem\" name=\"input2\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:dataOutput id=\"_45C2C340-D1D0-4D63-8419-EF38F9E73507_output1OutputX\" drools:dtype=\"String\" itemSubjectRef=\"__45C2C340-D1D0-4D63-8419-EF38F9E73507_output1OutputXItem\" name=\"output1\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:dataOutput id=\"_45C2C340-D1D0-4D63-8419-EF38F9E73507_output2OutputX\" drools:dtype=\"String\" itemSubjectRef=\"__45C2C340-D1D0-4D63-8419-EF38F9E73507_output2OutputXItem\" name=\"output2\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:dataInputRefs>_45C2C340-D1D0-4D63-8419-EF38F9E73507_input1InputX</bpmn2:dataInputRefs>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:dataInputRefs>_45C2C340-D1D0-4D63-8419-EF38F9E73507_input2InputX</bpmn2:dataInputRefs>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:dataOutputRefs>_45C2C340-D1D0-4D63-8419-EF38F9E73507_output1OutputX</bpmn2:dataOutputRefs>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:dataOutputRefs>_45C2C340-D1D0-4D63-8419-EF38F9E73507_output2OutputX</bpmn2:dataOutputRefs>"));
    }

    @Test
    public void testMarshallStartNoneEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_STARTNONEEVENT);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 3, 2);
        Assert.assertTrue((boolean)result.contains("<bpmn2:startEvent"));
        Assert.assertTrue((boolean)result.contains("name=\"MyStartNoneEvent\""));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[MyStartNoneEvent]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("<![CDATA[MyStartNoneEventDocumentation]]></bpmn2:documentation>"));
        Assert.assertTrue((boolean)result.contains("</bpmn2:startEvent>"));
        Assert.assertTrue((boolean)result.contains("<drools:metaData name=\"customSLADueDate\">"));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[12/25/1983]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("</drools:metaData>"));
    }

    @Test
    public void testMarshallStartTimerEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_STARTTIMEREVENT);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 3, 2);
        Assert.assertTrue((boolean)result.contains("name=\"StartTimer\" isInterrupting=\"false\">"));
        Assert.assertTrue((boolean)result.contains("name=\"StartTimer\" isInterrupting=\"false\">"));
        Assert.assertTrue((boolean)result.contains("P4H</bpmn2:timeDuration>"));
        Assert.assertTrue((boolean)result.contains("language=\"cron\">*/2 * * * *</bpmn2:timeCycle>"));
        Assert.assertTrue((boolean)result.contains("<drools:metaData name=\"customSLADueDate\">"));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[12/25/1983]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("</drools:metaData>"));
    }

    @Test
    public void testMarshallStartSignalEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_STARTSIGNALEVENT);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 3, 2);
        Assert.assertTrue((boolean)result.contains("<bpmn2:startEvent"));
        Assert.assertTrue((boolean)result.contains(" name=\"StartSignalEvent1\""));
        Assert.assertTrue((boolean)result.contains("<bpmn2:signal id=\"_47718ea6-a6a4-3ceb-9e93-2111bdad0b8c\" name=\"sig1\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:signalEventDefinition"));
        Assert.assertTrue((boolean)result.contains("signalRef=\"_47718ea6-a6a4-3ceb-9e93-2111bdad0b8c\"/>"));
        Assert.assertTrue((boolean)result.contains("<drools:metaData name=\"customSLADueDate\">"));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[12/25/1983]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("</drools:metaData>"));
    }

    @Test
    public void testMarshallStartConditionalEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_STARTCONDITIONALEVENT);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 1, 0);
        Assert.assertTrue((boolean)result.contains("<bpmn2:startEvent id=\"_8F9C10C4-F1EE-4B49-B4CE-3059ADD4B391\""));
        Assert.assertTrue((boolean)result.contains(" name=\"StartConditionalEvent\""));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[StartConditionalEventName]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("<![CDATA[StartConditionalEventDocumentation]]></bpmn2:documentation>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:conditionalEventDefinition"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:condition"));
        Assert.assertTrue((boolean)result.contains("![CDATA[StartConditionalEventConditionExpression]]></bpmn2:condition>"));
        Assert.assertTrue((boolean)result.contains("</bpmn2:condition>"));
        Assert.assertTrue((boolean)result.contains("</bpmn2:conditionalEventDefinition>"));
        Assert.assertTrue((boolean)result.contains("<drools:metaData name=\"customSLADueDate\">"));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[12/25/1983]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("</drools:metaData>"));
    }

    @Test
    public void testMarshallStartEscalationEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_STARTESCALATIONEVENT);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 1, 0);
        Assert.assertTrue((boolean)result.contains("<bpmn2:startEvent id=\"_D5AAA79F-9CD6-43C1-92E2-5D3C9340A303\""));
        Assert.assertTrue((boolean)result.contains(" name=\"StartEscalationEvent\""));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[StartEscalationEventName]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("<![CDATA[StartEscalationEventDocumentation]]></bpmn2:documentation>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:escalationEventDefinition"));
        Assert.assertTrue((boolean)result.contains("drools:esccode=\"EscalationCode\""));
        Assert.assertTrue((boolean)result.contains("<bpmn2:escalation"));
        Assert.assertTrue((boolean)result.contains("escalationCode=\"EscalationCode\""));
        Assert.assertTrue((boolean)result.contains("<drools:metaData name=\"customSLADueDate\">"));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[12/25/1983]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("</drools:metaData>"));
    }

    @Test
    public void testMarshallStartCompensationEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_STARTCOMPENSATIONEVENT);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 1, 0);
        Assert.assertTrue((boolean)result.contains("<bpmn2:startEvent id=\"_19C23644-6CF0-4508-81B2-4CA2179137AB\""));
        Assert.assertTrue((boolean)result.contains(" name=\"StartCompensationEvent\""));
        Assert.assertTrue((boolean)result.contains("isInterrupting=\"false\""));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[StartCompensationEventName]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("<![CDATA[StartCompensationEventDocumentation]]></bpmn2:documentation>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:compensateEventDefinition"));
        Assert.assertTrue((boolean)result.contains("<drools:metaData name=\"customSLADueDate\">"));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[12/25/1983]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("</drools:metaData>"));
    }

    @Test
    public void testMarshallStartErrorEventEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_STARTERROREVENT);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 2, 1);
        Assert.assertTrue((boolean)result.contains("<bpmn2:startEvent"));
        Assert.assertTrue((boolean)result.contains(" name=\"MyStartErrorEvent\""));
        Assert.assertTrue((boolean)result.contains("<bpmn2:errorEventDefinition"));
        Assert.assertTrue((boolean)result.contains("errorRef=\"MyError\""));
        Assert.assertTrue((boolean)result.contains("drools:erefname=\"MyError\""));
        Assert.assertTrue((boolean)result.contains("<bpmn2:error"));
        Assert.assertTrue((boolean)result.contains("id=\"MyError\""));
        Assert.assertTrue((boolean)result.contains("errorCode=\"MyError\""));
        Assert.assertTrue((boolean)result.contains("<drools:metaData name=\"customSLADueDate\">"));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[12/25/1983]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("</drools:metaData>"));
    }

    @Test
    public void testMarshallEndSignalEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_ENDSIGNALEVENT);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 1, 0);
        Assert.assertTrue((boolean)result.contains("<bpmn2:endEvent id=\"_C9151E0C-2E3E-4558-AFC2-34038E3A8552\""));
        Assert.assertTrue((boolean)result.contains(" name=\"EndSignalEvent\""));
        Assert.assertTrue((boolean)result.contains("<bpmn2:signalEventDefinition"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:signal id=\"_fa547353-0e4d-3a5a-9e1e-b53d2fedb10c\" name=\"employee\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpmndi:BPMNDiagram"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:relationship"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:extensionElements"));
    }

    @Test
    public void testMarshallStartMessageEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_STARTMESSAGEEVENT);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 1, 0);
        Assert.assertTrue((boolean)result.contains("<bpmn2:startEvent id=\"_34C4BBFC-544F-4E23-B17B-547BB48EEB63\""));
        Assert.assertTrue((boolean)result.contains(" name=\"StartMessageEvent\""));
        Assert.assertTrue((boolean)result.contains("<bpmn2:message "));
        Assert.assertTrue((boolean)result.contains(" name=\"msgref\""));
        Assert.assertTrue((boolean)result.contains("<bpmn2:messageEventDefinition"));
        Assert.assertTrue((boolean)result.contains("<drools:metaData name=\"customSLADueDate\">"));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[12/25/1983]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("</drools:metaData>"));
    }

    @Test
    public void testMarshallEndMessageEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_ENDMESSAGEEVENT);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 1, 0);
        Assert.assertTrue((boolean)result.contains("<bpmn2:endEvent id=\"_4A8A0A9E-D4A5-4B6E-94A6-20817A57B3C6\""));
        Assert.assertTrue((boolean)result.contains(" name=\"EndMessageEvent\""));
        Assert.assertTrue((boolean)result.contains("<bpmn2:message "));
        Assert.assertTrue((boolean)result.contains(" name=\"msgref\""));
        Assert.assertTrue((boolean)result.contains("<bpmn2:messageEventDefinition"));
    }

    @Test
    public void testMarshallTimerIntermediateEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_INTERMEDIATE_TIMER_EVENT);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 1, 0);
        Assert.assertTrue((boolean)result.contains("<bpmn2:intermediateCatchEvent"));
        Assert.assertTrue((boolean)result.contains(" name=\"MyTimer\""));
        Assert.assertTrue((boolean)result.contains("<bpmn2:timerEventDefinition"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:timeDate"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:timeDuration"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:timeCycle"));
        Assert.assertTrue((boolean)result.contains("<drools:metaData name=\"customSLADueDate\">"));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[12/25/1983]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("</drools:metaData>"));
    }

    @Test
    public void testMarshallIntermediateSignalEventCatching() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_INTERMEDIATE_SIGNAL_EVENTCATCHING);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 1, 0);
        Assert.assertTrue((boolean)result.contains("<bpmn2:intermediateCatchEvent"));
        Assert.assertTrue((boolean)result.contains(" name=\"MySignalCatchingEvent\""));
        Assert.assertTrue((boolean)result.contains("<bpmn2:signalEventDefinition"));
        Assert.assertTrue((boolean)result.contains(" signalRef=\"_3b677877-9be0-3fe7-bfc4-94a862fdc919\""));
        Assert.assertTrue((boolean)result.contains("<bpmn2:signal"));
        Assert.assertTrue((boolean)result.contains("name=\"MySignal\""));
        Assert.assertTrue((boolean)result.contains("<drools:metaData name=\"customSLADueDate\">"));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[12/25/1983]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("</drools:metaData>"));
    }

    @Test
    public void testMarshallIntermediatErrorEventCatching() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_INTERMEDIATE_ERROR_EVENTCATCHING);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 1, 0);
        Assert.assertTrue((boolean)result.contains("<bpmn2:intermediateCatchEvent"));
        Assert.assertTrue((boolean)result.contains(" name=\"MyErrorCatchingEvent\""));
        Assert.assertTrue((boolean)result.contains("<bpmn2:errorEventDefinition"));
        Assert.assertTrue((boolean)result.contains("errorRef=\"MyError\""));
        Assert.assertTrue((boolean)result.contains("<bpmn2:error"));
        Assert.assertTrue((boolean)result.contains("id=\"MyError\""));
        Assert.assertTrue((boolean)result.contains("errorCode=\"MyError\""));
        Assert.assertTrue((boolean)result.contains("<drools:metaData name=\"customSLADueDate\">"));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[12/25/1983]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("</drools:metaData>"));
    }

    @Test
    public void testMarshallIntermediateMessageEventThrowing() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_INTERMEDIATE_MESSAGE_EVENTTHROWING);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 1, 0);
        Assert.assertTrue((boolean)result.contains("<bpmn2:intermediateThrowEvent"));
        Assert.assertTrue((boolean)result.contains(" name=\"IntermediateMessageEventThrowing\""));
        Assert.assertTrue((boolean)result.contains("<bpmn2:message "));
        Assert.assertTrue((boolean)result.contains(" name=\"msgref\""));
        Assert.assertTrue((boolean)result.contains("<bpmn2:messageEventDefinition"));
    }

    @Test
    public void testMarshallIntermediateSignalEventThrowing() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_INTERMEDIATE_SIGNAL_EVENTTHROWING);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 1, 0);
        Assert.assertTrue((boolean)result.contains("<bpmn2:intermediateThrowEvent"));
        Assert.assertTrue((boolean)result.contains(" name=\"MySignalThrowingEvent\""));
        Assert.assertTrue((boolean)result.contains("<bpmn2:signalEventDefinition"));
        Assert.assertTrue((boolean)result.contains(" signalRef=\"_3b677877-9be0-3fe7-bfc4-94a862fdc919\""));
        Assert.assertTrue((boolean)result.contains("<bpmn2:signal"));
        Assert.assertTrue((boolean)result.contains("name=\"MySignal\""));
        Assert.assertTrue((boolean)result.contains("<drools:metaData name=\"customScope\">"));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[processInstance]]></drools:metaValue>"));
    }

    @Test
    public void testMarshallIntermediateEscalationEventThrowing() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_INTERMEDIATE_ESCALATION_EVENTTHROWING);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 1, 0);
        Assert.assertTrue((boolean)result.contains("<bpmn2:intermediateThrowEvent id=\"_8516D854-F67F-4697-9837-40A32033AE25\""));
        Assert.assertTrue((boolean)result.contains(" name=\"ThrowingEscalationEventName\""));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[ThrowingEscalationEventName]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("<![CDATA[ThrowingEscalationEventDocumentation]]></bpmn2:documentation>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:escalationEventDefinition"));
        Assert.assertTrue((boolean)result.contains("drools:esccode=\"EscalationCode\""));
        Assert.assertTrue((boolean)result.contains("<bpmn2:escalation"));
        Assert.assertTrue((boolean)result.contains("escalationCode=\"EscalationCode\""));
    }

    @Test
    public void testMarshallIntermediateCompensationEventThrowing() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_INTERMEDIATE_COMPENSATION_EVENTTHROWING);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 2, 0);
        Assert.assertTrue((boolean)result.contains("<bpmn2:intermediateThrowEvent id=\"_F1D87D25-4D73-4DC5-A0C2-C627CED773BA\""));
        Assert.assertTrue((boolean)result.contains(" name=\"IntermediateCompensationEventThrowing\""));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[ThrowingCompensationEventName]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("<![CDATA[ThrowingCompensationEventDocumentation]]></bpmn2:documentation>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:compensateEventDefinition"));
        Assert.assertTrue((boolean)result.contains("activityRef=\"_E318295E-B0B6-4FB2-B5EB-A43BFD44FCBD\""));
    }

    @Test
    public void testMarshallIntermediateMessageEventCatching() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_INTERMEDIATE_MESSAGE_EVENTCATCHING);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 1, 0);
        Assert.assertTrue((boolean)result.contains("<bpmn2:intermediateCatchEvent"));
        Assert.assertTrue((boolean)result.contains(" name=\"IntermediateMessageEventCatching\""));
        Assert.assertTrue((boolean)result.contains("<bpmn2:message "));
        Assert.assertTrue((boolean)result.contains(" name=\"msgref1\""));
        Assert.assertTrue((boolean)result.contains("<bpmn2:messageEventDefinition"));
        Assert.assertTrue((boolean)result.contains("<drools:metaData name=\"customSLADueDate\">"));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[12/25/1983]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("</drools:metaData>"));
    }

    @Test
    public void testMarshallEndNoneEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_ENDNONEEVENT);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 2, 1);
        Assert.assertTrue((boolean)result.contains("<bpmn2:endEvent"));
        Assert.assertTrue((boolean)result.contains(" id=\"_9DF2C9D3-15DF-4436-B6C6-85B58B8696B6\""));
        Assert.assertTrue((boolean)result.contains("name=\"MyEndNoneEvent\""));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[MyEndNoneEvent]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("<![CDATA[MyEndNoneEventDocumentation]]></bpmn2:documentation>"));
        Assert.assertTrue((boolean)result.contains("</bpmn2:endEvent>"));
    }

    @Test
    public void testMarshallEndTerminateEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_ENDTERMINATEEVENT);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 2, 1);
        Assert.assertTrue((boolean)result.contains("<bpmn2:endEvent"));
        Assert.assertTrue((boolean)result.contains(" id=\"_1B379E3E-E4ED-4BD2-AEE8-CD85374CEC78\""));
        Assert.assertTrue((boolean)result.contains("name=\"MyEndTerminateEvent\""));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[MyEndTerminateEvent]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("<![CDATA[MyEndTerminateEventDocumentation]]></bpmn2:documentation>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:terminateEventDefinition"));
        Assert.assertTrue((boolean)result.contains("</bpmn2:endEvent>"));
    }

    @Test
    public void testMarshallEndErrorEnd() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_ENDERROR_EVENT);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 1, 0);
        Assert.assertTrue((boolean)result.contains("<bpmn2:error id=\"MyError\" errorCode=\"MyError\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:endEvent"));
        Assert.assertTrue((boolean)result.contains(" name=\"MyErrorEventName\""));
        Assert.assertTrue((boolean)result.contains("<bpmn2:errorEventDefinition"));
        Assert.assertTrue((boolean)result.contains(" errorRef=\"MyError\""));
        Assert.assertTrue((boolean)result.contains(" drools:erefname=\"MyError\""));
    }

    @Test
    public void testMarshallEndEscalationEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_ENDESCALATIONEVENT);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 1, 0);
        Assert.assertTrue((boolean)result.contains("<bpmn2:endEvent id=\"_8F6A4096-26AA-4C14-B1F0-B96ED24BD5C7\""));
        Assert.assertTrue((boolean)result.contains(" name=\"EndEscalationEventName\""));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[EndEscalationEventName]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("<![CDATA[EndEscalationEventDocumentation]]></bpmn2:documentation>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:escalationEventDefinition"));
        Assert.assertTrue((boolean)result.contains("drools:esccode=\"EscalationCode\""));
        Assert.assertTrue((boolean)result.contains("<bpmn2:escalation"));
        Assert.assertTrue((boolean)result.contains("escalationCode=\"EscalationCode\""));
    }

    @Test
    public void testMarshallEndCompensationEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_ENDCOMPENSATIONEVENT);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 2, 0);
        Assert.assertTrue((boolean)result.contains("<bpmn2:endEvent id=\"_2AEA503B-26E5-4F11-A54D-3E275F8BFA6A\""));
        Assert.assertTrue((boolean)result.contains(" name=\"EndCompensationEventName\""));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[EndCompensationEventName]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("<![CDATA[EndCompensationEventDocumentation]]></bpmn2:documentation>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:compensateEventDefinition"));
        Assert.assertTrue((boolean)result.contains("activityRef=\"_7795AFA7-E602-4D90-B4B6-249639C4D965\""));
    }

    @Test
    public void testMarshallReusableSubprocess() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_REUSABLE_SUBPROCESS);
        Assertions.assertDiagram(diagram, 4);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 3, 2);
        Assert.assertTrue((boolean)result.contains("<bpmn2:callActivity id=\"_FC6D8570-8C67-40C2-8B7B-953DE15765FB\" drools:independent=\"false\" drools:waitForCompletion=\"true\" name=\"my subprocess\" calledElement=\"my-called-element&quot; &lt;&amp;&gt; &quot;\">"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:dataInput id=\"_FC6D8570-8C67-40C2-8B7B-953DE15765FB_input1InputX\" drools:dtype=\"String\" itemSubjectRef=\"__FC6D8570-8C67-40C2-8B7B-953DE15765FB_input1InputXItem\" name=\"input1\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:dataOutput id=\"_FC6D8570-8C67-40C2-8B7B-953DE15765FB_output2OutputX\" drools:dtype=\"Float\" itemSubjectRef=\"__FC6D8570-8C67-40C2-8B7B-953DE15765FB_output2OutputXItem\" name=\"output2\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:sourceRef>pv1</bpmn2:sourceRef>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:targetRef>_FC6D8570-8C67-40C2-8B7B-953DE15765FB_input1InputX</bpmn2:targetRef>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:sourceRef>_FC6D8570-8C67-40C2-8B7B-953DE15765FB_output2OutputX</bpmn2:sourceRef>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:targetRef>pv2</bpmn2:targetRef>"));
        String flatResult = result.replace(NEW_LINE, " ").replaceAll("( )+", " ");
        Assert.assertTrue((boolean)flatResult.contains("<drools:metaData name=\"elementname\"> <drools:metaValue><![CDATA[my subprocess]]></drools:metaValue> </drools:metaData>"));
        Assert.assertTrue((boolean)flatResult.contains("<drools:metaData name=\"customAsync\"> <drools:metaValue><![CDATA[true]]></drools:metaValue>"));
    }

    @Test
    public void testMarshallReusableSubprocessMI() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_REUSABLE_SUBPROCESS_MI);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 3, 2);
        Assert.assertTrue((boolean)result.contains("<bpmn2:callActivity id=\"_CACC5C21-CE79-4445-9411-BE8C7A75E860\""));
        Assert.assertTrue((boolean)result.contains("name=\"TheReusableSubProcess\" calledElement=\"test.SubProcess\">"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:itemDefinition id=\"_CACC5C21-CE79-4445-9411-BE8C7A75E860_multiInstanceItemType_theInputVariable\" structureRef=\"java.lang.Object\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:itemDefinition id=\"_CACC5C21-CE79-4445-9411-BE8C7A75E860_multiInstanceItemType_theOutputVariable\" structureRef=\"java.lang.Object\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:dataInput id=\"_CACC5C21-CE79-4445-9411-BE8C7A75E860_IN_COLLECTIONInputX\" itemSubjectRef=\"_theInputCollectionItem\" name=\"IN_COLLECTION\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:dataInput id=\"_CACC5C21-CE79-4445-9411-BE8C7A75E860_theInputVariableInputX\" itemSubjectRef=\"_CACC5C21-CE79-4445-9411-BE8C7A75E860_multiInstanceItemType_theInputVariable\" name=\"theInputVariable\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:dataOutput id=\"_CACC5C21-CE79-4445-9411-BE8C7A75E860_OUT_COLLECTIONOutputX\" itemSubjectRef=\"_theOutputCollectionItem\" name=\"OUT_COLLECTION\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:dataOutput id=\"_CACC5C21-CE79-4445-9411-BE8C7A75E860_theOutputVariableOutputX\" itemSubjectRef=\"_CACC5C21-CE79-4445-9411-BE8C7A75E860_multiInstanceItemType_theOutputVariable\" name=\"theOutputVariable\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:dataInputRefs>_CACC5C21-CE79-4445-9411-BE8C7A75E860_IN_COLLECTIONInputX</bpmn2:dataInputRefs>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:dataInputRefs>_CACC5C21-CE79-4445-9411-BE8C7A75E860_theInputVariableInputX</bpmn2:dataInputRefs>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:dataOutputRefs>_CACC5C21-CE79-4445-9411-BE8C7A75E860_OUT_COLLECTIONOutputX</bpmn2:dataOutputRefs>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:dataOutputRefs>_CACC5C21-CE79-4445-9411-BE8C7A75E860_theOutputVariableOutputX</bpmn2:dataOutputRefs>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:sourceRef>theInputCollection</bpmn2:sourceRef>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:targetRef>_CACC5C21-CE79-4445-9411-BE8C7A75E860_IN_COLLECTIONInputX</bpmn2:targetRef>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:sourceRef>theInputVariable</bpmn2:sourceRef>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:targetRef>_CACC5C21-CE79-4445-9411-BE8C7A75E860_theInputVariableInputX</bpmn2:targetRef>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:sourceRef>_CACC5C21-CE79-4445-9411-BE8C7A75E860_OUT_COLLECTIONOutputX</bpmn2:sourceRef>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:targetRef>theOutputCollection</bpmn2:targetRef>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:sourceRef>_CACC5C21-CE79-4445-9411-BE8C7A75E860_theOutputVariableOutputX</bpmn2:sourceRef>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:targetRef>theOutputVariable</bpmn2:targetRef>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:multiInstanceLoopCharacteristics"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:loopDataInputRef>_CACC5C21-CE79-4445-9411-BE8C7A75E860_IN_COLLECTIONInputX</bpmn2:loopDataInputRef>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:loopDataOutputRef>_CACC5C21-CE79-4445-9411-BE8C7A75E860_OUT_COLLECTIONOutputX</bpmn2:loopDataOutputRef>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:inputDataItem xsi:type=\"bpmn2:tDataInput\" id=\"theInputVariable\" itemSubjectRef=\"_CACC5C21-CE79-4445-9411-BE8C7A75E860_multiInstanceItemType_theInputVariable\" name=\"theInputVariable\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:outputDataItem xsi:type=\"bpmn2:tDataOutput\" id=\"theOutputVariable\" itemSubjectRef=\"_CACC5C21-CE79-4445-9411-BE8C7A75E860_multiInstanceItemType_theOutputVariable\" name=\"theOutputVariable\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:completionCondition xsi:type=\"bpmn2:tFormalExpression\" id=\""));
        Assert.assertTrue((boolean)result.contains("<![CDATA[theCompletionCondition]]></bpmn2:completionCondition>"));
        Assert.assertTrue((boolean)result.contains("</bpmn2:multiInstanceLoopCharacteristics>"));
    }

    @Test
    public void testMarshallEmbeddedSubprocess() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_EMBEDDED_SUBPROCESS);
        Assertions.assertDiagram(diagram, 10);
        Assertions.assertDocumentation(diagram, "_C3EBE7F1-8E57-4BB1-B380-40BB02E9464E", "Subprocess  Documentation Value");
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 9, 7);
        String SLA_DUE_DATE = "12/25/1983";
        Assert.assertTrue((boolean)result.contains("<bpmn2:subProcess id=\"_C3EBE7F1-8E57-4BB1-B380-40BB02E9464E\" "));
        Assert.assertTrue((boolean)result.contains("<drools:metaData name=\"customSLADueDate\">"));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[12/25/1983]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("</drools:metaData>"));
    }

    @Test
    public void testMarshallEmbeddedSubprocessDuplicateElements() throws Exception {
        String f = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/subprocessDuplicateElements.bpmn";
        Diagram<Graph, Metadata> diagram = this.unmarshall(f);
        String result = this.tested.marshall(diagram);
        Assert.assertFalse((String)"should not contain the same node twice", (boolean)result.replaceFirst("id=\"5FAC4991-B287-4787-9916-9D3D5D215977\"", "BLAH").contains("id=\"5FAC4991-B287-4787-9916-9D3D5D215977\""));
    }

    @Test
    public void testMarshallEmbeddedSubprocessNestedDuplicates() throws Exception {
        String f = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/subprocessNested.bpmn";
        Diagram<Graph, Metadata> diagram = this.unmarshall(f);
        String result = this.tested.marshall(diagram);
        Assert.assertFalse((String)"should not contain the same node twice", (boolean)result.replaceFirst("id=\"_CANDIDATE_\"", "BLAH").contains("id=\"_CANDIDATE_\""));
    }

    @Test
    public void testMarshallMultipleInstanceSubprocess() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_MULTIPLE_INSTANCE_SUBPROCESS);
        Assertions.assertDiagram(diagram, 2);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 1, 0);
        Assert.assertEquals((String)"Unexpected number of extensionElements sections.", (long)2L, (long)this.countOccurrences(result, "<bpmn2:extensionElements>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:subProcess id=\"_2316CEC1-C1F7-41B1-8C91-3CE73ADE5571\""));
        Assert.assertTrue((boolean)result.contains("name=\"MultipleInstanceSubprocess\""));
        Assert.assertTrue((boolean)result.contains("<drools:onEntry-script scriptFormat=\"http://www.java.com/java\">"));
        Assert.assertTrue((boolean)result.contains("<drools:script><![CDATA[onEntryAction]]></drools:script>"));
        Assert.assertTrue((boolean)result.contains("</drools:onEntry-script>"));
        Assert.assertTrue((boolean)result.contains("<drools:onExit-script scriptFormat=\"http://www.java.com/java\">"));
        Assert.assertTrue((boolean)result.contains("<drools:script><![CDATA[onExitAction]]></drools:script>"));
        Assert.assertTrue((boolean)result.contains("</drools:onExit-script>"));
        Assert.assertTrue((boolean)result.contains("<drools:metaData name=\"customAsync\">"));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[true]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("</drools:metaData>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:dataOutput id=\"_2316CEC1-C1F7-41B1-8C91-3CE73ADE5571_OUT_COLLECTIONOutputX\" itemSubjectRef=\"_var2Item\" name=\"OUT_COLLECTION\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:multiInstanceLoopCharacteristics"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:loopDataInputRef>_2316CEC1-C1F7-41B1-8C91-3CE73ADE5571_IN_COLLECTIONInputX</bpmn2:loopDataInputRef>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:loopDataOutputRef>_2316CEC1-C1F7-41B1-8C91-3CE73ADE5571_OUT_COLLECTIONOutputX</bpmn2:loopDataOutputRef>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:inputDataItem xsi:type=\"bpmn2:tDataInput\" id=\"dataInput\" itemSubjectRef=\"_2316CEC1-C1F7-41B1-8C91-3CE73ADE5571_multiInstanceItemType_dataInput\" name=\"dataInput\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:outputDataItem xsi:type=\"bpmn2:tDataOutput\" id=\"dataOutput\" itemSubjectRef=\"_2316CEC1-C1F7-41B1-8C91-3CE73ADE5571_multiInstanceItemType_dataOutput\" name=\"dataOutput\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:completionCondition xsi:type=\"bpmn2:tFormalExpression\""));
        Assert.assertTrue((boolean)result.contains("<![CDATA[a=b]]></bpmn2:completionCondition>"));
        Assert.assertTrue((boolean)result.contains("</bpmn2:multiInstanceLoopCharacteristics>"));
        Assert.assertTrue((boolean)result.contains("<drools:metaData name=\"customSLADueDate\">"));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[12/25/1983]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("</drools:metaData>"));
    }

    private int countOccurrences(String input, String lookup) {
        Pattern p = Pattern.compile(lookup);
        Matcher matcher = p.matcher(input);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    @Test
    public void testMarshallEventSubprocess() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_EVENT_SUBPROCESS);
        Assertions.assertDiagram(diagram, 2);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 1, 0);
        String SLA_DUE_DATE = "12/25/1983";
        Assert.assertTrue((boolean)result.contains("<bpmn2:subProcess id=\"_DF031493-5F1C-4D2B-9916-2FEABB1FADFF\""));
        Assert.assertTrue((boolean)result.contains("<drools:metaData name=\"customSLADueDate\">"));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[12/25/1983]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("</drools:metaData>"));
    }

    @Test
    public void testMarshallAdHocSubprocess() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_ADHOC_SUBPROCESS);
        Assertions.assertDiagram(diagram, 9);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 8, 5);
        Assert.assertTrue((boolean)result.contains("<bpmn2:adHocSubProcess id=\"_B65DDF51-9822-4B12-8669-2018A845A01B\""));
        Assert.assertTrue((boolean)result.contains("name=\"AdHocSubprocess1\""));
        Assert.assertTrue((boolean)result.contains("<drools:onEntry-script scriptFormat=\"http://www.mvel.org/2.0\">"));
        Assert.assertTrue((boolean)result.contains("<drools:script><![CDATA[System.out.println(\"onEntryAction\");]]></drools:script>"));
        Assert.assertTrue((boolean)result.contains("</drools:onEntry-script>"));
        Assert.assertTrue((boolean)result.contains("<drools:onExit-script scriptFormat=\"http://www.java.com/java\">"));
        Assert.assertTrue((boolean)result.contains("<drools:script><![CDATA[System.out.println(\"onExitAction\");]]></drools:script>"));
        Assert.assertTrue((boolean)result.contains("</drools:onExit-script>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:completionCondition xsi:type=\"bpmn2:tFormalExpression\""));
        Assert.assertTrue((boolean)result.contains("language=\"http://www.jboss.org/drools/rule\"><![CDATA[autocomplete]]></bpmn2:completionCondition>"));
        Assert.assertTrue((boolean)result.contains("<drools:metaData name=\"customAsync\">"));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[true]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("</drools:metaData>"));
        String SLA_DUE_DATE = "12/25/1983";
        Assert.assertTrue((boolean)result.contains("<drools:metaData name=\"customSLADueDate\">"));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[12/25/1983]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("</drools:metaData>"));
    }

    @Test
    public void testMarshallUserTaskAssignees() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_USERTASKASSIGNEES);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 5, 4);
        Assert.assertTrue((boolean)result.contains("<![CDATA[admin,kiemgmt]]>"));
        result = result.replace(NEW_LINE, " ");
        Assert.assertTrue((boolean)result.matches("(.*)<bpmn2:resourceAssignmentExpression(.*)>user</bpmn2:formalExpression>(.*)"));
        Assert.assertTrue((boolean)result.matches("(.*)<bpmn2:resourceAssignmentExpression(.*)>user1</bpmn2:formalExpression>(.*)"));
    }

    @Test
    public void testMarshallUserTaskProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_USERTASKPROPERTIES);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 3, 2);
        Assert.assertTrue((boolean)result.contains("MyUserTask]]></bpmn2:from>"));
        String flatResult = result.replace(NEW_LINE, " ").replaceAll("( )+", " ");
        Assert.assertTrue((boolean)flatResult.contains("<drools:metaData name=\"customAsync\"> <drools:metaValue><![CDATA[true]]></drools:metaValue>"));
        Assert.assertTrue((boolean)flatResult.contains("<drools:metaData name=\"customAutoStart\"> <drools:metaValue><![CDATA[true]]></drools:metaValue>"));
        Assert.assertTrue((boolean)flatResult.contains("<drools:onEntry-script scriptFormat=\"http://www.java.com/java\">"));
        Assert.assertTrue((boolean)flatResult.contains("<drools:script><![CDATA[System.out.println(\"Hello\");]]></drools:script>"));
        Assert.assertTrue((boolean)flatResult.contains("<drools:script><![CDATA[System.out.println(\"Bye\");]]></drools:script>"));
    }

    @Test
    public void testMarshallSimulationProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_SIMULATIONPROPERTIES);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 3, 2);
        result = result.replaceAll("\\s+", " ");
        result = result.replaceAll("> <", "><");
        Assert.assertTrue((boolean)result.contains("<bpsim:TimeParameters xsi:type=\"bpsim:TimeParameters\"><bpsim:ProcessingTime xsi:type=\"bpsim:Parameter\"><bpsim:PoissonDistribution mean=\"321.0\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpsim:ResourceParameters xsi:type=\"bpsim:ResourceParameters\"><bpsim:Availability xsi:type=\"bpsim:Parameter\"><bpsim:FloatingParameter value=\"999.0\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpsim:Quantity xsi:type=\"bpsim:Parameter\"><bpsim:FloatingParameter value=\"111.0\"/></bpsim:Quantity>"));
        Assert.assertTrue((boolean)result.contains("<bpsim:CostParameters xsi:type=\"bpsim:CostParameters\"><bpsim:UnitCost xsi:type=\"bpsim:Parameter\"><bpsim:FloatingParameter value=\"123.0\"/>"));
        Assert.assertTrue((boolean)result.contains("<bpsim:TimeParameters xsi:type=\"bpsim:TimeParameters\"><bpsim:ProcessingTime xsi:type=\"bpsim:Parameter\"><bpsim:UniformDistribution max=\"10.0\" min=\"5.0\"/>"));
    }

    @Test
    public void testMarshallEvaluationTwice() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_EVALUATION);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 7, 7);
        Diagram<Graph, Metadata> diagram2 = this.unmarshall(BPMN_EVALUATION);
        String result2 = this.tested.marshall(diagram2);
        Assertions.assertDiagram(result2, 1, 7, 7);
    }

    @Test
    public void testMarshallScriptTask() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_SCRIPTTASK);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 4, 3);
        Assert.assertTrue((boolean)result.contains("name=\"Javascript Script Task\" scriptFormat=\"http://www.javascript.com/javascript\""));
        Assert.assertTrue((boolean)result.contains("name=\"Java Script Task\" scriptFormat=\"http://www.java.com/java\""));
        Assert.assertTrue((boolean)result.contains("<bpmn2:script><![CDATA[var str = FirstName + LastName;]]></bpmn2:script>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:script><![CDATA[if (name.toString().equals(\"Jay\")) {" + NEW_LINE + NEW_LINE + "      System.out.println(\"Hello\\n\" + name.toString() + \"\\n\");" + NEW_LINE + NEW_LINE + "} else {" + NEW_LINE + NEW_LINE + NEW_LINE + "  System.out.println(\"Hi\\n\" + name.toString() + \"\\n\");" + NEW_LINE + NEW_LINE + NEW_LINE + "}" + NEW_LINE + "]]></bpmn2:script>"));
        String flatResult = result.replace(NEW_LINE, " ").replaceAll("( )+", " ");
        Assert.assertTrue((boolean)flatResult.contains("<drools:metaData name=\"customAsync\"> <drools:metaValue><![CDATA[true]]></drools:metaValue>"));
        Assert.assertTrue((boolean)flatResult.contains("<drools:metaData name=\"customAutoStart\"> <drools:metaValue><![CDATA[true]]></drools:metaValue>"));
    }

    @Test
    public void testMarshallSequenceFlow() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_SEQUENCEFLOW);
        this.assertConditionLanguage(diagram, "_C9F8F30D-E772-4504-A480-6EC894B289DC", "javascript");
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 6, 5);
        Assert.assertTrue((boolean)result.contains("language=\"http://www.javascript.com/javascript\"><![CDATA[age >= 10;]]></bpmn2:conditionExpression>"));
        Assert.assertTrue((boolean)result.contains("language=\"http://www.java.com/java\"><![CDATA[age" + NEW_LINE + "<" + NEW_LINE + "10;]]></bpmn2:conditionExpression>"));
    }

    private void assertConditionLanguage(Diagram<Graph, Metadata> diagram, String id, String value) {
        List<Node> nodes = this.getNodes(diagram);
        Optional<SequenceFlow> sequenceFlow = Stream.concat(nodes.stream().flatMap(node -> {
            List d = node.getInEdges();
            return d.stream();
        }), nodes.stream().flatMap(node -> {
            List d = node.getOutEdges();
            return d.stream();
        })).filter(edge -> edge.getUUID().equals(id)).map(node -> (View)node.getContent()).filter(view -> view.getDefinition() instanceof SequenceFlow).map(view -> (SequenceFlow)view.getDefinition()).findFirst();
        String conditionLanguage = sequenceFlow.isPresent() ? sequenceFlow.get().getExecutionSet().getConditionExpression().getValue().getLanguage() : null;
        Assert.assertEquals((Object)value, conditionLanguage);
    }

    @Test
    public void testMarshallBusinessRuleTask() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_BUSINESSRULETASKRULEFLOWGROUP);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(diagram, 2);
        Assert.assertTrue((boolean)result.contains("<bpmn2:businessRuleTask "));
        String flatResult = result.replace(NEW_LINE, " ").replaceAll("( )+", " ");
        Assert.assertTrue((boolean)flatResult.contains("<drools:metaData name=\"customAsync\"> <drools:metaValue><![CDATA[true]]></drools:metaValue>"));
        Assert.assertTrue((boolean)flatResult.contains("<drools:onEntry-script scriptFormat=\"http://www.java.com/java\">"));
        Assert.assertTrue((boolean)flatResult.contains("<drools:script><![CDATA[System.out.println(\"Hello\");]]></drools:script>"));
        Assert.assertTrue((boolean)flatResult.contains("<drools:script><![CDATA[System.out.println(\"Bye\");]]></drools:script>"));
    }

    @Test
    public void testMarshallInclusiveGateway() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_INCLUSIVE_GATEWAY);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 6, 6);
        Assert.assertTrue((boolean)result.contains("<bpmn2:inclusiveGateway id=\"_526EE472-FE8B-4E9A-A951-CFBA86C3691F\" drools:dg=\"_3D5701E9-CFD3-4218-9200-897B6D4FF041\" name=\"InclusiveGatewayName\" gatewayDirection=\"Diverging\" default=\"_3D5701E9-CFD3-4218-9200-897B6D4FF041\">"));
    }

    @Test
    public void testMarshallXorGateway() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_XORGATEWAY);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 6, 5);
        Assert.assertTrue((boolean)result.contains("<bpmn2:exclusiveGateway id=\"_877EA035-1A14-42E9-8CAA-43E9BF908C70\" drools:dg=\"_5110D608-BDAD-47BF-A3F9-E1DBE43ED7CD\" name=\"AgeSplit\" gatewayDirection=\"Diverging\" default=\"_5110D608-BDAD-47BF-A3F9-E1DBE43ED7CD\">"));
    }

    @Test
    public void testMarshallIntermediateTimerEvent() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_TIMER_EVENT);
        IntermediateTimerEvent timerEvent = null;
        Iterator<Element> it = this.nodesIterator(diagram);
        while (it.hasNext()) {
            Object oDefinition;
            Element element = it.next();
            if (!(element.getContent() instanceof View) || !((oDefinition = ((View)element.getContent()).getDefinition()) instanceof IntermediateTimerEvent)) continue;
            timerEvent = (IntermediateTimerEvent)oDefinition;
            break;
        }
        Assert.assertNotNull(timerEvent);
        Assert.assertNotNull((Object)timerEvent.getGeneral());
        Assert.assertNotNull((Object)timerEvent.getExecutionSet());
        Assert.assertEquals((Object)"myTimeDateValue", (Object)timerEvent.getExecutionSet().getTimerSettings().getValue().getTimeDate());
        Assert.assertEquals((Object)"MyTimeDurationValue", (Object)timerEvent.getExecutionSet().getTimerSettings().getValue().getTimeDuration());
        Assert.assertEquals((Object)"myTimeCycleValue", (Object)timerEvent.getExecutionSet().getTimerSettings().getValue().getTimeCycle());
        Assert.assertEquals((Object)"cron", (Object)timerEvent.getExecutionSet().getTimerSettings().getValue().getTimeCycleLanguage());
    }

    @Test
    public void testMarshallIntermediateConditionalEvents() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_INTERMEDIATE_CONDITIONAL_EVENTS);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 3, 0);
        Assert.assertTrue((boolean)result.contains("<bpmn2:intermediateCatchEvent id=\"_31A24997-C7B3-4286-8B4D-0EFD7CB11206\""));
        Assert.assertTrue((boolean)result.contains(" name=\"CatchingIntermediateConditionalEventName\""));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[CatchingIntermediateConditionalEventName]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("<![CDATA[CatchingIntermediateConditionalDocumentation]]></bpmn2:documentation>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:conditionalEventDefinition"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:condition"));
        Assert.assertTrue((boolean)result.contains("![CDATA[CatchingIntermediateConditionalEventCompletionCondition]]></bpmn2:condition>"));
        Assert.assertTrue((boolean)result.contains("</bpmn2:condition>"));
        Assert.assertTrue((boolean)result.contains("</bpmn2:conditionalEventDefinition>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:boundaryEvent id=\"_FD2DB546-4A85-4C50-9003-548A9A354F97\""));
        Assert.assertTrue((boolean)result.contains(" name=\"BoundaryConditionalEventName\""));
        Assert.assertTrue((boolean)result.contains("attachedToRef=\"_0EE77FB7-0610-496D-AF48-6ADECE39897A\""));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[BoundaryConditionalEventName]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("<![CDATA[BoundaryConditionalEventDocumentation]]></bpmn2:documentation>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:conditionalEventDefinition"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:condition"));
        Assert.assertTrue((boolean)result.contains("![CDATA[BoundaryConditionalEventCompletionCondition]]></bpmn2:condition>"));
        Assert.assertTrue((boolean)result.contains("</bpmn2:condition>"));
        Assert.assertTrue((boolean)result.contains("</bpmn2:conditionalEventDefinition>"));
        Assert.assertTrue((boolean)result.contains("<drools:metaData name=\"customSLADueDate\">"));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[12/25/1983]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("</drools:metaData>"));
    }

    @Test
    public void testMarshallIntermediateEscalationEvents() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_INTERMEDIATE_ESCALATION_EVENTS);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 2, 0);
        Assert.assertTrue((boolean)result.contains("<bpmn2:boundaryEvent id=\"_C7F2BA98-1100-4CF8-A994-40E2B65F6E5D\""));
        Assert.assertTrue((boolean)result.contains(" name=\"BoundaryEscalationEventName\""));
        Assert.assertTrue((boolean)result.contains("attachedToRef=\"_3817E92F-D45A-4878-AAB2-95B057C485A1\""));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[BoundaryEscalationEventName]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("<![CDATA[BoundaryEscalationEventDocumentation]]></bpmn2:documentation>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:escalationEventDefinition"));
        Assert.assertTrue((boolean)result.contains("drools:esccode=\"EscalationCode\""));
        Assert.assertTrue((boolean)result.contains("<bpmn2:escalation"));
        Assert.assertTrue((boolean)result.contains("escalationCode=\"EscalationCode\""));
        Assert.assertTrue((boolean)result.contains("<drools:metaData name=\"customSLADueDate\">"));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[12/25/1983]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("</drools:metaData>"));
    }

    @Test
    public void testMarshallIntermediateCompensationEvents() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_INTERMEDIATE_COMPENSATION_EVENTS);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 2, 0);
        Assert.assertTrue((boolean)result.contains("<bpmn2:boundaryEvent id=\"_8CE8AB54-7E8B-4032-B340-2DBEBAB5080F\""));
        Assert.assertTrue((boolean)result.contains(" name=\"IntermediateCompensationEventName\""));
        Assert.assertTrue((boolean)result.contains("attachedToRef=\"_0D213C4C-5B7F-4319-A69A-9F840345F330\""));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[IntermediateCompensationEventName]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("<![CDATA[IntermediateCompensationEventDocumentation]]></bpmn2:documentation>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:compensateEventDefinition"));
        Assert.assertTrue((boolean)result.contains("<drools:metaData name=\"customSLADueDate\">"));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[12/25/1983]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("</drools:metaData>"));
    }

    @Test
    public void testMarshallIntermediateCompensationEventsWithAssociations() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_INTERMEDIATE_COMPENSATION_EVENTS_WITH_ASSOCIATION);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 5, 3);
        Assert.assertTrue((boolean)result.contains("<bpmn2:boundaryEvent id=\"_DF70C614-A641-4109-8A8D-506B15E3F31B\""));
        Assert.assertTrue((boolean)result.contains(" name=\"IntermediateCompensationEventName\""));
        Assert.assertTrue((boolean)result.contains("attachedToRef=\"_C18CC8D2-D7CA-457D-9258-01D1E6973A86\""));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[IntermediateCompensationEventName]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("<![CDATA[IntermediateCompensationEventDocumentation]]></bpmn2:documentation>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:compensateEventDefinition"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:association id=\"_B41D28D1-FC39-40E8-BF89-C57649989014\""));
        Assert.assertTrue((boolean)result.contains("associationDirection=\"One\""));
        Assert.assertTrue((boolean)result.contains("sourceRef=\"_DF70C614-A641-4109-8A8D-506B15E3F31B\""));
        Assert.assertTrue((boolean)result.contains("targetRef=\"_7EF24042-BD4E-4843-9874-8AC3F7AFF3CD\""));
        Assert.assertTrue((boolean)result.contains("<![CDATA[AssociationDocumentation]]></bpmn2:documentation>"));
        Assert.assertTrue((boolean)result.contains("</bpmn2:association>"));
        Assert.assertTrue((boolean)result.contains("<drools:metaData name=\"customSLADueDate\">"));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[12/25/1983]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("</drools:metaData>"));
    }

    @Test
    public void testMarshallMagnetDockers() throws Exception {
        Diagram<Graph, Metadata> diagram1 = this.unmarshall(BPMN_MAGNETDOCKERS);
        String result = this.tested.marshall(diagram1);
        Assertions.assertDiagram(result, 1, 8, 7);
        Diagram<Graph, Metadata> diagram2 = this.unmarshall(new ByteArrayInputStream(result.getBytes()));
        this.testMagnetDockers(diagram2);
    }

    @Test
    public void testMarshallMagnetsInlane() throws Exception {
        Diagram<Graph, Metadata> diagram1 = this.unmarshall(BPMN_MAGNETSINLANE);
        String result = this.tested.marshall(diagram1);
        Assertions.assertDiagram(result, 1, 6, 4);
        Assert.assertTrue((boolean)result.contains("<di:waypoint xsi:type=\"dc:Point\" x=\"371.0\" y=\"86.0\"/>"));
        Assert.assertTrue((boolean)result.contains("<di:waypoint xsi:type=\"dc:Point\" x=\"406.0\" y=\"324.0\"/>"));
        Assert.assertTrue((boolean)result.contains("<di:waypoint xsi:type=\"dc:Point\" x=\"692.0\" y=\"276.0\"/>"));
        Assert.assertTrue((boolean)result.contains("<di:waypoint xsi:type=\"dc:Point\" x=\"805.0\" y=\"76.0\"/>"));
        Assert.assertTrue((boolean)result.contains("<di:waypoint xsi:type=\"dc:Point\" x=\"81.0\" y=\"86.0\"/>"));
        Assert.assertTrue((boolean)result.contains("<di:waypoint xsi:type=\"dc:Point\" x=\"235.0\" y=\"86.0\"/>"));
        Assert.assertTrue((boolean)result.contains("<di:waypoint xsi:type=\"dc:Point\" x=\"474.0\" y=\"372.0\"/>"));
        Assert.assertTrue((boolean)result.contains("<di:waypoint xsi:type=\"dc:Point\" x=\"556.0\" y=\"276.0\"/>"));
        Diagram<Graph, Metadata> diagram2 = this.unmarshall(new ByteArrayInputStream(result.getBytes()));
        this.testMagnetsInLane(diagram2);
    }

    private ViewConnector getInEdgeViewConnector(Node node) {
        List edges = node.getInEdges();
        if (edges != null) {
            for (Edge edge : edges) {
                if (!(edge.getContent() instanceof ViewConnector)) continue;
                return (ViewConnector)edge.getContent();
            }
        }
        return null;
    }

    private ViewConnector getOutEdgeViewConnector(Node node) {
        List edges = node.getOutEdges();
        if (edges != null) {
            for (Edge edge : edges) {
                if (!(edge.getContent() instanceof ViewConnector)) continue;
                return (ViewConnector)edge.getContent();
            }
        }
        return null;
    }

    private Element findElementByContentType(Diagram<Graph, Metadata> diagram, Class contentClass) {
        Iterator<Element> it = this.nodesIterator(diagram);
        while (it.hasNext()) {
            Object oDefinition;
            Element element = it.next();
            if (!(element.getContent() instanceof View) || !contentClass.isInstance(oDefinition = ((View)element.getContent()).getDefinition())) continue;
            return element;
        }
        return null;
    }

    @Test
    public void testUnmarshallEmbeddedSubprocess() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_EMBEDDED_SUBPROCESS);
        EmbeddedSubprocess subprocess = null;
        Iterator<Element> it = this.nodesIterator(diagram);
        while (it.hasNext()) {
            Object oDefinition;
            Element element = it.next();
            if (!(element.getContent() instanceof View) || !((oDefinition = ((View)element.getContent()).getDefinition()) instanceof EmbeddedSubprocess)) continue;
            subprocess = (EmbeddedSubprocess)oDefinition;
            break;
        }
        Assert.assertNotNull(subprocess);
        Node embeddedSubprocessNode = diagram.getGraph().getNode("_C3EBE7F1-8E57-4BB1-B380-40BB02E9464E");
        EmbeddedSubprocess embeddedSubprocess = (EmbeddedSubprocess)((Definition)embeddedSubprocessNode.getContent()).getDefinition();
        String SLA_DUE_DATE = "12/25/1983";
        Assert.assertEquals((Object)"12/25/1983", (Object)embeddedSubprocess.getExecutionSet().getSlaDueDate().getValue());
    }

    @Test
    public void testUnmarshallMultipleInstanceSubprocess() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_MULTIPLE_INSTANCE_SUBPROCESS);
        Assertions.assertDiagram(diagram, 2);
        Assert.assertEquals((Object)"MultipleInstanceSubprocess", (Object)diagram.getMetadata().getTitle());
        Node multipleInstanceSubprocessNode = diagram.getGraph().getNode("_2316CEC1-C1F7-41B1-8C91-3CE73ADE5571");
        MultipleInstanceSubprocess multipleInstanceSubprocess = (MultipleInstanceSubprocess)((Definition)multipleInstanceSubprocessNode.getContent()).getDefinition();
        Assert.assertEquals((Object)"var1", (Object)multipleInstanceSubprocess.getExecutionSet().getMultipleInstanceCollectionInput().getValue());
        Assert.assertEquals((Object)"var2", (Object)multipleInstanceSubprocess.getExecutionSet().getMultipleInstanceCollectionOutput().getValue());
        Assert.assertEquals((Object)"dataInput:java.lang.Object", (Object)multipleInstanceSubprocess.getExecutionSet().getMultipleInstanceDataInput().getValue());
        Assert.assertEquals((Object)"dataOutput:java.lang.Object", (Object)multipleInstanceSubprocess.getExecutionSet().getMultipleInstanceDataOutput().getValue());
        Assert.assertEquals((Object)"a=b", (Object)multipleInstanceSubprocess.getExecutionSet().getMultipleInstanceCompletionCondition().getValue());
        Assert.assertEquals((Object)"onEntryAction", (Object)((ScriptTypeValue)multipleInstanceSubprocess.getExecutionSet().getOnEntryAction().getValue().getValues().get(0)).getScript());
        Assert.assertEquals((Object)"java", (Object)((ScriptTypeValue)multipleInstanceSubprocess.getExecutionSet().getOnEntryAction().getValue().getValues().get(0)).getLanguage());
        Assert.assertEquals((Object)"onExitAction", (Object)((ScriptTypeValue)multipleInstanceSubprocess.getExecutionSet().getOnExitAction().getValue().getValues().get(0)).getScript());
        Assert.assertEquals((Object)"java", (Object)((ScriptTypeValue)multipleInstanceSubprocess.getExecutionSet().getOnExitAction().getValue().getValues().get(0)).getLanguage());
        Assert.assertTrue((boolean)multipleInstanceSubprocess.getExecutionSet().getIsAsync().getValue());
        Assert.assertEquals((Object)"mi-var1:String:[]", (Object)multipleInstanceSubprocess.getProcessData().getProcessVariables().getValue());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)multipleInstanceSubprocess.getExecutionSet().getIsAsync().getValue());
        String SLA_DUE_DATE = "12/25/1983";
        Assert.assertEquals((Object)"12/25/1983", (Object)multipleInstanceSubprocess.getExecutionSet().getSlaDueDate().getValue());
    }

    @Test
    public void testUnmarshallEventSubprocess() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_EVENT_SUBPROCESS);
        Assertions.assertDiagram(diagram, 2);
        Assert.assertEquals((Object)"EventSubProcess", (Object)diagram.getMetadata().getTitle());
        Node eventSubprocessNode = diagram.getGraph().getNode("_DF031493-5F1C-4D2B-9916-2FEABB1FADFF");
        EventSubprocess eventSubprocess = (EventSubprocess)((Definition)eventSubprocessNode.getContent()).getDefinition();
        Assert.assertTrue((boolean)eventSubprocess.getExecutionSet().getIsAsync().getValue());
        Assert.assertEquals((Object)eventSubprocess.getProcessData().getProcessVariables().getValue(), (Object)"Var1:String:[]");
        String SLA_DUE_DATE = "12/25/1983";
        Assert.assertEquals((Object)"12/25/1983", (Object)eventSubprocess.getExecutionSet().getSlaDueDate().getValue());
    }

    @Test
    public void testUnmarshallSeveralDiagrams() throws Exception {
        Diagram<Graph, Metadata> diagram1 = this.unmarshall(BPMN_EVALUATION);
        Assertions.assertDiagram(diagram1, 8);
        Assert.assertEquals((Object)"Evaluation", (Object)diagram1.getMetadata().getTitle());
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_LANES);
        Assertions.assertDiagram(diagram, 7);
        Assert.assertEquals((Object)"Lanes test", (Object)diagram.getMetadata().getTitle());
    }

    @Test
    public void testUnmarshallWorkItems() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_SERVICE_TASKS);
        Assertions.assertDiagram(diagram, 5);
        Node emailNode = diagram.getGraph().getNode("_277CE006-5E6E-4960-A68C-CC8A5347C33F");
        Assert.assertTrue((boolean)(((Definition)emailNode.getContent()).getDefinition() instanceof ServiceTask));
        ServiceTask email = (ServiceTask)((Definition)emailNode.getContent()).getDefinition();
        Assert.assertEquals((Object)WorkItemDefinitionMockRegistry.EMAIL.getName(), (Object)email.getName());
        Assert.assertEquals((Object)WorkItemDefinitionMockRegistry.EMAIL.getCategory(), (Object)email.getCategory());
        Assert.assertEquals((Object)WorkItemDefinitionMockRegistry.EMAIL.getDefaultHandler(), (Object)email.getDefaultHandler());
        Assert.assertEquals((Object)WorkItemDefinitionMockRegistry.EMAIL.getDescription(), (Object)email.getDescription());
        Assert.assertEquals((Object)WorkItemDefinitionMockRegistry.EMAIL.getDisplayName(), (Object)email.getGeneral().getName().getValue());
        Assert.assertEquals((Object)WorkItemDefinitionMockRegistry.EMAIL.getDocumentation(), (Object)email.getGeneral().getDocumentation().getValue());
        Node logNode = diagram.getGraph().getNode("_A940748F-A658-4FB8-84FD-B69F4B7A9205");
        Assert.assertTrue((boolean)(((Definition)logNode.getContent()).getDefinition() instanceof ServiceTask));
        ServiceTask log = (ServiceTask)((Definition)logNode.getContent()).getDefinition();
        Assert.assertEquals((Object)WorkItemDefinitionMockRegistry.LOG.getName(), (Object)log.getName());
        Assert.assertEquals((Object)WorkItemDefinitionMockRegistry.LOG.getCategory(), (Object)log.getCategory());
        Assert.assertEquals((Object)WorkItemDefinitionMockRegistry.LOG.getDefaultHandler(), (Object)log.getDefaultHandler());
        Assert.assertEquals((Object)WorkItemDefinitionMockRegistry.LOG.getDescription(), (Object)log.getDescription());
        Assert.assertEquals((Object)WorkItemDefinitionMockRegistry.LOG.getDisplayName(), (Object)log.getGeneral().getName().getValue());
        Assert.assertEquals((Object)WorkItemDefinitionMockRegistry.LOG.getDocumentation(), (Object)log.getGeneral().getDocumentation().getValue());
    }

    @Test
    public void testUnmarshallNestedSubprocesses() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_NESTED_SUBPROCESSES);
        Assertions.assertDiagram(diagram, 8);
        Bounds event1ExpectedBounds = Bounds.create((double)84.0, (double)275.0, (double)140.0, (double)331.0);
        Node event1 = diagram.getGraph().getNode("_46579C86-4ED2-4DDC-BBD0-51AC99034F0A");
        Assert.assertEquals((Object)event1ExpectedBounds, (Object)((View)event1.getContent()).getBounds());
        Bounds subProcess1ExpectedBounds = Bounds.create((double)278.0, (double)68.0, (double)1443.0, (double)537.0);
        Bounds subProcess2ExpectedBounds = Bounds.create((double)196.0, (double)63.0, (double)1095.0, (double)428.0);
        Bounds task1ExpectedBounds = Bounds.create((double)25.0, (double)143.0, (double)179.0, (double)245.0);
        Node subProcess1 = diagram.getGraph().getNode("_3EF003AC-1AB2-416A-83EA-926A3978D6C0");
        Node task1 = diagram.getGraph().getNode("_529CFC51-DEAE-4E40-8404-BEAABC043171");
        Node subProcess2 = diagram.getGraph().getNode("_793D68BA-AC40-4B16-A036-36353F686977");
        List subProcess1Children = GraphUtils.getChildNodes((Node)subProcess1);
        Assert.assertEquals((long)2L, (long)subProcess1Children.size());
        Assert.assertTrue((boolean)subProcess1Children.contains(task1));
        Assert.assertTrue((boolean)subProcess1Children.contains(subProcess2));
        Assert.assertEquals((Object)subProcess1ExpectedBounds, (Object)((View)subProcess1.getContent()).getBounds());
        Assert.assertEquals((Object)subProcess2ExpectedBounds, (Object)((View)subProcess2.getContent()).getBounds());
        Assert.assertEquals((Object)task1ExpectedBounds, (Object)((View)task1.getContent()).getBounds());
        Bounds subProcess3ExpectedBounds = Bounds.create((double)193.0, (double)46.0, (double)846.0, (double)299.0);
        Bounds task2ExpectedBounds = Bounds.create((double)20.0, (double)80.0, (double)174.0, (double)182.0);
        Node subProcess3 = diagram.getGraph().getNode("_AE368C8F-8BE4-40A5-BC48-5CE5ACF05605");
        Node task2 = diagram.getGraph().getNode("_2265BA12-91FA-4064-8A7E-C963E15517EB");
        List subProcess2Children = GraphUtils.getChildNodes((Node)subProcess2);
        Assert.assertEquals((long)2L, (long)subProcess2Children.size());
        Assert.assertTrue((boolean)subProcess2Children.contains(task2));
        Assert.assertTrue((boolean)subProcess2Children.contains(subProcess3));
        Assert.assertEquals((Object)subProcess3ExpectedBounds, (Object)((View)subProcess3.getContent()).getBounds());
        Assert.assertEquals((Object)task2ExpectedBounds, (Object)((View)task2.getContent()).getBounds());
        Bounds task3ExpectedBounds = Bounds.create((double)24.0, (double)34.0, (double)178.0, (double)136.0);
        Node task3 = diagram.getGraph().getNode("_B7873741-0FFA-4E46-B2E7-3B81D25842B3");
        List subProcess3Children = GraphUtils.getChildNodes((Node)subProcess3);
        Assert.assertEquals((long)1L, (long)subProcess3Children.size());
        Assert.assertTrue((boolean)subProcess3Children.contains(task3));
        Assert.assertEquals((Object)task3ExpectedBounds, (Object)((View)task3.getContent()).getBounds());
    }

    @Test
    public void testMarshallNestedSubprocesses() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_NESTED_SUBPROCESSES);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 7, 1);
        BPMNDirectDiagramMarshallerTest.assertCoordinatesProperlyCalculatedAndMarshalled(diagram, result, "_46579C86-4ED2-4DDC-BBD0-51AC99034F0A", null);
        BPMNDirectDiagramMarshallerTest.assertCoordinatesProperlyCalculatedAndMarshalled(diagram, result, "_3EF003AC-1AB2-416A-83EA-926A3978D6C0", true);
        BPMNDirectDiagramMarshallerTest.assertCoordinatesProperlyCalculatedAndMarshalled(diagram, result, "_529CFC51-DEAE-4E40-8404-BEAABC043171", null);
        BPMNDirectDiagramMarshallerTest.assertCoordinatesProperlyCalculatedAndMarshalled(diagram, result, "_793D68BA-AC40-4B16-A036-36353F686977", true);
        BPMNDirectDiagramMarshallerTest.assertCoordinatesProperlyCalculatedAndMarshalled(diagram, result, "_AE368C8F-8BE4-40A5-BC48-5CE5ACF05605", true);
        BPMNDirectDiagramMarshallerTest.assertCoordinatesProperlyCalculatedAndMarshalled(diagram, result, "_2265BA12-91FA-4064-8A7E-C963E15517EB", null);
        BPMNDirectDiagramMarshallerTest.assertCoordinatesProperlyCalculatedAndMarshalled(diagram, result, "_B7873741-0FFA-4E46-B2E7-3B81D25842B3", null);
    }

    private static void assertCoordinatesProperlyCalculatedAndMarshalled(Diagram<Graph, Metadata> diagram, String marshalledDiagram, String elementId, Boolean isExpandedAttribute) {
        Node node = diagram.getGraph().getNode(elementId);
        Bounds nodeAbsoluteBounds = BasePropertyWriter.absoluteBounds((Node)node);
        float expectedX = Double.valueOf(nodeAbsoluteBounds.getX()).floatValue();
        float expectedY = Double.valueOf(nodeAbsoluteBounds.getY()).floatValue();
        float expectedWidth = nodeAbsoluteBounds.getLowerRight().getX().floatValue() - nodeAbsoluteBounds.getUpperLeft().getX().floatValue();
        float expectedHeight = nodeAbsoluteBounds.getLowerRight().getY().floatValue() - nodeAbsoluteBounds.getUpperLeft().getY().floatValue();
        BPMNDirectDiagramMarshallerTest.assertContainsShape(marshalledDiagram, elementId, expectedX, expectedY, expectedWidth, expectedHeight, isExpandedAttribute);
    }

    private static void assertContainsShape(String bpmnContent, String elementId, float expectedX, float expectedY, float expectedWidth, float expectedHeight, Boolean isExpandedAttribute) {
        if (isExpandedAttribute != null) {
            Assert.assertTrue((boolean)bpmnContent.contains(String.format("<bpmndi:BPMNShape id=\"shape_%s\" bpmnElement=\"%s\" isExpanded=\"%s\">", elementId, elementId, isExpandedAttribute.toString())));
        } else {
            Assert.assertTrue((boolean)bpmnContent.contains(String.format("<bpmndi:BPMNShape id=\"shape_%s\" bpmnElement=\"%s\">", elementId, elementId)));
        }
        Assert.assertTrue((boolean)bpmnContent.contains(String.format("<dc:Bounds height=\"%s\" width=\"%s\" x=\"%s\" y=\"%s\"/>", Float.valueOf(expectedHeight), Float.valueOf(expectedWidth), Float.valueOf(expectedX), Float.valueOf(expectedY))));
    }

    @Test
    public void testUnmarshall_ARIS_LANES_1() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_ARIS_LANES_1);
        Node bpmnDiagramNode = diagram.getGraph().getNode("Definitions_ID-ef3bd1b1-35d2-11e9-21c1-02b28450efee");
        Assert.assertNotNull((Object)bpmnDiagramNode);
        BPMNDiagramImpl bpmnDiagram = (BPMNDiagramImpl)((Definition)bpmnDiagramNode.getContent()).getDefinition();
        Assertions.assertDiagram(diagram, 7);
        Assert.assertEquals((Object)"ARIS_LANES_1", (Object)bpmnDiagram.getDiagramSet().getName().getValue());
        this.assertExpectedLane(diagram, "ID-fba59d50-35d2-11e9-21c1-02b28450efee", "Lane1", bpmnDiagramNode, "ID-fba59d56-35d2-11e9-21c1-02b28450efee");
        this.assertExpectedLane(diagram, "ID-fba59d52-35d2-11e9-21c1-02b28450efee", "Lane2", bpmnDiagramNode, "ID-fba59d59-35d2-11e9-21c1-02b28450efee");
    }

    @Test
    public void testUnmarshall_ARIS_LANES_2() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_ARIS_LANES_2);
        Node bpmnDiagramNode = diagram.getGraph().getNode("Definitions_ID-4c9756c0-35da-11e9-21c1-02b28450efee");
        Assert.assertNotNull((Object)bpmnDiagramNode);
        BPMNDiagramImpl bpmnDiagram = (BPMNDiagramImpl)((Definition)bpmnDiagramNode.getContent()).getDefinition();
        Assertions.assertDiagram(diagram, 12);
        Assert.assertEquals((Object)"ARIS_LANES_2", (Object)bpmnDiagram.getDiagramSet().getName().getValue());
        this.assertExpectedLane(diagram, "ID-57e50405-35da-11e9-21c1-02b28450efee", "Lane1.1", bpmnDiagramNode, "ID-57e5041a-35da-11e9-21c1-02b28450efee", "ID-57e5041d-35da-11e9-21c1-02b28450efee");
        this.assertExpectedLane(diagram, "ID-57e50402-35da-11e9-21c1-02b28450efee", "Lane1.2", bpmnDiagramNode, "ID-57e50414-35da-11e9-21c1-02b28450efee", "ID-57e50417-35da-11e9-21c1-02b28450efee");
        this.assertExpectedLane(diagram, "ID-57e5040e-35da-11e9-21c1-02b28450efee", "Lane2.1", bpmnDiagramNode, new String[0]);
        this.assertExpectedLane(diagram, "ID-57e5040b-35da-11e9-21c1-02b28450efee", "Lane2.2", bpmnDiagramNode, "ID-57e50420-35da-11e9-21c1-02b28450efee");
    }

    @Test
    public void testUnmarshall_ARIS_LANES_3() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_ARIS_LANES_3);
        Node bpmnDiagramNode = diagram.getGraph().getNode("Definitions_ID-3cad84c1-35dd-11e9-21c1-02b28450efee");
        Assert.assertNotNull((Object)bpmnDiagramNode);
        BPMNDiagramImpl bpmnDiagram = (BPMNDiagramImpl)((Definition)bpmnDiagramNode.getContent()).getDefinition();
        Assertions.assertDiagram(diagram, 17);
        Assert.assertEquals((Object)"ARIS_LANES_3", (Object)bpmnDiagram.getDiagramSet().getName().getValue());
        this.assertExpectedLane(diagram, "ID-43452405-35dd-11e9-21c1-02b28450efee", "LaneA1.1", bpmnDiagramNode, "ID-43452430-35dd-11e9-21c1-02b28450efee");
        this.assertExpectedLane(diagram, "ID-43452409-35dd-11e9-21c1-02b28450efee", "LaneA1.2.2", bpmnDiagramNode, "ID-43452424-35dd-11e9-21c1-02b28450efee");
        this.assertExpectedLane(diagram, "ID-43452410-35dd-11e9-21c1-02b28450efee", "LaneA1.2.1.1", bpmnDiagramNode, "ID-4345242d-35dd-11e9-21c1-02b28450efee");
        this.assertExpectedLane(diagram, "ID-43452413-35dd-11e9-21c1-02b28450efee", "LaneA1.2.1.2", bpmnDiagramNode, "ID-4345242a-35dd-11e9-21c1-02b28450efee");
        this.assertExpectedLane(diagram, "ID-43452417-35dd-11e9-21c1-02b28450efee", "LaneA2", bpmnDiagramNode, "ID-69882521-35df-11e9-21c1-02b28450efee");
        this.assertExpectedLane(diagram, "ID-4345241e-35dd-11e9-21c1-02b28450efee", "LaneA3.1", bpmnDiagramNode, "ID-69882527-35df-11e9-21c1-02b28450efee");
        this.assertExpectedLane(diagram, "ID-4345241b-35dd-11e9-21c1-02b28450efee", "LaneA3.2", bpmnDiagramNode, "ID-69882524-35df-11e9-21c1-02b28450efee");
    }

    @Test
    public void testUnmarshall_ARIS_MULTIPLE_COLLAPSED_SUBPROCESSES() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(ARIS_MULTIPLE_COLLAPSED_SUBPROCESSES);
        Assertions.assertDiagram(diagram, 11);
        String subProcess1_ID = "ID-4dee0202-4681-11e9-21c1-02b28450efee";
        Node subProcess1 = diagram.getGraph().getNode(subProcess1_ID);
        String task1_1 = "ID-4dee0204-4681-11e9-21c1-02b28450efee";
        String task1_2 = "ID-4dee0207-4681-11e9-21c1-02b28450efee";
        BPMNDirectDiagramMarshallerTest.assertContains(subProcess1, Arrays.asList(task1_1, task1_2));
        String subProcess2_ID = "ID-4dee020a-4681-11e9-21c1-02b28450efee";
        Node subProcess2 = diagram.getGraph().getNode(subProcess2_ID);
        String task2_1 = "ID-4dee020c-4681-11e9-21c1-02b28450efee";
        String task2_2 = "ID-4dee020f-4681-11e9-21c1-02b28450efee";
        BPMNDirectDiagramMarshallerTest.assertContains(subProcess2, Arrays.asList(task2_1, task2_2));
    }

    @Test
    public void testMarshall_ARIS_MULTIPLE_COLLAPSED_SUBPROCESSES() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(ARIS_MULTIPLE_COLLAPSED_SUBPROCESSES);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 10, 7);
        BPMNDirectDiagramMarshallerTest.assertCoordinatesProperlyCalculatedAndMarshalled(diagram, result, "ID-4dee0202-4681-11e9-21c1-02b28450efee", true);
        BPMNDirectDiagramMarshallerTest.assertCoordinatesProperlyCalculatedAndMarshalled(diagram, result, "ID-4dee0204-4681-11e9-21c1-02b28450efee", null);
        BPMNDirectDiagramMarshallerTest.assertCoordinatesProperlyCalculatedAndMarshalled(diagram, result, "ID-4dee0207-4681-11e9-21c1-02b28450efee", null);
        BPMNDirectDiagramMarshallerTest.assertCoordinatesProperlyCalculatedAndMarshalled(diagram, result, "ID-4dee020a-4681-11e9-21c1-02b28450efee", true);
        BPMNDirectDiagramMarshallerTest.assertCoordinatesProperlyCalculatedAndMarshalled(diagram, result, "ID-4dee020c-4681-11e9-21c1-02b28450efee", null);
        BPMNDirectDiagramMarshallerTest.assertCoordinatesProperlyCalculatedAndMarshalled(diagram, result, "ID-4dee020f-4681-11e9-21c1-02b28450efee", null);
    }

    @Test
    public void testUnmarshall_ARIS_NESTED_COLLAPSED_SUBPROCESSES() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(ARIS_NESTED_COLLAPSED_SUBPROCESSES);
        Assertions.assertDiagram(diagram, 9);
        String subProcessA1_ID = "ID-401c4a50-4673-11e9-21c1-02b28450efee";
        Node subProcessA1 = diagram.getGraph().getNode(subProcessA1_ID);
        String subProcessA2_ID = "ID-401c4a58-4673-11e9-21c1-02b28450efee";
        String taskA1_1 = "ID-401c4a55-4673-11e9-21c1-02b28450efee";
        String taskA1_2 = "ID-401c4a5b-4673-11e9-21c1-02b28450efee";
        String taskA1_3 = "ID-401c4a6b-4673-11e9-21c1-02b28450efee";
        BPMNDirectDiagramMarshallerTest.assertContains(subProcessA1, Arrays.asList(subProcessA2_ID, taskA1_1, taskA1_2, taskA1_3));
        String taskA2_1 = "ID-401c4a64-4673-11e9-21c1-02b28450efee";
        String taskA2_2 = "ID-401c4a67-4673-11e9-21c1-02b28450efee";
        Node subProcessA2 = diagram.getGraph().getNode(subProcessA2_ID);
        BPMNDirectDiagramMarshallerTest.assertContains(subProcessA2, Arrays.asList(taskA2_1, taskA2_2));
    }

    @Test
    public void testMarshall_ARIS_NESTED_COLLAPSED_SUBPROCESSES() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(ARIS_NESTED_COLLAPSED_SUBPROCESSES);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 8, 6);
        BPMNDirectDiagramMarshallerTest.assertCoordinatesProperlyCalculatedAndMarshalled(diagram, result, "ID-401c4a52-4673-11e9-21c1-02b28450efee", null);
        BPMNDirectDiagramMarshallerTest.assertCoordinatesProperlyCalculatedAndMarshalled(diagram, result, "ID-401c4a50-4673-11e9-21c1-02b28450efee", true);
        BPMNDirectDiagramMarshallerTest.assertCoordinatesProperlyCalculatedAndMarshalled(diagram, result, "ID-401c4a55-4673-11e9-21c1-02b28450efee", null);
        BPMNDirectDiagramMarshallerTest.assertCoordinatesProperlyCalculatedAndMarshalled(diagram, result, "ID-401c4a5b-4673-11e9-21c1-02b28450efee", null);
        BPMNDirectDiagramMarshallerTest.assertCoordinatesProperlyCalculatedAndMarshalled(diagram, result, "ID-401c4a6b-4673-11e9-21c1-02b28450efee", null);
        BPMNDirectDiagramMarshallerTest.assertCoordinatesProperlyCalculatedAndMarshalled(diagram, result, "ID-401c4a58-4673-11e9-21c1-02b28450efee", true);
        BPMNDirectDiagramMarshallerTest.assertCoordinatesProperlyCalculatedAndMarshalled(diagram, result, "ID-401c4a64-4673-11e9-21c1-02b28450efee", null);
        BPMNDirectDiagramMarshallerTest.assertCoordinatesProperlyCalculatedAndMarshalled(diagram, result, "ID-401c4a67-4673-11e9-21c1-02b28450efee", null);
    }

    @Test
    public void testUnmarshall_ARIS_COLLAPSED_SUBPROCESS_IN_LANE() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(ARIS_COLLAPSED_SUBPROCESS_IN_LANE);
        Assertions.assertDiagram(diagram, 7);
        String lane_ID = "ID-feebbb40-5aab-11e9-21c1-02b28450efee";
        Node lane = diagram.getGraph().getNode(lane_ID);
        String task1 = "ID-feebbb42-5aab-11e9-21c1-02b28450efee";
        String task2 = "ID-feebbb49-5aab-11e9-21c1-02b28450efee";
        String subProcess1_ID = "ID-feebbb45-5aab-11e9-21c1-02b28450efee";
        BPMNDirectDiagramMarshallerTest.assertContains(lane, Arrays.asList(task1, task2, subProcess1_ID));
        Node subProcess1 = diagram.getGraph().getNode(subProcess1_ID);
        String task1_1 = "ID-feebbb50-5aab-11e9-21c1-02b28450efee";
        String task1_2 = "ID-feebbb53-5aab-11e9-21c1-02b28450efee";
        BPMNDirectDiagramMarshallerTest.assertContains(subProcess1, Arrays.asList(task1_1, task1_2));
    }

    @Test
    public void testMarshall_ARIS_COLLAPSED_SUBPROCESS_IN_LANE() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(ARIS_COLLAPSED_SUBPROCESS_IN_LANE);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 6, 3);
        BPMNDirectDiagramMarshallerTest.assertCoordinatesProperlyCalculatedAndMarshalled(diagram, result, "ID-feebbb40-5aab-11e9-21c1-02b28450efee", null);
        BPMNDirectDiagramMarshallerTest.assertCoordinatesProperlyCalculatedAndMarshalled(diagram, result, "ID-feebbb42-5aab-11e9-21c1-02b28450efee", null);
        BPMNDirectDiagramMarshallerTest.assertCoordinatesProperlyCalculatedAndMarshalled(diagram, result, "ID-feebbb49-5aab-11e9-21c1-02b28450efee", null);
        BPMNDirectDiagramMarshallerTest.assertCoordinatesProperlyCalculatedAndMarshalled(diagram, result, "ID-feebbb45-5aab-11e9-21c1-02b28450efee", true);
        BPMNDirectDiagramMarshallerTest.assertCoordinatesProperlyCalculatedAndMarshalled(diagram, result, "ID-feebbb50-5aab-11e9-21c1-02b28450efee", null);
        BPMNDirectDiagramMarshallerTest.assertCoordinatesProperlyCalculatedAndMarshalled(diagram, result, "ID-feebbb53-5aab-11e9-21c1-02b28450efee", null);
    }

    private static void assertContains(Node<View<? extends Definition>, ?> container, List<String> containedNodes) {
        List<Node> children = GraphUtils.getChildNodes(container).stream().filter(child -> containedNodes.contains(child.getUUID())).collect(Collectors.toList());
        Bounds containerBounds = ((View)container.getContent()).getBounds();
        Point2D containerAbsolutePosition = GraphUtils.getComputedPosition(container);
        Bounds containerAbsoluteBounds = Bounds.create((double)containerAbsolutePosition.getX(), (double)containerAbsolutePosition.getY(), (double)(containerAbsolutePosition.getX() + containerBounds.getWidth()), (double)(containerAbsolutePosition.getY() + containerBounds.getHeight()));
        Assert.assertEquals((long)containedNodes.size(), (long)children.size());
        children.forEach(child -> {
            Bounds relativeBounds = ((View)child.getContent()).getBounds();
            Point2D absolutePosition = GraphUtils.getComputedPosition((Node)child);
            Bounds absoluteBounds = Bounds.create((double)absolutePosition.getX(), (double)absolutePosition.getY(), (double)(absolutePosition.getX() + relativeBounds.getWidth()), (double)(absolutePosition.getY() + relativeBounds.getHeight()));
            BPMNDirectDiagramMarshallerTest.assertContains(containerAbsoluteBounds, absoluteBounds);
        });
    }

    private static void assertContains(Bounds container, Bounds contained) {
        Assert.assertTrue((container.getUpperLeft().getX() < contained.getUpperLeft().getX() ? 1 : 0) != 0);
        Assert.assertTrue((container.getUpperLeft().getY() < contained.getUpperLeft().getY() ? 1 : 0) != 0);
        Assert.assertTrue((container.getLowerRight().getX() > contained.getLowerRight().getX() ? 1 : 0) != 0);
        Assert.assertTrue((container.getLowerRight().getY() > contained.getLowerRight().getY() ? 1 : 0) != 0);
    }

    private void assertExpectedLane(Diagram<Graph, Metadata> diagram, String laneId, String laneName, Node<? extends Definition, ?> parentNode, String ... expectedChildrenIds) {
        Node laneNode = diagram.getGraph().getNode(laneId);
        Assert.assertNotNull((String)("Node: " + laneId + " was not found in diagram"), (Object)laneNode);
        Assert.assertTrue((String)("Node: " + laneId + " is not a Lane"), (boolean)(((Definition)laneNode.getContent()).getDefinition() instanceof Lane));
        Lane lane = (Lane)((Definition)laneNode.getContent()).getDefinition();
        Assert.assertEquals((Object)laneName, (Object)lane.getGeneral().getName().getValue());
        Assert.assertEquals((long)1L, (long)laneNode.getInEdges().size());
        Assert.assertEquals(parentNode, (Object)((Edge)laneNode.getInEdges().get(0)).getSourceNode());
        if (expectedChildrenIds == null) {
            Assert.assertEquals((long)0L, (long)laneNode.getOutEdges().size());
        } else {
            Assert.assertEquals((long)expectedChildrenIds.length, (long)laneNode.getOutEdges().size());
            Arrays.stream(expectedChildrenIds).forEach(expectedChildrenId -> Assert.assertTrue((boolean)laneNode.getOutEdges().stream().anyMatch(outEdge -> outEdge.getTargetNode().getUUID().equals(expectedChildrenId))));
        }
    }

    @Test
    public void testMarshallWorkItems() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_SERVICE_TASKS);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 4, 3);
        Assert.assertTrue((boolean)result.contains("drools:taskName=\"Email\""));
        Assert.assertTrue((boolean)result.contains("drools:taskName=\"Log\""));
    }

    @Test
    public void testNotifications() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_REASSIGNMENT_NOTIFICATION);
        Node multipleInstanceSubprocessNode = diagram.getGraph().getNode("_F402A212-CBB8-4F1B-A7FC-EE185C41BBF7");
        org.kie.workbench.common.stunner.bpmn.definition.UserTask userTask = (org.kie.workbench.common.stunner.bpmn.definition.UserTask)((Definition)multipleInstanceSubprocessNode.getContent()).getDefinition();
        NotificationsInfo notificationsInfo = userTask.getExecutionSet().getNotificationsInfo();
        Assert.assertEquals((long)1L, (long)notificationsInfo.getValue().getValues().size());
        NotificationValue notification = (NotificationValue)notificationsInfo.getValue().getValues().get(0);
        Assert.assertEquals((Object)"[from:director|tousers:alessio,guest,john|togroups:Developer,IT|replyTo:guest|subject:test|body:test body]@[11h]", (Object)notification.toCDATAFormat());
        Assert.assertEquals((Object)"NotStartedNotify", (Object)notification.getType());
    }

    @Test
    public void testReassignments() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_REASSIGNMENT_NOTIFICATION);
        Node multipleInstanceSubprocessNode = diagram.getGraph().getNode("_F402A212-CBB8-4F1B-A7FC-EE185C41BBF7");
        org.kie.workbench.common.stunner.bpmn.definition.UserTask userTask = (org.kie.workbench.common.stunner.bpmn.definition.UserTask)((Definition)multipleInstanceSubprocessNode.getContent()).getDefinition();
        ReassignmentsInfo reassignmentsInfo = userTask.getExecutionSet().getReassignmentsInfo();
        Assert.assertEquals((long)2L, (long)reassignmentsInfo.getValue().getValues().size());
        ReassignmentValue reassignment = (ReassignmentValue)reassignmentsInfo.getValue().getValues().get(0);
        Assert.assertEquals((Object)"[users:Reviewer|groups:kirill]@[1111w]", (Object)reassignment.toCDATAFormat());
        Assert.assertEquals((Object)"NotStartedReassign", (Object)reassignment.getType());
        reassignment = (ReassignmentValue)reassignmentsInfo.getValue().getValues().get(1);
        Assert.assertEquals((Object)"[users:Forms,HR|groups:director,guest]@[22h]", (Object)reassignment.toCDATAFormat());
        Assert.assertEquals((Object)"NotCompletedReassign", (Object)reassignment.getType());
    }

    @Test
    public void testUnmarshallEventGateway() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_EVENT_GATEWAY);
        Assertions.assertDiagram(diagram, 7);
        Assert.assertEquals((Object)diagram.getMetadata().getTitle(), (Object)"TestEventGateway");
        Graph graph = diagram.getGraph();
        Node gatewayNode = graph.getNode("_AFDF2596-C521-4753-AC22-2DCCAD391F98");
        Assert.assertTrue((boolean)(((Definition)gatewayNode.getContent()).getDefinition() instanceof EventGateway));
        EventGateway eventGateway = (EventGateway)((Definition)gatewayNode.getContent()).getDefinition();
        Assert.assertEquals((Object)"EventGatewayName", (Object)eventGateway.getGeneral().getName().getValue());
        Assert.assertEquals((Object)"EventGatewayDocumentation", (Object)eventGateway.getGeneral().getDocumentation().getValue());
        SequenceFlow inSequenceFlow = gatewayNode.getInEdges().stream().filter(edge -> "_E805280D-5862-4F56-B02A-E34F7D519050".equals(edge.getUUID())).map(edge -> (SequenceFlow)((ViewConnector)edge.getContent()).getDefinition()).findFirst().orElseThrow(() -> new Exception("Expected sequenceFlow: _E805280D-5862-4F56-B02A-E34F7D519050 was not found"));
        SequenceFlow outSequenceFlow1 = gatewayNode.getOutEdges().stream().filter(edge -> "_CCEF6352-760D-4641-B9C9-0B01FD4DD704".equals(edge.getUUID())).map(edge -> (SequenceFlow)((ViewConnector)edge.getContent()).getDefinition()).findFirst().orElseThrow(() -> new Exception("Expected sequenceFlow: _CCEF6352-760D-4641-B9C9-0B01FD4DD704 was not found"));
        SequenceFlow outSequenceFlow2 = gatewayNode.getOutEdges().stream().filter(edge -> "_1CD28E0D-1910-45FE-9AEC-932FA28C77AA".equals(edge.getUUID())).map(edge -> (SequenceFlow)((ViewConnector)edge.getContent()).getDefinition()).findFirst().orElseThrow(() -> new Exception("Expected sequenceFlow: _1CD28E0D-1910-45FE-9AEC-932FA28C77AA was not found"));
        Assert.assertNotNull((Object)inSequenceFlow);
        Assert.assertEquals((Object)"inSequence", (Object)inSequenceFlow.getGeneral().getName().getValue());
        Assert.assertNotNull((Object)outSequenceFlow1);
        Assert.assertEquals((Object)"outSequence1", (Object)outSequenceFlow1.getGeneral().getName().getValue());
        Assert.assertNotNull((Object)outSequenceFlow2);
        Assert.assertEquals((Object)"outSequence2", (Object)outSequenceFlow2.getGeneral().getName().getValue());
    }

    @Test
    public void testMarshallEventGateway() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall(BPMN_EVENT_GATEWAY);
        Assertions.assertDiagram(diagram, 7);
        String result = this.tested.marshall(diagram);
        Assertions.assertDiagram(result, 1, 6, 5);
        Assert.assertTrue((boolean)result.contains("<bpmn2:eventBasedGateway id=\"_AFDF2596-C521-4753-AC22-2DCCAD391F98\" name=\"EventGatewayName\" gatewayDirection=\"Diverging\">"));
        Assert.assertTrue((boolean)result.contains("<![CDATA[EventGatewayDocumentation]]></bpmn2:documentation>"));
        Assert.assertTrue((boolean)result.contains("<drools:metaValue><![CDATA[EventGatewayName]]></drools:metaValue>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:incoming>_E805280D-5862-4F56-B02A-E34F7D519050</bpmn2:incoming>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:outgoing>_1CD28E0D-1910-45FE-9AEC-932FA28C77AA</bpmn2:outgoing>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:outgoing>_CCEF6352-760D-4641-B9C9-0B01FD4DD704</bpmn2:outgoing>"));
        Assert.assertTrue((boolean)result.contains("</bpmn2:eventBasedGateway>"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:sequenceFlow id=\"_E805280D-5862-4F56-B02A-E34F7D519050\" name=\"inSequence\" sourceRef=\"_FC7A4CF4-08CC-4F85-A518-34E67416160C\" targetRef=\"_AFDF2596-C521-4753-AC22-2DCCAD391F98\">"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:sequenceFlow id=\"_CCEF6352-760D-4641-B9C9-0B01FD4DD704\" name=\"outSequence1\" sourceRef=\"_AFDF2596-C521-4753-AC22-2DCCAD391F98\" targetRef=\"_F2D949C2-84FE-4AF9-A4B2-C2DC917C1050\">"));
        Assert.assertTrue((boolean)result.contains("<bpmn2:sequenceFlow id=\"_1CD28E0D-1910-45FE-9AEC-932FA28C77AA\" name=\"outSequence2\" sourceRef=\"_AFDF2596-C521-4753-AC22-2DCCAD391F98\" targetRef=\"_19AA4F91-684B-495F-9880-DA506E0696FE\">"));
    }

    private List<Node> getNodes(Diagram<Graph, Metadata> diagram) {
        Graph graph = diagram.getGraph();
        Assert.assertNotNull((Object)graph);
        Iterator nodesIterable = graph.nodes().iterator();
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodesIterable.forEachRemaining(nodes::add);
        return nodes;
    }

    private Iterator<Element> nodesIterator(Diagram<Graph, Metadata> diagram) {
        return diagram.getGraph().nodes().iterator();
    }

    private Process getProcess(Definitions definitions) {
        Object o = Arrays.stream(definitions.getRootElements().toArray()).filter(x -> x instanceof Process).findFirst().orElse(null);
        return o;
    }

    private void assertItemExists(List<RootElement> rootElements, String id, String structureRef) {
        for (RootElement rootElement : rootElements) {
            if (!id.equals(rootElement.getId()) || !(rootElement instanceof ItemDefinition)) continue;
            ItemDefinition itemDefinition = (ItemDefinition)rootElement;
            if (structureRef.equals(itemDefinition.getStructureRef())) {
                return;
            }
            Assert.fail((String)("Found mismatching item with id = " + id + " " + itemDefinition));
        }
        Assert.fail((String)("Could not find item id = " + id));
    }

    private Property getProcessProperty(List<Property> properties, String id, String itemSubjectRef) {
        for (Property property : properties) {
            if (!id.equals(property.getId()) && !id.equals(property.getName())) continue;
            if (itemSubjectRef.equals(property.getItemSubjectRef().getId())) {
                return property;
            }
            return null;
        }
        return null;
    }

    private String getProcessPropertyValue(Process process, String propertyName) {
        for (FeatureMap.Entry entry : process.getAnyAttribute()) {
            if (!propertyName.equals(entry.getEStructuralFeature().getName())) continue;
            return entry.getValue().toString();
        }
        return null;
    }

    private String getProcessExtensionValue(Process process, String propertyName) {
        List extensionValues = process.getExtensionValues();
        for (ExtensionAttributeValue extensionValue : extensionValues) {
            FeatureMap featureMap = extensionValue.getValue();
            for (int i = 0; i < featureMap.size(); ++i) {
                EStructuralFeatureImpl.SimpleFeatureMapEntry featureMapEntry = (EStructuralFeatureImpl.SimpleFeatureMapEntry)featureMap.get(i);
                MetaDataType featureMapValue = (MetaDataType)featureMapEntry.getValue();
                if (!propertyName.equals(featureMapValue.getName())) continue;
                return featureMapValue.getMetaValue();
            }
        }
        return "";
    }

    private Object getNamedFlowElement(Process process, Class cls, String name) {
        List flowElements = process.getFlowElements();
        for (FlowElement flowElement : flowElements) {
            if (!cls.isInstance(flowElement) || !name.equals(flowElement.getName())) continue;
            return flowElement;
        }
        return null;
    }

    private DataInput getDataInput(Activity activity, String name) {
        List dataInputs;
        InputOutputSpecification ioSpecification = activity.getIoSpecification();
        if (ioSpecification != null && (dataInputs = ioSpecification.getDataInputs()) != null) {
            return Arrays.stream(dataInputs.toArray(new DataInput[dataInputs.size()])).filter(dataInput -> name.equals(dataInput.getName())).findFirst().orElse(null);
        }
        return null;
    }

    private DataOutput getDataOutput(Activity activity, String name) {
        List dataOutputs;
        InputOutputSpecification ioSpecification = activity.getIoSpecification();
        if (ioSpecification != null && (dataOutputs = ioSpecification.getDataOutputs()) != null) {
            return Arrays.stream(dataOutputs.toArray(new DataOutput[dataOutputs.size()])).filter(dataOutput -> name.equals(dataOutput.getName())).findFirst().orElse(null);
        }
        return null;
    }

    private void validateDataInputOrOutput(ItemAwareElement itemAwareElement, String idSuffix, String dataType, String itemSubjectRefSuffix) {
        Assert.assertNotNull((Object)itemAwareElement);
        Assert.assertTrue((boolean)itemAwareElement.getId().endsWith(idSuffix));
        ItemDefinition itemDefinition = itemAwareElement.getItemSubjectRef();
        Assert.assertNotNull((Object)itemDefinition);
        Assert.assertEquals((Object)itemDefinition.getStructureRef(), (Object)dataType);
        Assert.assertTrue((boolean)itemDefinition.getId().endsWith(itemSubjectRefSuffix));
    }

    private ItemAwareElement getDataInputAssociationSourceRef(Activity activity, String id) {
        List dataInputAssociations = activity.getDataInputAssociations();
        if (dataInputAssociations != null) {
            for (DataInputAssociation dataInputAssociation : dataInputAssociations) {
                ItemAwareElement result;
                List sourceRef = dataInputAssociation.getSourceRef();
                if (sourceRef == null || sourceRef.isEmpty() || (result = (ItemAwareElement)Arrays.stream(sourceRef.toArray(new ItemAwareElement[sourceRef.size()])).filter(itemAwareElement -> id.equals(itemAwareElement.getId()) || id.equals(((Property)itemAwareElement).getName())).findFirst().orElse(null)) == null) continue;
                return result;
            }
        }
        return null;
    }

    private ItemAwareElement getDataInputAssociationTargetRef(Activity activity, String idSuffix) {
        List dataInputAssociations = activity.getDataInputAssociations();
        if (dataInputAssociations != null) {
            for (DataInputAssociation dataInputAssociation : dataInputAssociations) {
                ItemAwareElement targetRef = dataInputAssociation.getTargetRef();
                if (targetRef == null || !targetRef.getId().endsWith(idSuffix)) continue;
                return targetRef;
            }
        }
        return null;
    }

    private ItemAwareElement getDataOutputAssociationSourceRef(Activity activity, String idSuffix) {
        List dataOutputAssociations = activity.getDataOutputAssociations();
        if (dataOutputAssociations != null) {
            for (DataOutputAssociation dataOutputAssociation : dataOutputAssociations) {
                ItemAwareElement result;
                List sourceRef = dataOutputAssociation.getSourceRef();
                if (sourceRef == null || sourceRef.isEmpty() || (result = (ItemAwareElement)Arrays.stream(sourceRef.toArray(new ItemAwareElement[sourceRef.size()])).filter(itemAwareElement -> itemAwareElement.getId().endsWith(idSuffix)).findFirst().orElse(null)) == null) continue;
                return result;
            }
        }
        return null;
    }

    private ItemAwareElement getDataOutputAssociationTargetRef(Activity activity, String id) {
        List dataOutputAssociations = activity.getDataOutputAssociations();
        if (dataOutputAssociations != null) {
            for (DataOutputAssociation dataOutputAssociation : dataOutputAssociations) {
                ItemAwareElement targetRef = dataOutputAssociation.getTargetRef();
                if ((targetRef == null || !id.equals(targetRef.getId())) && !id.equals(((Property)targetRef).getName())) continue;
                return targetRef;
            }
        }
        return null;
    }

    private Diagram<Graph, Metadata> unmarshall(String s) throws Exception {
        return Unmarshalling.unmarshall((DiagramMarshaller)this.tested, s);
    }

    private Diagram<Graph, Metadata> unmarshall(ByteArrayInputStream s) throws Exception {
        return Unmarshalling.unmarshall((DiagramMarshaller)this.tested, s);
    }
}

