/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server.conversion;

import java.util.Iterator;
import java.util.List;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.drools.core.util.StringUtils;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.models.guided.dtable.shared.model.RowNumberCol52;
import org.drools.workbench.models.guided.dtable.shared.model.RuleNameColumn;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.util.BRLColumnUtil;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.util.ColumnContext;
import org.kie.soup.commons.validation.PortablePreconditions;

public class PatternRowBuilder {
    private static final int PATTERN_ROW = 6;
    private final GuidedDecisionTable52 dtable;
    private final Sheet sheet;
    private final Row patternRow;
    private ColumnContext columnContext;
    private int columnIndex = 0;
    private int sourceIndex = 0;

    public PatternRowBuilder(Sheet sheet, GuidedDecisionTable52 dtable, ColumnContext columnContext) {
        this.sheet = (Sheet)PortablePreconditions.checkNotNull((String)"sheet", (Object)sheet);
        this.dtable = (GuidedDecisionTable52)PortablePreconditions.checkNotNull((String)"dtable", (Object)dtable);
        this.columnContext = (ColumnContext)PortablePreconditions.checkNotNull((String)"brlColumnIndex", (Object)columnContext);
        this.patternRow = sheet.createRow(6);
    }

    public void build() {
        List expandedColumns = this.dtable.getExpandedColumns();
        while (this.sourceIndex < expandedColumns.size()) {
            block7: {
                block4: {
                    BaseColumn baseColumn;
                    block6: {
                        block5: {
                            block3: {
                                baseColumn = (BaseColumn)expandedColumns.get(this.sourceIndex);
                                if (!(baseColumn instanceof BRLActionVariableColumn)) break block3;
                                this.sourceIndex = this.sourceIndex + this.dtable.getBRLColumn((BRLActionVariableColumn)baseColumn).getChildColumns().size() - 1;
                                break block4;
                            }
                            if (!(baseColumn instanceof BRLConditionVariableColumn)) break block5;
                            this.addBRLConditionVariableColumn((BRLConditionVariableColumn)baseColumn);
                            break block4;
                        }
                        if (!(baseColumn instanceof ConditionCol52)) break block6;
                        this.addConditionCol52((ConditionCol52)baseColumn);
                        break block4;
                    }
                    if (baseColumn instanceof RowNumberCol52 || baseColumn instanceof RuleNameColumn) break block7;
                }
                ++this.columnIndex;
            }
            ++this.sourceIndex;
        }
    }

    public void addConditionCol52(ConditionCol52 baseColumn) {
        ConditionCol52 col = baseColumn;
        Pattern52 pattern = this.dtable.getPattern(col);
        int columnWidth = this.getColumnWidth(pattern);
        this.addPattern(columnWidth, this.hasEntryPoint(pattern), pattern.isNegated(), pattern.getBoundName(), pattern.getFactType());
    }

    public void addBRLConditionVariableColumn(BRLConditionVariableColumn baseColumn) {
        BRLConditionColumn brlColumn = this.dtable.getBRLColumn(baseColumn);
        if (BRLColumnUtil.canThisColumnBeSplitToMultiple(brlColumn)) {
            Iterator patternIterator = brlColumn.getDefinition().iterator();
            while (patternIterator.hasNext()) {
                IPattern iPattern = (IPattern)patternIterator.next();
                if (iPattern instanceof FactPattern) {
                    FactPattern factPattern = (FactPattern)iPattern;
                    int amountOfUniqueVariables = this.columnContext.getAmountOfUniqueVariables(iPattern);
                    this.addPattern(amountOfUniqueVariables, false, factPattern.isNegated(), factPattern.getBoundName(), factPattern.getFactType());
                    this.sourceIndex = this.sourceIndex + amountOfUniqueVariables - 1;
                }
                if (!patternIterator.hasNext()) continue;
                ++this.columnIndex;
            }
        } else {
            this.sourceIndex = this.sourceIndex + brlColumn.getChildColumns().size() - 1;
        }
    }

    private void addPattern(int columnWidth, boolean hasEntryPoint, boolean negated, String boundName, String factType) {
        int endIndex = this.columnIndex + columnWidth - 1;
        for (int i = this.columnIndex; i <= endIndex; ++i) {
            if (hasEntryPoint) {
                throw new UnsupportedOperationException("Conversion of the entry points are not supported.");
            }
            if (negated) {
                this.patternRow.createCell(i).setCellValue(String.format("not %s", factType));
                continue;
            }
            if (boundName == null) {
                this.patternRow.createCell(i).setCellValue(factType);
                continue;
            }
            this.patternRow.createCell(i).setCellValue(String.format("%s : %s", boundName, factType));
        }
        if (columnWidth > 1) {
            this.sheet.addMergedRegion(new CellRangeAddress(6, 6, this.columnIndex, endIndex));
            this.sheet.validateMergedRegions();
            this.columnIndex = endIndex;
            this.sourceIndex = this.sourceIndex + columnWidth - 1;
        }
    }

    private boolean hasEntryPoint(Pattern52 pattern) {
        return !StringUtils.isEmpty((CharSequence)pattern.getEntryPointName());
    }

    private int getColumnWidth(Pattern52 pattern) {
        if (StringUtils.isEmpty((CharSequence)pattern.getBoundName())) {
            return 1;
        }
        return pattern.getChildColumns().size();
    }
}

