/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.archetype.mgmt.backend.preference;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.shared.preferences.WorkbenchPreferenceScopeResolutionStrategies;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.kie.workbench.common.screens.archetype.mgmt.shared.preferences.ArchetypePreferences;
import org.uberfire.preferences.shared.PreferenceScope;
import org.uberfire.preferences.shared.PreferenceScopeFactory;
import org.uberfire.preferences.shared.impl.PreferenceScopeResolutionStrategyInfo;
import org.uberfire.security.Resource;

@ApplicationScoped
public class ArchetypePreferencesManager {
    private static final String EMPTY = "";
    private PreferenceScopeFactory scopeFactory;
    private WorkbenchPreferenceScopeResolutionStrategies workbenchPreferenceScopeResolutionStrategies;
    private ArchetypePreferences archetypePreferences;
    private OrganizationalUnitService ouService;

    public ArchetypePreferencesManager() {
    }

    @Inject
    public ArchetypePreferencesManager(PreferenceScopeFactory scopeFactory, WorkbenchPreferenceScopeResolutionStrategies workbenchPreferenceScopeResolutionStrategies, ArchetypePreferences archetypePreferences, OrganizationalUnitService ouService) {
        this.scopeFactory = scopeFactory;
        this.workbenchPreferenceScopeResolutionStrategies = workbenchPreferenceScopeResolutionStrategies;
        this.archetypePreferences = archetypePreferences;
        this.ouService = ouService;
    }

    public void addArchetype(String archetype) {
        this.archetypePreferences.load();
        if (this.addArchetypePreference(archetype)) {
            this.archetypePreferences.save(this.getGlobalScope());
        }
        this.getOuIdentifiers().forEach(identifier -> {
            PreferenceScopeResolutionStrategyInfo info = this.workbenchPreferenceScopeResolutionStrategies.getSpaceInfoFor(identifier);
            this.archetypePreferences.load(info);
            if (this.addArchetypePreference(archetype)) {
                this.archetypePreferences.save(info);
            }
        });
    }

    private boolean addArchetypePreference(String archetype) {
        boolean hasEffect = false;
        if (!this.containsArchetype(archetype)) {
            Map archetypeSelectionMap = this.archetypePreferences.getArchetypeSelectionMap();
            archetypeSelectionMap.put(archetype, true);
            if (archetypeSelectionMap.size() == 1) {
                this.archetypePreferences.setDefaultSelection(archetype);
            }
            hasEffect = true;
        }
        return hasEffect;
    }

    public void removeArchetype(String archetype) {
        this.archetypePreferences.load();
        if (this.removeArchetypePreference(archetype)) {
            this.archetypePreferences.save(this.getGlobalScope());
        }
        this.getOuIdentifiers().forEach(identifier -> {
            PreferenceScopeResolutionStrategyInfo info = this.workbenchPreferenceScopeResolutionStrategies.getSpaceInfoFor(identifier);
            this.archetypePreferences.load(info);
            if (this.removeArchetypePreference(archetype)) {
                this.archetypePreferences.save(info);
            }
        });
    }

    private boolean removeArchetypePreference(String archetype) {
        boolean hasEffect = false;
        if (this.containsArchetype(archetype)) {
            Map archetypeSelectionMap = this.archetypePreferences.getArchetypeSelectionMap();
            boolean updateDefault = this.archetypePreferences.getDefaultSelection().equals(archetype);
            archetypeSelectionMap.remove(archetype);
            if (updateDefault) {
                Optional firstArchetype = archetypeSelectionMap.keySet().stream().sorted().findFirst();
                this.archetypePreferences.setDefaultSelection(firstArchetype.orElse(EMPTY));
            }
            hasEffect = true;
        }
        return hasEffect;
    }

    public void setDefaultArchetype(String archetype) {
        this.archetypePreferences.load();
        if (this.setDefaultArchetypePreference(archetype)) {
            this.archetypePreferences.save(this.getGlobalScope());
        }
        this.getOuIdentifiers().forEach(identifier -> {
            PreferenceScopeResolutionStrategyInfo info = this.workbenchPreferenceScopeResolutionStrategies.getSpaceInfoFor(identifier);
            this.archetypePreferences.load(info);
            if (this.setDefaultArchetypePreference(archetype)) {
                this.archetypePreferences.save(info);
            }
        });
    }

    private boolean setDefaultArchetypePreference(String archetype) {
        boolean hasEffect = false;
        if (this.containsArchetype(archetype)) {
            this.archetypePreferences.setDefaultSelection(archetype);
            hasEffect = true;
        }
        return hasEffect;
    }

    public void initializeCustomPreferences() {
        this.getOuIdentifiers().forEach(this::initializeCustomPreference);
    }

    public void initializeCustomPreference(String identifier) {
        PreferenceScopeResolutionStrategyInfo info = this.workbenchPreferenceScopeResolutionStrategies.getSpaceInfoFor(identifier);
        this.archetypePreferences.load(info);
        this.archetypePreferences.save(info);
    }

    private List<String> getOuIdentifiers() {
        return this.ouService.getAllOrganizationalUnits().stream().map(Resource::getIdentifier).collect(Collectors.toList());
    }

    private PreferenceScope getGlobalScope() {
        return this.scopeFactory.createScope("global");
    }

    public void enableArchetype(String archetype, boolean isEnabled, boolean customIncluded) {
        this.archetypePreferences.load();
        if (this.enableArchetypePreference(archetype, isEnabled)) {
            this.archetypePreferences.save(this.getGlobalScope());
        }
        if (customIncluded) {
            this.getOuIdentifiers().forEach(identifier -> {
                PreferenceScopeResolutionStrategyInfo info = this.workbenchPreferenceScopeResolutionStrategies.getSpaceInfoFor(identifier);
                this.archetypePreferences.load(info);
                if (this.enableArchetypePreference(archetype, isEnabled)) {
                    this.archetypePreferences.save(info);
                }
            });
        }
    }

    private boolean enableArchetypePreference(String archetype, boolean isEnabled) {
        boolean hasEffect = false;
        if (this.containsArchetype(archetype)) {
            boolean updateDefault;
            Map archetypeSelectionMap = this.archetypePreferences.getArchetypeSelectionMap();
            archetypeSelectionMap.put(archetype, isEnabled);
            boolean bl = updateDefault = !isEnabled && this.archetypePreferences.getDefaultSelection().equals(archetype);
            if (updateDefault) {
                Optional<String> firstValidArchetype = archetypeSelectionMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).findFirst();
                this.archetypePreferences.setDefaultSelection(firstValidArchetype.orElse(EMPTY));
            }
            hasEffect = true;
        }
        return hasEffect;
    }

    boolean containsArchetype(String archetype) {
        return this.archetypePreferences.getArchetypeSelectionMap().containsKey(archetype);
    }
}

