/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.builder.core;

import java.util.Set;
import org.kie.scanner.KieModuleMetaData;
import org.kie.soup.project.datamodel.oracle.TypeSource;

public class TypeSourceResolver {
    private final Set<String> javaResources;
    private final KieModuleMetaData kieModuleMetaData;

    public TypeSourceResolver(KieModuleMetaData kieModuleMetaData, Set<String> javaResources) {
        this.kieModuleMetaData = kieModuleMetaData;
        this.javaResources = javaResources;
    }

    public TypeSource getTypeSource(Class<?> clazz) {
        if (this.isDeclaredInDRL(clazz)) {
            return TypeSource.DECLARED;
        }
        if (this.isDefinedInProjectOrWithinDependency(clazz)) {
            return TypeSource.JAVA_PROJECT;
        }
        return TypeSource.JAVA_DEPENDENCY;
    }

    private boolean isDefinedInProjectOrWithinDependency(Class<?> clazz) {
        return this.javaResources.contains(this.toFQCN(clazz));
    }

    private boolean isDeclaredInDRL(Class<?> clazz) {
        return this.kieModuleMetaData.getTypeMetaInfo(clazz).isDeclaredType();
    }

    private String toFQCN(Class<?> clazz) {
        String fullyQualifiedClassName = clazz.getName();
        int innerClassIdentifierIndex = fullyQualifiedClassName.indexOf("$");
        if (innerClassIdentifierIndex > 0) {
            return fullyQualifiedClassName.substring(0, innerClassIdentifierIndex);
        }
        return fullyQualifiedClassName;
    }
}

