/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.associations;

import org.eclipse.bpmn2.Association;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Result;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.ElementContainer;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.AssociationPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.BasePropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNViewDefinition;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssociationConverter {
    private static final Logger LOG = LoggerFactory.getLogger(AssociationConverter.class);
    private final PropertyWriterFactory propertyWriterFactory;

    public AssociationConverter(PropertyWriterFactory propertyWriterFactory) {
        this.propertyWriterFactory = propertyWriterFactory;
    }

    public Result<BasePropertyWriter> toFlowElement(Edge<?, ?> edge, ElementContainer process) {
        ViewConnector connector = (ViewConnector)edge.getContent();
        org.kie.workbench.common.stunner.bpmn.definition.Association definition = (org.kie.workbench.common.stunner.bpmn.definition.Association)connector.getDefinition();
        Association association = Factories.bpmn2.createAssociation();
        AssociationPropertyWriter p = this.propertyWriterFactory.of(association);
        association.setId(edge.getUUID());
        BasePropertyWriter pSrc = process.getChildElement(edge.getSourceNode().getUUID());
        BasePropertyWriter pTgt = process.getChildElement(edge.getTargetNode().getUUID());
        if (pSrc == null || pTgt == null) {
            String msg = String.format("BasePropertyWriter was not found for source node or target node at edge: %s, pSrc = %s, pTgt = %s", edge.getUUID(), pSrc, pTgt);
            LOG.debug(msg);
            return Result.failure(msg, new MarshallingMessage[0]);
        }
        p.setSource(pSrc);
        p.setTarget(pTgt);
        p.setConnection((ViewConnector<? extends BPMNViewDefinition>)connector);
        BPMNGeneralSet general = definition.getGeneral();
        p.setDocumentation(general.getDocumentation().getValue());
        p.setDirectionAssociation(definition);
        return Result.of(p, new MarshallingMessage[0]);
    }
}

