/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Expression;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.PotentialOwner;
import org.eclipse.bpmn2.ResourceAssignmentExpression;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.UserTask;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomInput;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.ParsedNotificationsInfos;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.ParsedReassignmentsInfos;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.associations.AssociationType;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.MultipleInstanceActivityPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.Scripts;
import org.kie.workbench.common.stunner.bpmn.definition.property.assignee.Actors;
import org.kie.workbench.common.stunner.bpmn.definition.property.notification.NotificationTypeListValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.notification.NotificationsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.reassignment.ReassignmentTypeListValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.reassignment.ReassignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.OnEntryAction;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.OnExitAction;

public class UserTaskPropertyWriter
extends MultipleInstanceActivityPropertyWriter {
    private final UserTask task;
    private final CustomInput<String> description;
    private final CustomInput<String> createdBy;
    private final CustomInput<String> taskName;
    private final CustomInput<String> groupId;
    private final CustomInput<Boolean> skippable;
    private final CustomInput<String> priority;
    private final CustomInput<String> subject;
    private final CustomInput<String> content;
    private final CustomInput<String> notStartedReassign;
    private final CustomInput<String> notCompletedReassign;
    private final CustomInput<String> notStartedNotify;
    private final CustomInput<String> notCompletedNotify;

    public UserTaskPropertyWriter(UserTask task, VariableScope variableScope) {
        super((Activity)task, variableScope);
        this.task = task;
        this.skippable = CustomInput.skippable.of((Task)task);
        this.addItemDefinition(this.skippable.typeDef());
        this.priority = CustomInput.priority.of((Task)task);
        this.addItemDefinition(this.priority.typeDef());
        this.subject = CustomInput.subject.of((Task)task);
        this.addItemDefinition(this.subject.typeDef());
        this.description = CustomInput.description.of((Task)task);
        this.addItemDefinition(this.description.typeDef());
        this.createdBy = CustomInput.createdBy.of((Task)task);
        this.addItemDefinition(this.createdBy.typeDef());
        this.taskName = CustomInput.taskName.of((Task)task);
        this.addItemDefinition(this.taskName.typeDef());
        this.groupId = CustomInput.groupId.of((Task)task);
        this.addItemDefinition(this.groupId.typeDef());
        this.content = CustomInput.content.of((Task)task);
        this.addItemDefinition(this.content.typeDef());
        this.notStartedReassign = CustomInput.notStartedReassign.of((Task)task);
        this.addItemDefinition(this.notStartedReassign.typeDef());
        this.notCompletedReassign = CustomInput.notCompletedReassign.of((Task)task);
        this.addItemDefinition(this.notCompletedReassign.typeDef());
        this.notStartedNotify = CustomInput.notStartedNotify.of((Task)task);
        this.addItemDefinition(this.notStartedNotify.typeDef());
        this.notCompletedNotify = CustomInput.notCompletedNotify.of((Task)task);
        this.addItemDefinition(this.notCompletedNotify.typeDef());
    }

    public void setAsync(boolean async) {
        CustomElement.async.of((BaseElement)this.task).set(async);
    }

    public void setSkippable(boolean skippable) {
        this.skippable.set(skippable);
    }

    public void setPriority(String priority) {
        this.priority.set(priority);
    }

    public void setSubject(String subject) {
        this.subject.set(subject);
    }

    public void setDescription(String description) {
        this.description.set(description);
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy.set(createdBy);
    }

    public void setAdHocAutostart(boolean autoStart) {
        CustomElement.autoStart.of((BaseElement)this.task).set(autoStart);
    }

    public void setTaskName(String taskName) {
        this.taskName.set(taskName);
    }

    public void setActors(Actors actors) {
        for (String actor : this.fromActorString(actors.getValue())) {
            PotentialOwner potentialOwner = Factories.bpmn2.createPotentialOwner();
            potentialOwner.setId("_" + UUID.randomUUID().toString());
            FormalExpression formalExpression = Factories.bpmn2.createFormalExpression();
            formalExpression.setBody(actor);
            ResourceAssignmentExpression resourceAssignmentExpression = Factories.bpmn2.createResourceAssignmentExpression();
            resourceAssignmentExpression.setExpression((Expression)formalExpression);
            potentialOwner.setResourceAssignmentExpression(resourceAssignmentExpression);
            this.task.getResources().add(potentialOwner);
        }
    }

    public void setReassignments(ReassignmentsInfo reassignments) {
        this.fromReassignment(reassignments.getValue());
    }

    private List<String> fromActorString(String delimitedActors) {
        String[] split = delimitedActors.split(",");
        if (split.length == 1 && split[0].isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(split);
    }

    private void fromReassignment(ReassignmentTypeListValue value) {
        if (value != null && !value.getValues().isEmpty()) {
            this.notStartedReassign.set(ParsedReassignmentsInfos.ofCDATA(value, AssociationType.NOT_STARTED_REASSIGN));
            this.notCompletedReassign.set(ParsedReassignmentsInfos.ofCDATA(value, AssociationType.NOT_COMPLETED_REASSIGN));
        }
    }

    public void setGroupId(String value) {
        this.groupId.set(value);
    }

    public void setOnEntryAction(OnEntryAction onEntryAction) {
        Scripts.setOnEntryAction((FlowElement)this.task, onEntryAction);
    }

    public void setOnExitAction(OnExitAction onExitAction) {
        Scripts.setOnExitAction((FlowElement)this.task, onExitAction);
    }

    public void setContent(String content) {
        this.content.set(content);
    }

    public void setSLADueDate(String slaDueDate) {
        CustomElement.slaDueDate.of((BaseElement)this.task).set(slaDueDate);
    }

    public void setNotifications(NotificationsInfo notificationsInfo) {
        this.fromNotification(notificationsInfo.getValue());
    }

    private void fromNotification(NotificationTypeListValue value) {
        if (value != null && !value.getValues().isEmpty()) {
            this.notStartedNotify.set(ParsedNotificationsInfos.ofCDATA(value, AssociationType.NOT_STARTED_NOTIFY));
            this.notCompletedNotify.set(ParsedNotificationsInfos.ofCDATA(value, AssociationType.NOT_COMPLETED_NOTIFY));
        }
    }
}

