/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.mavenembedder;

import java.util.Map;
import org.apache.maven.cli.KieMavenCli;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.mavenembedder.MavenEmbedderUtils;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="MavenEmbedderDefinitions.wid", name="MavenEmbedder", displayName="MavenEmbedder", defaultHandler="mvel: new org.jbpm.process.workitem.mavenembedder.MavenEmbedderWorkItemHandler()", documentation="mavenembedder-workitem/index.html", category="mavenembedder-workitem", icon="MavenEmbedder.png", parameters={@WidParameter(name="Goals", required=true), @WidParameter(name="CLOptions"), @WidParameter(name="WorkDirectory", required=true), @WidParameter(name="ProjectRoot", required=true), @WidParameter(name="Mode")}, results={@WidResult(name="MavenResults", runtimeType="java.util.Map")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="mavenembedder-workitem", version="7.39.0.Final")}, serviceInfo=@WidService(category="Maven Embedder", description="Execute Maven builds", keywords="maven,mvn,build,execute,pom,project,intall", action=@WidAction(title="Execute Maven commands")))
public class MavenEmbedderWorkItemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(MavenEmbedderWorkItemHandler.class);
    private static final String RESULTS_VALUES = "MavenResults";

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            final String goals = (String)workItem.getParameter("Goals");
            final String commandLineOptions = (String)workItem.getParameter("CLOptions");
            final String workDir = (String)workItem.getParameter("WorkDirectory");
            final String projectRoot = (String)workItem.getParameter("ProjectRoot");
            String modeStr = (String)workItem.getParameter("Mode");
            MavenEmbedderUtils.MavenEmbedderMode mode = MavenEmbedderUtils.MavenEmbedderMode.valueOf(modeStr == null ? "SYNC" : modeStr.toUpperCase());
            logger.debug("About to execute maven {} with options {} with working directory {}", new Object[]{goals, commandLineOptions, workDir});
            switch (mode) {
                case SYNC: {
                    Map<String, Object> results = MavenEmbedderUtils.executeMavenGoals(new KieMavenCli(projectRoot), RESULTS_VALUES, projectRoot, commandLineOptions, goals, workDir);
                    workItemManager.completeWorkItem(workItem.getId(), results);
                    break;
                }
                case ASYNC: {
                    final long workItemId = workItem.getId();
                    final String deploymentId = ((WorkItemImpl)workItem).getDeploymentId() == null ? "" : ((WorkItemImpl)workItem).getDeploymentId();
                    final long processInstanceId = workItem.getProcessInstanceId();
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Map<String, Object> results = MavenEmbedderUtils.executeMavenGoals(new KieMavenCli(projectRoot), MavenEmbedderWorkItemHandler.RESULTS_VALUES, projectRoot, commandLineOptions, goals, workDir);
                                RuntimeManager manager = RuntimeManagerRegistry.get().getManager(deploymentId);
                                if (manager == null) {
                                    logger.error("Unable to complete workitem: runtime manager not found.");
                                    throw new RuntimeException("Unable to complete workitem: runtime manager not found.");
                                }
                                RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
                                engine.getKieSession().getWorkItemManager().completeWorkItem(workItemId, results);
                                manager.disposeRuntimeEngine(engine);
                            }
                            catch (Exception e) {
                                logger.error("Unable to execute maven commands asynchronously", (Throwable)e);
                                throw new RuntimeException("Unable to execute maven commands asynchronously", e);
                            }
                        }
                    }).start();
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }
}

