/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.send;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.mariadb.jdbc.internal.packet.send.InterfaceSendPacket;
import org.mariadb.jdbc.internal.query.Query;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class SendTextQueryPacket
implements InterfaceSendPacket {
    private Query query;
    private List<Query> queries;
    private boolean isRewritable;
    private int rewriteOffset;

    public SendTextQueryPacket(List<Query> queries, boolean isRewritable, int rewriteOffset) {
        this.queries = queries;
        this.query = null;
        this.isRewritable = isRewritable;
        this.rewriteOffset = rewriteOffset;
    }

    public SendTextQueryPacket(Query query) {
        this.query = query;
        this.queries = null;
        this.isRewritable = false;
        this.rewriteOffset = 0;
    }

    @Override
    public int send(OutputStream stream) throws IOException, QueryException {
        PacketOutputStream pos = (PacketOutputStream)stream;
        pos.startPacket(0);
        pos.write(3);
        int queryNumberSend = 1;
        if (this.query != null) {
            this.query.writeTo(stream);
        } else if (this.queries.size() == 1) {
            this.queries.get(0).writeTo(stream);
        } else if (!this.isRewritable) {
            this.queries.get(0).writeTo(stream);
            for (int i = 1; i < this.queries.size(); ++i) {
                if (!pos.checkRewritableLength(this.queries.get(i).getQuerySize())) continue;
                pos.write(59);
                this.queries.get(i).writeTo(stream);
                ++queryNumberSend;
            }
        } else {
            this.queries.get(0).writeFirstRewritePart(stream);
            int lastPartLength = this.queries.get(0).writeLastRewritePartLength();
            for (int i = 1; i < this.queries.size(); ++i) {
                if (!pos.checkRewritableLength(this.queries.get(i).writeToRewritablePartLength(this.rewriteOffset) + lastPartLength)) continue;
                this.queries.get(i).writeToRewritablePart(stream, this.rewriteOffset);
                ++queryNumberSend;
            }
            this.queries.get(0).writeLastRewritePart(stream);
        }
        pos.finishPacket();
        return queryNumberSend;
    }
}

